package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.models.Restaurant;

public class SettingsRestaurantManagementFragment extends BaseFragment {
    private LinearLayout llOpeningHours;
    private LinearLayout llOrderOptions;
    private LinearLayout llDineinOptions;
    private LinearLayout llOffers;
    private LinearLayout llReservationOptions;
    private Restaurant restaurant = myPreferences.getRestaurant();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_restaurant_management, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void setListeners() {
        llOpeningHours.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_setting_fragment, new SettingsOpeningHoursFragment(), "order_option");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llOrderOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsOrderOptionsFragment(), "Order options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llReservationOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsReservationOptionsFragment(), "Reservation options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llDineinOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsDineinOptionsFragment(), "Dine in options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llOffers.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsOfferFragment(), "Offers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });

    }

    private void initViews(View view) {
        llOpeningHours = view.findViewById(R.id.llOpeningHours);
        llOrderOptions = view.findViewById(R.id.llOrderOptions);
        LinearLayout llPreOrderOptions = view.findViewById(R.id.llPreOrderOptions);
        llDineinOptions = view.findViewById(R.id.llDineinOptions);
        llOffers = view.findViewById(R.id.llOffers);
        llReservationOptions = view.findViewById(R.id.llReservationOptions);

        llPreOrderOptions.setVisibility(View.GONE);
        if (restaurant!=null && restaurant.restaurant_delivery.equalsIgnoreCase("yes")) {
            llOrderOptions.setVisibility(View.VISIBLE);
        } else {
            llOrderOptions.setVisibility(View.GONE);
        }
    }
}
