package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.merchant.adapters.VouchersAdapter;
import com.ubsidi.epos_2021.merchant.models.DeliveryFee;
import com.ubsidi.epos_2021.merchant.models.Voucher;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class SettingsVoucherCodesFragment extends BaseFragment {

    private RecyclerView rvVoucherCodes;
    private ArrayList<Voucher> vouchers = new ArrayList<>();
    private ArrayList<Voucher> removedVouchers = new ArrayList<>();
    private MaterialCardView cvAdd;
    private LinearLayout llMainLayout;
    private MaterialButton btnUpdate;
    DeliveryFee freeDelivery;
    private LinearLayout llLoading;
    private VouchersAdapter voucherAdapter;
    private Type voucherType = new TypeToken<List<Voucher>>() {
    }.getType();
    private Chip chipBack;

    private AlertDialog progressDialog;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_voucher_codes, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
        fetchData();
    }

    private void fetchData() {
        new Thread(this::fetchVoucherCodes).start();
    }

    private void fetchVoucherCodes() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.online_voucher_codes)
                    .addQueryParameter("restaurant_id", myApp.restaurant_id)
                    .addQueryParameter("status", "1")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                                vouchers.clear();
                                removedVouchers.clear();
                                vouchers.addAll(new Gson().fromJson(response.toString(), voucherType));
                                voucherAdapter.notifyDataSetChanged();
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setListeners() {
        try {
            cvAdd.setOnClickListener(view -> {
                VoucherCodeEditBottomFragment voucherCodeEditBottomFragment = getInstanceVoucherCode(null);
                voucherCodeEditBottomFragment.show(getActivity().getSupportFragmentManager(), "voucher_code");
                voucherCodeEditBottomFragment.setDialogDismissListener(o -> {
                    ((Voucher) o).restaurant_id = myApp.restaurant_id;
                    ((Voucher) o).status = true;
                    vouchers.add((Voucher) o);
                    updateVoucherCodes();
                });
            });

            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public VoucherCodeEditBottomFragment getInstanceVoucherCode(Voucher voucher) {
        VoucherCodeEditBottomFragment voucherCodeEditBottomFragment = new VoucherCodeEditBottomFragment();
        Bundle bundle = new Bundle();
        bundle.putString("voucher", new Gson().toJson(voucher));
        voucherCodeEditBottomFragment.setArguments(bundle);
        return voucherCodeEditBottomFragment;
    }

    private void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity());
        llMainLayout = view.findViewById(R.id.llMainLayout);
        rvVoucherCodes = view.findViewById(R.id.rvVoucherCodes);
        cvAdd = view.findViewById(R.id.cvAdd);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        llLoading = view.findViewById(R.id.llLoading);
        chipBack = view.findViewById(R.id.chipBack);

        voucherAdapter = new VouchersAdapter(vouchers, (position, data) -> {
            Voucher voucher = (Voucher) data;
            VoucherCodeEditBottomFragment voucherCodeEditBottomFragment = getInstanceVoucherCode(voucher);
            voucherCodeEditBottomFragment.show(getActivity().getSupportFragmentManager(), "voucher_code");
            voucherCodeEditBottomFragment.setDialogDismissListener(o -> {
                if (o != null) {
                    ((Voucher) o).restaurant_id = myApp.restaurant_id;
                    vouchers.set(position, (Voucher) o);
                    voucherAdapter.notifyDataSetChanged();
                    updateVoucherCodes();
                }
            });
        }, (position, data) -> {
            ((Voucher) data).status = false;
            updateVoucherCodes();
        });
        rvVoucherCodes.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvVoucherCodes.setNestedScrollingEnabled(false);
        rvVoucherCodes.setAdapter(voucherAdapter);
    }

    private void updateVoucherCodes() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }

            AndroidNetworking.post(ApiEndPoints.online_voucher_codes + "bulk")
                    .addBodyParameter("restaurant_vouchers", new Gson().toJson(vouchers))
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, response.getString("message"));
                                fetchData();
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, apiError.getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
