package com.ubsidi.epos_2021.merchant.fragments;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.DialogFragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.TerminalApplicationDelegate;
import com.stripe.stripeterminal.external.callable.BluetoothReaderListener;
import com.stripe.stripeterminal.external.callable.Callback;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.callable.PaymentIntentCallback;
import com.stripe.stripeterminal.external.callable.ReaderCallback;
import com.stripe.stripeterminal.external.models.BatteryStatus;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryMethod;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderDisplayMessage;
import com.stripe.stripeterminal.external.models.ReaderEvent;
import com.stripe.stripeterminal.external.models.ReaderInputOptions;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.SimulateReaderUpdate;
import com.stripe.stripeterminal.external.models.SimulatedCard;
import com.stripe.stripeterminal.external.models.SimulatorConfiguration;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.log.LogLevel;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CardReaderAdapter;
import com.ubsidi.epos_2021.comman.CustomTerminalEventListener;
import com.ubsidi.epos_2021.comman.CustomTokenProvider;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissDataListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

/**
 * Created by Amrish on 11-11-2020.
 */
public class StripeInternetCardReaderPaymentFragment extends DialogFragment implements BluetoothReaderListener {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private TextView tvMessage;
    private ProgressBar pbLoading;
    private Float amount;
    private BusinessCardReader cardReader;
    private DialogDismissDataListener dialogDismissListener;
    private Cancelable cancelableDiscovery;
    private Business merchantBusinesses = MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business;
    boolean readersFound = false, readerSelectionDisplayed = false;
    private MaterialButton btnCancel;
    private ArrayList<Object> cardReaderObjects = new ArrayList<>();
    private LinearLayout llReaderView, llLoaderView;
    private RecyclerView rvReaders;
    private CardReaderAdapter cardReaderAdapter;

    public void setDialogDismissListener(DialogDismissDataListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_stripe_bluetooth_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        TerminalApplicationDelegate.onCreate(getActivity().getApplication());
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(broadcastReceiver, new IntentFilter(Constants.CARD_READER_MESSAGE));
        if (getArguments() != null) {
            cardReader = new Gson().fromJson(getArguments().getString("card_reader"), BusinessCardReader.class);
            amount = getArguments().getFloat("amount");
        }
        initViews(view);
        setListeners();
        initialize();
    }

    private void initViews(View view) {
        pbLoading = view.findViewById(R.id.pbLoading);
        tvMessage = view.findViewById(R.id.tvMessage);
        btnCancel = view.findViewById(R.id.btnCancel);
        llReaderView = view.findViewById(R.id.llReadersView);
        llLoaderView = view.findViewById(R.id.llLoaderView);
        llReaderView.setVisibility(View.GONE);
        rvReaders = view.findViewById(R.id.rvCardReaders);
        rvReaders.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        cardReaderAdapter = new CardReaderAdapter(cardReaderObjects, (position, data) -> {
            if (data instanceof Reader) {
                llLoaderView.setVisibility(View.VISIBLE);
                llReaderView.setVisibility(View.GONE);
                connectReader((Reader) data, cardReader.s_location_id);
            }
        });
        rvReaders.setAdapter(cardReaderAdapter);
        btnCancel.setVisibility(View.GONE);
        if (BluetoothAdapter.getDefaultAdapter() != null &&
                !BluetoothAdapter.getDefaultAdapter().isEnabled()) {
            BluetoothAdapter.getDefaultAdapter().enable();
        }
    }

    private void setListeners() {
        btnCancel.setOnClickListener(v -> {
            turnOnOffDeviceBluetooth();
            dismiss();
        });
        tvMessage.setOnClickListener(v -> {
            ClipboardManager clipboard = (ClipboardManager) getActivity().getSystemService(Context.CLIPBOARD_SERVICE);
            ClipData clip = ClipData.newPlainText("label", tvMessage.getText().toString());
            clipboard.setPrimaryClip(clip);
        });

    }

    private void turnOnOffDeviceBluetooth() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter.isEnabled()) {
                bluetoothAdapter.disable();
                // ToastUtils.makeToast(getActivity(), "BLUETOOTH TURNED OFF.");
            }
            new Handler(Objects.requireNonNull(Looper.myLooper()))
                    .postDelayed(() -> {
                        if (!bluetoothAdapter.isEnabled()) {
                            bluetoothAdapter.enable();
                            //   ToastUtils.makeToast(getActivity(), "BLUETOOTH TURNED ON.");
                        }
                    }, 1000);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        try {
            if (!Terminal.isInitialized()) {
                Terminal.initTerminal(getActivity(), LogLevel.VERBOSE, new CustomTokenProvider(cardReader.s_location_id, merchantBusinesses.id), new CustomTerminalEventListener(getActivity()));
            } else {
                LogUtils.e("Terminal already initialized");
            }
        } catch (TerminalException e) {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss("Location services are required in order to initialize the Terminal", "", "");
            dismiss();
        }
        discoverReaders();
    }

    //Simulated
    boolean isSimulated = false;

    private void discoverReaders() {
        LogUtils.e("Discovering Readers");
        //Charges declined 4000000000000002
        //Success Discover Type 6011111111111117
        if (isSimulated) {
            SimulatorConfiguration simulatorConfiguration = new SimulatorConfiguration(SimulateReaderUpdate.RANDOM, new SimulatedCard("4242424242424242"), 0L);
            Terminal.getInstance().setSimulatorConfiguration(simulatorConfiguration);
        }
        sendMessage("Discovering readers...", 0);
        DiscoveryConfiguration discoveryConfig = new DiscoveryConfiguration(0, DiscoveryMethod.INTERNET, isSimulated);
        cancelableDiscovery = Terminal.getInstance().discoverReaders(discoveryConfig, new DiscoveryListener() {
            @Override
            public void onUpdateDiscoveredReaders(@NonNull List<Reader> list) {
                LogUtils.e("TERMINAL:::Discovery result::" + list.size());
                getActivity().runOnUiThread(() -> {
                    // if size is 1 connect reader by default instead of display only 1 list in dialog
                    // if size is 1 connect reader by default instead of display only 1 list in dialog
                    //ToastUtils.makeLongToast(getActivity(),"size of the list is "+list.size());
                    if (list.size() == 1) {
                        llLoaderView.setVisibility(View.VISIBLE);
                        llReaderView.setVisibility(View.GONE);
                        connectReader(list.get(0), cardReader.s_location_id);
                    } else {
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                            List<Reader> filterSerialList = new ArrayList<>();
                            // store setting filter name in list
                            for (int i = 0; i < list.size(); i++) {
                                LogUtils.e("List:::Serial numner::" + (list.get(i).getSerialNumber()) + " card reader serial number " + cardReader.serial_number);
                                if (cardReader.serial_number != null && list.get(i).getSerialNumber() != null && Objects.equals(list.get(i).getSerialNumber().toLowerCase(Locale.getDefault()), cardReader.serial_number.toLowerCase(Locale.getDefault()))) {
                                    filterSerialList.add(list.get(i));
                                }
                            }
                            if (!filterSerialList.isEmpty()) {
                                llLoaderView.setVisibility(View.VISIBLE);
                                llReaderView.setVisibility(View.GONE);
                                connectReader(filterSerialList.get(0), cardReader.s_location_id);
                            } else {
                                llLoaderView.setVisibility(View.GONE);
                                llReaderView.setVisibility(View.VISIBLE);
                                ArrayList<Object> localObjects = new ArrayList<>(list);
                                cardReaderAdapter.updateReaders(localObjects);
                            }
                        }
                    }
                });
            }
        }, callback);

    }

    final Callback callback = new Callback() {
        @Override
        public void onSuccess() {
            LogUtils.e("On success");
        }

        @Override
        public void onFailure(@NotNull TerminalException e) {
            LogUtils.e("on failure: " + e.getErrorMessage());
        }
    };

    Reader stripeReader;

    private void connectReader(Reader reader, String locationId) {
        sendMessage("Connecting to terminal: " + reader.getSerialNumber(), 0);
        ConnectionConfiguration.BluetoothConnectionConfiguration connectionConfig =
                new ConnectionConfiguration.BluetoothConnectionConfiguration(locationId);

        Terminal.getInstance().connectBluetoothReader(reader, connectionConfig, this, new ReaderCallback() {
            @Override
            public void onSuccess(Reader r) {
                getActivity().runOnUiThread(() -> {
                    stripeReader = r;
                    cardReader.s_terminal_id = r.getId();
                    createPaymentIntent();

                });

            }

            @Override
            public void onFailure(TerminalException e) {
                e.printStackTrace();
                sendMessage("Terminal Exception\nCode:" + e.getErrorCode().toString() + "\n" + e.getErrorMessage() + "\n", 2);

            }
        });

    }

    private HashMap<String, String> generatePaymentIntentParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format(amount * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", merchantBusinesses.s_account_id == null ? "merchant" : "connect");
        params.put("business_id", merchantBusinesses.id);
        if (cardReader.s_terminal_id != null)
            params.put("s_terminal_id", cardReader.s_terminal_id);
        else params.put("s_terminal_id", cardReader.id);
        return params;
    }

    private void createPaymentIntent() {
        AndroidNetworking.post(ApiEndPoints.PAYMENT_INTENT)
                .addBodyParameter(generatePaymentIntentParams())
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            if (response.has("payment_intent")) {
                                JSONObject paymentIntent = response.getJSONObject("payment_intent");
                                String paymentSecret = paymentIntent.getString("client_secret");
                                Terminal.getInstance().retrievePaymentIntent(paymentSecret, new PaymentIntentCallback() {
                                    @Override
                                    public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                                        sendMessage("Please present card", 0);
                                        getActivity().runOnUiThread(() -> {
                                            collectPaymentMethod(paymentIntent);
                                        });
                                    }

                                    @Override
                                    public void onFailure(@NotNull TerminalException e) {
                                        LogUtils.e("Error while retriving intent");
                                        e.printStackTrace();
                                        sendMessage("Payment Failed", 2);
                                    }
                                });

                            }
                        } catch (JSONException e) {
                            e.printStackTrace();

                        }

                    }

                    @Override
                    public void onError(ANError anError) {
                        anError.printStackTrace();
                        LogUtils.e("MOTO PAYMENT ERROR");
                        LogUtils.e(anError.getErrorBody());

                    }
                });
    }

    private void collectPaymentMethod(PaymentIntent paymentIntent) {
        LogUtils.e("Collecting Payment method");
        Terminal.getInstance().collectPaymentMethod(paymentIntent,
                new PaymentIntentCallback() {
                    @Override
                    public void onSuccess(PaymentIntent paymentIntent) {
                        LogUtils.e("Processing payment intent");
                        sendMessage("Processing payment", 0);
                        // Placeholder for processing paymentIntent
                        processPayment(paymentIntent);
                    }

                    @Override
                    public void onFailure(TerminalException exception) {
                        // Placeholder for handling exception
                        sendMessage("Error while processing payment", 2);
                        LogUtils.e(new Gson().toJson(exception));
                        LogUtils.e("Error while collecting payment method:" + exception.getErrorCode());
                        exception.printStackTrace();
                    }
                });
    }

    private void processPayment(PaymentIntent paymentIntent) {
        LogUtils.e("Process payment intent");
        Terminal.getInstance().processPayment(paymentIntent, new PaymentIntentCallback() {
            @Override
            public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                capturePaymentIntent(paymentIntent);
            }

            @Override
            public void onFailure(@NotNull TerminalException e) {
                LogUtils.e(e.getErrorMessage());
                LogUtils.e("Process payment error");
                sendMessage(e.getErrorMessage(), 2);
            }
        });
    }

    private HashMap<String, String> getCapturePaymentIntentParams(String payment_intent_id) {
        HashMap<String, String> params = new HashMap<>();

        params.put("payment_intent_id", payment_intent_id);
        params.put("business_id", merchantBusinesses.id);
        if (cardReader.s_terminal_id != null)
            params.put("s_terminal_id", cardReader.s_terminal_id);
        else params.put("s_terminal_id", cardReader.id);
        return params;
    }

    private void capturePaymentIntent(PaymentIntent paymentIntent) {
        try {
            AndroidNetworking.post(ApiEndPoints.CAPTURE_PAYMENT_INTENT)
                    .addBodyParameter(getCapturePaymentIntentParams(paymentIntent.getId()))
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            sendMessage("Payment successful", 1);
                            // Get card brand name and number manually , removing PaymentMethod class
                            String cardName = "";
                            String cardNumber = "";
                            try {
                                if (response != null) {
                                    JSONObject jsoncharges = response.getJSONObject("charges");
                                    if (jsoncharges != null) {
                                        JSONArray data = jsoncharges.getJSONArray("data");
                                        if (data.length() == 0) return;
                                        JSONObject jsonFirstObject = data.getJSONObject(0);
                                        JSONObject payment_method_details = jsonFirstObject.getJSONObject("payment_method_details");
                                        if (payment_method_details != null) {
                                            JSONObject card_present = payment_method_details.getJSONObject("card_present");
                                            if (card_present != null && card_present.has("brand")) {
                                                cardName = card_present.getString("brand");
                                            }
                                            if (card_present != null && card_present.has("last4")) {
                                                cardNumber = card_present.getString("last4");
                                            }
                                        }
                                    }
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                            Terminal.getInstance().disconnectReader(callback);
                            if (dialogDismissListener != null)
                                dialogDismissListener.onDialogDismiss(paymentIntent, cardName, cardNumber);
                            dismiss();
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (anError.getErrorCode() > 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                sendMessage("Payment Failed: " + apiError.getMessage(), 2);
                            } else {
                                sendMessage("Payment Failed: ", 2);
                            }
                            LogUtils.e("MOTO PAYMENT ERROR");
                            LogUtils.e(anError.getErrorBody());

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessage(String message, int status) {
        Intent pushNotification = new Intent(Constants.CARD_READER_MESSAGE);
        pushNotification.putExtra("status", status);
        LogUtils.e("TERMINAL::" + message);
        if (message != null)
            pushNotification.putExtra("message", message);
        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(pushNotification);
    }

    BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getExtras() != null) {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        String message = intent.getStringExtra("message");
                        int status = intent.getIntExtra("status", 0);//0=neutral, 1=success, 2=failed

                        if (!Validators.isNullOrEmpty(message)) {
                            if (getActivity() != null)
                                getActivity().runOnUiThread(() -> {
                                    tvMessage.setText(intent.getStringExtra("message"));
                                    ClipboardManager clipboard = (ClipboardManager) getActivity().getSystemService(Context.CLIPBOARD_SERVICE);
                                    ClipData clip = ClipData.newPlainText("label", message);
                                    clipboard.setPrimaryClip(clip);
                                });
                        }
                        if (status == 2) {
                            pbLoading.setVisibility(View.GONE);
                            btnCancel.setVisibility(View.VISIBLE);
                        } else {
                            btnCancel.setVisibility(View.GONE);
                            pbLoading.setVisibility(View.VISIBLE);
                        }
                    });
                }

            }
        }
    };

    @Override
    public void onDismiss(@NonNull @NotNull DialogInterface dialog) {
        super.onDismiss(dialog);
        LogUtils.e("Dismissed");

        if (stripeReader != null) {
            try {
                Terminal.getInstance().disconnectReader(callback);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        cancelableDiscovery.cancel(callback);
        LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(broadcastReceiver);
    }

    //BluetoothReaderListener methods starts
    @Override
    public void onStartInstallingUpdate(@NotNull ReaderSoftwareUpdate readerSoftwareUpdate, @org.jetbrains.annotations.Nullable Cancelable cancelable) {
        sendMessage("Update installing", 0);
    }

    @Override
    public void onReportReaderSoftwareUpdateProgress(float v) {
        sendMessage("Updating " + MyApp.df.format(v * 100) + "%", 0);
    }

    @Override
    public void onFinishInstallingUpdate(@org.jetbrains.annotations.Nullable ReaderSoftwareUpdate readerSoftwareUpdate, @org.jetbrains.annotations.Nullable TerminalException e) {
        sendMessage("Finishing Updating", 0);
    }

    @Override
    public void onReportAvailableUpdate(@NotNull ReaderSoftwareUpdate readerSoftwareUpdate) {
        sendMessage("Update available", 0);
    }

    @Override
    public void onRequestReaderInput(@NotNull ReaderInputOptions readerInputOptions) {

    }

    @Override
    public void onRequestReaderDisplayMessage(@NotNull ReaderDisplayMessage readerDisplayMessage) {
        sendMessage("Message\n" + readerDisplayMessage.toString(), 0);
    }

    @Override
    public void onReportReaderEvent(@NotNull ReaderEvent readerEvent) {

    }

    @Override
    public void onReportLowBatteryWarning() {
        sendMessage("Low battery please recharge the reader", 0);
    }

    @Override
    public void onBatteryLevelUpdate(float v, @NonNull BatteryStatus batteryStatus, boolean b) {

    }
    //BluetoothReaderListener methods end
}
