package com.ubsidi.epos_2021.models;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.ArrayList;
import java.util.Objects;

@Entity
public class Addon {
    @NonNull
    @PrimaryKey
    public String id;
    @ColumnInfo(index = true)
    public String parent_id;
    public int sequence;
    public boolean disabled;
    public String created_at;
    public String name,top_color,bottom_color;
    public float price;
    public float web_price;
    public float takeaway_price;
    public float delivery_price;
    public float waiting_price;
    public int quantity = 0;
    @Ignore
    public boolean contain = false;
    @Ignore
    public ArrayList<Addon> children;
    @Ignore
    public boolean selected;
    @Ignore
    public float selected_price;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Addon addon = (Addon) o;
        return Objects.equals(id, addon.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
