package com.ubsidi.epos_2021.models;

import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.Objects;

/**
 * Created by Amrish on 05-05-2021.
 */
@Entity
public class Customer {
    @PrimaryKey(autoGenerate = true)
    public int _id;

    public String id;
    public String name;
    public String mobile;
    public String email;
    public String landline;
    public String birth_date;
    public String anniversary_date;
    public String house_no;
    public String street;
    public String postcode;
    public String distance;
    public String city;
    public String country;
    public String state;
    public String membership_no;
    public String membership_points;
    public String available_credit;
    public boolean news_letter;

    @Ignore
    public OrderType selectedOrderType;  // For local use only
    @Ignore
    public Table selectedTable;  // For local use only
    @Ignore
    public int no_guest;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Customer customer = (Customer) o;
        return Objects.equals(id, customer.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
