package com.ubsidi.epos_2021.models;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.ArrayList;
import java.util.Objects;

/**
 * Created by Amrish on 04-05-2021.
 */
@Entity
public class Order {
    @PrimaryKey(autoGenerate = true)
    public int _id;
    public int _customer_id;

    public String id;
    public String comment;
    public String created_at;
    public String updated_at;
    public String customer_id;
    public String customer_name;
    public String delivery_date;
    public String device_id;
    public String split_type; //order_item,person
    public int split_count;
    public String order_action_id;
    public String order_status;
    public String order_status_id;
    public String order_type;
    public String order_type_id;
    public String preparation_location_id;
    public String table_id;
    public String table_number;
    public float sub_total;
    public float gratuity;
    public float service_charge;
    public float delivery_charge;
    public float discount;
    public float tax;
    public float total;
    public float total_paid;
    public String updater_id;
    public String no_guest;
    public boolean is_archived;
    public boolean is_table_swap;
    public int print_id;
    @Ignore
    public boolean selected, expanded;
    @Ignore
    public Customer customer;
    @Ignore
    public ArrayList<Product> product_items;
    @Ignore
    public ArrayList<OrderItem> order_items;
    @Ignore
    public ArrayList<OrderSplit> order_splits;
    @Ignore
    public ArrayList<OrderPayment> order_payments;
    @ColumnInfo(name = "is_uploaded_on_server")
    public boolean is_uploaded_on_server = false;

    @ColumnInfo(name = "unique_id")
    public String unique_id = "";
    @ColumnInfo(name = "socket_type")
    public String socket_type = "";
    public String delivery_collection_time_slot = "";
    public String display_order_id = "";
    public boolean is_delivery_collection_ask = false;
    public boolean is_auto_service_charge_remove = false;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Order order = (Order) o;
        return _id == order._id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(_id);
    }

    @Override
    public String toString() {
        return "Order{" +
                "_id=" + _id +
                ", _customer_id=" + _customer_id +
                ", id='" + id + '\'' +
                ", comment='" + comment + '\'' +
                ", created_at='" + created_at + '\'' +
                ", updated_at='" + updated_at + '\'' +
                ", customer_id='" + customer_id + '\'' +
                ", customer_name='" + customer_name + '\'' +
                ", delivery_date='" + delivery_date + '\'' +
                ", device_id='" + device_id + '\'' +
                ", split_type='" + split_type + '\'' +
                ", split_count=" + split_count +
                ", order_action_id='" + order_action_id + '\'' +
                ", order_status='" + order_status + '\'' +
                ", order_status_id='" + order_status_id + '\'' +
                ", order_type='" + order_type + '\'' +
                ", order_type_id='" + order_type_id + '\'' +
                ", preparation_location_id='" + preparation_location_id + '\'' +
                ", table_id='" + table_id + '\'' +
                ", table_number='" + table_number + '\'' +
                ", sub_total=" + sub_total +
                ", gratuity=" + gratuity +
                ", service_charge=" + service_charge +
                ", delivery_charge=" + delivery_charge +
                ", discount=" + discount +
                ", tax=" + tax +
                ", total=" + total +
                ", total_paid=" + total_paid +
                ", updater_id='" + updater_id + '\'' +
                ", no_guest='" + no_guest + '\'' +
                ", is_archived=" + is_archived +
                ", print_id=" + print_id +
                ", selected=" + selected +
                ", expanded=" + expanded +
                ", customer=" + customer +
                ", product_items=" + product_items +
                ", order_items=" + order_items +
                ", order_splits=" + order_splits +
                ", order_payments=" + order_payments +
                ", is_uploaded_on_server=" + is_uploaded_on_server +
                ", unique_id='" + unique_id + '\'' +
                '}';
    }
}
