package com.ubsidi.epos_2021.models;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.ArrayList;

/**
 * Created by Amrish on 08-05-2021.
 */
@Entity(foreignKeys = @ForeignKey(entity = Order.class, parentColumns = "_id", childColumns = "_order_id", onDelete = ForeignKey.CASCADE))
public class OrderItem {

    @PrimaryKey(autoGenerate = true)
    public int _id;
    @ColumnInfo(index = true)
    public int _order_id;
    public int _order_split_id;
    public String unique_id = "";
    public String id, product_id, product_name, product_short_name, product_description, order_id, updater_id, order_split_id, preparation_location_id, collection_preparation_location_id, delivery_preparation_location_id, banquet_preparation_location_id;
    public String special_instruction, category_name ,created_at,updated_at;
    public float price, sub_total, addons_price, ingredients_price, instruction_price, total;
    public float web_price, delivery_price, takeaway_price, waiting_price;
    public int quantity = 1, sent_to_kitchen_quantity = 0;
    @Ignore
    public int sent_to_kitchen_quantity_for_local_use = 0;
    public boolean sent_to_kitchen, misc;
    @ColumnInfo(name = "block_id")
    public String block_id;
    @ColumnInfo(name = "block_name")
    public String block_name;

    @Ignore
    public ArrayList<OrderItemAddon> order_item_addons = new ArrayList<>();
    @Ignore
    public ArrayList<OrderItemIngredient> order_item_ingredients = new ArrayList<>();
    public boolean is_delete = false;
    @Ignore
    public boolean shouldEdit;
    @Ignore
    public boolean shouldClick;

    /*@Ignore
    public String table_type;*/
    @Override
    public String toString() {
        return "OrderItem{" +
                "_id=" + _id +
                ", _order_id=" + _order_id +
                ", _order_split_id=" + _order_split_id +
                ", id='" + id + '\'' +
                ", product_id='" + product_id + '\'' +
                ", product_name='" + product_name + '\'' +
                ", product_short_name='" + product_short_name + '\'' +
                ", product_description='" + product_description + '\'' +
                ", order_id='" + order_id + '\'' +
                ", updater_id='" + updater_id + '\'' +
                ", order_split_id='" + order_split_id + '\'' +
                ", preparation_location_id='" + preparation_location_id + '\'' +
                ", collection_preparation_location_id='" + collection_preparation_location_id + '\'' +
                ", delivery_preparation_location_id='" + delivery_preparation_location_id + '\'' +
                ", banquet_preparation_location_id='" + banquet_preparation_location_id + '\'' +
                ", special_instruction='" + special_instruction + '\'' +
                ", category_name='" + category_name + '\'' +
                ", price=" + price +
                ", sub_total=" + sub_total +
                ", addons_price=" + addons_price +
                ", ingredients_price=" + ingredients_price +
                ", instruction_price=" + instruction_price +
                ", total=" + total +
                ", web_price=" + web_price +
                ", delivery_price=" + delivery_price +
                ", takeaway_price=" + takeaway_price +
                ", created_at=" + created_at +
                ", updated_at=" + updated_at +
                ", is_delete=" + is_delete +
                ", waiting_price=" + waiting_price +
                ", quantity=" + quantity +
                ", sent_to_kitchen_quantity=" + sent_to_kitchen_quantity +
                ", sent_to_kitchen_quantity_for_local_use=" + sent_to_kitchen_quantity_for_local_use +
                ", sent_to_kitchen=" + sent_to_kitchen +
                ", misc=" + misc +
                ", block_id='" + block_id + '\'' +
                ", order_item_addons=" + order_item_addons +
                ", order_item_ingredients=" + order_item_ingredients +
                ", shouldEdit=" + shouldEdit +
                ", shouldClick=" + shouldClick +
                '}';
    }
}
