package com.ubsidi.epos_2021.models;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.Objects;

/**
 * Created by Amrish on 08-05-2021.
 */

@Entity(foreignKeys = @ForeignKey(entity = OrderItem.class, parentColumns = {"_id"}, childColumns = {"_order_item_id"}, onDelete = ForeignKey.CASCADE))
public class OrderItemAddon {
    @PrimaryKey(autoGenerate = true)
    public int _id;
    @ColumnInfo(index = true)
//    @Relation(entity = OrderItem.class,parentColumn = "_id",entityColumn = "_order_item_id")
    public int _order_item_id;

    public String id, order_item_id, order_id, updater_id, addon_id, addon_name;
    public String special_instruction;
    public float price, total;
    public int quantity = 0;
    @Ignore
    public Addon addon;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderItemAddon that = (OrderItemAddon) o;
        return Objects.equals(addon_id, that.addon_id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(addon_id);
    }
}
