package com.ubsidi.epos_2021.models;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

/**
 * Created by Amrish on 08-05-2021.
 */
@Entity(foreignKeys = @ForeignKey(entity = OrderItem.class, parentColumns = {"_id"}, childColumns = {"_order_item_id"}, onDelete = ForeignKey.CASCADE))
public class OrderItemIngredient {

    @PrimaryKey(autoGenerate = true)
    public int _id;

    @ColumnInfo(index = true)
    public int _order_item_id;

    public String id, order_item_id, order_id, updater_id, product_ingredient_id, ingredient_id, ingredient_name;
    public float price, total;
    public int quantity;
    public boolean with, without;
    @Ignore
    public ProductIngredient product_ingredient;
}
