package com.ubsidi.epos_2021.models;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.Objects;

/**
 * Created by Amrish on 13-05-2021.
 */
@Entity(foreignKeys = @ForeignKey(entity = Order.class, parentColumns = "_id", childColumns = "_order_id", onDelete = ForeignKey.CASCADE))
public class OrderSplit {
    @PrimaryKey(autoGenerate = true)
    public int _id;
    @ColumnInfo(index = true)
    public int _order_id;
    public String unique_id = "";
    public String id, order_id, group_name;
    public float total, paid_amount;
    @Ignore
    public boolean selected;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderSplit that = (OrderSplit) o;
        return _id == that._id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(_id);
    }
}
