package com.ubsidi.epos_2021.models;

import androidx.room.Ignore;

import java.util.Objects;

/**
 * Created by Amrish on 04-05-2021.
 */
public class OrderType {
    public String id, type, top_color, bottom_color;
    public boolean isChecked;
    @Ignore
    public boolean isSelected = false;
    public int count;

    @Ignore
    public OrderType() {
    }


    @Ignore
    public OrderType(String id, String type) {
        this.id = id;
        this.type = type;
    }

    @Ignore
    public OrderType(String id, String type, int count) {
        this.id = id;
        this.type = type;
        this.count = count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderType orderType = (OrderType) o;
        if (type != null)
            return Objects.equals(type.toLowerCase(), orderType.type.toLowerCase());
        else if (id != null) Objects.equals(id.toLowerCase(), orderType.id.toLowerCase());
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type);
    }
}
