package com.ubsidi.epos_2021.models;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import java.util.ArrayList;
import java.util.Objects;

/**
 * Created by Amrish on 24-04-2021.
 */
@Entity
public class Product {
    @PrimaryKey
    @NonNull
    public String id;
    //Variables, bottom_color will be used as font color and top_color will be used as font color.
    public String name, short_name, description, category_id, top_color, bottom_color, preparation_location_id,collection_preparation_location_id,delivery_preparation_location_id,banquet_preparation_location_id, image, image_url, thumb_url,barcode;
    public float price, web_price, delivery_price, takeaway_price, waiting_price;
    //storage/emulated/0/Android/data/com.example.epos_2021/files/epos2021
    // Price => Dinein Price
    // takeaway_price => Collection price
    // waiting_price => Banquet Price
    public boolean favourite, bar_favourite, tax_included, taxable, auto_modify, stockable, is_banquet, is_collection, is_delivery, is_dinein, misc, disabled, auto_addon;
    public int sequence;
    public int total_addons;
    @Ignore
    public Category category;
    // For local  use
    @Ignore
    public ArrayList<OrderItemAddon> order_item_addons = new ArrayList<>();
    @Ignore
    public ArrayList<OrderItemIngredient> order_item_ingredients = new ArrayList<>();
    @Ignore
    public ArrayList<ProductAddon> productAddons = new ArrayList<>();
    @Ignore
    public ArrayList<ProductAddon> product_addons = new ArrayList<>();  // This comes from dbpull
    @Ignore
    public ArrayList<ProductIngredient> product_ingredients = new ArrayList<>();  // This comes from dbpull
    @Ignore
    public float selected_price, total_price, addons_price;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Product product = (Product) o;
        return Objects.equals(id, product.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
