package com.ubsidi.epos_2021.models;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import java.util.Objects;

/**
 * Created by Amrish on 22-05-2021.
 */
@Entity
public class SiteSetting {

    @PrimaryKey
    @NonNull
    public String key;//: "address"

    public String comment;//: "Business Addresss"
    public String created_at;//: "2021-05-19T12:58:10.000000Z"
    public String data_type;//: "string"
    public String expected_values;//: ""
    public String hint;//: "Business Address"
    public String id;//: 1
    public boolean is_editable;//: true
    public String name;//: "Address"
    public String sequence;//: 0
    public String setting_group;//: null
    public String value;//: "Business Address"


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SiteSetting that = (SiteSetting) o;
        return key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key);
    }
}
