package com.ubsidi.epos_2021.models;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;

@Entity(foreignKeys = @ForeignKey(entity = Floor.class, parentColumns = "id", childColumns = "floor_id"))
@TypeConverters
public class Table {
    @NonNull
    @PrimaryKey
    public String id;
    @ColumnInfo(index = true)
    public String floor_id;
    @Ignore
    @ColumnInfo(name = "_last_order_id")
    public int _last_order_id;
    public String number, table_status_id, last_order_id;
    public String floor_name, status;
    public int sequence;
    public boolean disabled, locked;

    public float last_order_total;

    public String last_order_created_at,merge_table_id,merge_table_name,updater_id;
    @Ignore
    public TableStatus table_status;
}
