package com.ubsidi.epos_2021.network;


import androidx.multidex.BuildConfig;

/**
 * Created by Amrish on 19-08-2020.
 */
public class ApiEndPoints {
    public static boolean ubsidiBuild = true; //true for live and false for test

    public static String BASE_URL() {
         //return "http://192.168.1.29:8300/";
        //return "http://192.168.1.35:8300/";
       // return "https://testrms.tiffintom.com/V2/public/";
        if (BuildConfig.DEBUG) {
            if (ubsidiBuild) {
                return "https://www.ubsidi.com/V2/public/";
            } else
                return "https://testrms.tiffintom.com/public/";
        } else {
            return "https://www.ubsidi.com/V2/public/";
        }
    }

    public static String BASE_URL_EPOS() {
        return BASE_URL() + "epos/";
    }

    public static String BASE_URL_MERCHANT() {
        return BASE_URL() + "merchant/";
    }

    public static String BASE_URL_EPOS_TIFFINTOM() {
        return BASE_URL() + "epos/tiffintom/";
    }

    public static String ONLINE_BASE_URL() {
        if (BuildConfig.DEBUG) {
            if (ubsidiBuild) return "https://www.tiffintom.com/v5/StoreMobileApi/requests";
            return "https://www.tiffintom.net/v2/StoreMobileApi/requests";
        } else {
            return "https://www.tiffintom.com/v5/StoreMobileApi/requests";
        }
    }

    public static String database_file = BASE_URL_EPOS() + "order-logs/";
    public static String external_payment = BASE_URL_EPOS() + "external-payments/";
    public static String SITESETTINGSRMS = BASE_URL() + "api/site-settings/";
    public static String postcode = BASE_URL() + "api/postcodes/find/";
    public static String devices = BASE_URL_EPOS() + "devices/";
    public static String admin_login = BASE_URL_EPOS() + "login/";
    public static String site_settings = BASE_URL_EPOS() + "site-settings/";
    public static String database_pull = BASE_URL_EPOS() + "database/pull";
    public static String database_push = BASE_URL_EPOS() + "database/push";
    public static String businesses = BASE_URL_EPOS() + "businesses/";
    public static String users = BASE_URL_EPOS() + "users/";
    public static String user_login = BASE_URL_EPOS() + "users/login/";
    public static String user_logout = "/logout";
    public static String mini_users = BASE_URL_EPOS() + "users/mini/";
    public static String floors = BASE_URL_EPOS() + "floors/";
    public static String categories = BASE_URL_EPOS() + "categories/";
    public static String customers = BASE_URL_EPOS() + "customers/";
    public static String products = BASE_URL_EPOS() + "products/";
    public static String product_addons = BASE_URL_EPOS() + "product-addons/";
    public static String product_ingredients = BASE_URL_EPOS() + "product-ingredients/";
    public static String voucher = BASE_URL_EPOS() + "vouchers/find/";
    public static String voucher_add = BASE_URL_EPOS() + "vouchers/";
    public static String preplocation = BASE_URL_EPOS() + "preparation-locations/";
    public static String calllogs = BASE_URL_EPOS() + "call-logs/";
    public static String calculate_delivery_charge = BASE_URL_EPOS() + "delivery-charges/calculate/";
    public static String reservations = BASE_URL_EPOS() + "reservations/";
    public static String reservation_statuses = BASE_URL_EPOS() + "reservation-statuses/";
    public static String reservation_types = BASE_URL_EPOS() + "reservation-types/";
    public static String reservation_deposit = BASE_URL_EPOS() + "deposit-types/";
    public static String cashdraw_log = BASE_URL_EPOS() + "cashdraw-logs/";
    public static String print_settings = BASE_URL_EPOS() + "print-settings/";

    public static String tables = BASE_URL_EPOS() + "tables/";
    public static String tables_status_bulk = BASE_URL_EPOS() + "tables/status-bulk";
    //public static String orders = BASE_URL_EPOS() + "orders1/";
    public static String orders = BASE_URL_EPOS() + "orders/";
    public static String orders1 = BASE_URL_EPOS() + "orders/";
    public static String order_types = BASE_URL_EPOS() + "order-types/";
    public static String order_payments = BASE_URL_EPOS() + "order-payments/";
    public static String order_splits = BASE_URL_EPOS() + "order-splits/";
    public static String payment_methods = BASE_URL_EPOS() + "payment-methods/";
    public static String full_report = BASE_URL_EPOS() + "reports/";
    public static String online_report = BASE_URL_EPOS() + "reports/online-order";
    public static String sales_report = BASE_URL_EPOS() + "reports/products-wise";
    public static String category_report = BASE_URL_EPOS() + "reports/products-category-wise/";
    public static String archive_orders = BASE_URL_EPOS() + "orders/bulk-archive/";
    public static String unarchive_orders = BASE_URL_EPOS() + "orders/bulk-unarchive/";

    public static String merchant_transactions = BASE_URL_MERCHANT() + "businesses/{business_id}/card-transactions";
    public static String merchant_statements = BASE_URL_MERCHANT() + "businesses/{business_id}/statements";
    public static String merchant_transactions_archive = BASE_URL_MERCHANT() + "businesses/{business_id}/card-transactions/archive";
    public static String merchant_transactions_unarchive = BASE_URL_MERCHANT() + "businesses/{business_id}/card-transactions/unarchive";
    public static String merchant_refund_transaction = BASE_URL_MERCHANT() + "businesses/{business_id}/card-transactions/{id}/refund";
    public static String MERCHANT_BUSINESSES_ALL_TRANSACTIONS = BASE_URL_MERCHANT() + "businesses/{business_id}/all-transactions";
    public static String MERCHANT_BUSINESS_ALL_TRANSACTIONS_UNARCHIVE = BASE_URL_MERCHANT() + "businesses/{business_id}/all-transactions/unarchive";
    public static String MERCHANT_BUSINESS_ALL_TRANSACTIONS_ARCHIVE = BASE_URL_MERCHANT() + "businesses/{business_id}/all-transactions/archive";
    public static String MERCHANT_REFUND_PAYPAL_TRANSACTIONS = BASE_URL_MERCHANT() + "businesses/{business_id}/paypal-transactions/{id}/refund";

    public static String factory_reset = BASE_URL_EPOS() + "factory-reset";
    public static String delete_orders = BASE_URL_EPOS() + "orders/delete-all";
    public static String delete_reservations = BASE_URL_EPOS() + "reservations/delete-all";
    public static String delete_cash_draw_logs = BASE_URL_EPOS() + "cashdraw-logs/delete-all";
    public static String delete_calllogs = BASE_URL_EPOS() + "call-logs/delete-all";
    public static String PAYMENT_INTENT = BASE_URL() + "api/pg/payment-intent";
    public static String APPLICATION_FEE = BASE_URL() + "api/pg/calculate-application-fee";
    public static String CARD_READER_PAYMENT = BASE_URL() + "card-reader-payment"; //For webview
    public static String CARD_READER_TOKEN = BASE_URL() + "api/pg/card-reader-connection-token";
    public static String CAPTURE_PAYMENT_INTENT = BASE_URL() + "api/pg/payment-intent-capture";
    public static String READ_TO_COLLECT = "/ready-to-collect";


    public static String restaurant_details = BASE_URL_EPOS_TIFFINTOM() + "restaurants/";
    public static String restaurant_counts = BASE_URL_EPOS_TIFFINTOM() + "restaurants/{id}/counts";
    public static String online_reservations = BASE_URL_EPOS_TIFFINTOM() + "bookings/";
    public static String online_reservations_delete = BASE_URL_EPOS_TIFFINTOM() + "bookings/bulk-delete";
    public static String online_order_delete = BASE_URL_EPOS_TIFFINTOM() + "orders/bulk-delete";
    public static String online_reservations_status_change = BASE_URL_EPOS_TIFFINTOM() + "bookings/{id}/change-status";
    public static String online_orders = BASE_URL_EPOS_TIFFINTOM() + "orders/";
    public static String online_payment_links = BASE_URL_EPOS_TIFFINTOM() + "payment-message/";
    public static String online_payment_links_resend = BASE_URL_EPOS_TIFFINTOM() + "payment-message/{id}/resend/";
    public static String online_orders_status_change = BASE_URL_EPOS_TIFFINTOM() + "orders/{id}/change-status";
    public static String online_orders_send_rtc = BASE_URL_EPOS_TIFFINTOM() + "orders/{id}/rtc";
    public static String online_orders_time_slots = BASE_URL_EPOS_TIFFINTOM() + "orders/{id}/time-slots";
    public static String online_dinein_orders = BASE_URL_EPOS_TIFFINTOM() + "dinein-orders/";
    public static String online_dinein_orders_status_change = BASE_URL_EPOS_TIFFINTOM() + "dinein-orders/{id}/change-status";
    public static String online_orders_home = BASE_URL_EPOS_TIFFINTOM() + "orders/home";
    public static String online_voucher_codes = BASE_URL_EPOS_TIFFINTOM() + "restaurant-vouchers/";
    public static String online_auto_discounts = BASE_URL_EPOS_TIFFINTOM() + "offers/";
    public static String online_orders_history = BASE_URL_EPOS_TIFFINTOM() + "orders/history";
    public static String online_app_feedback = BASE_URL_EPOS_TIFFINTOM() + "app-feedback/";
    public static String get_chat_messages = BASE_URL_EPOS_TIFFINTOM() + "chat";
    public static String order_help_list = BASE_URL_EPOS_TIFFINTOM() + "order-help/";

}
