package com.ubsidi.epos_2021.network;

import android.content.Intent;
import android.util.Log;

import androidx.multidex.BuildConfig;

import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.AdminLoginActivity;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.utils.EasyAES;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.io.IOException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
 * Created by Amrish on 23-04-2021.
 */
public class NetworkInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) {

        Request originalRequest = chain.request();
        URL url = originalRequest.url().url();
        Response response = null;

        HashMap<String, String> allQueries = getQueryMap(url.getQuery());
        boolean isAdminRequest = allQueries.containsKey("request_for") && allQueries.get("request_for").equalsIgnoreCase("admin");
        try {
            Request.Builder tokenRequestBuilder = originalRequest.newBuilder();
            Map<String, String> headers;
            if (isAdminRequest) {
                headers = MyApp.getInstance().myPreferences.getAdminAuthToken();
            } else {
                headers = MyApp.getInstance().myPreferences.getUserAuthToken();
            }
            tokenRequestBuilder.addHeader("package-name", MyApp.getInstance().getPackageName());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    tokenRequestBuilder.header(entry.getKey(), entry.getValue());
                }
            }
            response = chain.proceed(tokenRequestBuilder.build());
            String xToken = response.header("x-token", null);
            String xRefreshToken = response.header("x-refresh-token", null);
            if (xToken != null && xRefreshToken != null) {
                if (isAdminRequest) {
                    MyApp.getInstance().myPreferences.saveAdminTokens(xToken, xRefreshToken);
                } else {
                    MyApp.getInstance().myPreferences.saveUserTokens(xToken, xRefreshToken);
                }
            }
            Log.e("Token", " " + xToken);
            Log.e("Token", " " + xRefreshToken);
            Log.e("BusinessId", " " + MyApp.getInstance().myPreferences.getBusinessId());
            if (response.code() == 200) {
                String enc_data = "" + response.body().string();
                if(enc_data.length()>87){
                    StringBuilder stringBuilder = new StringBuilder(enc_data);
                    stringBuilder.replace(0,15,"");
                    stringBuilder.replace(8,15,"");
                    stringBuilder.replace(14,22,"");
                    stringBuilder.replace(22,28,"");
                    stringBuilder.replace(28,35,"");
                    stringBuilder.replace(stringBuilder.length()-18,stringBuilder.length()-3,"");
                    enc_data= EasyAES.decryptString(stringBuilder.toString());
                }else{
                    enc_data= EasyAES.decryptString(enc_data);
                }
                return response.newBuilder()
                        .body(ResponseBody.create(response.body().contentType(), enc_data)).build();
            }

        }catch (SocketException | UnknownHostException e)
        {
            e.printStackTrace();
            ToastUtils.makeSnackToast(MyApp.getInstance().getApplicationContext(), "Session timeout, Please try again later");
            return null;
        } //            new Handler(Looper.getMainLooper()).post(() -> {
        //                ToastUtils.makeToast(MyApp.getInstance(), "No internet connection available");
        //            });
        //            AndroidNetworking.cancelAll();
        catch (IOException e) {
            LogUtils.e(e);
            e.printStackTrace();
//            new Handler(Looper.getMainLooper()).post(() -> {
//                ToastUtils.makeToast(MyApp.getInstance(), "No internet connection!");
//            });
//            AndroidNetworking.cancelAll();
            return null;
        }
        if (response.code() > 300) {
            try {
                if (BuildConfig.DEBUG) {
                    LogUtils.network("====API ERROR====");
                    LogUtils.network(response.code() + " => " + response.request().method() + " => " + URLDecoder.decode(response.request().url().url().toString(), "UTF-8"));
                    // print body response
                    LogUtils.network("===Body====");
                    if (response!=null&&response.body()!=null) {
                        LogUtils.network(new Gson().toJson(response.body()));
                    }

                    if (response.body().contentLength() > 0) {
                        LogUtils.network(new String(response.peekBody(response.body().contentLength()).bytes()));
                    } else {
                        LogUtils.network(new String(response.peekBody(1024).bytes()));
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
                return response;
            }
            if (response.code() == 403) {
                if (isAdminRequest) {
                    MyApp.getInstance().myPreferences.saveLoggedInAdmin(null);
                    MyApp.getInstance().myPreferences.saveBusinessId(null);
                    MyApp.getInstance().myPreferences.saveAdminTokens(null, null);

                    MyApp.getInstance().startActivity(new Intent(MyApp.getInstance(), AdminLoginActivity.class));

                    ToastUtils.makeSnackToast(MyApp.getInstance().getApplicationContext(), "Session expired");
                }
            }
        }

        return response;
    }

    public static HashMap<String, String> getQueryMap(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Validators.isNullOrEmpty(query)) return map;
        String[] params = query.split("&");

        for (String param : params) {
            String paramArray[] = param.split("=");
            String name = param.split("=")[0];
            String value = null;
            if (paramArray.length == 2) {
                value = param.split("=")[1];
            }
            map.put(name, value);
        }
        return map;
    }
}