package com.ubsidi.epos_2021.online.adapters;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Paint;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.interfaces.RecyclerItemViewClickListener;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderStatusIndicatorHeader;

import java.util.ArrayList;
import java.util.Date;

/**
 * Created by Amrish on 09-11-2020.
 */
public class OnlineOrdersAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public ArrayList<Object> ordersList;
    private Activity activity;
    private RecyclerItemViewClickListener itemViewClickListener, viewClickListener, printClickListener, rtcClicked;
    public boolean showCheck = false;
    public boolean isHasDeletePermission = false;

    public OnlineOrdersAdapter(FragmentActivity activity, ArrayList<Object> ordersList, RecyclerItemViewClickListener itemViewClickListener, RecyclerItemViewClickListener viewClickListener, RecyclerItemViewClickListener printClickListener, RecyclerItemViewClickListener rtcClicked) {
        this.ordersList = ordersList;
        this.activity = activity;
        this.itemViewClickListener = itemViewClickListener;
        this.viewClickListener = viewClickListener;
        this.printClickListener = printClickListener;
        this.rtcClicked = rtcClicked;
    }

    public OnlineOrdersAdapter(FragmentActivity activity, ArrayList<Object> ordersList, RecyclerItemViewClickListener itemViewClickListener) {
        this.ordersList = ordersList;
        this.activity = activity;
        this.itemViewClickListener = itemViewClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (ordersList.get(position) instanceof OrderDetail) {
            return R.layout.item_online_order_list;
        } else {
            return R.layout.item_online_orders_status_indicator;
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        if (viewType == R.layout.item_online_order_list) {
            return new OrderViewHolder(view);
        } else {
            return new OrderStatusHeaderViewHolder(view);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_online_orders_status_indicator) {
                OrderStatusHeaderViewHolder viewHolder = (OrderStatusHeaderViewHolder) holder;
                OrderStatusIndicatorHeader header = (OrderStatusIndicatorHeader) ordersList.get(position);
                viewHolder.tvTitle.setText(header.title);
            }
            if (getItemViewType(position) == R.layout.item_online_order_list) {
                OrderViewHolder viewHolder = (OrderViewHolder) holder;
                OrderDetail order = (OrderDetail) ordersList.get(position);
                boolean isDinein = Validators.isNullOrEmpty(order.order_type);
                boolean isPreOrder = false;
                boolean delayed = false;
                if (showCheck && (order.past_days >= 180) && isHasDeletePermission) {
                    viewHolder.rbSelect.setVisibility(View.VISIBLE);
                } else {
                    viewHolder.rbSelect.setVisibility(View.GONE);
                }
                viewHolder.rbSelect.setChecked(order.isDeleteSelected);
                viewHolder.rbSelect.setOnCheckedChangeListener((compoundButton, b) -> {
                    if (compoundButton.isPressed()) {
                        order.isDeleteSelected = b;
                        rtcClicked.onItemClick(compoundButton, position, order);
                    }
                });
                if (!isDinein) {
                    isPreOrder = CommonFunctions.isPreOrder(order.delivery_date, order.status);
                }
                String paymentStatus;
                if (order.payment_status.equalsIgnoreCase("p")) {
                    paymentStatus = "Paid";
                } else {
                    paymentStatus = "Unpaid";
                }

                String chipMessage = "Tap to view";
                if (order.status.equalsIgnoreCase("pending")) {
                    chipMessage = "Tap to view";
                } else if (order.status.equalsIgnoreCase("delivered")) {
                    if (isDinein) {
                        chipMessage = "Served";
                    } else {
                        if (order.order_type.equalsIgnoreCase("delivery")) {
                            chipMessage = "Delivered";
                        } else {
                            chipMessage = "Collected";
                        }
                    }
                } else if (order.status.equalsIgnoreCase("accepted") || order.status.equalsIgnoreCase("waiting") || order.status.equalsIgnoreCase("driver accepted")) {
                    if (isDinein) {
                        chipMessage = "Mark as served";
                    } else {
                        if (order.order_type.equalsIgnoreCase("delivery")) {
                            chipMessage = "Mark as delivered";
                        } else {
                            chipMessage = "Mark as collected";
                            // TODO Check if business has RTC enabled or NOT
                        }
                        Date preparationDate = CommonFunctions.convertStringDateToDate(order.preparation, "hh:mm a");
                        Date nowDate = CommonFunctions.convertStringDateToDate(CommonFunctions.getCurrentTimeFormatted("hh:mm a"), "hh:mm a");

                        delayed = preparationDate.getTime() < nowDate.getTime();
                    }

                } else if (order.status.equalsIgnoreCase("failed")) {
                    chipMessage = "Rejected";
                }

                if (order.status.equalsIgnoreCase("pending")) {
                    if (isPreOrder) {
                        //viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_orange));
                        viewHolder.llMainView.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_orange));
                    } else {
                        if (isDinein) {
                            //viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_amber));
                            viewHolder.llMainView.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_amber));
                        } else if (order.order_type.equalsIgnoreCase("delivery")) {
                            //viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_green));
                            viewHolder.llMainView.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_green));
                        } else if (order.order_type.equalsIgnoreCase("pickup") ||
                                order.order_type.equalsIgnoreCase("collection")) {
                            //viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_indigo));
                            viewHolder.llMainView.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_indigo));
                        }
                    }
                    viewHolder.tvStatus.setVisibility(View.VISIBLE);
                    viewHolder.tvOrderStatus.setTextColor(activity.getResources().getColor(R.color.white));
                    viewHolder.tvCustomerName.setTextColor(activity.getResources().getColor(R.color.white));
                    viewHolder.tvView.setVisibility(View.INVISIBLE);
                    viewHolder.ivPrint.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.white)));

                } else {
                    if (delayed) {
                        //                    viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_delay));
                        viewHolder.tvStatus.setVisibility(View.VISIBLE);
                        viewHolder.llMainView.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_delay));
                        viewHolder.tvOrderStatus.setTextColor(activity.getResources().getColor(R.color.white));
                        viewHolder.tvCustomerName.setTextColor(activity.getResources().getColor(R.color.white));
                        viewHolder.tvView.setTextColor(activity.getResources().getColor(R.color.white));
                        viewHolder.ivPrint.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.white)));
                    } else {
                        viewHolder.llMainView.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_grey));
                        viewHolder.tvStatus.setVisibility(View.GONE);
                        viewHolder.tvOrderStatus.setTextColor(activity.getResources().getColor(R.color.light_black));
                        viewHolder.tvCustomerName.setTextColor(activity.getResources().getColor(R.color.light_black));
                        viewHolder.tvView.setTextColor(activity.getResources().getColor(R.color.light_black));
                        viewHolder.ivPrint.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.black)));
                    }
                    viewHolder.tvView.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
                    viewHolder.tvView.setVisibility(View.VISIBLE);
                }
                if (order.status.equalsIgnoreCase("pending"))
                    viewHolder.ivPrint.setVisibility(View.INVISIBLE);
                else
                    viewHolder.ivPrint.setVisibility(View.VISIBLE);


                if (order.status.equalsIgnoreCase("delivered")) {
                    viewHolder.cvAction.setEnabled(false);
                    viewHolder.tvAction.setTextColor(activity.getResources().getColor(R.color.chip_green_color));
                } else if (order.status.equalsIgnoreCase("failed")) {
                    viewHolder.cvAction.setEnabled(false);
                    viewHolder.tvAction.setTextColor(activity.getResources().getColor(R.color.chip_orange_color));
                } else if (order.status.equalsIgnoreCase("accepted")) {
                    viewHolder.cvAction.setEnabled(true);
                    viewHolder.tvAction.setTextColor(activity.getResources().getColor(R.color.chip_green_color));
                } else {
                    viewHolder.tvAction.setTextColor(activity.getResources().getColor(R.color.chip_green_color));
                }
                viewHolder.tvCustomerName.setText(order.customer_name);
                if (isDinein) {
                    viewHolder.tvOrderStatus.setText("Dine in");
                    viewHolder.tvPreOrder.setVisibility(View.GONE);
                } else {
                    String orderType = (order.order_type).substring(0, 1).toUpperCase() + (order.order_type).substring(1);
                    if (orderType.equalsIgnoreCase("pickup")) {
                        orderType = "Collection";
                    } else {
                        orderType = (order.order_type).substring(0, 1).toUpperCase() + (order.order_type).substring(1);
                    }
                    if (isPreOrder) {
                        viewHolder.tvPreOrder.setVisibility(View.VISIBLE);
                        viewHolder.tvPreOrder.setText("Pre-order: " + CommonFunctions.formatUnknownDateTime(order.delivery_date, "yyyy-MM-dd", "dd/MM/yyyy"));
                        viewHolder.tvOrderStatus.setText(orderType);
                        viewHolder.tvCustomerName.setText(order.customer_name);
                    } else {
                        if (delayed) {
                            viewHolder.tvPreOrder.setVisibility(View.VISIBLE);
                            viewHolder.tvPreOrder.setText("Delayed");
                            viewHolder.tvOrderStatus.setText(orderType);
                            viewHolder.tvCustomerName.setText(order.customer_name);
                        } else {
                            viewHolder.tvPreOrder.setVisibility(View.GONE);
                            viewHolder.tvOrderStatus.setText(orderType);
                        }
                    }
                }

                viewHolder.tvStatus.setText(paymentStatus);
                if (paymentStatus.equalsIgnoreCase("Paid")) {
                    viewHolder.tvStatus.setTextColor(activity.getResources().getColor(R.color.chip_green_color));
                } else {
                    viewHolder.tvStatus.setTextColor(activity.getResources().getColor(R.color.reject_color));
                }
                Log.e("status", "" + order.payment_status);
                Log.e("status", "" + order.status);


                viewHolder.tvAction.setText(chipMessage);
                viewHolder.cvAction.setOnClickListener(v -> {
                    if (itemViewClickListener != null) {
                        itemViewClickListener.onItemClick(v, position, order);
                    }
                });

                viewHolder.tvView.setOnClickListener(v -> {
                    if (viewClickListener != null) {
                        viewClickListener.onItemClick(v, position, order);
                    }
                });
                viewHolder.ivPrint.setOnClickListener(v -> {
                    if (printClickListener != null) {
                        printClickListener.onItemClick(v, position, order);
                    }
                });
                viewHolder.cvOrder.setOnClickListener(view -> {
                    if (viewClickListener != null) {
                        viewClickListener.onItemClick(view, position, order);
                    }
                });
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return ordersList.size();
    }


    protected static class OrderViewHolder extends RecyclerView.ViewHolder {
        private MaterialCardView cvOrder, cvAction;
        private LinearLayout llMainView;
        private TextView tvOrderStatus, tvCustomerName, tvView, tvAction, tvPreOrder, tvStatus;
        private AppCompatImageView ivPrint;
        CheckBox rbSelect;

        public OrderViewHolder(@NonNull View itemView) {
            super(itemView);
            rbSelect = itemView.findViewById(R.id.rbSelect);
            cvOrder = itemView.findViewById(R.id.cvOrder);
            tvOrderStatus = itemView.findViewById(R.id.tvOrderStatus);
            tvCustomerName = itemView.findViewById(R.id.tvName);
            ivPrint = itemView.findViewById(R.id.ivPrint);
            tvView = itemView.findViewById(R.id.tvView);
            tvAction = itemView.findViewById(R.id.tvAction);
            tvPreOrder = itemView.findViewById(R.id.tvPreOrder);
            tvStatus = itemView.findViewById(R.id.tvStatus);
            llMainView = itemView.findViewById(R.id.llMainView);
            cvAction = itemView.findViewById(R.id.cvAction);
        }
    }

    protected static class OrderStatusHeaderViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTitle;

        public OrderStatusHeaderViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
        }
    }
}
