package com.ubsidi.epos_2021.online.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;

import java.text.DecimalFormat;
import java.util.ArrayList;

/**
 * Created by Amrish on 07-09-2020.
 */
public class OrderedProductItemsAdapter extends RecyclerView.Adapter<OrderedProductItemsAdapter.ItemViewHolder> {

    private ArrayList<OrderProductDetail> orderedItems;
    private boolean showPrice = false;

    public OrderedProductItemsAdapter(ArrayList<OrderProductDetail> orderedItems) {
        this.orderedItems = orderedItems;
    }

    public OrderedProductItemsAdapter(ArrayList<OrderProductDetail> orderedItems, boolean showPrice) {
        this.orderedItems = orderedItems;
        this.showPrice = showPrice;
    }

    private DecimalFormat df = new DecimalFormat("#.##");

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ItemViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_online_ordered_product_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder holder, int position) {

        try {
            OrderProductDetail cart = orderedItems.get(position);
            holder.tvName.setText(cart.menu_name);
            holder.tvCount.setText(String.valueOf(cart.quantity) + "x");

            if (cart.subaddons_name.contains("<br>")) {
                String str = cart.subaddons_name.replace("<br>", System.lineSeparator());
                holder.tvSubAddon.setText(str);
            } else {
                holder.tvSubAddon.setText(cart.subaddons_name);
            }
            if (!Validators.isNullOrEmpty(cart.subaddons_name)) {
                holder.tvSubAddon.setVisibility(View.VISIBLE);
            } else {
                holder.tvSubAddon.setVisibility(View.GONE);
            }
            if (showPrice) {
                holder.tvPrice.setVisibility(View.VISIBLE);
            } else {
                holder.tvPrice.setVisibility(View.GONE);
            }
            holder.tvPrice.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(cart.total_price)));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderedItems.size();
    }

    @Override
    public long getItemId(int position) {
        return orderedItems.get(position).id;
    }

    protected static class ItemViewHolder extends RecyclerView.ViewHolder {

        private TextView tvCount, tvName, tvPrice, tvSubAddon;

        public ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            tvCount = itemView.findViewById(R.id.tvCount);
            tvName = itemView.findViewById(R.id.tvName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvSubAddon = itemView.findViewById(R.id.tvSubAddon);
        }
    }
}
