package com.ubsidi.epos_2021.online.base;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Printer;

import java.util.HashMap;

/**
 * Created by Amrish on 11-11-2020.
 */
public class BaseDialog extends DialogFragment {
    protected MyApp myApp = MyApp.getInstance();
    protected AlertDialog progressDialog;
    protected HashMap<String, Object> intentExtrasData = new HashMap<>();
    protected AppCompatImageView ivClose;
    protected Admin loggedInAdmin = myApp.myPreferences.getLoggedInAdmin();
    protected Business selectedBusiness = loggedInAdmin.selected_business;
    protected Printer defaultPrinter;

    @Override
    public int getTheme() {
        if (Build.VERSION.SDK_INT > 21) {
            return R.style.BottomSheetDialogTheme;
        } else {
            return super.getTheme();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        manageIntents();
        initViews(view);
        setListeners();
    }

    protected void manageIntents() {
        Bundle bundle = getArguments();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                intentExtrasData.put(key, bundle.get(key));
            }
        }
    }

    protected void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity(), "Loading...");
        defaultPrinter = myApp.myPreferences.getDefaultPrinter();
    }

    protected void setListeners() {
        if (ivClose != null) {
            ivClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                }
            });
        }
    }
}
