package com.ubsidi.epos_2021.online.base;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;

import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Printer;

/**
 * Created by admin on 22-01-2018.
 */

public class BaseFragment extends Fragment {

    protected MyApp myApp = MyApp.getInstance();
    protected AlertDialog progressDialog;
    protected Admin loggedInAdmin = myApp.myPreferences.getLoggedInAdmin();
    protected Business selectedBusiness = loggedInAdmin.selected_business;
    protected Printer defaultPrinter;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        manageIntents();
        initViews(view);
    }

    protected void manageIntents() {
    }

    protected void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity(), "Loading...");
        defaultPrinter = myApp.myPreferences.getDefaultPrinter();
    }


}
