package com.ubsidi.epos_2021.online.fragments;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.TimePicker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.adapters.TimeslotsSelectionAdapter;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * Created by Amrish on 11-11-2020.
 */
public class DelayOrderSetTimeBottomSheetFragment extends DialogFragment {
    private int order_type = -1; // 0 dinein, 1 delivery, 2 pickup
    private String order_id;
    private boolean delay;
    private ArrayList<String> timeSlotsString = new ArrayList<>();
    private TimeslotsSelectionAdapter adapter;
    private RecyclerView rvSlots;
    private LinearLayout llLoading;
    private String selectedTimeSlot = "";
    private LinearLayout llData;
    private MaterialButton btnConfirm, btnCancel;
    private DialogDismissListener dialogDismissListener;
    private TextView tvSelectedTime;
    private AlertDialog progressDialog;
    private Chip chipBack;

    @Override
    public int getTheme() {
        return R.style.MyRightDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        getDialog().getWindow().setGravity(Gravity.END);
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_online_order_delay_settime_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                delay = getArguments().getBoolean("delay");
                order_id = getArguments().getString("order_id");
                order_type = getArguments().getInt("order_type");
            }

            initViews(view);
            fetchTimeSlots();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void initViews(View view) {
        chipBack = view.findViewById(R.id.chipBack);
        progressDialog = CommonFunctions.customProgressDialog(getActivity());
        llLoading = view.findViewById(R.id.llLoading);
        rvSlots = view.findViewById(R.id.rvTimeSlots);
        llData = view.findViewById(R.id.llData);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnCancel = view.findViewById(R.id.btnCancel);
        TextView tvTitle = view.findViewById(R.id.tvTitle);
        TextView tvSubTitle = view.findViewById(R.id.tvSubTitle);
        tvSelectedTime = view.findViewById(R.id.tvSelectedTime);

        adapter = new TimeslotsSelectionAdapter(timeSlotsString, (position, data) -> {
            try {
                adapter.notifyDataSetChanged();
                if (position < timeSlotsString.size() - 1) {
                    selectedTimeSlot = (String) data;
                    if (order_type == 1) {
                        tvSelectedTime.setText("New delivery time " + selectedTimeSlot + " selected");
                        tvSelectedTime.setVisibility(View.VISIBLE);
                    }
                    if (order_type == 2) {
                        tvSelectedTime.setVisibility(View.VISIBLE);
                        tvSelectedTime.setText("New collection time " + selectedTimeSlot + " selected");
                    }
                }
                if (position == timeSlotsString.size() - 1) {
                    Calendar calendar = Calendar.getInstance();

                    TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), timeSetListener, calendar.get(Calendar.HOUR_OF_DAY), calendar.get(Calendar.MINUTE), false);
                    timePickerDialog.show();
                    timePickerDialog.setOnCancelListener(dialogInterface -> {
                        adapter.selectedTimeslot = selectedTimeSlot;
                        timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
                        adapter.notifyDataSetChanged();
                        if (order_type == 1) {
                            tvSelectedTime.setText("New delivery time " + selectedTimeSlot + " selected");
                            tvSelectedTime.setVisibility(View.VISIBLE);
                        }
                        if (order_type == 2) {
                            tvSelectedTime.setVisibility(View.VISIBLE);
                            tvSelectedTime.setText("New collection time " + selectedTimeSlot + " selected");
                        }
                        if (Validators.isNullOrEmpty(selectedTimeSlot)) {
                            tvSelectedTime.setVisibility(View.GONE);
                        }
                    });


                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        rvSlots.setAdapter(adapter);
        rvSlots.setLayoutManager(new GridLayoutManager(getActivity(), 2));
        if (order_type == 1) {
            tvSubTitle.setText("Please select new time for delivery of the order");
        } else if (order_type == 2) {
            tvSubTitle.setText("Please select new time for pickup of the order");
        } else {
            tvSubTitle.setVisibility(View.GONE);
        }

        if (order_type == 2) {
            if (delay) {
                tvTitle.setText("Delay Order");
            } else {
                tvTitle.setText("Collection Order");
            }
        } else if (order_type == 1) {
            if (delay) {
                tvTitle.setText("Delay Order");
            } else {
                tvTitle.setText("Delivery Order");
            }
        } else {
            if (delay) {
                tvTitle.setText("Delay order");
            } else {
                tvTitle.setText("Select Time");
            }
        }
    }

    private void setListeners() {
        chipBack.setOnClickListener(view -> dismiss());
        btnCancel.setOnClickListener(view -> dismiss());
        btnConfirm.setOnClickListener(view -> {
            try {
                if (!Validators.isNullOrEmpty(selectedTimeSlot)) {
                    if (delay) {
                        acceptOrder("Accepted");
                    } else
                        acceptOrder("Accepted");
                } else ToastUtils.makeToast(getActivity(), "Please select time slot first.");
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void acceptOrder(String status) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            String url = ApiEndPoints.online_orders_status_change;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }
            AndroidNetworking.post(url)
                    .addPathParameter("id", order_id)
                    .addBodyParameter("order_id", order_id)
                    .addBodyParameter("preparation", selectedTimeSlot)
                    .addBodyParameter("status", status)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            if (dialogDismissListener != null) {
                                dialogDismissListener.onDialogDismiss(selectedTimeSlot);
                                dismiss();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchTimeSlots() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                    llData.setVisibility(View.GONE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.online_orders_time_slots)
                    .addPathParameter("id", order_id)
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                    llData.setVisibility(View.VISIBLE);
                                });
                            }
                            timeSlotsString.clear();
                            timeSlotsString.addAll(new Gson().fromJson(response.toString(), new TypeToken<List<String>>() {
                            }.getType()));
                            timeSlotsString.add("Custom");
                            adapter.notifyDataSetChanged();
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                });
                            }
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void selectOldTimeSlot() {
        adapter.selectedTimeslot = selectedTimeSlot;
        timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
        adapter.notifyDataSetChanged();
    }

    TimePickerDialog.OnTimeSetListener timeSetListener = new TimePickerDialog.OnTimeSetListener() {
        @Override
        public void onTimeSet(TimePicker timePicker, int hour, int minutes) {
            Calendar calendar = Calendar.getInstance();
            int currentHour = calendar.get(Calendar.HOUR_OF_DAY);
            int currentMinute = calendar.get(Calendar.MINUTE);
            boolean valid = false;
            String pickedTime = hour + ":" + minutes;
            String current = currentHour + ":" + currentMinute;
            if (hour == currentHour) {
                valid = minutes >= currentMinute;
            } else valid = hour > currentHour;
            if (valid) {
                String timeSet = "";
                if (hour > 12) {
                    hour -= 12;
                    timeSet = "PM";
                } else if (hour == 0) {
                    hour += 12;
                    timeSet = "AM";
                } else if (hour == 12) {
                    timeSet = "PM";
                } else {
                    timeSet = "AM";
                }

                String min = "";
                if (minutes < 10)
                    min = "0" + minutes;
                else
                    min = String.valueOf(minutes);
                selectedTimeSlot = String.valueOf(hour) + ':' + min + " " + timeSet;
                adapter.selectedTimeslot = selectedTimeSlot;
                timeSlotsString.set(timeSlotsString.size() - 1, selectedTimeSlot);
                adapter.notifyDataSetChanged();
            } else {
                selectedTimeSlot = "";
                ToastUtils.makeToast(getActivity(), "Invalid timeslot");
                selectOldTimeSlot();
            }
        }
    };


}
