package com.ubsidi.epos_2021.online.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;


/**
 * Created by Amrish on 11-11-2020.
 */
public class EnterPasswordDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String forWhat, yes_no, title, info;
    private MaterialButton btnConfirm, btnCancel;
    private AppCompatEditText etPassword;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_enter_password, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                forWhat = getArguments().getString("for_what");
                yes_no = getArguments().getString("yes_no");
                info = getArguments().getString("info");
                title = getArguments().getString("title");
            }
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnCancel = view.findViewById(R.id.btnCancel);
        etPassword = view.findViewById(R.id.etPassword);
        TextView tvInfo = view.findViewById(R.id.tvInfo);
        TextView tvTitle = view.findViewById(R.id.tvTitle);

        if (forWhat != null && forWhat.equalsIgnoreCase("online_order")) {
            if (yes_no.equalsIgnoreCase("yes"))
                tvInfo.setText("Please enter your password to turn on online orders");
            else tvInfo.setText("Please enter your password to turn off online orders");
        } else if (forWhat != null && forWhat.equalsIgnoreCase("booking_status")) {
            if (yes_no.equalsIgnoreCase("yes"))
                tvInfo.setText("Please enter your password to turn on reservations");
            else tvInfo.setText("Please enter your password to turn off reservations");
        } else {
            tvInfo.setText(info);
            tvTitle.setText(title);
        }
    }

    private void setListeners() {
        btnConfirm.setOnClickListener(view -> {
            etPassword.setError(null);
            if (!Validators.isNullOrEmpty(forWhat)) {
                if (etPassword.getText().toString().isEmpty()) {
                    etPassword.setError("Please enter password");
                } else {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(etPassword.getText().toString());
                    dismiss();
                    CommonFunctions.hideKeyboard(getActivity(), etPassword);
                }
            } else {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(etPassword.getText().toString());
                dismiss();
                CommonFunctions.hideKeyboard(getActivity(), etPassword);
            }
        });
        btnCancel.setOnClickListener(view ->
        {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss(null);
            dismiss();
        });
    }


}
