package com.ubsidi.epos_2021.online.fragments;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.imin.library.IminSDKManager;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.SurChargesAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.SurChargesModel;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.adapters.OrderedProductItemsAdapter;
import com.ubsidi.epos_2021.online.base.BaseDialog;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 03-06-2021.
 */
public class OnlineOrderViewFragment extends BaseDialog {
    private DialogDismissListener dialogDismissListener;
    private int order_type = -1; // 0 dinein, 1 delivery, 2 pickup
    private String order_id;
    private RecyclerView rvSurCharges;
    private ArrayList<SurChargesModel> surChargesArrayList = new ArrayList<>();
    private SurChargesAdapter surChargesAdapter;
    private OrderedProductItemsAdapter productItemsAdapter;
    private ArrayList<OrderProductDetail> productDetails = new ArrayList<>();
    private TextView tvOrderNumber, tvOrderPaymentStatus, tvOrderDate, tvDeliveryTime, tvMiles, tvCustomerName, tvCustomerMobile, tvDeliveryAddress, tvTotal, tvPaymentMethodName, tvCardDetails, tvReadMore, tvInstructions, tvInstructionTitle;
    private MaterialCardView cvInstruction, cvDeliveryInstructions;
    private LinearLayout cvData;
    private MaterialButton btnAccept, btnReject, btnDelay, btnSetReminder, btnPrint, btnOnTheWay, btnReadytoCollect;
    private OrderDetail orderDetail;
    private final Restaurant savedRestaurant = myApp.myPreferences.getRestaurant();
    private ZoneRichPrinter zoneRichPrinter;
    private WifiPrinter wifiPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private TextView tvSubTotal, tvServiceCharge, tvDeliveryFee, tvTipAmount, tvCharityAmount, tvDiscount, tvRewardDiscount, tvRewardDiscountLabel, tvWalletAmount, tvGratuityAmount, tvDeliveryInstructionsTitle, tvDeliveryInstruction, tvDeliveryReadMore;
    private LinearLayout llDiscount, llDeliveryFee, llCharityAmount, llTipAmount, llWalletAmountl, llRewardDiscount, llLoading, llServiceCharge, llGratuity;
    private TextView tvPreparationTime;
    private Chip ivBack;
    protected Printer defaultOnlineKitchenPrinter;
    private String lastPrintIp;
    private SiteSetting kitchenCopyType, buzzerSetting;
    private MaterialCardView llMainLayout;
    private BluetoothPrinter bluetoothPrinter;
    private OrderSetTimeDialogFragment orderSetTimeBottomSheetFragment;

    @Nullable
    @org.jetbrains.annotations.Nullable
    @Override
    public View onCreateView(@NonNull @NotNull LayoutInflater inflater, @Nullable @org.jetbrains.annotations.Nullable ViewGroup container, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_online_order_view, container, false);
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        fetchData();
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {

            order_id = getArguments().getString("order_id");
            order_type = getArguments().getInt("order_type");
        }

    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        zoneRichPrinter = new ZoneRichPrinter(getActivity());
        zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
        sunmiPrinter = new SunmiPrinter(getActivity());
        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
            sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
        }
        wifiPrinter = WifiPrinter.getInstance();
        bluetoothPrinter = new BluetoothPrinter(getActivity());
        kitchenCopyType = myApp.findSetting("kitchen_copy_type");
        buzzerSetting = myApp.findSetting("open_cash_drawer_after_send_to_kitchen");
        SiteSetting kitchenPrinterSetting = myApp.findSetting("default_prep_location_for_web");

        if (kitchenPrinterSetting != null && !Validators.isNullOrEmpty(kitchenPrinterSetting.value)) {
            for (Printer p : loggedInAdmin.selected_business.printers) {
                if (p.id.equalsIgnoreCase(kitchenPrinterSetting.value)) {
                    defaultOnlineKitchenPrinter = p;
                    break;
                }
            }
        }
        RecyclerView rvCartItems = view.findViewById(R.id.rvCartItems);
        tvOrderNumber = view.findViewById(R.id.tvOrderNumber);
        tvOrderPaymentStatus = view.findViewById(R.id.tvOrderPaymentStatus);
        tvOrderDate = view.findViewById(R.id.tvOrderDate);
        tvDeliveryTime = view.findViewById(R.id.tvDeliveryTime);
        tvMiles = view.findViewById(R.id.tvMiles);
        tvCustomerName = view.findViewById(R.id.tvCustomerName);
        tvCustomerMobile = view.findViewById(R.id.tvCustomerMobile);
        tvDeliveryAddress = view.findViewById(R.id.tvDeliveryAddress);
        tvTotal = view.findViewById(R.id.tvTotal);
        tvPaymentMethodName = view.findViewById(R.id.tvPaymentMethodName);
        tvCardDetails = view.findViewById(R.id.tvCardDetails);
        tvReadMore = view.findViewById(R.id.tvReadMore);
        cvInstruction = view.findViewById(R.id.cvInstruction);
        tvInstructions = view.findViewById(R.id.tvInstructions);
        tvInstructionTitle = view.findViewById(R.id.tvInstructionsTitle);
        rvSurCharges = view.findViewById(R.id.rvSurCharges);
        tvDeliveryReadMore = view.findViewById(R.id.tvDeliveryReadMore);
        cvDeliveryInstructions = view.findViewById(R.id.cvDeliveryInstruction);
        tvDeliveryInstruction = view.findViewById(R.id.tvDeliveryInstructions);
        tvDeliveryInstructionsTitle = view.findViewById(R.id.tvDeliveryInstructionsTitle);

        tvPreparationTime = view.findViewById(R.id.tvPreparationTime);

        tvSubTotal = view.findViewById(R.id.tvSubtotal);
        tvServiceCharge = view.findViewById(R.id.tvServiceFee);
        tvDeliveryFee = view.findViewById(R.id.tvDeliveryFee);
        tvDiscount = view.findViewById(R.id.tvDiscount);
        tvTipAmount = view.findViewById(R.id.tvTipAmount);
        tvRewardDiscount = view.findViewById(R.id.tvRewardDiscount);
        tvRewardDiscountLabel = view.findViewById(R.id.tvRewardDiscountLabel);
        tvCharityAmount = view.findViewById(R.id.tvCharityAmount);
        tvWalletAmount = view.findViewById(R.id.tvWalletAmount);
        tvGratuityAmount = view.findViewById(R.id.tvGratuityAmount);

        llCharityAmount = view.findViewById(R.id.ll_CharityAmount);
        llDeliveryFee = view.findViewById(R.id.ll_Delivery);
        llDiscount = view.findViewById(R.id.ll_Discount);
        llTipAmount = view.findViewById(R.id.ll_TipAmount);
        llWalletAmountl = view.findViewById(R.id.ll_WalletAmount);
        llRewardDiscount = view.findViewById(R.id.llRewardDiscount);
        llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
        llGratuity = view.findViewById(R.id.ll_Gratuity);

        llLoading = view.findViewById(R.id.llLoading);
        cvData = view.findViewById(R.id.cvData);
        btnAccept = view.findViewById(R.id.btnAccept);
        btnReject = view.findViewById(R.id.btnReject);
        btnSetReminder = view.findViewById(R.id.btnReminder);
        btnDelay = view.findViewById(R.id.btnDelayOrder);
        btnPrint = view.findViewById(R.id.btnPrint);
        btnOnTheWay = view.findViewById(R.id.btnOnTheWay);
        btnReadytoCollect = view.findViewById(R.id.btnReadytoCollect);
        ivBack = view.findViewById(R.id.chipBack);
        llMainLayout = view.findViewById(R.id.llMainLayout);

        rvCartItems.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        productItemsAdapter = new OrderedProductItemsAdapter(productDetails, true);
        rvCartItems.setNestedScrollingEnabled(false);
        rvCartItems.setAdapter(productItemsAdapter);

        rvSurCharges.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        surChargesAdapter = new SurChargesAdapter(requireActivity(), surChargesArrayList, (position, data) -> {

        });
        rvSurCharges.setNestedScrollingEnabled(false);
        rvSurCharges.setAdapter(surChargesAdapter);
    }

    private void updateViews() {

        if (orderDetail != null) {
            boolean isPreOrder;
            if (order_type > 0)
                isPreOrder = CommonFunctions.isPreOrder(orderDetail.delivery_date, orderDetail.status);
            else isPreOrder = false;
            String orderType = CommonFunctions.getOnlineOrderType(order_type);
            Log.e("order_type", " " + orderType);

            if (orderType.equals("Pickup")) {
                btnOnTheWay.setVisibility(View.GONE);
                btnReadytoCollect.setVisibility(View.VISIBLE);
            } else if (orderType.equals("Delivery")) {
                btnOnTheWay.setVisibility(View.VISIBLE);
                btnReadytoCollect.setVisibility(View.GONE);
            } else {
                // btnOnTheWay.setVisibility(View.VISIBLE);
                btnReadytoCollect.setVisibility(View.GONE);
            }

            if (isPreOrder) {
                tvOrderPaymentStatus.setText("Preorder for " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd/MM/yyyy") + " - " + orderType + " - " + (orderDetail.payment_status.equalsIgnoreCase("p") ? "Paid" : "Unpaid"));
            } else
                tvOrderPaymentStatus.setText(orderType + " - " + (orderDetail.payment_status.equalsIgnoreCase("p") ? "Paid" : "Unpaid"));
            tvOrderNumber.setText("#" + orderDetail.order_number);
            if (order_type == 1 && !Validators.isNullOrEmpty(orderDetail.distance)) {
                tvMiles.setText(orderDetail.distance + " Away");
                tvMiles.setVisibility(View.VISIBLE);
            } else {
                tvMiles.setVisibility(View.GONE);
            }

            try {
                if (order_type == 0) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(tvOrderPaymentStatus.getContext(), R.color.orders_card_bg_amber));
                } else if (order_type == 1) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(tvOrderPaymentStatus.getContext(), R.color.orders_card_bg_green));
                } else if (order_type == 2) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(tvOrderPaymentStatus.getContext(), R.color.orders_card_bg_indigo));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (isPreOrder) {
                tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(tvOrderPaymentStatus.getContext(), R.color.orders_card_bg_orange));
            }
            StringBuilder personalDetails = new StringBuilder();
            personalDetails.append("Name: ");
            personalDetails.append(orderDetail.customer_name);
            tvCustomerName.setText(personalDetails.toString());
            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                personalDetails = new StringBuilder();
                personalDetails.append("Mobile: ");
                personalDetails.append(orderDetail.customer_phone);
                tvCustomerMobile.setText(personalDetails.toString());
                tvCustomerMobile.setVisibility(View.VISIBLE);
            } else {
                tvCustomerMobile.setVisibility(View.GONE);
            }

            if (order_type == 1 && !Validators.isNullOrEmpty(orderDetail.address)) {
                personalDetails = new StringBuilder();
                personalDetails.append("Delivery Address: ");
                personalDetails.append(orderDetail.address);
                tvDeliveryAddress.setText(personalDetails.toString());
                tvDeliveryAddress.setVisibility(View.VISIBLE);
            } else {
                tvDeliveryAddress.setVisibility(View.GONE);
            }
            if (!Validators.isNullOrEmpty(orderDetail.created)) {
                personalDetails = new StringBuilder();
                personalDetails.append("Ordered at: ");
                personalDetails.append(CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a, dd-MM-yyyy"));
                tvOrderDate.setText(personalDetails.toString());
                tvOrderDate.setVisibility(View.VISIBLE);
            } else {
                tvOrderDate.setVisibility(View.GONE);
            }

            personalDetails = new StringBuilder();
            if (order_type > 0) {
                personalDetails.append("Required by: ");
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    personalDetails.append("ASAP");
                } else {
                    personalDetails.append(orderDetail.delivery_time);
                    personalDetails.append(", ").append(CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"));
                }
            } else {
                personalDetails = new StringBuilder();
                personalDetails.append("Served by: ");
                personalDetails.append("ASAP");
            }
            tvDeliveryTime.setText(personalDetails.toString());


            if (order_type > 0 && orderDetail.status.equalsIgnoreCase("accepted")) {
                tvPreparationTime.setVisibility(View.VISIBLE);
                tvPreparationTime.setText(orderDetail.preparation + " Selected");
            } else
                tvPreparationTime.setVisibility(View.GONE);


            tvSubTotal.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.order_sub_total)));
            if (orderDetail.service_charge > 0) {
                if ("no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                    llServiceCharge.setVisibility(View.GONE);
                    orderDetail.order_grand_total = (orderDetail.order_grand_total - orderDetail.service_charge);
                } else {
                    llServiceCharge.setVisibility(View.VISIBLE);
                }

                tvServiceCharge.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.service_charge)));
            } else {
                llServiceCharge.setVisibility(View.GONE);
            }
            tvTotal.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.order_grand_total + orderDetail.charity_amount)));

            if (orderDetail.offer_amount + orderDetail.voucher_amount > 0) {
                tvDiscount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.voucher_amount + orderDetail.offer_amount)));
                llDiscount.setVisibility(View.VISIBLE);
            } else {
                llDiscount.setVisibility(View.GONE);
            }

            if (orderDetail.reward_offer > 0) {
                tvRewardDiscountLabel.setText("Redeem Amount (" + orderDetail.reward_offer_percentage + "%)");
                tvRewardDiscount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.reward_offer)));
                llRewardDiscount.setVisibility(View.VISIBLE);
            } else {
                llRewardDiscount.setVisibility(View.GONE);
            }


            if (orderDetail.delivery_charge > 0) {
                tvDeliveryFee.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.delivery_charge)));
                llDeliveryFee.setVisibility(View.VISIBLE);
            } else {
                llDeliveryFee.setVisibility(View.GONE);
            }

            if (orderDetail.driver_tip > 0) {
                tvTipAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format((orderDetail.driver_tip))));
                llTipAmount.setVisibility(View.VISIBLE);
            } else {
                llTipAmount.setVisibility(View.GONE);
            }
            if (orderDetail.charity_amount > 0)
                tvCharityAmount.setText(String.format("%s%s", orderDetail.charity_message + "(" + MyApp.currencySymbol, MyApp.df.format(orderDetail.charity_amount)) + ")");
            else {
                llCharityAmount.setVisibility(View.GONE);
            }

            if (orderDetail.wallet_amount > 0)
                tvWalletAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.wallet_amount)));
            else
                llWalletAmountl.setVisibility(View.GONE);


            if (orderDetail.gratuity > 0) {
                tvGratuityAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.gratuity)));
                llGratuity.setVisibility(View.VISIBLE);
            } else {
                llGratuity.setVisibility(View.GONE);
            }

            if (Validators.isNullOrEmpty(orderDetail.order_description)) {
                tvInstructionTitle.setVisibility(View.GONE);
                cvInstruction.setVisibility(View.GONE);
            } else {
                tvInstructionTitle.setVisibility(View.VISIBLE);
                cvInstruction.setVisibility(View.VISIBLE);
                if (orderDetail.order_description.length() > 50) {
                    tvReadMore.setVisibility(View.GONE);
                    //  tvInstructions.setText(orderDetail.orderdescrption.substring(0, 50));
                    tvInstructions.setText(orderDetail.order_description);
                } else {
                    tvInstructions.setText(orderDetail.order_description);
                    tvReadMore.setVisibility(View.GONE);
                }
            }
            if (Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                tvDeliveryInstructionsTitle.setVisibility(View.GONE);
                cvDeliveryInstructions.setVisibility(View.GONE);
            } else {
                tvDeliveryInstructionsTitle.setVisibility(View.VISIBLE);
                cvDeliveryInstructions.setVisibility(View.VISIBLE);
                if (orderDetail.delivery_instruction.length() > 50) {
                    tvDeliveryReadMore.setVisibility(View.GONE);
                    tvDeliveryInstruction.setText(orderDetail.delivery_instruction);
                    //  tvDeliveryInstruction.setText(orderDetail.delivery_instruction.substring(0, 50));
                } else {
                    tvDeliveryInstruction.setText(orderDetail.delivery_instruction);
                    tvDeliveryReadMore.setVisibility(View.GONE);
                }
            }
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) {
                if (!Validators.isNullOrEmpty(orderDetail.card_brand)) {
                    tvCardDetails.setText(String.format("**** %s", orderDetail.card_number));
                    tvCardDetails.setVisibility(View.VISIBLE);
                } else {
                    tvCardDetails.setVisibility(View.GONE);
                }
                tvPaymentMethodName.setText(String.format("%s%s Paid via Credit/Debit card", MyApp.currencySymbol, MyApp.df.format((orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount)));
            } else if (orderDetail.payment_method.equalsIgnoreCase("paypal")) {
                tvPaymentMethodName.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(((orderDetail.order_grand_total + orderDetail.charity_amount)) - orderDetail.wallet_amount)) + " Paid via Paypal");
            } else if (orderDetail.payment_method.equalsIgnoreCase("cod")) {
                if (orderDetail.payment_status.equalsIgnoreCase("p"))
                    tvPaymentMethodName.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format((orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount)) + " Paid via Cash");
                else {
                    if (order_type == 0)
                        tvPaymentMethodName.setText("Due to be payed at restaurant");
                    else if (order_type == 1)
                        tvPaymentMethodName.setText("Cash on delivery");
                    else if (order_type == 2)
                        tvPaymentMethodName.setText("Cash on collection");
                    tvPaymentMethodName.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
                }
            } else if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit")) {
                String paidVia;
                if (orderDetail.payment_method.equalsIgnoreCase("wallet")) {
                    paidVia = "Wallet";
                } else {
                    paidVia = "Credit";
                }
                tvPaymentMethodName.setText(tvTotal.getText().toString() + " Paid via " + paidVia);
            }
            String positiveButtonText = "Accept";
            btnReject.setVisibility(View.GONE);
            btnDelay.setVisibility(View.GONE);
            btnAccept.setEnabled(true);
            btnReject.setText("Reject");
            Log.e("Order_status", "" + orderDetail.status);
            if (orderDetail.status.equalsIgnoreCase("pending")) {
                btnReject.setVisibility(View.VISIBLE);
                btnAccept.setVisibility(View.VISIBLE);
                positiveButtonText = "Accept";
                if (!isPreOrder) {
                    btnSetReminder.setVisibility(View.GONE);
                } else {
                    btnSetReminder.setVisibility(View.VISIBLE);
                }
                // After accepting order below buttons will be visible
                btnReadytoCollect.setVisibility(View.GONE);
                btnOnTheWay.setVisibility(View.GONE);
            } else if (orderDetail.status.equalsIgnoreCase("accepted")) {
                if (order_type == 0) {
                    positiveButtonText = "Mark as served";
                } else if (order_type == 2) {
                    positiveButtonText = "Mark as collected";
                } else {
                    positiveButtonText = "Mark as delivered";
                }
                if (order_type > 0)
                    btnDelay.setVisibility(View.VISIBLE);
                btnAccept.setVisibility(View.VISIBLE);

            } else if (orderDetail.status.equalsIgnoreCase("delivered")) {
                btnAccept.setEnabled(false);
                if (order_type == 0) {
                    positiveButtonText = "Served";
                } else if (order_type == 2) {
                    positiveButtonText = "Collected";
                } else {
                    positiveButtonText = "Delivered";
                }
                btnReadytoCollect.setVisibility(View.GONE);
                btnOnTheWay.setVisibility(View.GONE);

            } else if (orderDetail.status.equalsIgnoreCase("failed")) {
                btnAccept.setVisibility(View.GONE);
                btnReadytoCollect.setVisibility(View.GONE);
                btnOnTheWay.setVisibility(View.GONE);

                btnReject.setVisibility(View.VISIBLE);
                positiveButtonText = "Rejected";
                btnReject.setEnabled(false);
                btnReject.setText("Rejected");

            }
            btnAccept.setText(positiveButtonText);
        }
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    protected void setListeners() {
        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //getActivity().onBackPressed();
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("cancel");
                }
                dismiss();
            }
        });
        btnPrint.setOnClickListener(view -> {
            printOrder();
        });

        tvReadMore.setOnClickListener(view -> {
            if (tvReadMore.getText().toString().contains("less")) {
                tvReadMore.setText("Read more");
                if (orderDetail.order_description.length() > 50)
                    tvInstructions.setText(orderDetail.order_description.substring(0, 50));
                else tvInstructions.setText(orderDetail.order_description);
            } else {
                tvReadMore.setText("Read less");
                tvInstructions.setText(orderDetail.order_description);
            }
        });

        tvDeliveryReadMore.setOnClickListener(view -> {
            if (tvDeliveryReadMore.getText().toString().contains("less")) {
                tvDeliveryReadMore.setText("Read more");
                if (orderDetail.order_description.length() > 50)
                    tvDeliveryInstruction.setText(orderDetail.delivery_instruction.substring(0, 50));
                else tvDeliveryInstruction.setText(orderDetail.delivery_instruction);
            } else {
                tvDeliveryReadMore.setText("Read less");
                tvDeliveryInstruction.setText(orderDetail.delivery_instruction);
            }
        });

        btnOnTheWay.setOnClickListener(view -> {
            Log.e("Order_Id", "" + order_id);
            SendNotificationToUser(order_id);
        });

        btnReadytoCollect.setOnClickListener(view -> {
            Log.e("Order_Id", "" + order_id);
            SendNotificationToUser(order_id);
        });

        btnAccept.setOnClickListener(view -> {
            if (btnAccept.getText().toString().equalsIgnoreCase("accept")) {
                if (order_type > 0) {
                    orderSetTimeBottomSheetFragment = getInstanceOrderSetTime(order_type, order_id, orderDetail);
                    orderSetTimeBottomSheetFragment.show(getActivity().getSupportFragmentManager(), "accept_order_set_time");
                    orderSetTimeBottomSheetFragment.setDialogDismissListener(acceptOrderDialogListener);
                } else {
                    acceptOrder("Accepted");
                }
            } else {
                if (orderDetail.status.equalsIgnoreCase("accepted"))
                    acceptOrder("Delivered");
                else {
                    ToastUtils.makeToast(getActivity(), "Unknown action");
                }
            }
        });
        btnSetReminder.setOnClickListener(view -> {
            PreorderSetReminderDialogFragment preorderSetReminderFragment = getInstancePreorderSetReminder(orderDetail);
            preorderSetReminderFragment.show(getChildFragmentManager(), "set_reminder");
        });
        btnReject.setOnClickListener(view -> {
            RejectReasonDialogFragment rejectReasonDialogFragment = getInstanceejectReason("Item out of stock, Not taking orders, Customer error, Other");
            rejectReasonDialogFragment.show(getChildFragmentManager(), "reject_order");
            rejectReasonDialogFragment.setDialogDismissListener(rejectOrderDialogListener);
        });
        btnDelay.setOnClickListener(view -> {
            DelayOrderSetTimeBottomSheetFragment delayOrderSetTimeBottomSheetFragment = getInstanceDelayOrderSet(order_type, order_id, true);
            delayOrderSetTimeBottomSheetFragment.show(getActivity().getSupportFragmentManager(), "delay_order_set_time");
            delayOrderSetTimeBottomSheetFragment.setDialogDismissListener(orderDelayDialogListener);
        });

    }

    public RejectReasonDialogFragment getInstanceejectReason(String reasons) {
        RejectReasonDialogFragment rejectReasonDialogFragment = new RejectReasonDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("reasons", reasons);
        rejectReasonDialogFragment.setArguments(bundle);
        return rejectReasonDialogFragment;
    }

    public DelayOrderSetTimeBottomSheetFragment getInstanceDelayOrderSet(int order_type, String order_id, boolean delay) {
        DelayOrderSetTimeBottomSheetFragment orderViewBottomSheetFragment = new DelayOrderSetTimeBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("order_type", order_type);
        bundle.putString("order_id", order_id);
        bundle.putBoolean("delay", delay);
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    private void SendNotificationToUser(String order_id) {
        LogUtils.e("Send notification to user");
        //Log.e("Url", "" + ApiEndPoints.orders_tiffintom + order_id + "/rtc");
        AndroidNetworking.post(ApiEndPoints.online_orders_send_rtc)
                .addPathParameter("id", order_id)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        Log.e("Response", "Error : " + response);
                        CommonFunctions.showSnackBar(myApp.getApplicationContext(), llMainLayout, "Message sent");
                    }

                    @Override
                    public void onError(ANError anError) {
                        Log.e("Response", "Error : " + anError.getErrorCode());
                    }
                });
    }

    String orderStatusMessage = "";
    DialogDismissListener rejectOrderDialogListener = o -> {
        if (o instanceof String)
            rejectOrder(String.valueOf(o));
    };

    DialogDismissListener acceptOrderDialogListener = o -> {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                if (orderSetTimeBottomSheetFragment != null) {
                    orderSetTimeBottomSheetFragment.dismiss();
                }
                llLoading.setVisibility(View.VISIBLE);
                progressDialog.show();
            });
        }
        orderStatusMessage = "Order has been accepted";
        orderDetail.status = "Accepted";
        orderDetail.preparation = (String) o;
        ToastUtils.showSnackBarFull(getActivity(), llMainLayout, "Order has been accepted", "success");
        btnReadytoCollect.setVisibility(View.VISIBLE);
        printOrder();
    };
    DialogDismissListener orderDelayDialogListener = o -> {
        fetchOrderDetails();
        orderStatusMessage = "Order time has been extended";
        sendStatusChangeEvent();
        ToastUtils.showSnackBarFull(getActivity(), llMainLayout, "Order has been delayed", "reject");
    };

    private void fetchData() {
        new Thread(this::fetchOrderDetails).start();
    }


    private void fetchOrderDetails() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                        llLoading.setVisibility(View.VISIBLE);
                        cvData.setVisibility(View.INVISIBLE);
                    }
            );
        }
        String url = ApiEndPoints.online_orders;
        if (order_type == 0) {
            url = ApiEndPoints.online_dinein_orders;
        }
        AndroidNetworking.get(url + order_id)
                .build()
                .getAsObject(OrderDetail.class, new ParsedRequestListener<OrderDetail>() {
                    @Override
                    public void onResponse(OrderDetail response) {
                        orderDetail = response;
                        orderDetail.service_charge_status = savedRestaurant.service_charge_status;
                        if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                            rvSurCharges.setVisibility(View.VISIBLE);
                            surChargesArrayList.addAll(orderDetail.surcharges);
                            surChargesAdapter.notifyDataSetChanged();
                        }
                        if (orderDetail.cart_view != null) {
                            productDetails.addAll(orderDetail.cart_view);
                            productItemsAdapter.notifyDataSetChanged();
                        }
                        updateViews();
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                llLoading.setVisibility(View.GONE);
                                cvData.setVisibility(View.VISIBLE);
                            });
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        anError.printStackTrace();
                        if (anError.getErrorCode() == 400) {
                            ToastUtils.showSnackBar(getActivity(), llMainLayout, anError.getErrorAsObject(ApiError.class).getMessage());
                        } else {
                            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Somethign went wrong!");
                        }
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                llLoading.setVisibility(View.GONE);
                                cvData.setVisibility(View.INVISIBLE);
                            });
                        }
                    }
                });

    }

    private void acceptOrder(String status) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            String url = ApiEndPoints.online_orders_status_change;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }

            Log.e("Test", " " + url);
            Log.e("Test", " " + order_id);
            Log.e("Test", " " + orderDetail.preparation);
            Log.e("Test", " " + status);

            AndroidNetworking.post(url)
                    .addPathParameter("id", order_id)
                    .addBodyParameter("order_id", order_id)
                    .addBodyParameter("preparation", orderDetail.preparation)
                    .addBodyParameter("status", status)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            Log.e("Test", " " + response.toString());
                            orderDetail.status = status;
                            if (status.equalsIgnoreCase("accept")) {
                                orderDetail.status = "Accepted";
                                orderRejected = false;
                                orderStatusMessage = "Order has been accepted";
                                btnReadytoCollect.setVisibility(View.VISIBLE);
                                ToastUtils.showSnackBarFull(getActivity(), llMainLayout, "Order has been accepted", "success");
                                printOrder();
                            }
                            if (status.equalsIgnoreCase("delivered")) {
                                orderRejected = false;
                                orderStatusMessage = "Order has been delivered";
                                ToastUtils.showSnackBarFull(getActivity(), llMainLayout, "Order has been delivered", "success");
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rejectOrder(String reason) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            String url = ApiEndPoints.online_orders_status_change;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }
            AndroidNetworking.post(url)
                    .addPathParameter("id", order_id)
                    .addBodyParameter("failed_reason", reason)
                    .addBodyParameter("status", "Failed")
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            orderDetail.failed_reason = reason;
                            orderRejected = true;
                            orderStatusMessage = "Order has been rejected";
                            orderDetail.status = "Failed";
                            printOrder();
                            ToastUtils.showSnackBarFull(getActivity(), llMainLayout, "Order has been rejected", "reject");
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean orderRejected = false;

    private void sendStatusChangeEvent() {
        Intent pushNotification = new Intent(Constants.ORDER_STATUS_CHANGE);
        pushNotification.putExtra("rejected", orderRejected);
        pushNotification.putExtra("message", orderStatusMessage);
        pushNotification.putExtra("orderdetail", new Gson().toJson(orderDetail));
        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(pushNotification);
    }


    private void printOrder() {
        try {
            getActivity().runOnUiThread(() -> {
                //progressDialog.show();
                llLoading.setVisibility(View.VISIBLE);
            });
            if (defaultPrinter != null) {
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "Do you wish to print this order?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continuePrint();
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });
                } else {
                    continuePrint();
                }

            } else {
                goBack();
                sendStatusChangeEvent();

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void continuePrint() {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                lastPrintIp = defaultPrinter.ip;
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        if (zoneRichPrinter == null) {
                            ToastUtils.makeToast(getActivity(), "Printer is null");
                        } else {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printZonerich(orderDetail, false, defaultPrinter.ip);
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, false);
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (sunmiPrinter == null) {
                        ToastUtils.makeToast(getActivity(), "Printer is null");
                    } else {
                        printSunmi(orderDetail, false);
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin(orderDetail, false);
                    } else {
                        if (wifiPrinter == null) {
                            ToastUtils.makeToast(getActivity(), "Printer is null");
                        } else {
                            wifiPrinter.disconnect();
                            CommonFunctions.functionThatDelay(100);
                            wifiPrinter.connect(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printWifi(orderDetail, false);
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isOpenCashDrawer = false;
    boolean isOpenCashDrawerDefault = false;

    private void continueForKitchenCopy(OrderDetail orderDetail, String printerType) {
//        if (true) {
//            goBack();
//            return;
//        }
//        defaultOnlineKitchenPrinter = defaultPrinter;
        try {

            try {
                new Thread(() -> {
                    ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) myApp.appDatabase.prepLocationDao().list();
                    isOpenCashDrawer = false;
                    if (prepLocations != null && prepLocations.size() > 0 && defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.id)) {
                        for (int i = 0; i < prepLocations.size(); i++) {
                            if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultOnlineKitchenPrinter.id) && prepLocations.get(i).cash_draw) {
                                isOpenCashDrawer = true;
                                break;
                            }
                        }
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
                isOpenCashDrawer = false;
            }
            if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultOnlineKitchenPrinter.ip != null && !defaultOnlineKitchenPrinter.ip.equalsIgnoreCase("")) {
                    zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                    CommonFunctions.functionThatDelay(100);
                    printZonerich(orderDetail, true, defaultOnlineKitchenPrinter.ip);

                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        zoneRichPrinter.openCashDrawer();
                    }
                } else {
                    try {
                        if (bluetoothPrinter != null) {
                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                            if (device != null) {
                                CommonFunctions.functionThatDelay(100);
                                printBTZonerich(orderDetail, true);
                                CommonFunctions.functionThatDelay(100);
                                bluetoothPrinter.openCashDrawer();
                            } else {
                                ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                printSunmi(orderDetail, true);
                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                        sunmiPrinterV3Mix.openCashDrawer();
                    }else {
                        sunmiPrinter.openCashDrawer();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                    printIMin(orderDetail, true);
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        IminSDKManager.opencashBox();
                    }
                } else {
                    if (lastPrintIp != null && !lastPrintIp.equalsIgnoreCase(defaultOnlineKitchenPrinter.ip)) {
                        wifiPrinter.disconnect();
                        CommonFunctions.functionThatDelay(100);
                        wifiPrinter.connect(defaultOnlineKitchenPrinter.ip);
                    } else {
                        if (defaultOnlineKitchenPrinter.ip != null) {
                            wifiPrinter.disconnect();
                            CommonFunctions.functionThatDelay(100);
                            wifiPrinter.connect(defaultOnlineKitchenPrinter.ip);
                        }
                    }
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        CommonFunctions.functionThatDelay(500);
                        wifiPrinter.openCashDrawer(false);
                    }
                    CommonFunctions.functionThatDelay(500);
                    printWifi(orderDetail, true);
                }
            } else if (defaultPrinter != null && !Validators.isNullOrEmpty(defaultPrinter.printer_model_name)) {
                try {
                    new Thread(() -> {
                        ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) myApp.appDatabase.prepLocationDao().list();
                        isOpenCashDrawerDefault = false;
                        if (prepLocations != null && prepLocations.size() > 0) {
                            for (int i = 0; i < prepLocations.size(); i++) {
                                if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultPrinter.id) && prepLocations.get(i).cash_draw) {
                                    isOpenCashDrawerDefault = true;
                                    break;
                                }
                            }
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    isOpenCashDrawerDefault = false;
                }
                CommonFunctions.functionThatDelay(200);
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        printZonerich(orderDetail, true, defaultPrinter.ip);

                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            zoneRichPrinter.openCashDrawer();
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, true);
                                    CommonFunctions.functionThatDelay(100);
                                    bluetoothPrinter.openCashDrawer();
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi(orderDetail, true);

                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                            sunmiPrinterV3Mix.openCashDrawer();
                        }else {
                            sunmiPrinter.openCashDrawer();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin(orderDetail, true);
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                            IminSDKManager.opencashBox();
                        }
                    } else {
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            wifiPrinter.openCashDrawer(false);
                        }
                        CommonFunctions.functionThatDelay(500);
                        printWifi(orderDetail, true);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIMin(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            String onlineOrderPrintCount;
            onlineOrderPrintCount = myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print;
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }

            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                myApp.iMinPrinterUtils.printOrderFoodHub(listPrintStructure, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, onlineOrderPrintCount, () -> {
                    if (kitchenCopy) {
                        goBack();
                        sendStatusChangeEvent();
                    }
                    return null;
                });
            } else {
                myApp.iMinPrinterUtils.printOrder(myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, onlineOrderPrintCount, () -> {
                    if (kitchenCopy) {
                        goBack();
                        sendStatusChangeEvent();
                    }
                    return null;
                });
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });
                }

            } else {
               /* goBack();
                sendStatusChangeEvent();*/

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonerich(OrderDetail orderDetail, boolean kitchenCopy, String defaultPrinterId) {
        try {
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }

            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                zoneRichPrinter.printOrderFoodHub(listPrintStructure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> {
                    if (kitchenCopy) {
                        goBack();
                        sendStatusChangeEvent();
                    }
                    return null;
                });
            } else {
                zoneRichPrinter.printOrder(structure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> {
                    if (kitchenCopy) {
                        goBack();
                        sendStatusChangeEvent();
                    }
                    return null;
                });
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });
                }

            } else {
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    sendStatusChangeEvent();
                    goBack();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBTZonerich(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrderZoneRich(myApp.tiffintomLogoSmall, orderDetail, kitchenCopy);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });
                }

            } else {
                goBack();
                sendStatusChangeEvent();

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void printWifi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            wifiPrinter.printOrder(myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, myApp.myPreferences.getPrintSetting(), kitchenCopy, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "wifi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "wifi");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });
                }

            } else {
                goBack();
                sendStatusChangeEvent();

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSunmi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                    sunmiPrinterV3Mix.printOrderFoodHub(listPrintStructure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> {
                        if (kitchenCopy) {
                            goBack();
                            sendStatusChangeEvent();
                        }
                        return null;
                    });
                }else {
                    sunmiPrinter.printOrderFoodHub(listPrintStructure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> {
                        if (kitchenCopy) {
                            goBack();
                            sendStatusChangeEvent();
                        }
                        return null;
                    });
                }
            } else {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                    sunmiPrinterV3Mix.printOrder(structure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> {
                        if (kitchenCopy) {
                            goBack();
                            sendStatusChangeEvent();
                        }
                        return null;
                    });
                }else {
                    sunmiPrinter.printOrder(structure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> {
                        if (kitchenCopy) {
                            goBack();
                            sendStatusChangeEvent();
                        }
                        return null;
                    });
                }
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "sunmi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "sunmi");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });
                }

            } else {
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    sendStatusChangeEvent();
                    goBack();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goBack() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                llLoading.setVisibility(View.GONE);
                progressDialog.dismiss();
                dialogDismissListener.onDialogDismiss("confirm");
                dismiss();
                //getActivity().onBackPressed();
            });
        }
    }

    public OrderSetTimeDialogFragment getInstanceOrderSetTime(int order_type, String order_id, OrderDetail orderDetail) {
        OrderSetTimeDialogFragment orderViewBottomSheetFragment = new OrderSetTimeDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("order_type", order_type);
        bundle.putString("order_id", order_id);
        bundle.putString("order_detail", new Gson().toJson(orderDetail));
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    public PreorderSetReminderDialogFragment getInstancePreorderSetReminder(OrderDetail orderDetail) {
        PreorderSetReminderDialogFragment preorderSetReminderFragment = new PreorderSetReminderDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order", new Gson().toJson(orderDetail));
        preorderSetReminderFragment.setArguments(bundle);
        return preorderSetReminderFragment;
    }
}
