package com.ubsidi.epos_2021.online.fragments;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.chip.Chip;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.imin.library.IminSDKManager;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.adapters.OnlineOrdersAdapter;
import com.ubsidi.epos_2021.online.base.BaseFragment;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderStatusIndicatorHeader;
import com.ubsidi.epos_2021.online.models.RestaurantOrderResponse;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * Created by Amrish on 03-06-2021.
 */
public class OnlineOrdersFragment extends BaseFragment {

    private RestaurantOrderResponse ordersResponse;
    private ArrayList<Object> ordersList = new ArrayList<>();
    private RecyclerView rvOrders;
    private OnlineOrdersAdapter onlineOrdersAdapter;
    private LinearLayout llLoading;
    private LinearLayout llData;
    private LinearLayout llNoRecord;
    private TextView tvOrders, tvErrorMessage;
    private SwipeRefreshLayout swipeRefreshLayout;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private BroadcastReceiver broadcastReceiver, orderStatusChangedReceiver;
    private ZoneRichPrinter zoneRichPrinter;
    private BluetoothPrinter bluetoothPrinter;
    private WifiPrinter wifiPrinter;
    private Snackbar snackbar;
    private CoordinatorLayout coordinatorLayout;
    protected Printer defaultOnlineKitchenPrinter;
    private SiteSetting kitchenCopyType, buzzerSetting;
    private String lastPrintIp;
    private boolean fromTheme2;
    private String fromHome;
    private Chip chipBack;
    private Restaurant savedRestaurant;
    private boolean isRequestOnGoing = false;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            fromTheme2 = getArguments().getBoolean("from_theme2", false);
            fromHome = getArguments().getString("from_home");
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_online_orders, container, false);
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            savedRestaurant = myApp.myPreferences.getRestaurant();
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            SiteSetting kitchenPrinterSetting = myApp.findSetting("default_prep_location_for_web");
            buzzerSetting = myApp.findSetting("open_cash_drawer_after_send_to_kitchen");
            kitchenCopyType = myApp.findSetting("kitchen_copy_type");

            if (kitchenPrinterSetting != null && !Validators.isNullOrEmpty(kitchenPrinterSetting.value)) {
                for (Printer p : loggedInAdmin.selected_business.printers) {
                    if (p.id.equalsIgnoreCase(kitchenPrinterSetting.value)) {
                        defaultOnlineKitchenPrinter = p;
                        break;
                    }
                }
            }
            coordinatorLayout = view.findViewById(R.id.coordinatorLayout);
            rvOrders = view.findViewById(R.id.rvOrders);
            llLoading = view.findViewById(R.id.llLoading);
            tvOrders = view.findViewById(R.id.tvAllOrders);
            llData = view.findViewById(R.id.llRootData);
            llNoRecord = view.findViewById(R.id.llNoRecord);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            LinearLayout llOrderHistory = view.findViewById(R.id.llOrderHistory);
            chipBack = view.findViewById(R.id.chipBack);
            LinearLayout llTitle = view.findViewById(R.id.llTitle);

            if (fromTheme2) {
                llOrderHistory.setVisibility(View.GONE);
            } else {
                llOrderHistory.setVisibility(View.VISIBLE);
            }
            if (!Validators.isNullOrEmpty(fromHome)) {
                llTitle.setVisibility(View.VISIBLE);
            } else {
                llTitle.setVisibility(View.GONE);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.online_order_history.actions.list)
                llOrderHistory.setVisibility(View.VISIBLE);
            else
                llOrderHistory.setVisibility(View.GONE);

            onlineOrdersAdapter = new OnlineOrdersAdapter(getActivity(), ordersList, (view1, position, data) -> {
                OrderDetail order = (OrderDetail) data;
                int orderType = -1;
                if (Validators.isNullOrEmpty(order.order_type)) {
                    orderType = 0;
                } else if (order.order_type.equalsIgnoreCase("delivery")) {
                    orderType = 1;
                } else if (order.order_type.equalsIgnoreCase("pickup")) {
                    orderType = 2;
                }
                if (order.status.equalsIgnoreCase("pending")) {
                    openOrderView(orderType, order.id);

                } else if (order.status.equalsIgnoreCase("accepted")) {
                    String orderTitle = "", orderDescription = "";
                    if (Validators.isNullOrEmpty(order.order_type)) {
                        orderTitle = "Ready to serve";
                        orderDescription = "Do you wish to confirm mark this order as ready to serve?";
                    } else {
                        if (order.order_type.equalsIgnoreCase("delivery")) {
                            orderTitle = "Mark as delivered";
                            orderDescription = "Do you wish to mark this order as delivered?";
                        } else if (order.order_type.equalsIgnoreCase("pickup")) {
                            orderTitle = "Mark as collected";
                            orderDescription = "Do you wish to mark this order as picked up?";
                        }
                    }
                    openConfirmationDialog(order, orderTitle, orderDescription);

                }
            }, (view1, position, data) -> {
                OrderDetail order = (OrderDetail) data;
                int orderType = -1;
                if (Validators.isNullOrEmpty(order.order_type)) {
                    orderType = 0;
                } else if (order.order_type.equalsIgnoreCase("delivery")) {
                    orderType = 1;
                } else if (order.order_type.equalsIgnoreCase("pickup")) {
                    orderType = 2;
                }
                openOrderView(orderType, order.id);
            }, (view1, position, data) -> {
                // Print clicked
                fetchOrderDetail((OrderDetail) data);
            }, (view1, position, data) -> {
                // RTC Clicked
                sendRTC(((OrderDetail) data).id);
            });

            int spanCount = getResources().getInteger(R.integer.epos_orders_span);
            GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), spanCount);
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
                @Override
                public int getSpanSize(int position) {
                    if (ordersList.get(position) instanceof OrderDetail) {
                        return 1;
                    } else {
                        return spanCount;
                    }
                }
            });
            rvOrders.setLayoutManager(gridLayoutManager);
            rvOrders.setNestedScrollingEnabled(false);
            rvOrders.setAdapter(onlineOrdersAdapter);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateOrderTakingStatus();
        setListeners();
        fetchData();

    }

    private void setListeners() {
        chipBack.setOnClickListener(view -> getActivity().onBackPressed());
        swipeRefreshLayout.setOnRefreshListener(this::fetchData);
        rvOrders.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                int topRowVerticalPosition =
                        (recyclerView == null || recyclerView.getChildCount() == 0) ? 0 : recyclerView.getChildAt(0).getTop();
                swipeRefreshLayout.setEnabled(topRowVerticalPosition >= 0);

            }
        });

        tvOrders.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, OnlineOrdersHistoryFragment.getInstance(), "all_orders");
            ft.addToBackStack("let_go_back");
            ft.commit();
        });
        broadcastReceiver = new BroadcastReceiver() {
            public void onReceive(Context context, Intent intent) {

                boolean refresh = intent.getBooleanExtra("refresh", false);
                boolean forOrders = intent.getBooleanExtra("orders", false);
                if (refresh && forOrders && !isRequestOnGoing) {
                    swipeRefreshLayout.setRefreshing(true);
                    fetchData();
                }
            }
        };
        orderStatusChangedReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String message = intent.getStringExtra("message");
                boolean reject = intent.getBooleanExtra("rejected", false);
                String orderDetails = intent.getStringExtra("orderdetail");

                OrderDetail orderDetail = new Gson().fromJson(orderDetails, OrderDetail.class);
                int orderType = -1;
                if (Validators.isNullOrEmpty(orderDetail.order_type)) {
                    orderType = 0;
                } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
                    orderType = 1;
                } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
                    orderType = 2;
                }
                try {
                    LogUtils.e(message);
                    int finalOrderType = orderType;
                    snackbar = Snackbar.make(coordinatorLayout, message, Snackbar.LENGTH_LONG)
                            .setActionTextColor(getResources().getColor(R.color.white))
                            .setAction("view", v -> {
                                openOrderView(finalOrderType, orderDetail.id);
                            });
                    View mView = snackbar.getView();
                    TextView sbTextView = (TextView) mView.findViewById(com.google.android.material.R.id.snackbar_text);
                    sbTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, context.getResources().getDimension(R.dimen.text_size_16));
                    (mView).getLayoutParams().width = context.getResources().getDimensionPixelSize(R.dimen.width_400);
                    if (reject) {
                        snackbar.setBackgroundTint(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_orange));
                    } else {
                        snackbar.setBackgroundTint(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_green));
                    }
                    snackbar.show();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void openOrderView(int orderType, String orderId) {
        OnlineOrderViewFragment onlineOrderViewFragment = myApp.getInstanceOnlineOrder(orderId, orderType);
        onlineOrderViewFragment.show(getActivity().getSupportFragmentManager(), "NewFragmentTag");
        onlineOrderViewFragment.setDialogDismissListener(acceptOrderDialogListener);
    }

    DialogDismissListener acceptOrderDialogListener = o -> {
        fetchData();
    };

    private void updateOrderTakingStatus() {
        //TODO Update Switch if online orders enabled or not
//        switchCompat.setChecked(myApp.getMyPreferences().getLoggedInRestaurant().online_order.equalsIgnoreCase("Yes"));
    }

    private void setupAdapter() {
        try {
            if (ordersResponse != null) {
                ordersList.clear();
                int pendingOrdersCount = 0;
                if (ordersResponse.pending_orders != null) {
                    pendingOrdersCount = pendingOrdersCount + ordersResponse.pending_orders.size();
                }
                if (ordersResponse.dinein_pending_orders != null) {
                    pendingOrdersCount = pendingOrdersCount + ordersResponse.dinein_pending_orders.size();
                }

                if (pendingOrdersCount > 0) {
                    // Check Pre-Order
                    ArrayList<OrderDetail> orders = new ArrayList<>();
                    if (ordersResponse.pending_orders != null)
                        orders.addAll(ordersResponse.pending_orders);
                    if (ordersResponse.dinein_pending_orders != null)
                        orders.addAll(ordersResponse.dinein_pending_orders);

                    ArrayList<OrderDetail> pendingOrders = new ArrayList<>();
                    ArrayList<OrderDetail> preOrders = new ArrayList<>();

                    for (OrderDetail order : orders) {
                        if (!Validators.isNullOrEmpty(order.order_type)) {
                            Date todayDate = CommonFunctions.convertStringDateToDate(CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy"), "dd-MM-yyyy");
                            Date orderDate = CommonFunctions.convertStringDateToDate(order.delivery_date, "yyyy-MM-dd");
                            if (CommonFunctions.isPreOrderWithoutStatus(order.delivery_date)) {
                                pendingOrders.add(order);
                            } else {
                                preOrders.add(order);
                            }
                        } else {
                            pendingOrders.add(order);
                        }
                    }
                    if (preOrders.size() > 0) {
                        ordersList.add(new OrderStatusIndicatorHeader("Pre order (" + preOrders.size() + ")"));
                        ordersList.addAll(sortOrdersByNew(preOrders));
                    }
                    if (pendingOrders.size() > 0) {
                        ordersList.add(new OrderStatusIndicatorHeader("New order (" + pendingOrders.size() + ")"));
                        ordersList.addAll(sortOrdersByNew(pendingOrders));
                        //                    myApp.startOrderSound();
                    }
                }

                int inProgressOrders = 0;
                if (ordersResponse.accepted_orders != null) {
                    inProgressOrders = inProgressOrders + ordersResponse.accepted_orders.size();
                }
                if (ordersResponse.dinein_accepted_orders != null) {
                    inProgressOrders = inProgressOrders + ordersResponse.dinein_accepted_orders.size();
                }
                if (inProgressOrders > 0) {

                    ArrayList<OrderDetail> orders = new ArrayList<>();
                    if (ordersResponse.accepted_orders != null)
                        orders.addAll(ordersResponse.accepted_orders);
                    if (ordersResponse.dinein_accepted_orders != null)
                        orders.addAll(ordersResponse.dinein_accepted_orders);

                    ordersList.add(new OrderStatusIndicatorHeader("Order in progress (" + inProgressOrders + ")"));
                    ordersList.addAll(sortOrdersByNew(orders));
                }

                int completedOrders = 0;
                if (ordersResponse.completed_orders != null) {
                    completedOrders = completedOrders + ordersResponse.completed_orders.size();
                }
                if (ordersResponse.dinein_completed_orders != null) {
                    completedOrders = completedOrders + ordersResponse.dinein_completed_orders.size();
                }
                if (completedOrders > 0) {
                    ArrayList<OrderDetail> orders = new ArrayList<>();
                    ordersList.add(new OrderStatusIndicatorHeader("Completed order (" + completedOrders + ")"));
                    if (ordersResponse.completed_orders != null)
                        orders.addAll(ordersResponse.completed_orders);
                    if (ordersResponse.dinein_completed_orders != null)
                        orders.addAll(ordersResponse.dinein_completed_orders);
                    ordersList.addAll(sortOrdersByNew(orders));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<OrderDetail> sortOrdersByNew(ArrayList<OrderDetail> orders) {
        Collections.sort(orders, (restaurantOrder, t1) -> {
            Date orderDateLHS;
            if (!Validators.isNullOrEmpty(restaurantOrder.order_type)) {
                String date = restaurantOrder.delivery_date.split("T")[0] + " " + restaurantOrder.delivery_time;
                orderDateLHS = CommonFunctions.convertStringDateToDate(date, "dd-MM-yyyy hh:mm a");
            } else {
                orderDateLHS = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(restaurantOrder.created.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy hh:mm a"), "dd-MM-yyyy hh:mm a");
            }

            Date orderDateRHS;
            if (!Validators.isNullOrEmpty(t1.order_type)) {
                String date = t1.delivery_date.split("T")[0] + " " + t1.delivery_time;
                orderDateRHS = CommonFunctions.convertStringDateToDate(date, "dd-MM-yyyy hh:mm a");
            } else {
                orderDateRHS = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(t1.created.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy hh:mm a"), "dd-MM-yyyy hh:mm a");
            }

            return orderDateRHS.compareTo(orderDateLHS);
        });
        return orders;
    }

    private void openConfirmationDialog(OrderDetail order, String orderTitle, String orderDescription) {

        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog(orderTitle, orderDescription, 0, "Confirm", "Cancel");
        confirmationDialogFragment.setCancelable(false);
        confirmationDialogFragment.show(getChildFragmentManager(), "printer");
        confirmationDialogFragment.setDialogDismissListener(o -> {
            try {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm")) {
                        int orderType = -1;
                        if (Validators.isNullOrEmpty(order.order_type)) {
                            orderType = 0;
                        } else if (order.order_type.equalsIgnoreCase("delivery")) {
                            orderType = 1;
                        } else if (order.order_type.equalsIgnoreCase("pickup")) {
                            orderType = 2;
                        }
                        changeOrderStatus(orderType, order.id, "Delivered");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });

    }

    private void fetchData() {
        new Thread(this::fetchOrders).start();
    }

    private void fetchOrders() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    if (swipeRefreshLayout.isRefreshing()) {
                        llLoading.setVisibility(View.GONE);
                    } else {
                        llLoading.setVisibility(View.VISIBLE);
                    }

                });
            }
            isRequestOnGoing = true;
            AndroidNetworking.get(ApiEndPoints.online_orders_home)
                    .addQueryParameter("restaurant_id", myApp.restaurant_id)
                    .build()
                    .getAsObject(RestaurantOrderResponse.class, new ParsedRequestListener<RestaurantOrderResponse>() {
                        @Override
                        public void onResponse(RestaurantOrderResponse response) {
                            try {
                                isRequestOnGoing = false;
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llData.setVisibility(View.VISIBLE);
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                                ordersResponse = response;
                                setupAdapter();
                                onlineOrdersAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            isRequestOnGoing = false;
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                    llNoRecord.setVisibility(View.VISIBLE);
                                    if (ordersResponse == null) {
                                        tvErrorMessage.setVisibility(View.VISIBLE);
                                    } else {
                                        tvErrorMessage.setVisibility(View.GONE);
                                    }

                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }
                            anError.printStackTrace();
                            if (!CommonFunctions.isConnected(getActivity())) {
                                myApp.noInternet(getActivity());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchOrderDetail(OrderDetail order) {
        try {
            int order_type = -1;
            if (Validators.isNullOrEmpty(order.order_type)) {
                order_type = 0;
            } else if (order.order_type.equalsIgnoreCase("delivery")) {
                order_type = 1;
            } else if (order.order_type.equalsIgnoreCase("pickup")) {
                order_type = 2;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                            progressDialog.show();
                        }
                );
            }
            String url = ApiEndPoints.online_orders;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders;
            }
            AndroidNetworking.get(url + order.id)
                    .build()
                    .getAsObject(OrderDetail.class, new ParsedRequestListener<OrderDetail>() {
                        @Override
                        public void onResponse(OrderDetail response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                            }
                            response.service_charge_status = savedRestaurant.service_charge_status;
                            createPrint(response);

                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                            }
                            LogUtils.e("ERROR IN ORDER VIEW");
                            LogUtils.e(anError.getErrorBody());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void sendRTC(String id) {
        try {
            AndroidNetworking.post(ApiEndPoints.online_orders_send_rtc)
                    .addPathParameter("id", id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            CommonFunctions.showSnackBar(getActivity(), coordinatorLayout, "Message sent");

                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                CommonFunctions.showSnackBar(getActivity(), coordinatorLayout, anError.getErrorAsObject(ApiError.class).getMessage());
                            } else {
                                CommonFunctions.showSnackBar(getActivity(), coordinatorLayout, "Something went wrong! Please try after sometime.");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeOrderStatus(int order_type, String order_id, String status) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            String url = ApiEndPoints.online_orders_status_change;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }
            AndroidNetworking.post(url)
                    .addBodyParameter("status", status)
                    .addBodyParameter("order_id", order_id)
                    .addPathParameter("id", order_id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            OrderDetail orderDetail = new OrderDetail();
                            orderDetail.id = order_id;

                            if (order_type == 0) {
                                orderDetail.order_type = "Dine in";
                            } else if (order_type == 1) {
                                orderDetail.order_type = "Delivery";
                            } else if (order_type == 2) {
                                orderDetail.order_type = "Pickup";
                            }
                            sendStatusChangeEvent("Order has been delivered", orderDetail, false);
                            swipeRefreshLayout.setRefreshing(true);
                            fetchData();
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                            LogUtils.e("Order Status Change error");
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPrint(OrderDetail orderDetail) {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                lastPrintIp = defaultPrinter.ip;
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        if (zoneRichPrinter == null) {
                            CommonFunctions.showSnackBar(getActivity(), coordinatorLayout, "Printer is null");
                        } else {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printZonerich(orderDetail, false, defaultPrinter.ip);
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, false);
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (sunmiPrinter == null) {
                        ToastUtils.makeToast(getActivity(), "Printer is null");
                    } else {
                        printSunmi(orderDetail, false);
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if(defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")){
                        printIMin(orderDetail, false);
                    }else{
                        if (wifiPrinter == null) {
                            ToastUtils.makeToast(getActivity(), "Printer is null");
                        } else {
                            //if (wifiPrinter.connectionFlag==1) {
                            wifiPrinter.disconnect();
                            //}
                            CommonFunctions.functionThatDelay(100);
                            if (wifiPrinter.connectionFlag == 0) {
                                wifiPrinter.connect(defaultPrinter.ip);
                            }
                            CommonFunctions.functionThatDelay(100);
                            printWifi(orderDetail, false);
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isOpenCashDrawer = false;
    boolean isOpenCashDrawerDefault = false;

    private void continueForKitchenCopy(OrderDetail orderDetail, String printerType) {
        try {

            try {
                new Thread(() -> {
                    ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) myApp.appDatabase.prepLocationDao().list();
                    isOpenCashDrawer = false;
                    if (prepLocations != null && prepLocations.size() > 0 && defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.id)) {
                        for (int i = 0; i < prepLocations.size(); i++) {
                            if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultOnlineKitchenPrinter.id) && prepLocations.get(i).cash_draw) {
                                isOpenCashDrawer = true;
                                break;
                            }
                        }
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
                isOpenCashDrawer = false;
            }
          /*  int numberOfPrint = 0;
            Business business = myApp.myPreferences.getLoggedInAdmin().selected_business;
            if (orderDetail.order_type.equalsIgnoreCase("Collection")) {
                numberOfPrint = Integer.parseInt(business.collection_number_of_print);
            } else if (orderDetail.order_type.equalsIgnoreCase("Delivery")) {
                numberOfPrint = Integer.parseInt(business.delivery_number_of_print);
            } else if (orderDetail.order_type.equalsIgnoreCase("Waiting")) {
                numberOfPrint = Integer.parseInt(business.collection_number_of_print);
            } else if (orderDetail.order_type.equalsIgnoreCase("Dine in")) {
                numberOfPrint = Integer.parseInt(business.dinein_number_of_print);
            } else {
                numberOfPrint = Integer.parseInt(business.online_order_number_of_print);
            }*/
            if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
               // for (int i = 0; i < numberOfPrint; i++) {
                    if (defaultOnlineKitchenPrinter.ip != null && !defaultOnlineKitchenPrinter.ip.equalsIgnoreCase("")) {
                        zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        printZonerich(orderDetail, true, defaultOnlineKitchenPrinter.ip);

                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                            zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            zoneRichPrinter.openCashDrawer();
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, true);
                                    CommonFunctions.functionThatDelay(100);
                                    bluetoothPrinter.openCashDrawer();
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
               // }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                printSunmi(orderDetail, true);
                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                        sunmiPrinterV3Mix.openCashDrawer();
                    }else {
                        sunmiPrinter.openCashDrawer();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if(defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4")){
                    printIMin(orderDetail, true);
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        IminSDKManager.opencashBox();
                    }
                }else{
                    //for (int i = 0; i < numberOfPrint; i++) {
                    if (!lastPrintIp.equalsIgnoreCase(defaultOnlineKitchenPrinter.ip)) {
                        wifiPrinter.disconnect();
                        CommonFunctions.functionThatDelay(100);
                        wifiPrinter.connect(defaultOnlineKitchenPrinter.ip);
                    }
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        CommonFunctions.functionThatDelay(500);
                        wifiPrinter.openCashDrawer(false);
                    }
                    CommonFunctions.functionThatDelay(500);
                    printWifi(orderDetail, true);
                    // }
                }
            } else if (defaultPrinter != null && !Validators.isNullOrEmpty(defaultPrinter.printer_model_name)) {
                try {
                    new Thread(() -> {
                        ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) myApp.appDatabase.prepLocationDao().list();
                        isOpenCashDrawerDefault = false;
                        if (prepLocations != null && prepLocations.size() > 0) {
                            for (int i = 0; i < prepLocations.size(); i++) {
                                if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultPrinter.id) && prepLocations.get(i).cash_draw) {
                                    isOpenCashDrawerDefault = true;
                                    break;
                                }
                            }
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    isOpenCashDrawerDefault = false;
                }
                CommonFunctions.functionThatDelay(200);
               // for (int i = 0; i < numberOfPrint; i++) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printZonerich(orderDetail, true, defaultPrinter.ip);

                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                                zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                CommonFunctions.functionThatDelay(100);
                                zoneRichPrinter.openCashDrawer();
                            }
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        CommonFunctions.functionThatDelay(100);
                                        printBTZonerich(orderDetail, true);
                                        CommonFunctions.functionThatDelay(100);
                                        bluetoothPrinter.openCashDrawer();
                                    } else {
                                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                        printSunmi(orderDetail, true);

                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                sunmiPrinterV3Mix.openCashDrawer();
                            }else {
                                sunmiPrinter.openCashDrawer();
                            }
                        }
                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                        if(defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")){
                            printIMin(orderDetail, true);
                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                                IminSDKManager.opencashBox();
                            }
                        }else{
                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                                wifiPrinter.openCashDrawer(false);
                            }
                            CommonFunctions.functionThatDelay(500);
                            printWifi(orderDetail, true);
                        }
                    }
                //}
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBTZonerich(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrderZoneRich(myApp.tiffintomLogoSmall, orderDetail, kitchenCopy);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIMin(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            String onlineOrderPrintCount;
            onlineOrderPrintCount = myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print;
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName ="";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName =printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName =printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if(printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")){
                myApp.iMinPrinterUtils.printOrderFoodHub(listPrintStructure,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, onlineOrderPrintCount, () -> null);
            }else {
                myApp.iMinPrinterUtils.printOrder(myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, onlineOrderPrintCount, () -> null);
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonerich(OrderDetail orderDetail, boolean kitchenCopy, String defaultPrinterId) {
        try {
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName ="";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName =printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName =printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if(printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")){
                zoneRichPrinter.printOrderFoodHub(listPrintStructure,printSettings,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail,  kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> null);
            }else {
                zoneRichPrinter.printOrder(structure,printSettings,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> null);
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    CommonFunctions.functionThatDelay(400);
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printWifi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            wifiPrinter.printOrder(myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, myApp.myPreferences.getPrintSetting(), kitchenCopy, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "wifi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "wifi");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSunmi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName ="";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName =printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if(printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                    sunmiPrinterV3Mix.printOrderFoodHub(listPrintStructure,printSettings,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail,  kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }else {
                    sunmiPrinter.printOrderFoodHub(listPrintStructure,printSettings,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail,  kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }
            }else {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                    sunmiPrinterV3Mix.printOrder(structure,printSettings,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail,  kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }else {
                    sunmiPrinter.printOrder(structure,printSettings,myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail,  kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "sunmi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "sunmi");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();

        if (getActivity() != null && broadcastReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(broadcastReceiver, new IntentFilter(Constants.NOTIFICATION));
        if (getActivity() != null && orderStatusChangedReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderStatusChangedReceiver, new IntentFilter(Constants.ORDER_STATUS_CHANGE));
    }

    @Override
    public void onStop() {
        try {
            if (getActivity() != null && broadcastReceiver != null)
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(broadcastReceiver);
            if (getActivity() != null && orderStatusChangedReceiver != null)
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderStatusChangedReceiver);
            if (getActivity() != null && progressDialog != null) {
                progressDialog.dismiss();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }

    private void sendStatusChangeEvent(String orderStatusMessage, OrderDetail orderDetail, boolean orderRejected) {
        try {
            Intent pushNotification = new Intent(Constants.ORDER_STATUS_CHANGE);
            pushNotification.putExtra("rejected", orderRejected);
            pushNotification.putExtra("message", orderStatusMessage);
            pushNotification.putExtra("orderdetail", new Gson().toJson(orderDetail));
            LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(pushNotification);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
