package com.ubsidi.epos_2021.online.fragments;

import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.cardview.widget.CardView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.android.material.snackbar.Snackbar;
import com.imin.library.IminSDKManager;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.adapters.OnlineOrdersAdapter;
import com.ubsidi.epos_2021.online.base.BaseFragment;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderStatusIndicatorHeader;
import com.ubsidi.epos_2021.online.models.RestaurantOrder;
import com.ubsidi.epos_2021.online.models.RestaurantOrderResponse;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * Created by Amrish on 04-06-2021.
 */
public class OnlineOrdersHistoryFragment extends BaseFragment {
    public static OnlineOrdersHistoryFragment getInstance() {
        return new OnlineOrdersHistoryFragment();
    }

    private int selectedOrderForDeleteCount = 0;
    private MaterialCardView btnDeleteAll;
    private SwitchCompat switchCompat;
    private LinearLayout llLoading, llData, llNoRecord;
    private boolean custom = false;
    private String sort_by = "Today";
    private LinearLayout llFilter;
    private TextView tvFilter, tvSelect;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private ZoneRichPrinter zoneRichPrinter;
    private BluetoothPrinter bluetoothPrinter;
    private WifiPrinter wifiPrinter;
    private RestaurantOrderResponse ordersResponse;
    private ArrayList<Object> ordersList = new ArrayList<>();
    private RecyclerView rvOrders;
    private OnlineOrdersAdapter ordersAdapter;
    private Chip ivBack;
    private Snackbar greySnackBar;
    private CoordinatorLayout coordinatorLayout;
    RestaurantOrder clickedOrder;
    boolean justPrint = false;
    private Printer defaultOnlineKitchenPrinter;
    private Date fromDate, toDate;
    private Calendar today;
    private boolean isCustomDate;
    private String dateFilter = "Today";
    private LinearLayout llFromDate, llToDate;
    private TextView tvFromDate, tvToDate, tvAllOrders;
    private MaterialButton btnToday, btnThisWeek, btnThisMonth, btnCustom;
    private MaterialButtonToggleGroup btnGroup;
    private CardView cvCustom;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    int day = 1;
    int lastCheckedId = -1;
    private int filterType = 0; //0 today, 1=week,2=month,3= custom
    private Calendar fromCalender = Calendar.getInstance();
    private Calendar toCalender = Calendar.getInstance();
    private String fromDateString, toDateString, lastPrintIp;
    private SiteSetting kitchenCopyType, buzzerSetting;
    private DatePickerDialog fromPicker, toPicker;
    private boolean fetchingOrders = true, moveNext = false;

    private LinearLayout llToday, llThisWeek, llThisMonth, llCustom;
    private TextView tvToday, tvThisWeek, tvThisMonth, tvCustom;
    private View vToday, vThisWeek, vThisMonth, vCustom;
    private Restaurant savedRestaurant;

    @Nullable
    @Override
    public View onCreateView(@NonNull @NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_online_orders_history, container, false);
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) return;
        setListeners();
        chekedBtn(llToday);
        getToday();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        savedRestaurant = myApp.myPreferences.getRestaurant();
        coordinatorLayout = view.findViewById(R.id.coordinatorLayout);
        zoneRichPrinter = new ZoneRichPrinter(getActivity());
        zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
        buzzerSetting = myApp.findSetting("open_cash_drawer_after_send_to_kitchen");
        wifiPrinter = WifiPrinter.getInstance();
        bluetoothPrinter = new BluetoothPrinter(getActivity());
        SiteSetting kitchenPrinterSetting = myApp.findSetting("default_prep_location_for_web");
        kitchenCopyType = myApp.findSetting("kitchen_copy_type");

        today = Calendar.getInstance();
        fromDate = today.getTime();
        toDate = today.getTime();

        fromMonth = today.get(Calendar.MONTH);
        fromDay = today.get(Calendar.DAY_OF_MONTH);
        fromYear = today.get(Calendar.YEAR);

        toMonth = today.get(Calendar.MONTH);
        toDay = today.get(Calendar.DAY_OF_MONTH);
        toYear = today.get(Calendar.YEAR);

        llFromDate = view.findViewById(R.id.llFromDate);
        llToDate = view.findViewById(R.id.llToDate);
        tvFromDate = view.findViewById(R.id.tvFromDate);
        tvToDate = view.findViewById(R.id.tvToDate);
        btnToday = view.findViewById(R.id.btnToday);
        btnThisWeek = view.findViewById(R.id.btnThisWeek);
        btnThisMonth = view.findViewById(R.id.btnThisMonth);
        btnCustom = view.findViewById(R.id.btnCustom);
        btnGroup = view.findViewById(R.id.btnGroup);
        cvCustom = view.findViewById(R.id.cvCustom);

        llToday = view.findViewById(R.id.llToday);
        llThisWeek = view.findViewById(R.id.llThisWeek);
        llThisMonth = view.findViewById(R.id.llThisMonth);
        llCustom = view.findViewById(R.id.llCustom);

        tvToday = view.findViewById(R.id.tvToday);
        tvThisWeek = view.findViewById(R.id.tvThisWeek);
        tvThisMonth = view.findViewById(R.id.tvThisMonth);
        tvCustom = view.findViewById(R.id.tvCustom);

        vToday = view.findViewById(R.id.vToday);
        vThisWeek = view.findViewById(R.id.vThisWeek);
        vThisMonth = view.findViewById(R.id.vThisMonth);
        vCustom = view.findViewById(R.id.vCustom);
        chekedBtn(llToday);
        if (kitchenPrinterSetting != null && !Validators.isNullOrEmpty(kitchenPrinterSetting.value)) {
            for (Printer p : loggedInAdmin.selected_business.printers) {
                if (p.id.equalsIgnoreCase(kitchenPrinterSetting.value)) {
                    defaultOnlineKitchenPrinter = p;
                    break;
                }
            }
        }
        sunmiPrinter = new SunmiPrinter(getActivity());
        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
            sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
        }
        llFilter = view.findViewById(R.id.llFiler);
        tvFilter = view.findViewById(R.id.tvFilter);
        tvSelect = view.findViewById(R.id.tvSelect);
        rvOrders = view.findViewById(R.id.rvOrders);
        switchCompat = view.findViewById(R.id.switchOrders);
        llLoading = view.findViewById(R.id.llLoading);
        btnDeleteAll = view.findViewById(R.id.btnDeleteAll);
        llData = view.findViewById(R.id.llData);
        llNoRecord = view.findViewById(R.id.llNoRecord);
        ivBack = view.findViewById(R.id.chipBack);

        tvSelect.setOnClickListener(view1 -> {
            ordersAdapter.showCheck = !ordersAdapter.showCheck;
            ordersAdapter.notifyDataSetChanged();
            if (ordersAdapter.showCheck) {
                tvSelect.setText("Cancel");
            } else {
                tvSelect.setText("Select");
            }
        });
        btnDeleteAll.setOnClickListener(v -> {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < ordersAdapter.ordersList.size(); i++) {
                Object order = ordersAdapter.ordersList.get(i);
                if (order instanceof OrderDetail) {
                    if (((OrderDetail) order).isDeleteSelected) {
                        if (((OrderDetail) order).past_days >= 180) {
                            jsonArray.put(((OrderDetail) order).id);
                        }
                    }
                }
            }
            if (jsonArray.length() == 0) {
                ToastUtils.makeToast(requireContext(), "Please select order to delete");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "Are you sure you want to delete this order?", 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirmation");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        deleteOnlineOrder(jsonArray.toString());
                    }
                });
            }
        });
        ordersAdapter = new OnlineOrdersAdapter(getActivity(), ordersList, (view1, position, data) -> {
            OrderDetail order = (OrderDetail) data;
            int orderType = -1;
            if (Validators.isNullOrEmpty(order.order_type)) {
                orderType = 0;
            } else if (order.order_type.equalsIgnoreCase("delivery")) {
                orderType = 1;
            } else if (order.order_type.equalsIgnoreCase("pickup")) {
                orderType = 2;
            }
            if (order.status.equalsIgnoreCase("pending")) {
                openOrderView(orderType, order.id);
            } else if (order.status.equalsIgnoreCase("accepted")) {
                openConfirmationDialog();
            }

        }, (view1, position, data) -> {
            OrderDetail order = (OrderDetail) data;
            int orderType = -1;
            if (Validators.isNullOrEmpty(order.order_type)) {
                orderType = 0;
            } else if (order.order_type.equalsIgnoreCase("delivery")) {
                orderType = 1;
            } else if (order.order_type.equalsIgnoreCase("pickup")) {
                orderType = 2;
            }
            openOrderView(orderType, order.id);
        }, (view1, position, data) -> {
            // Print clicked
            justPrint = true;
            fetchOrderDetail((OrderDetail) data);
        }, (view1, position, data) -> {
            //RTC clicked
            if (data instanceof OrderDetail) {
                selectedOrderForDeleteCount = ((OrderDetail) data).isDeleteSelected ? selectedOrderForDeleteCount + 1 : selectedOrderForDeleteCount - 1;
            }
            if (selectedOrderForDeleteCount != 0) {
                btnDeleteAll.setVisibility(View.VISIBLE);
            } else {
                btnDeleteAll.setVisibility(View.GONE);
            }
        });
        int spanCount = getResources().getInteger(R.integer.epos_orders_span);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), spanCount);
        gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                if (ordersList.get(position) instanceof OrderDetail) {
                    return 1;
                } else {
                    return spanCount;
                }
            }
        });
        rvOrders.setLayoutManager(gridLayoutManager);
        rvOrders.setNestedScrollingEnabled(false);
        rvOrders.setAdapter(ordersAdapter);
        ordersAdapter.isHasDeletePermission = MyApp.userPermission.online_order_delete.actions.list;
    }

    private void deleteOnlineOrder(String deleteOrdersId) {
        try {
            LogUtils.e("DELETING RESERVATION");
            new Thread(() -> {
                try {
                    //appDatabase.reservationDao().delete(reservation);
                    getActivity().runOnUiThread(() -> {
                        progressDialog.show();
                    });
                    AndroidNetworking.post(ApiEndPoints.online_order_delete)
                            .addQueryParameter("ids", deleteOrdersId)
                            .build()
                            .getAsJSONObject(new JSONObjectRequestListener() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    getActivity().runOnUiThread(() -> {
                                        selectedOrderForDeleteCount = 0;
                                        btnDeleteAll.setVisibility(View.GONE);
                                        tvSelect.performClick();
                                        progressDialog.dismiss();
                                        if (lastCheckedId == llToday.getId()) {
                                            llToday.performClick();
                                        }
                                        if (lastCheckedId == llThisWeek.getId()) {
                                            llThisWeek.performClick();
                                        }
                                        if (lastCheckedId == llThisMonth.getId()) {
                                            llThisMonth.performClick();
                                        }
                                        if (lastCheckedId == llCustom.getId()) {
                                            llCustom.performClick();
                                            fetchOrders();
                                        }
                                    });
                                }

                                @Override
                                public void onError(ANError anError) {
                                    LogUtils.e("ERROR WHILE DELETING ONLINE RESERVATION " + anError.getMessage());
                                    if (anError.getErrorCode() == 400) {
                                        ToastUtils.makeSnackToast(requireContext(), anError.getErrorAsObject(ApiError.class).getMessage());
                                        LogUtils.e(anError.getErrorAsObject(ApiError.class).getMessage());
                                    } else {
                                        ToastUtils.makeToast(requireContext(), anError.getMessage());
                                    }
                                }
                            });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openOrderView(int orderType, String orderId) {
        OnlineOrderViewFragment onlineOrderViewFragment = myApp.getInstanceOnlineOrder(orderId, orderType);
        onlineOrderViewFragment.show(getActivity().getSupportFragmentManager(), "NewFragmentTag");
        onlineOrderViewFragment.setDialogDismissListener(acceptOrderDialogListener);
    }

    DialogDismissListener acceptOrderDialogListener = o -> {
        chekedBtn(llToday);
        getToday();
    };

    private void setListeners() {

        ivBack.setOnClickListener(v -> getActivity().onBackPressed());

        llToday.setOnClickListener(v -> {
            cvCustom.setVisibility(View.GONE);
            filterType = 0;
            chekedBtn(llToday);
            getToday();
        });
        llThisWeek.setOnClickListener(v -> {
            cvCustom.setVisibility(View.GONE);
            filterType = 1;
            chekedBtn(llThisWeek);
            getWeek();
        });
        llThisMonth.setOnClickListener(v -> {
            cvCustom.setVisibility(View.GONE);
            filterType = 2;
            chekedBtn(llThisMonth);
            getCurrentMonth();
        });
        llCustom.setOnClickListener(v -> {
            cvCustom.setVisibility(View.VISIBLE);
            chekedBtn(llCustom);
        });


        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view1, y, m, d) -> {
                fromDay = d;
                fromMonth = m;
                fromYear = y;
                fromDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalender.set(y, m, d);

                tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
                tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

                filterType = 3;
                fetchOrders();
            }, fromCalender.get(Calendar.YEAR), fromCalender.get(Calendar.MONTH), fromCalender.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.setThemeDark(false);
            datePickerDialog.showYearPickerFirst(false);
            datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");
            if (!Validators.isNullOrEmpty(toDateString)) {
                datePickerDialog.setMaxDate(toCalender);
            }
        });

        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view12, y, m, d) -> {
                toDay = d;
                toMonth = m;
                toYear = y;
                toDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalender.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
                tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

                filterType = 3;
                fetchOrders();
            }, toCalender.get(Calendar.YEAR), toCalender.get(Calendar.MONTH), toCalender.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.setThemeDark(false);
            datePickerDialog.showYearPickerFirst(false);
            datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");
            if (!Validators.isNullOrEmpty(fromDateString)) {
                datePickerDialog.setMinDate(fromCalender);
            }
        });
    }

    private void chekedBtn(View v) {
        lastCheckedId = v.getId();
        vToday.setBackgroundResource(R.color.light_gray);
        tvToday.setAlpha(0.5f);

        vThisWeek.setBackgroundResource(R.color.light_gray);
        tvThisWeek.setAlpha(0.5f);

        vThisMonth.setBackgroundResource(R.color.light_gray);
        tvThisMonth.setAlpha(0.5f);

        vCustom.setBackgroundResource(R.color.light_gray);
        tvCustom.setAlpha(0.5f);

        if (v == llToday) {
            vToday.setBackgroundResource(R.color.persian_green);
            tvToday.setAlpha(1f);
        }
        if (v == llThisWeek) {
            vThisWeek.setBackgroundResource(R.color.persian_green);
            tvThisWeek.setAlpha(1f);
        }
        if (v == llThisMonth) {
            vThisMonth.setBackgroundResource(R.color.persian_green);
            tvThisMonth.setAlpha(1f);
        }
        if (v == llCustom) {
            vCustom.setBackgroundResource(R.color.persian_green);
            tvCustom.setAlpha(1f);
        }
    }

    private void customClick() {
        if ((!Validators.isNullOrEmpty(fromDateString)) && (Validators.isNullOrEmpty(toDateString))) {
            llToDate.performClick();
        } else {
            moveNext = true;
            llFromDate.performClick();
        }
    }

    private void getCurrentMonth() {
        c.set(year, month, day);
        fromDate = c.getTime();

        int numOfDaysInMonth = c.getActualMaximum(Calendar.DAY_OF_MONTH);
        c.add(Calendar.DAY_OF_MONTH, numOfDaysInMonth - 1);

        toDate = c.getTime();

        fromDateString = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "yyyy-MM-dd");
        toDateString = CommonFunctions.formatMiliToDesireFormat(toDate.getTime(), "yyyy-MM-dd");
        fetchingOrders = true;
        tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
        tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

        fetchOrders();
    }

    private void getWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        fromDate = cal.getTime();

        cal.add(Calendar.DATE, 6);
        toDate = cal.getTime();

        fromDateString = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "yyyy-MM-dd");
        toDateString = CommonFunctions.formatMiliToDesireFormat(toDate.getTime(), "yyyy-MM-dd");
        fetchingOrders = true;
        tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
        tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

        fetchOrders();
    }

    private void getToday() {
        fromDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
        toDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
        fromDate = new Date();
        toDate = fromDate;
        fetchingOrders = true;
        tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
        tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

        fetchOrders();
    }

    private void fetchData() {
        new Thread(this::fetchOrders).start();
    }

    private void fetchOrders() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            //'ThisWeek','ThisMonth','ThisYear','Today', 'Yesterday'

            Log.e("restaurant_id", "" + myApp.restaurant_id);
            Log.e("restaurant_id", "" + fromDateString.replace("/", "-"));
            Log.e("restaurant_id", "" + toDateString.replace("/", "-"));
            if (!myApp.restaurant_id.isEmpty()) {
                AndroidNetworking.get(ApiEndPoints.online_orders_history)
                        .addQueryParameter("restaurant_id", myApp.restaurant_id)
                        .addQueryParameter("start_date", fromDateString.replace("/", "-"))
                        .addQueryParameter("end_date", toDateString.replace("/", "-"))
                        .build()
                        .getAsObject(RestaurantOrderResponse.class, new ParsedRequestListener<RestaurantOrderResponse>() {
                            @Override
                            public void onResponse(RestaurantOrderResponse response) {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llData.setVisibility(View.VISIBLE);
                                    });
                                }
                                ordersResponse = response;
                                setupAdapter();
                                ordersAdapter.notifyDataSetChanged();
                            }

                            @Override
                            public void onError(ANError anError) {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llNoRecord.setVisibility(View.VISIBLE);
                                        ordersList.clear();
                                        ordersAdapter.notifyDataSetChanged();
                                    });
                                }
                                anError.printStackTrace();
                                if (!CommonFunctions.isConnected(getActivity())) {
                                    myApp.noInternet(getActivity());
                                }
                            }
                        });
            } else {
                llLoading.setVisibility(View.GONE);
                llNoRecord.setVisibility(View.VISIBLE);
                ordersList.clear();
                ordersAdapter.notifyDataSetChanged();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void openConfirmationDialog() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Accept Booking", "Do you want to confirm this booking?", 0, "Confirm", "Cancel");
            confirmationDialogFragment.show(getChildFragmentManager(), "order_accepted");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                try {
                    String action = (String) o; //confirm, cancel
                    if (action.equalsIgnoreCase("confirm")) {
                        int orderType = -1;
                        if (Validators.isNullOrEmpty(clickedOrder.order_type)) {
                            orderType = 0;
                        } else if (clickedOrder.order_type.equalsIgnoreCase("delivery")) {
                            orderType = 1;
                        } else if (clickedOrder.order_type.equalsIgnoreCase("pickup")) {
                            orderType = 2;
                        }
                        changeOrderStatus(orderType, clickedOrder.id, "Delivered");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeOrderStatus(int order_type, String order_id, String status) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            String url = ApiEndPoints.online_orders_status_change;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }
            AndroidNetworking.post(url)
                    .addPathParameter("id", order_id)
                    .addBodyParameter("order_id", order_id)
                    .addBodyParameter("status", status)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                fetchData();
                                if (order_type == 0) {
                                    // Firebase issue resolved for snakeBar
                                    CommonFunctions.showSnackBar(getActivity(), getActivity().findViewById(android.R.id.content), "Order served");
                                } else if (order_type == 1) {
                                    // Firebase issue resolved for snakeBar
                                    CommonFunctions.showSnackBar(getActivity(), getActivity().findViewById(android.R.id.content), "Order delivered");
                                } else {
                                    // Firebase issue resolved for snakeBar
                                    CommonFunctions.showSnackBar(getActivity(), getActivity().findViewById(android.R.id.content), "Order collected");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupAdapter() {
        try {
            if (ordersResponse != null) {
                ordersList.clear();

                int completedOrders = 0;
                if (ordersResponse.completed_orders != null) {
                    completedOrders = completedOrders + ordersResponse.completed_orders.size();
                }
                if (ordersResponse.dinein_completed_orders != null) {
                    completedOrders = completedOrders + ordersResponse.dinein_completed_orders.size();
                }
                if (completedOrders > 0) {
                    ArrayList<OrderDetail> orders = new ArrayList<>();
                    ordersList.add(new OrderStatusIndicatorHeader("Completed order (" + completedOrders + ")"));
                    if (ordersResponse.completed_orders != null)
                        orders.addAll(ordersResponse.completed_orders);
                    if (ordersResponse.dinein_completed_orders != null)
                        orders.addAll(ordersResponse.dinein_completed_orders);
                    ordersList.addAll(sortOrdersByNew(orders));
                }
            } else {
                ordersList.clear();
            }
            boolean isHasDeleteRecord = false;
            for (int i = 0; i < ordersAdapter.ordersList.size(); i++) {
                Object order = ordersAdapter.ordersList.get(i);
                if (order instanceof OrderDetail) {
                    if (((OrderDetail) order).past_days >= 180) {
                        isHasDeleteRecord = true;
                    }
                }
            }
            if (MyApp.userPermission.online_order_delete.actions.list && isHasDeleteRecord) {
                tvSelect.setVisibility(View.VISIBLE);
            } else {
                tvSelect.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<OrderDetail> sortOrdersByNew(ArrayList<OrderDetail> orders) {
        Collections.sort(orders, (restaurantOrder, t1) -> {
            Date orderDateLHS;
            if (!Validators.isNullOrEmpty(restaurantOrder.order_type)) {
                String date = restaurantOrder.delivery_date.split("T")[0] + " " + restaurantOrder.delivery_time;
                orderDateLHS = CommonFunctions.convertStringDateToDate(date, "dd-MM-yyyy hh:mm a");
            } else {
                orderDateLHS = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(restaurantOrder.created.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy hh:mm a"), "dd-MM-yyyy hh:mm a");
            }

            Date orderDateRHS;
            if (!Validators.isNullOrEmpty(t1.order_type)) {
                String date = t1.delivery_date.split("T")[0] + " " + t1.delivery_time;
                orderDateRHS = CommonFunctions.convertStringDateToDate(date, "dd-MM-yyyy hh:mm a");
            } else {
                orderDateRHS = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(t1.created.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy hh:mm a"), "dd-MM-yyyy hh:mm a");
            }

            return orderDateLHS.compareTo(orderDateRHS);
        });
        return orders;
    }

    private void fetchOrderDetail(OrderDetail order) {
        try {
            int order_type = -1;
            if (Validators.isNullOrEmpty(order.order_type)) {
                order_type = 0;
            } else if (order.order_type.equalsIgnoreCase("delivery")) {
                order_type = 1;
            } else if (order.order_type.equalsIgnoreCase("pickup")) {
                order_type = 2;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                            progressDialog.show();
                        }
                );
            }
            String url = ApiEndPoints.online_orders;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders;
            }
            AndroidNetworking.get(url + order.id)
                    .build()
                    .getAsObject(OrderDetail.class, new ParsedRequestListener<OrderDetail>() {
                        @Override
                        public void onResponse(OrderDetail response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                            }
                            response.service_charge_status = savedRestaurant.service_charge_status;
                            createPrint(response);

                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                            }
                            LogUtils.e("ERROR IN ORDER VIEW");
                            LogUtils.e(anError.getErrorBody());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void createPrint(OrderDetail orderDetail) {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                lastPrintIp = defaultPrinter.ip;
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        if (zoneRichPrinter == null) {
                            // Firebase issue resolved for snakeBar
                            CommonFunctions.showSnackBar(getActivity(), getActivity().findViewById(android.R.id.content), "Printer is null");
                        } else {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printZonerich(orderDetail, false, defaultPrinter.ip);
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, false);
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (sunmiPrinter == null) {
                        ToastUtils.makeToast(getActivity(), "Printer is null");
                    } else {
                        printSunmi(orderDetail, false);
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin(orderDetail, false);
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            if (wifiPrinter == null) {
                                ToastUtils.makeToast(getActivity(), "Printer is null");
                            } else {
                                wifiPrinter.disconnect();
                                CommonFunctions.functionThatDelay(100);
                                wifiPrinter.connect(defaultPrinter.ip);
                                CommonFunctions.functionThatDelay(100);
                                printWifi(orderDetail, false);
                            }
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        CommonFunctions.functionThatDelay(100);
                                        prinBTWifi(orderDetail, false);
                                    } else {
                                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isOpenCashDrawer = false;
    boolean isOpenCashDrawerDefault = false;

    private void continueForKitchenCopy(OrderDetail orderDetail, String printerType) {
//        if (true) {
////            goBack();
//            return;
//        }
//        defaultOnlineKitchenPrinter = defaultPrinter;
        try {

            try {
                new Thread(() -> {
                    ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) myApp.appDatabase.prepLocationDao().list();
                    isOpenCashDrawer = false;
                    if (prepLocations != null && prepLocations.size() > 0 && defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.id)) {
                        for (int i = 0; i < prepLocations.size(); i++) {
                            if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultOnlineKitchenPrinter.id) && prepLocations.get(i).cash_draw) {
                                isOpenCashDrawer = true;
                                break;
                            }
                        }
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
                isOpenCashDrawer = false;
            }
            if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultOnlineKitchenPrinter.ip != null && !defaultOnlineKitchenPrinter.ip.equalsIgnoreCase("")) {
                    zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                    CommonFunctions.functionThatDelay(100);
                    printZonerich(orderDetail, true, defaultOnlineKitchenPrinter.ip);

                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        zoneRichPrinter.openCashDrawer();
                    }
                } else {
                    try {
                        if (bluetoothPrinter != null) {
                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                            if (device != null) {
                                CommonFunctions.functionThatDelay(100);
                                printBTZonerich(orderDetail, true);
                                CommonFunctions.functionThatDelay(100);
                                bluetoothPrinter.openCashDrawer();
                            } else {
                                ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                printSunmi(orderDetail, true);
                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                        sunmiPrinterV3Mix.openCashDrawer();
                    }else {
                        sunmiPrinter.openCashDrawer();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                    printIMin(orderDetail, true);
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        IminSDKManager.opencashBox();
                    }
                } else {
                    if (!lastPrintIp.equalsIgnoreCase(defaultOnlineKitchenPrinter.ip)) {
                        wifiPrinter.disconnect();
                        CommonFunctions.functionThatDelay(100);
                        wifiPrinter.connect(defaultOnlineKitchenPrinter.ip);
                    }
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        CommonFunctions.functionThatDelay(500);
                        wifiPrinter.openCashDrawer(false);
                    }
                    CommonFunctions.functionThatDelay(500);
                    printWifi(orderDetail, true);
                }
            } else if (defaultPrinter != null && !Validators.isNullOrEmpty(defaultPrinter.printer_model_name)) {
                try {
                    new Thread(() -> {
                        ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) myApp.appDatabase.prepLocationDao().list();
                        isOpenCashDrawerDefault = false;
                        if (prepLocations != null && prepLocations.size() > 0) {
                            for (int i = 0; i < prepLocations.size(); i++) {
                                if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultPrinter.id) && prepLocations.get(i).cash_draw) {
                                    isOpenCashDrawerDefault = true;
                                    break;
                                }
                            }
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    isOpenCashDrawerDefault = false;
                }
                CommonFunctions.functionThatDelay(200);
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        printZonerich(orderDetail, true, defaultPrinter.ip);

                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            zoneRichPrinter.openCashDrawer();
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, true);
                                    CommonFunctions.functionThatDelay(100);
                                    bluetoothPrinter.openCashDrawer();
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi(orderDetail, true);

                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                            sunmiPrinterV3Mix.openCashDrawer();
                        }else {
                            sunmiPrinter.openCashDrawer();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin(orderDetail, true);
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                            IminSDKManager.opencashBox();
                        }
                    } else {
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            wifiPrinter.openCashDrawer(false);
                        }
                        CommonFunctions.functionThatDelay(500);
                        printWifi(orderDetail, true);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIMin(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            String onlineOrderPrintCount;
            onlineOrderPrintCount = myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print;
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                myApp.iMinPrinterUtils.printOrderFoodHub(listPrintStructure, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, onlineOrderPrintCount, () -> null);
            } else {
                myApp.iMinPrinterUtils.printOrder(myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, onlineOrderPrintCount, () -> null);
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonerich(OrderDetail orderDetail, boolean kitchenCopy, String defaultPrinterId) {
        try {
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                zoneRichPrinter.printOrderFoodHub(listPrintStructure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> null);
            } else {
                zoneRichPrinter.printOrder(structure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> null);
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            }
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBTZonerich(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrderZoneRich(myApp.tiffintomLogoSmall, orderDetail, kitchenCopy);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printWifi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            wifiPrinter.printOrder(myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, myApp.myPreferences.getPrintSetting(), kitchenCopy, kitchenCopy, myApp.myPreferences, myApp.orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "wifi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "wifi");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prinBTWifi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrder(myApp.tiffintomLogoSmall, orderDetail, kitchenCopy, kitchenCopy);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "wifi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "wifi");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSunmi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                    sunmiPrinterV3Mix.printOrderFoodHub(listPrintStructure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }else {
                    sunmiPrinter.printOrderFoodHub(listPrintStructure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }
            } else {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                    sunmiPrinterV3Mix.printOrder(structure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }else {
                    sunmiPrinter.printOrder(structure, printSettings, myApp.tiffintomLogoSmall, myApp.businessLogo, orderDetail, kitchenCopy, myApp.orderTiffinTomLogo, myApp.myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "sunmi");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "sunmi");
                            }
                        }
                    });
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        if (getActivity() != null && progressDialog != null) {
            progressDialog.dismiss();
        }
        super.onStop();
    }
}
