package com.ubsidi.epos_2021.online.fragments;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.TimePicker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.adapters.OrderedProductItemsAdapter;
import com.ubsidi.epos_2021.online.adapters.TimeslotsSelectionAdapter;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * Created by Amrish on 11-11-2020.
 */
public class OrderSetTimeDialogFragment extends DialogFragment {
    private int order_type = -1; // 0 dinein, 1 delivery, 2 pickup
    private String order_id;
    private boolean delay;
    private ArrayList<String> timeSlotsString = new ArrayList<>();
    private TimeslotsSelectionAdapter adapter;
    private LinearLayout llLoading;
    private String selectedTimeSlot = "";
    private Button btnConfirm, btnCancel;
    private DialogDismissListener dialogDismissListener;
    private TextView tvSelectedTime;
    private OrderDetail orderDetail;
    private TextView tvSubTotal, tvServiceCharge, tvDeliveryFee, tvTipAmount, tvCharityAmount, tvDiscount, tvRewardDiscount, tvRewardDiscountLabel, tvWalletAmount, tvGratuityAmount;
    private LinearLayout llDiscount, llDeliveryFee, llCharityAmount, llTipAmount, llWalletAmountl, llRewardDiscount, llServiceCharge, llCancelReason, llGratuity;
    private TextView tvOrderNumber, tvOrderPaymentStatus, tvOrderDate, tvDeliveryTime, tvMiles, tvTotal, tvPaymentMethodName, tvCardDetails;
    private OrderedProductItemsAdapter productItemsAdapter;
    private ArrayList<OrderProductDetail> productDetails = new ArrayList<>();
    private AlertDialog progressDialog;
    private Chip chipBack;

    @Override
    public int getTheme() {
        return R.style.MyRightDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        getDialog().getWindow().setGravity(Gravity.END);
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_online_order_settime_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (getArguments() != null) {
            delay = getArguments().getBoolean("delay");
            order_id = getArguments().getString("order_id");
            order_type = getArguments().getInt("order_type");
            orderDetail = new Gson().fromJson(getArguments().getString("order_detail"), OrderDetail.class);
        }
        initViews(view);

        fetchTimeSlots();
        setListeners();
        updateViews();
    }


    private void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity());
        llLoading = view.findViewById(R.id.llLoading);
        RecyclerView rvSlots = view.findViewById(R.id.rvTimeSlots);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnCancel = view.findViewById(R.id.btnCancel);
        TextView tvTitle = view.findViewById(R.id.tvTitle);
        tvSelectedTime = view.findViewById(R.id.tvSelectedTime);

        RecyclerView rvCartItems = view.findViewById(R.id.rvCartItems);
        tvOrderNumber = view.findViewById(R.id.tvOrderNumber);
        tvOrderPaymentStatus = view.findViewById(R.id.tvOrderPaymentStatus);
        tvOrderDate = view.findViewById(R.id.tvOrderDate);
        tvDeliveryTime = view.findViewById(R.id.tvDeliveryTime);
        tvMiles = view.findViewById(R.id.tvMiles);
        tvTotal = view.findViewById(R.id.tvTotal);
        tvPaymentMethodName = view.findViewById(R.id.tvPaymentMethodName);
        tvCardDetails = view.findViewById(R.id.tvCardDetails);

        tvSubTotal = view.findViewById(R.id.tvSubtotal);
        tvServiceCharge = view.findViewById(R.id.tvServiceFee);
        tvDeliveryFee = view.findViewById(R.id.tvDeliveryFee);
        tvDiscount = view.findViewById(R.id.tvDiscount);
        tvTipAmount = view.findViewById(R.id.tvTipAmount);
        tvRewardDiscount = view.findViewById(R.id.tvRewardDiscount);
        tvRewardDiscountLabel = view.findViewById(R.id.tvRewardDiscountLabel);
        tvCharityAmount = view.findViewById(R.id.tvCharityAmount);
        tvWalletAmount = view.findViewById(R.id.tvWalletAmount);
        tvGratuityAmount = view.findViewById(R.id.tvGratuityAmount);

        llCharityAmount = view.findViewById(R.id.ll_CharityAmount);
        llDeliveryFee = view.findViewById(R.id.ll_Delivery);
        llDiscount = view.findViewById(R.id.ll_Discount);
        llTipAmount = view.findViewById(R.id.ll_TipAmount);
        llWalletAmountl = view.findViewById(R.id.ll_WalletAmount);
        llRewardDiscount = view.findViewById(R.id.llRewardDiscount);
        llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
        llGratuity = view.findViewById(R.id.ll_Gratuity);

        chipBack = view.findViewById(R.id.chipBack);

        adapter = new TimeslotsSelectionAdapter(timeSlotsString, (position, data) -> {
            adapter.notifyDataSetChanged();
            if (position < timeSlotsString.size() - 1) {
                selectedTimeSlot = (String) data;
                if (Validators.isNullOrEmpty(selectedTimeSlot)) {
                    tvSelectedTime.setVisibility(View.GONE);
                } else {
                    tvSelectedTime.setVisibility(View.VISIBLE);
                    tvSelectedTime.setText(selectedTimeSlot + " selected");
                }
            }
            if (position == timeSlotsString.size() - 1) {
                Calendar calendar = Calendar.getInstance();

                TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), timeSetListener, calendar.get(Calendar.HOUR_OF_DAY), calendar.get(Calendar.MINUTE), false);
                timePickerDialog.show();
                timePickerDialog.setOnCancelListener(dialogInterface -> {
                    adapter.selectedTimeslot = selectedTimeSlot;
                    timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
                    adapter.notifyDataSetChanged();

                    if (Validators.isNullOrEmpty(selectedTimeSlot)) {
                        tvSelectedTime.setVisibility(View.GONE);
                    } else {
                        tvSelectedTime.setVisibility(View.VISIBLE);
                        tvSelectedTime.setText(selectedTimeSlot + " selected");
                    }
                });


            }
        });
        rvSlots.setAdapter(adapter);
        rvSlots.setLayoutManager(new GridLayoutManager(getActivity(), 2));

        rvCartItems.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        productItemsAdapter = new OrderedProductItemsAdapter(productDetails, true);
        rvCartItems.setNestedScrollingEnabled(false);
        rvCartItems.setAdapter(productItemsAdapter);

        if (order_type == 2) {
            if (delay) {
                tvTitle.setText("Select Delay Pickup Time");
            } else {
                tvTitle.setText("Select Pickup Time");
            }
        } else if (order_type == 1) {
            if (delay) {
                tvTitle.setText("Select Delay Delivery Time");
            } else {
                tvTitle.setText("Select Delivery Time");
            }
        } else {
            if (delay) {
                tvTitle.setText("Delay order");
            } else {
                tvTitle.setText("Select Time");
            }
        }
    }

    private void setListeners() {
        btnCancel.setOnClickListener(view -> dismiss());
        chipBack.setOnClickListener(view -> dismiss());
        btnConfirm.setOnClickListener(view -> {
            if (!Validators.isNullOrEmpty(selectedTimeSlot)) {
                if (delay) {
                    acceptOrder("Accepted");
                } else
                    acceptOrder("Accepted");
            } else ToastUtils.makeToast(getActivity(), "Please select time slot first.");
        });
    }

    private void updateViews() {

        try {
            if (orderDetail != null) {
                boolean isPreOrder;
                if (order_type > 0)
                    isPreOrder = CommonFunctions.isPreOrder(orderDetail.delivery_date, orderDetail.status);
                else isPreOrder = false;
                String orderType = CommonFunctions.getOnlineOrderType(order_type);

                tvTotal.setText(MyApp.currencySymbol + MyApp.df.format(orderDetail.order_grand_total));
                if (isPreOrder) {
                    tvOrderPaymentStatus.setText("Preorder for " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd/MM/yyyy") + " - " + orderType + " - " + (orderDetail.payment_status.equalsIgnoreCase("p") ? "Paid" : "Unpaid"));
                } else
                    tvOrderPaymentStatus.setText(orderType + " - " + (orderDetail.payment_status.equalsIgnoreCase("p") ? "Paid" : "Unpaid"));
                tvOrderNumber.setText("#" + orderDetail.order_number);
                if (order_type == 1 && !Validators.isNullOrEmpty(orderDetail.distance)) {
                    tvMiles.setText(orderDetail.distance + " Away");
                    tvMiles.setVisibility(View.VISIBLE);
                } else {
                    tvMiles.setVisibility(View.GONE);
                }
                if (order_type == 0) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_amber));
                } else if (order_type == 1) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_green));
                } else if (order_type == 2) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_indigo));
                }
                if (isPreOrder) {
                    tvOrderPaymentStatus.setTextColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_orange));
                }
                StringBuilder personalDetails = new StringBuilder();

                if (!Validators.isNullOrEmpty(orderDetail.created)) {
                    personalDetails = new StringBuilder();
                    personalDetails.append("Ordered at: ");
                    personalDetails.append(CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a, dd-MM-yyyy"));
                    tvOrderDate.setText(personalDetails.toString());
                    tvOrderDate.setVisibility(View.VISIBLE);
                } else {
                    tvOrderDate.setVisibility(View.GONE);
                }

                personalDetails = new StringBuilder();
                if (order_type > 0) {
                    personalDetails.append("Required by: ");
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        personalDetails.append("ASAP");
                    } else {
                        personalDetails.append(orderDetail.delivery_time);
                        personalDetails.append(", ").append(CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"));
                    }
                } else {
                    personalDetails = new StringBuilder();
                    personalDetails.append("Served by: ");
                    personalDetails.append("ASAP");
                }
                tvDeliveryTime.setText(personalDetails.toString());

                tvSubTotal.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.order_sub_total)));
                if (orderDetail.service_charge > 0) {
                    if ("no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                        llServiceCharge.setVisibility(View.GONE);
                    } else {
                        llServiceCharge.setVisibility(View.VISIBLE);
                    }
                    tvServiceCharge.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.service_charge)));
                } else {
                    llServiceCharge.setVisibility(View.GONE);
                }
                tvTotal.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.order_grand_total + orderDetail.charity_amount)));
                if (orderDetail.offer_amount + orderDetail.voucher_amount > 0) {
                    tvDiscount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.voucher_amount + orderDetail.offer_amount)));
                    llDiscount.setVisibility(View.VISIBLE);
                } else {
                    llDiscount.setVisibility(View.GONE);
                }

                if (orderDetail.reward_offer > 0) {
                    tvRewardDiscountLabel.setText("Redeem Amount (" + orderDetail.reward_offer_percentage + "%)");
                    tvRewardDiscount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.reward_offer)));
                    llRewardDiscount.setVisibility(View.VISIBLE);
                } else {
                    llRewardDiscount.setVisibility(View.GONE);
                }


                if (orderDetail.delivery_charge > 0) {
                    tvDeliveryFee.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.delivery_charge)));
                    llDeliveryFee.setVisibility(View.VISIBLE);
                } else {
                    llDeliveryFee.setVisibility(View.GONE);
                }

                if (orderDetail.driver_tip > 0) {
                    tvTipAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format((orderDetail.driver_tip))));
                    llTipAmount.setVisibility(View.VISIBLE);
                } else {
                    llTipAmount.setVisibility(View.GONE);
                }
                if (orderDetail.charity_amount > 0)
                    tvCharityAmount.setText(String.format("%s%s", orderDetail.charity_message + "(" + MyApp.currencySymbol, MyApp.df.format(orderDetail.charity_amount)) + ")");
                else {
                    llCharityAmount.setVisibility(View.GONE);
                }

                if (orderDetail.wallet_amount > 0)
                    tvWalletAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.wallet_amount)));
                else
                    llWalletAmountl.setVisibility(View.GONE);


                if (orderDetail.gratuity > 0) {
                    tvGratuityAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(orderDetail.gratuity)));
                    llGratuity.setVisibility(View.VISIBLE);
                } else {
                    llGratuity.setVisibility(View.GONE);
                }


                if (orderDetail.payment_method.equalsIgnoreCase("stripe")) {
                    if (!Validators.isNullOrEmpty(orderDetail.card_brand)) {
                        tvCardDetails.setText(String.format("**** %s", orderDetail.card_number));
                        tvCardDetails.setVisibility(View.VISIBLE);
                    } else {
                        tvCardDetails.setVisibility(View.GONE);
                    }
                    tvPaymentMethodName.setText(String.format("%s%s Paid via Credit/Debit card", MyApp.currencySymbol, (orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount));
                } else if (orderDetail.payment_method.equalsIgnoreCase("paypal")) {
                    tvPaymentMethodName.setText(String.format("%s%s Paid via Paypal", MyApp.currencySymbol, MyApp.df.format(((orderDetail.order_grand_total + orderDetail.charity_amount)) - orderDetail.wallet_amount)));
                } else if (orderDetail.payment_method.equalsIgnoreCase("cod")) {
                    if (orderDetail.payment_status.equalsIgnoreCase("p"))
                        tvPaymentMethodName.setText(String.format("%s%s Paid via Cash", MyApp.currencySymbol, MyApp.df.format((orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount)));
                    else {
                        if (order_type == 0)
                            tvPaymentMethodName.setText("Due to be payed at restaurant");
                        else if (order_type == 1)
                            tvPaymentMethodName.setText("Cash on delivery");
                        else if (order_type == 2)
                            tvPaymentMethodName.setText("Cash on collection");
                        tvPaymentMethodName.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
                    }
                } else if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit")) {
                    tvPaymentMethodName.setText(String.format("%s%s Paid via Credit", MyApp.currencySymbol, MyApp.df.format((orderDetail.order_grand_total + orderDetail.charity_amount) - orderDetail.wallet_amount)));
                }
                if (orderDetail != null && orderDetail.cart_view != null)
                    productDetails.addAll(orderDetail.cart_view);
                productItemsAdapter.notifyDataSetChanged();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void acceptOrder(String status) {
        try {
            String url = ApiEndPoints.online_orders_status_change;
            if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }
            Log.e("Test", " " + url);
            Log.e("Test", " " + order_id);
            Log.e("Test", " " + orderDetail.preparation);
            Log.e("Test", " " + status);
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }

            AndroidNetworking.post(url)
                    .addPathParameter("id", order_id)
                    .addBodyParameter("order_id", order_id)
                    .addBodyParameter("preparation", selectedTimeSlot)
                    .addBodyParameter("status", status)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.e("Test", " " + response);
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            if (dialogDismissListener != null) {
                                dialogDismissListener.onDialogDismiss(selectedTimeSlot);
                                //dismiss();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                    try {
                                        if (anError.getErrorBody() != null) {
                                            JSONObject jsonObject = new JSONObject(anError.getErrorBody());
                                            if (jsonObject.has("message")) {
                                                ToastUtils.makeToast(requireContext(), jsonObject.getString("message"));
                                            }
                                        }
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                });
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchTimeSlots() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.online_orders_time_slots)
                    .addPathParameter("id", order_id)
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                });
                            }
                            timeSlotsString.clear();
                            timeSlotsString.addAll(new Gson().fromJson(response.toString(), new TypeToken<List<String>>() {
                            }.getType()));
                            timeSlotsString.add("Custom");
                            adapter.notifyDataSetChanged();
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                });
                            }
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void selectOldTimeSlot() {
        try {
            adapter.selectedTimeslot = selectedTimeSlot;
            timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
            adapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    TimePickerDialog.OnTimeSetListener timeSetListener = new TimePickerDialog.OnTimeSetListener() {
        @Override
        public void onTimeSet(TimePicker timePicker, int hour, int minutes) {
            try {
                Calendar calendar = Calendar.getInstance();
                int currentHour = calendar.get(Calendar.HOUR_OF_DAY);
                int currentMinute = calendar.get(Calendar.MINUTE);
                boolean valid = false;
                String pickedTime = hour + ":" + minutes;
                String current = currentHour + ":" + currentMinute;
                if (hour == currentHour) {
                    valid = minutes >= currentMinute;
                } else valid = hour > currentHour;
                if (valid) {
                    String timeSet = "";
                    if (hour > 12) {
                        hour -= 12;
                        timeSet = "PM";
                    } else if (hour == 0) {
                        hour += 12;
                        timeSet = "AM";
                    } else if (hour == 12) {
                        timeSet = "PM";
                    } else {
                        timeSet = "AM";
                    }

                    String min = "";
                    if (minutes < 10)
                        min = "0" + minutes;
                    else
                        min = String.valueOf(minutes);
                    selectedTimeSlot = String.valueOf(hour) + ':' + min + " " + timeSet;
                    adapter.selectedTimeslot = selectedTimeSlot;
                    timeSlotsString.set(timeSlotsString.size() - 1, selectedTimeSlot);
                    adapter.notifyDataSetChanged();
                } else {
                    selectedTimeSlot = "";
                    ToastUtils.makeToast(getActivity(), "Invalid timeslot");
                    selectOldTimeSlot();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };


}
