package com.ubsidi.epos_2021.online.fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.android.material.radiobutton.MaterialRadioButton;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by Amrish on 27-11-2020.
 */
public class PreorderSetReminderDialogFragment extends DialogFragment {
    private RadioGroup rgTime;
    private MaterialRadioButton rb1Hour, rb2Hour, rb3Hour, rb4Hour, rb5Hour, rbCustomHour, rbCustom;
    private int hour = 0;
    private Calendar reminderCalendar = Calendar.getInstance();
    private Calendar deliveryCalendar = Calendar.getInstance();
    private OrderDetail orderDetail;
    private MaterialButton btnConfirm, btnCancel;
    private Chip chipBack;
    private TextView tvSeletedTime;

    @Override
    public int getTheme() {
        return R.style.MyRightDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        getDialog().getWindow().setGravity(Gravity.END);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            orderDetail = new Gson().fromJson(getArguments().getString("order"), OrderDetail.class);
        }

        return inflater.inflate(R.layout.fragment_online_preorder_setreminder, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setCalendars();
        setListeners();
    }

    private void initViews(View view) {
        rgTime = view.findViewById(R.id.rgTime);
        rb1Hour = view.findViewById(R.id.rbOneHour);
        rb2Hour = view.findViewById(R.id.rbTwoHour);
        rb3Hour = view.findViewById(R.id.rbThreeHour);
        rb4Hour = view.findViewById(R.id.rbFourHour);
        rb5Hour = view.findViewById(R.id.rbFiveHour);
        rbCustomHour = view.findViewById(R.id.rbCustomHour);
        rbCustom = view.findViewById(R.id.rbCustom);
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnCancel = view.findViewById(R.id.btnCancel);
        chipBack = view.findViewById(R.id.chipBack);
        tvSeletedTime = view.findViewById(R.id.tvSelectedTime);
    }

    private void setListeners() {
        chipBack.setOnClickListener(v -> dismiss());
        rgTime.setOnCheckedChangeListener((radioGroup, i) -> {
            tvSeletedTime.setVisibility(View.VISIBLE);
            if (i == R.id.rbOneHour) {
                hour = 1;
                tvSeletedTime.setText("Reminder set for " + rb1Hour.getText().toString());
            } else if (i == R.id.rbTwoHour) {
                hour = 2;
                tvSeletedTime.setText("Reminder set for " + rb2Hour.getText().toString());
            } else if (i == R.id.rbThreeHour) {
                hour = 3;
                tvSeletedTime.setText("Reminder set for " + rb3Hour.getText().toString());
            } else if (i == R.id.rbFourHour) {
                hour = 4;
                tvSeletedTime.setText("Reminder set for " + rb4Hour.getText().toString());
            } else if (i == R.id.rbFiveHour) {
                hour = 5;
                tvSeletedTime.setText("Reminder set for " + rb5Hour.getText().toString());
            } else if (i == R.id.rbCustom) {
                showEditHours();
            } else if (i == R.id.rbCustomHour) {
                hour = customHour;
                tvSeletedTime.setText("Reminder set for " + rbCustomHour.getText().toString());
            }

        });
        btnCancel.setOnClickListener(view -> dismiss());
        btnConfirm.setOnClickListener(view -> {
            if (hour > 0) {
                reminderCalendar.set(Calendar.HOUR_OF_DAY, deliveryCalendar.get(Calendar.HOUR_OF_DAY));
                reminderCalendar.add(Calendar.HOUR_OF_DAY, -hour);
                ToastUtils.makeToast(getActivity(), "Reminder set for order");
                dismiss();
            } else {
                ToastUtils.makeToast(getActivity(), "Please select reminder");
            }
        });

    }

    private void setCalendars() {
        Date deliveryDate = CommonFunctions.convertStringDateToDate((CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy") + " " + orderDetail.delivery_time), "dd-MM-yyyy hh:mm a");
        deliveryCalendar.setTime(deliveryDate);
        reminderCalendar.setTime(deliveryDate);
    }

    private int customHour = 0;

    private void showEditHours() {
        try {
            rbCustom.setChecked(false);
            AlertDialog alertDialog = new AlertDialog.Builder(getActivity()).create();
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            View dialogView = inflater.inflate(R.layout.dialog_set_custom_time, null);

            MaterialButton btnConfirm = dialogView.findViewById(R.id.btnConfirm);
            MaterialButton btnCancel = dialogView.findViewById(R.id.btnCancel);
            AppCompatEditText etHour = dialogView.findViewById(R.id.etHours);
            if (customHour > 0) {
                etHour.setText(String.valueOf(customHour));
                etHour.setSelection(etHour.getText().toString().length());
            }
            btnConfirm.setOnClickListener(view -> {
                if (!etHour.getText().toString().isEmpty() && Integer.parseInt(etHour.getText().toString()) > 0) {
                    customHour = Integer.parseInt((etHour.getText().toString()));
                    hour = customHour;
                    if (hour == 1) {
                        rb1Hour.setChecked(true);
                    } else if (hour == 2) {
                        rb2Hour.setChecked(true);
                    } else if (hour == 3) {
                        rb3Hour.setChecked(true);
                    } else if (hour == 4) {
                        rb4Hour.setChecked(true);
                    } else if (hour == 5) {
                        rb5Hour.setChecked(true);
                    } else {
                        rbCustomHour.setText(customHour + " hours before delivery");
                        rbCustomHour.setChecked(customHour > 0);
                        rbCustomHour.setVisibility(View.VISIBLE);
                    }

                    alertDialog.dismiss();
                } else {
                    ToastUtils.makeToast(getActivity(), "Please enter valid hour");
                }
            });
            btnCancel.setOnClickListener(view -> {

                if (hour == 1) {
                    rb1Hour.setChecked(true);
                } else if (hour == 2) {
                    rb2Hour.setChecked(true);
                } else if (hour == 3) {
                    rb3Hour.setChecked(true);
                } else if (hour == 4) {
                    rb4Hour.setChecked(true);
                } else if (hour == 5) {
                    rb5Hour.setChecked(true);
                } else {
                    rbCustomHour.setChecked(customHour > 0);
                }
                alertDialog.dismiss();
            });
            alertDialog.setView(dialogView);
            alertDialog.setCancelable(false);
            alertDialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
