package com.ubsidi.epos_2021.online.fragments;

import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.adapters.ReasonSelectionAdapter;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Created by Amrish on 11-11-2020.
 */
public class RejectReasonDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private ArrayList<String> reasons = new ArrayList<>();
    private ReasonSelectionAdapter reasonSelectionAdapter;
    private MaterialButton btnConfirm;
    private DialogDismissListener dialogDismissListener;
    private String selectedReason;
    private AppCompatEditText etOtherReason;
    private String title, info;
    private Chip chipBack;
    int successType = 0; //0 nutral, 1= success, 2= error

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_online_order_reject_reason, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                title = getArguments().getString("title");
                info = getArguments().getString("info");
                successType = getArguments().getInt("type");
                selectedReason = getArguments().getString("selected_reason");
            }
            reasons.addAll(Arrays.asList(getArguments().getString("reasons").split(",")));
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            TextView tvTitle = view.findViewById(R.id.tvTitle);
            TextView tvInfo = view.findViewById(R.id.tvInfo);
            RecyclerView rvReasons = view.findViewById(R.id.rvReasons);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            etOtherReason = view.findViewById(R.id.etOtherReason);
            chipBack = view.findViewById(R.id.chipBack);
            reasonSelectionAdapter = new ReasonSelectionAdapter(reasons, (position, data) -> {
                reasonSelectionAdapter.notifyDataSetChanged();
                selectedReason = (String) data;
                etOtherReason.setText(selectedReason);
                if (selectedReason.trim().equalsIgnoreCase("other")) {
                    etOtherReason.setText("");
                    etOtherReason.setVisibility(View.VISIBLE);
                } else {
                    etOtherReason.setVisibility(View.GONE);
                }
            });
            rvReasons.setAdapter(reasonSelectionAdapter);
            rvReasons.setLayoutManager(new GridLayoutManager(getActivity(), 2));

            if (!Validators.isNullOrEmpty(selectedReason)) {
                reasonSelectionAdapter.selectedReason = selectedReason;
                reasonSelectionAdapter.notifyDataSetChanged();
                etOtherReason.setText(selectedReason);
            }
            if (!Validators.isNullOrEmpty(title)) {
                tvTitle.setText(title);
                if (successType == 1) {
                    tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.chip_green_color));
                } else if (successType == 2) {
                    tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
                } else {
                    tvTitle.setTextColor((Color.parseColor("#A4A0A0")));
                }
            }
            if (!Validators.isNullOrEmpty(info)) {
                tvInfo.setText(info);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        btnConfirm.setOnClickListener(view -> {
            if (!Validators.isNullOrEmpty(etOtherReason.getText().toString())) {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(etOtherReason.getText().toString());
                    dismiss();
                }
            } else {
                ToastUtils.makeToast(getActivity(), "Please provide reason");
            }
        });
        chipBack.setOnClickListener(view -> dismiss());
    }
}
