package com.ubsidi.epos_2021.online.notification;

import static com.ubsidi.epos_2021.utils.Constants.AUTO_ACCEPT;
import static com.ubsidi.epos_2021.utils.Constants.BOOKING_ID;
import static com.ubsidi.epos_2021.utils.Constants.PREPARATION_TIME;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.HomeActivity;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;

import org.json.JSONException;
import org.json.JSONObject;


public class MyOnlineFirebaseMessagingService extends FirebaseMessagingService {

    private static final String TAG = MyOnlineFirebaseMessagingService.class.getSimpleName();
    private NotificationUtils notificationUtils;
    String message = "", title = "";

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            if (remoteMessage.getNotification() != null)
                LogUtils.e("FCM: " + remoteMessage.getNotification().getTitle());
            LogUtils.e("FCM MESSAGE");
            // Check if message contains a notification payload.

            if (remoteMessage.getData().size() > 0) {

                try {
                    JSONObject json = new JSONObject(remoteMessage.getData().toString());
                    JSONObject data = json.getJSONObject("data");
                    Log.e("Notification", "data:" + data.toString());
                    if (data.has("notification_for")) {
                        //LogUtils.e("Notification for:" + data.getString("notification_for")+ " U0dater id "+data.getString("updater_id")+" logged user "+MyApp.getInstance().myPreferences.getLoggedInUser().id);
                        if(data.has("updater_id")){
                            if(!data.getString("updater_id").equalsIgnoreCase(MyApp.getInstance().myPreferences.getLoggedInUser().id)){
                                sendEposNotification(data);
                            }
                        }else {
                            sendEposNotification(data);
                        }

                    } else if (data.has("amount")) {
                        handlePaymentLinkDataMessage(data);
                    } else {
                        handleDataMessage(data);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendEposNotification(JSONObject data){
        try {
            if (data.getString("notification_for").equalsIgnoreCase("epos")) {
                Intent pushNotification = new Intent(Constants.EPOS_NEW_ORDER);
                pushNotification.putExtra("refresh", true);
                pushNotification.putExtra("notification_for", data.getString("notification_for"));
                if (data.has("device_id")) {
                    pushNotification.putExtra("device_id", data.getString("device_id"));
                }
                if (data.has("business_id")) {
                    pushNotification.putExtra("business_id", data.getString("business_id"));
                }
                if (data.has("notification_section")) {
                    LogUtils.e("Notification section:" + data.getString("notification_section"));
                    pushNotification.putExtra("notification_section", data.getString("notification_section"));
                    if (data.getString("notification_section").equalsIgnoreCase("orders")) {
                        pushNotification.putExtra("print", data.getBoolean("print"));
                        pushNotification.putExtra("order_id_", data.getInt("order_id"));
                    }
                }
                if (data.has("order_id")) {
                    LogUtils.e("new Order :" + data.get("order_id"));
                    pushNotification.putExtra("order_id", data.get("order_id").toString());
                }
                LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
            }
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void handlePaymentLinkDataMessage(JSONObject data) {
        LogUtils.e("Notification Message");
        LogUtils.e(data);
        try {
            // play notification sound
            NotificationUtils notificationUtils = new NotificationUtils(getApplicationContext());
            notificationUtils.playNotificationSound();
            Intent pushNotification = new Intent(Constants.PAYMENT_NOTIFICATION);
            pushNotification.putExtra("refresh", true);
            if (data.has("order_id")) {
                pushNotification.putExtra("order_id", data.get("order_id").toString());
                if (data.has("amount")) {
                    MyApp.getInstance().doOrderUpdateAndUpload(data.get("order_id").toString(),data.get("amount").toString());
                }
            }
            if (data.has("amount")) {
                pushNotification.putExtra("amount", data.getString("amount"));
            }
            if (data.has("status")) {
                pushNotification.putExtra("status", data.getString("status"));
            }
            if (data.has("transaction_id")) {
                pushNotification.putExtra("transaction_id", data.getString("transaction_id"));
            }
            if (data.has("email")) {
                pushNotification.putExtra("email", data.getString("email"));
            }
            if (data.has("phone")) {
                pushNotification.putExtra("phone", data.getString("phone"));
            }
            LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
        } catch (JSONException e) {
            LogUtils.e(TAG, "Json Exception: " + e.getMessage());
        } catch (Exception e) {
            LogUtils.e(TAG, "Exception: " + e.getMessage());
        }
    }


    private void handleDataMessage(JSONObject data) {
        LogUtils.e("Notification Message");
        LogUtils.e(data);
        try {

            title = data.getString("title");
            message = data.getString("message");
            String timestamp = data.getString("timestamp");
            String order_id = null;
            String payment_status = null;
            String order_status = null;
            String order_type = null;
            int booking_id = 0;
            String preparation_time = null;
            boolean auto_accept = false;
            if (data.has("order_id"))
                order_id = data.getString("order_id");
            if (data.has("payment_status"))
                payment_status = data.getString("payment_status");
            if (data.has("order_status"))
                order_status = data.getString("order_status");
            if (data.has("order_type"))
                order_type = data.getString("order_type");
            if (data.has(AUTO_ACCEPT))
                auto_accept = data.getBoolean(AUTO_ACCEPT);
            if (data.has(BOOKING_ID))
                booking_id = data.getInt(BOOKING_ID);
            if (data.has("preparation_time"))
                preparation_time = data.getString("preparation_time");
            LogUtils.e("OrderId=>" + order_id);
            LogUtils.e("PaymentStatus=>" + payment_status);
            LogUtils.e("OrderStatus=>" + order_status);
            LogUtils.e("OrderType=>" + order_type);
            LogUtils.e("booking_id=>" + booking_id);
            LogUtils.e("auto_accept=>" + auto_accept);
            sendPushNotificationBroadCast(title, message, order_id, payment_status, order_status, order_type,booking_id,auto_accept,preparation_time);
            Intent resultIntent = new Intent(getApplicationContext(), HomeActivity.class);
            if (title.equalsIgnoreCase("newtable")) {
                resultIntent.putExtra("destination", "reservations");
            } else {
                resultIntent.putExtra("destination", "orders");
            }
            if (!NotificationUtils.isAppIsInBackground(getApplicationContext())) {
                // app is in foreground, broadcast the push message
                Intent pushNotification = new Intent(Constants.NOTIFICATION);
                pushNotification.putExtra("refresh", true);

                LocalBroadcastManager.getInstance(this).sendBroadcast(pushNotification);

                // play notification sound
                NotificationUtils notificationUtils = new NotificationUtils(getApplicationContext());
                notificationUtils.playNotificationSound();

            }
//            showNotificationMessage(getApplicationContext(), title, message, timestamp, resultIntent);
        } catch (JSONException e) {
            LogUtils.e(TAG, "Json Exception: " + e.getMessage());
        } catch (Exception e) {
            LogUtils.e(TAG, "Exception: " + e.getMessage());
        }
    }

    private void sendPushNotificationBroadCast(String title, String message, String order_id, String payment_status, String order_status, String order_type,int booking_id,boolean auto_accept,String preparation_time) {
        try {
            Intent pushNotification = new Intent(Constants.PUSH_NOTIFICATION);
            pushNotification.putExtra("push", true);
            pushNotification.putExtra("title", title);
            pushNotification.putExtra("message", message);
            pushNotification.putExtra("order_id", order_id);
            pushNotification.putExtra("order_status", order_status);
            pushNotification.putExtra("order_type", order_type);
            pushNotification.putExtra("payment_status", payment_status);
            pushNotification.putExtra(BOOKING_ID, booking_id);
            pushNotification.putExtra(AUTO_ACCEPT, auto_accept);
            pushNotification.putExtra(PREPARATION_TIME, preparation_time);
            LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Showing notification with text only
     */
    private void showNotificationMessage(Context context, String title, String message, String timeStamp, Intent intent) {
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        notificationUtils.showNotificationMessage("TiffinTom Restaurant", message, timeStamp, intent);
    }

    @Override
    public void onNewToken(@NonNull String s) {
        super.onNewToken(s);
        try {
            MyApp.getInstance().myPreferences.setUserFCMToken(s);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
