package com.ubsidi.epos_2021.online.services_receivers;

import static com.ubsidi.epos_2021.utils.Constants.BUSINESS_EVENING_END_TIME;
import static com.ubsidi.epos_2021.utils.Constants.DDMMYYYY;
import static com.ubsidi.epos_2021.utils.Constants.DDMMYYYYHHMMA;

import android.app.IntentService;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;

import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.UploadOrdersActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.DeviceInfo;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.models.Counts;
import com.ubsidi.epos_2021.services.SingleCustomerUploadFromBackgroundService;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;


/**
 * Created by Amrish on 27-11-2020.
 */
//public class TiffintomPartnerService extends Service {
public class TiffintomPartnerService extends IntentService {
    /**
     * @param name
     * @deprecated
     */
    public TiffintomPartnerService() {
        super("Fetch Order Count");
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            startTimer();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MyApp myApp = MyApp.getInstance();

    /*@Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        try {
            startTimer();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return START_STICKY;
    }*/


    @Override
    public void onDestroy() {
        try {
            Intent broadcastIntent = new Intent(this, ServiceStopReceiver.class);
            sendBroadcast(broadcastIntent);
            stoptimertask();
            myApp.stopReservationsSound();
            myApp.stopOrderSound();
            myApp.stopDelayedOrderSound();
            myApp.stopNewMessageSound();
            myApp.stopPaymentFailedSound();
            myApp.stopPaymentSuccessSound();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    private Timer timer, countTimer;
    private TimerTask timerTask, countTimerTask;
    long oldTime = 0;

    public void startTimer() {
        //set a new Timer
        timer = new Timer();
        countTimer = new Timer();

        //initialize the TimerTask's job
        initTimerTask();

        //schedule the timer, to wake up every 2 second
        try {
            if (timerTask != null) timer.schedule(timerTask, 5000, 5000); //
            if (countTimerTask != null) countTimer.schedule(countTimerTask, 30000, 10000); //
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTimerTask() {
        timerTask = new TimerTask() {
            public void run() {
                try {
                    if (myApp.isConnected(getApplicationContext())) {
                        if (canWeUploadNextCallLog) {
                            new Thread(() -> {
                                CallLogs callLogs = myApp.appDatabase.calllogDao().uploadableFirst();
                                if (callLogs != null) {
                                    uploadCallLog(callLogs);
                                }
                            }).start();
                        }
                        if (canWeUploadNextReservation) {
                            if (!myApp.isReservationOpen) {
                                new Thread(() -> {
                                    Reservation reservation = myApp.appDatabase.reservationDao().uploadableFirst();
                                    if (reservation != null) {
                                        reservation.customer = myApp.appDatabase.customerDao().view(reservation._customer_id);
                                        reservation.customer_id = reservation.customer.id;
                                        uploadReservation(reservation);
                                    } else {
                                        LogUtils.e("No reservation found to upload");
                                    }
                                }).start();
                            } else {
                                LogUtils.e("We cannot upload reservation as already on that screen");
                            }
                        }
                        if (canWeUploadNextVoucher) {
                            new Thread(() -> {
                                Voucher voucher = myApp.appDatabase.voucherDao().view(0);
                                if (voucher != null) {
                                    voucher.customer = myApp.appDatabase.customerDao().view(voucher._customer_id);
                                    voucher.customer_id = voucher.customer.id;
                                    uploadVoucher(voucher);
                                }
                            }).start();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        countTimerTask = new TimerTask() {
            @Override
            public void run() {
                try {
                    if (!Validators.isNullOrEmpty(myApp.restaurant_id)) {
                        fetchCounts();
                        /*if (myApp.myPreferences.getOrderSyncMode().equalsIgnoreCase("manual")) {
                            SiteSetting businessEveningEndTime = myApp.findSetting(BUSINESS_EVENING_END_TIME);
                            if (businessEveningEndTime != null && businessEveningEndTime.value != null) {
                                Calendar currentCalender = Calendar.getInstance(Locale.getDefault());
                                Calendar deviceResetTime = Calendar.getInstance(Locale.getDefault());
                                String currentDate = CommonFunctions.formatMiliToDesireFormat(deviceResetTime.getTimeInMillis(), DDMMYYYY);
                                deviceResetTime.setTime(CommonFunctions.convertStringDateToDate(currentDate + " " + businessEveningEndTime.value, DDMMYYYYHHMMA));
                                deviceResetTime.add(Calendar.HOUR, -1);
                                Log.e("TiffintomPartnerService", "currentCompareTime " + deviceResetTime.getTime() + " currentCalender " + currentCalender.getTime() + " comapre " + (currentCalender.getTimeInMillis() >= deviceResetTime.getTimeInMillis()));
                                if (currentCalender.getTimeInMillis() >= deviceResetTime.getTimeInMillis()) {
                                    DeviceInfo deviceInfo = myApp.appDatabase.resetDeviceOnDailyDao().findByCustomerUploadDate(currentDate);
                                    if (deviceInfo == null) {
                                        try {
                                            deviceInfo = new DeviceInfo();
                                            deviceInfo.customerPushData = currentDate;
                                            myApp.appDatabase.resetDeviceOnDailyDao().insert(deviceInfo);
                                            new Thread(() -> {
                                                List<Customer> customerList;
                                                customerList = myApp.appDatabase.customerDao().list();
                                                if(customerList!=null){
                                                    for (int i = 0; i < customerList.size(); i++) {
                                                        startService(new Intent(TiffintomPartnerService.this, SingleCustomerUploadFromBackgroundService.class).putExtra("customer", new Gson().toJson(customerList.get(i))));
                                                    }
                                                }
                                            }).start();
                                        } catch (Exception e) {
                                            throw new RuntimeException(e);
                                        }
                                    }
                                }
                            }
                        }*/
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    boolean canWeUploadNextCallLog = true;
    boolean canWeUploadNextReservation = true;
    boolean canWeUploadNextVoucher = true;

    private void uploadCallLog(CallLogs callLogs) {
        try {
            canWeUploadNextCallLog = false;
            String url = ApiEndPoints.calllogs;
            if (!Validators.isNullOrEmpty(callLogs.id)) {
                url = url + callLogs.id;
            }
            AndroidNetworking.post(url)
                    .addBodyParameter(callLogs)
                    .build()
                    .getAsObject(CallLogs.class, new ParsedRequestListener<CallLogs>() {
                        @Override
                        public void onResponse(CallLogs response) {
                            canWeUploadNextCallLog = true;
                            LogUtils.e("Uploaded call log for number " + callLogs.number);
                            new Thread(() -> {
                                response._id = callLogs._id;
                                myApp.appDatabase.calllogDao().insert(response);
                            }).start();
                        }

                        @Override
                        public void onError(ANError anError) {
                            canWeUploadNextCallLog = true;
                            LogUtils.e("Cannot Upload call log for number " + callLogs.number);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uploadReservation(Reservation reservation) {
        try {
            canWeUploadNextReservation = false;
            String url = ApiEndPoints.reservations;
            if (!Validators.isNullOrEmpty(reservation.id)) {
                url = url + reservation.id;
            }
            LogUtils.e("Service Uploading reservation::" + new Gson().toJson(reservation));
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(reservation)
                    .build()
                    .getAsObject(Reservation.class, new ParsedRequestListener<Reservation>() {
                        @Override
                        public void onResponse(Reservation response) {
                            canWeUploadNextReservation = true;
                            new Thread(() -> {
                                reservation.id = response.id;
                                reservation.uploadable = false;
                                reservation.customer_id = response.customer_id;
                                reservation.customer.id = response.customer.id;
                                myApp.appDatabase.customerDao().insert(reservation.customer);
                                myApp.appDatabase.reservationDao().insert(reservation);
                            }).start();
                        }

                        @Override
                        public void onError(ANError anError) {
                            LogUtils.e("Error in uploading reservation");
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                if (anError.getErrorAsObject(ApiError.class).getCode().equalsIgnoreCase("404")) {
                                    new Thread(() -> {
                                        reservation.id = null;
                                        myApp.appDatabase.reservationDao().update(reservation);
                                        canWeUploadNextReservation = true;
                                    }).start();
                                } else {
                                    canWeUploadNextReservation = true;
                                }
                            } else {
                                canWeUploadNextReservation = true;
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uploadVoucher(Voucher voucher) {
        try {
            canWeUploadNextVoucher = false;
            String url = ApiEndPoints.voucher_add;
            if (!Validators.isNullOrEmpty(voucher.id)) {
                url = url + voucher.id;
            }
            LogUtils.e("Service Uploading voucher::" + new Gson().toJson(voucher));
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(voucher)
                    .build()
                    .getAsObject(Voucher.class, new ParsedRequestListener<Voucher>() {
                        @Override
                        public void onResponse(Voucher response) {
                            canWeUploadNextReservation = true;
                            new Thread(() -> {
                                voucher.id = response.id;
                                //                            voucher.uploadable = false;
                                voucher.customer_id = response.customer_id;
                                voucher.customer.id = response.customer.id;
                                myApp.appDatabase.customerDao().insert(voucher.customer);
                                myApp.appDatabase.voucherDao().insert(voucher);
                            }).start();
                        }

                        @Override
                        public void onError(ANError anError) {
                            LogUtils.e("Error in uploading voucher");
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                if (anError.getErrorAsObject(ApiError.class).getCode().equalsIgnoreCase("404")) {
                                    new Thread(() -> {
                                        voucher.id = null;
                                        myApp.appDatabase.voucherDao().insert(voucher);
                                        canWeUploadNextVoucher = true;
                                    }).start();
                                } else {
                                    canWeUploadNextVoucher = true;
                                }
                            } else {
                                canWeUploadNextVoucher = true;
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean lastBroadcastSent = false;

    public void fetchCounts() {
        try {
            if (Validators.isNullOrEmpty(myApp.restaurant_id)) return;
            AndroidNetworking.get(ApiEndPoints.restaurant_counts)
                    .addPathParameter("id", myApp.restaurant_id)
                    .build()
                    .getAsObject(Counts.class, new ParsedRequestListener<Counts>() {
                        @Override
                        public void onResponse(Counts response) {
                            if (response == null) return;
                            Intent pushNotification = new Intent(Constants.NOTIFICATION);
                            pushNotification.putExtra("refresh", true);
                            pushNotification.putExtra("counts", new Gson().toJson(response));

                            if (response.pending_orders > 0) {
                                MyApp.getInstance().startOrderSound();
                                pushNotification.putExtra("orders", true);
                                lastBroadcastSent = false;
                            } else {
                                MyApp.getInstance().stopOrderSound();
                                if (!lastBroadcastSent)
                                    pushNotification.putExtra("orders", true);
                                lastBroadcastSent = true;
                            }
                            if (response.pending_bookings > 0) {
                                MyApp.getInstance().startReservationsSound();
                                pushNotification.putExtra("reservations", true);
                            } else {
                                MyApp.getInstance().stopReservationsSound();
                            }
                            if (response.new_reviews > 0) {
                                pushNotification.putExtra("reviews", true);
                            }
                            if (response.delay_orders > 0) {
                                lastBroadcastSent = false;
                                pushNotification.putExtra("orders", true);
                            } else {
                                if (!lastBroadcastSent)
                                    pushNotification.putExtra("orders", true);
                                lastBroadcastSent = true;
                            }
                            if (response.unread_chat > 0) {
                                pushNotification.putExtra("chat", true);
                            }
                            LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * not needed
     */
    public void stoptimertask() {
        //stop the timer, if it's not already null
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

}
