package com.ubsidi.epos_2021.services;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;

import androidx.annotation.Nullable;

import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created by Amrish on 01-06-2021.
 */
public class ImageDownloadService extends IntentService {

    int _order_id = 0;

    private Order order;
    private MyApp myApp;
    private int position = -1;
    private String product_id, image_url;
    private AppDatabase appDatabase;
    private Order onlineOrderObject;

    public ImageDownloadService(Context context) {
        super("Upload Service");

        LogUtils.e("Intent Service");

    }

    public ImageDownloadService() {
        super("Upload Service");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            myApp = MyApp.getInstance();
            appDatabase = myApp.appDatabase;

            if (intent != null) {
                _order_id = intent.getIntExtra("_order_id", 0);
                position = intent.getIntExtra("position", -1);
                product_id = intent.getStringExtra("product_id");
                image_url = intent.getStringExtra("image_url");
                if (!Validators.isNullOrEmpty(image_url))
                    downloadImage();
                else publishResult();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void downloadImage(){
        try {
            new DownloadsImage().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, image_url, product_id);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishResult() {
        try {
            Intent intent = new Intent("image_download_download");
            intent.putExtra("image_url", image_url);
            intent.putExtra("position", position);
            intent.putExtra("product_id", product_id);
            sendBroadcast(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DownloadsImage extends AsyncTask<String, String, Void> {

        @Override
        protected Void doInBackground(String... strings) {
            try {
                URL url = null;
                try {
                    url = new URL(strings[0]);
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                if (url != null) {

                    File mydir = new File(getApplicationContext().getExternalFilesDir("epos2021").getAbsolutePath());
                    if (!mydir.exists()) {
                        boolean b = mydir.mkdirs();
                    }
                    File imageFile = new File(mydir.getAbsolutePath(), strings[1] + ".png"); // Imagename.png
                    if (imageFile.exists()) {
                        imageFile.delete();
                    }
                    imageFile = new File(mydir.getAbsolutePath(), strings[1] + ".png"); // Imagename.png
                    try {
                        FileOutputStream out = new FileOutputStream(imageFile);
                        Bitmap bm = BitmapFactory.decodeStream(url.openConnection().getInputStream());
                        bm.compress(Bitmap.CompressFormat.PNG, 100, out); // Compress Image
                        out.flush();
                        out.close();
                        // Tell the media scanner about the new file so that it is
                        // immediately available to the user.

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            publishResult();
        }
    }

}
