package com.ubsidi.epos_2021.services;

import android.app.IntentService;
import android.content.Intent;

import androidx.annotation.Nullable;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.network.ApiEndPoints;

/**
 * Created by Amrish on 01-06-2021.
 */
public class SingleCustomerUploadFromBackgroundService extends IntentService {

    public SingleCustomerUploadFromBackgroundService() {
        super("customer_upload_service");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            if (intent != null) {
                Customer customer = new Gson().fromJson(intent.getStringExtra("customer"), Customer.class);
                if(customer!=null){
                    uploadCustomer(customer);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void uploadCustomer(Customer customer) {
        try {
            String url = ApiEndPoints.customers;
            if (!Validators.isNullOrEmpty(customer.id)) {
                url = url + customer.id;
            }
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(customer)
                    .build()
                    .getAsObject(Customer.class, new ParsedRequestListener<Customer>() {
                        @Override
                        public void onResponse(Customer response) {

                        }

                        @Override
                        public void onError(ANError anError) {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
