package com.ubsidi.epos_2021.services;

import android.app.IntentService;
import android.content.Intent;
import android.os.AsyncTask;

import androidx.annotation.Nullable;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.util.concurrent.Callable;

/**
 * Created by Amrish on 01-06-2021.
 */
public class SingleCustomerUploadService extends IntentService {

    int _customer_id = 0;

    private MyApp myApp;
    private int position = -1;
    private AppDatabase appDatabase;
    private Order onlineOrderObject;
    private boolean forceFully;
    private Customer customer;


    public SingleCustomerUploadService() {
        super("customer_upload_service");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            myApp = MyApp.getInstance();
            appDatabase = myApp.appDatabase;

            if (intent != null) {
                _customer_id = intent.getIntExtra("_customer_id", 0);
                position = intent.getIntExtra("position", -1);
                forceFully = intent.getBooleanExtra("forcefully", false);
            }
            LogUtils.e("Uploading start for customer id: " + _customer_id + " position: " + position);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //FetchCustomerAsync();

        new FetchCustomerAsync(() -> {
            if (myApp.isConnected(this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                uploadCustomer(() -> {
                    new UpdateCustomerAsync(() -> {
                        publishResult(true);
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    return null;
                });
            }
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private void FetchCustomerAsync(){
        new FetchCustomerAsync(() -> {
            if (myApp.isConnected(this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                uploadCustomer(() -> {
                    new UpdateCustomerAsync(() -> {
                        publishResult(true);
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    return null;
                });
            }
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private void publishResult(boolean b) {
        Intent intent = new Intent("single_customer_upload");
        intent.putExtra("_customer_id", _customer_id);
        intent.putExtra("result", b);
        intent.putExtra("position", position);
        myApp.notifyCart(this, intent);
    }

    private void publishResult(boolean b, String message) {
        Intent intent = new Intent("single_customer_upload");
        intent.putExtra("_customer_id", _customer_id);
        intent.putExtra("result", b);
        intent.putExtra("message", message);
        intent.putExtra("position", position);
        myApp.notifyCart(this, intent);
    }

    private class FetchCustomerAsync extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchCustomerAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            customer = appDatabase.customerDao().view(_customer_id);
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true);
            }
        }
    }

    private void uploadCustomer(Callable<Void> nextMethod) {
        try {
            String url = ApiEndPoints.customers;
            if (!Validators.isNullOrEmpty(customer.id)) {
                url = url + customer.id;
            }
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(customer)
                    .build()
                    .getAsObject(Customer.class, new ParsedRequestListener<Customer>() {
                        @Override
                        public void onResponse(Customer response) {
                            response._id = customer._id;
                            customer = response;
                            if (nextMethod != null) {
                                try {
                                    nextMethod.call();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            publishResult(false, "\n[Customer ID=> " + customer._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UpdateCustomerAsync extends AsyncTask<String, String, String> {
        Callable<Void> nextMethod;

        public UpdateCustomerAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                appDatabase.customerDao().update(customer);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true);
            }
        }
    }

}
