package com.ubsidi.epos_2021.services;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;

import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.OrderItemWithAddonsIngredients;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.interfaces.OnCreateOrderSuccessListeners;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

/**
 * Created by Amrish on 01-06-2021.
 */


public class SingleOrderUploaderService extends IntentService {
    private MyApp myApp;
    private int position = -1;
    private AppDatabase appDatabase;
    private boolean forceFully;
    Voucher voucher;
    String oldStatus = null;
    String TAG = "::SERVICE::";
    private boolean isFromError = false;

    public SingleOrderUploaderService(Context context) {
        super("Upload Service");
    }

    public SingleOrderUploaderService() {
        super("Upload Service");
    }

    boolean orderCompleteAuto = false;

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            myApp = MyApp.getInstance();
            appDatabase = myApp.appDatabase;
            myApp.shallWeRefreshOrders = false;
            if (intent != null) {
                //_order_id = intent.getIntExtra("_order_id", 0);
                position = intent.getIntExtra("position", -1);
                forceFully = intent.getBooleanExtra("forcefully", false);
                isFromError = intent.getBooleanExtra("is_form_error", false);
            }
            SiteSetting orderCompleteMode = myApp.findSetting("order_complete_mode");
            if (orderCompleteMode != null && !Validators.isNullOrEmpty(orderCompleteMode.value) && (orderCompleteMode.value.toLowerCase().equalsIgnoreCase("auto") || orderCompleteMode.value.toLowerCase().equalsIgnoreCase("1") || orderCompleteMode.value.toLowerCase().equalsIgnoreCase("yes"))) {
                orderCompleteAuto = true;
            }

            //FetchOrderOfflineAsyncTask();
            new FetchOrderOfflineAsyncTask(intent, () -> null).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void publishResult(boolean b,String orderId) {
        //MyApp.getInstance().shallWeRefreshOrders = true;
        MyApp.getInstance().shallWeRefreshOrders = true;
        Intent intent = new Intent(Constants.EPOS_ORDER_UPDATE);
        //intent.putExtra("_order_id", _order_id);
        intent.putExtra("order_id", orderId);
        intent.putExtra("is_from_upload", true);
        intent.putExtra("result", b);
        intent.putExtra("position", position);
        myApp.notifyCart(this, intent);
    }

    private void publishResult(String message) {
       // MyApp.getInstance().shallWeRefreshOrders = true;
        MyApp.getInstance().shallWeRefreshOrders = true;
        Intent intent = new Intent(Constants.EPOS_ORDER_UPDATE);
        //intent.putExtra("_order_id", _order_id);
        intent.putExtra("result", false);
        intent.putExtra("message", message);
        intent.putExtra("position", position);
        myApp.notifyCart(this, intent);
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;
        Intent intent;

        public FetchOrderOfflineAsyncTask(Intent intent, Callable<Void> nextMethod) {
            this.intent = intent;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                int _order_id = 0;
                _order_id = intent.getIntExtra("_order_id", 0);
                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {
                    Order order;
                    Table table = null;
                    order = orderWithItems.order;
                    float total_paid = appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id);
                    if (order.total_paid != order.total) {
                        //order.total_paid = total_paid;
                        order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    } else {
                        LogUtils.e(TAG, "Order will not updated at");
                    }
                    order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                    order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                    order.order_items = new ArrayList<>();
                    for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                        OrderItem orderItem = item.orderItem;
                        orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                        orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                        order.order_items.add(orderItem);

                    }
                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    if (Validators.isNullOrEmpty(order.customer_id)) {
                        if (order.customer != null) {
                            order.customer_id = order.customer.id;
                        }
                    }
                    if (order.customer == null) {
                        order.customer = appDatabase.customerDao().view(order.customer_id);
                    }
                    String currentStatusId = order.order_status_id;

                    if (order.order_type_id.equalsIgnoreCase("1")) {
                        table = appDatabase.tableDao().view(order.table_id);
                        oldStatus = table.status;
                    }
                    TableStatus vacantStatus = myApp.findStatus("Vacant");
                    TableStatus orderTakenStatus = myApp.findStatus("Order Taken");
                    TableStatus servedStatus = myApp.findStatus("Served");
                    TableStatus takingOrderStatus = myApp.findStatus("Taking Order");
                    TableStatus servedPaidStatus = myApp.findStatus("Served and paid");

                    if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                        if (order.total > 0) {
                            LogUtils.e(TAG, "SERVICE_TABLE AUto Complete? " + orderCompleteAuto);
                            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                if (orderCompleteAuto) {
                                    order.order_status_id = "5";
                                    order.order_status = "Order Completed";
                                    LogUtils.e(TAG, "SERVICE_TABLE Order status " + order.order_status);
                                } else {
                                    if (!order.order_status_id.equalsIgnoreCase("6")) {
                                        order.order_status_id = "4";
                                        order.order_status = "Order Paid";
                                    }
                                }
                            } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 0) {
                                order.order_status_id = "7";
                                order.order_status = "Part Payment Received";
                            } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == -1) {
                                if (Validators.isNullOrEmpty(order.order_action_id)) {
                                    order.order_status_id = "1";
                                    order.order_status = "Taking Order";
                                } else {
                                    if (!order.order_status_id.equalsIgnoreCase("3")) {
                                        order.order_status_id = "2";
                                        order.order_status = "Order Taken";
                                    }
                                }
                            }
                        } else {
                            order.order_status_id = "2";
                            order.order_status = "Order Taken";

                        }
                        if (!currentStatusId.equalsIgnoreCase(order.order_status_id)) {
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                        }
                        LogUtils.e(TAG, "Updating SERVICE_TABLE order status " + order.order_status);
                        appDatabase.orderDao().update(order);
                        LogUtils.e(TAG, "Updating after update : SERVICE_TABLE order status " + order.order_status);
                        if (table != null) {
                            if (order.total > 0) {
                                if (order.total_paid > 0) {
                                    if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                                        if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                            table.status = servedPaidStatus.status;
                                            table.table_status_id = servedPaidStatus.id;
                                        } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 0) {
                                            table.table_status_id = orderTakenStatus.id;
                                            table.status = orderTakenStatus.status;
                                        }
                                    } else {
                                        table.status = vacantStatus.status;
                                        table.table_status_id = vacantStatus.id;
                                    }
                                } else {
                                    if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                                        if (order.order_status_id.equalsIgnoreCase("3")) {
                                            table.status = servedStatus.status;
                                            table.table_status_id = servedStatus.id;
                                        } else {
                                            if (Validators.isNullOrEmpty(order.order_action_id)) {
                                                table.table_status_id = takingOrderStatus.id;
                                                table.status = takingOrderStatus.status;
                                            } else {
                                                table.table_status_id = orderTakenStatus.id;
                                                table.status = orderTakenStatus.status;
                                            }
                                        }

                                    } else {
                                        table.status = vacantStatus.status;
                                        table.table_status_id = vacantStatus.id;
                                    }
                                    if (myApp.isPaymentLinkSent) {
                                        table.table_status_id = orderTakenStatus.id;
                                        table.status = orderTakenStatus.status;
                                    }
                                }
                            } else {
                                if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                                    table.status = takingOrderStatus.status;
                                    table.table_status_id = takingOrderStatus.id;
                                } else {
                                    table.status = vacantStatus.status;
                                    table.table_status_id = vacantStatus.id;
                                    table.locked = false;
                                }
                                if (myApp.isPaymentLinkSent) {
                                    table.table_status_id = orderTakenStatus.id;
                                    table.status = orderTakenStatus.status;
                                }
                            }
                            LogUtils.e(TAG, "Updating SERVICE_TABLE status:::" + table.status);
                            table.locked = false;
                            appDatabase.tableDao().insert(table);
                            //                        table= appDatabase.tableDao().view(table.id);
                            LogUtils.e(TAG, "Updating after update ::: SERVICE_TABLE status:::" + table.status);
                            OrderPayment op = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                        }
                    } else {
                        // Do not write here anything otherwise completed orders may be changed while pushing orders
                    }
                    if (myApp.isConnected(SingleOrderUploaderService.this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                        int sendAtLevel = 0;
                        if ((order.order_items != null && order.order_items.size() > 0) && (order.order_splits != null && order.order_splits.size() == 0 && order.order_payments != null && order.order_payments.size() == 0)) {
                            sendAtLevel = 0;
                        } else if (order.order_items != null && order.order_items.size() > 0 && (order.order_splits.size() >= 0 || order.order_payments.size() >= 0)) {
                            //sendAtLevel = 1;
                            sendAtLevel = 0;
                        } else if (order.order_items != null && order.order_items.size() == 0) {
                            sendAtLevel = 0;
                        }
                        Log.e("order_status_id", "order_status_id " + order.order_status_id + " order " + order.is_table_swap);
                        Log.e("isNullOrEmptyis", "isNullOrEmpty " + (!Validators.isNullOrEmpty(order.id) && order.order_items != null && order.order_items.isEmpty() && !Validators.isNullOrEmpty(order.order_status_id) && Integer.parseInt(order.order_status_id) != 10 && !order.is_table_swap));
                        if (!Validators.isNullOrEmpty(order.id) && order.order_items != null && order.order_items.isEmpty() && !Validators.isNullOrEmpty(order.order_status_id) && Integer.parseInt(order.order_status_id) != 10
                                && !order.is_table_swap) {
                            order.is_uploaded_on_server = true;
                            appDatabase.orderDao().update(order);
                            if (!myApp.isConnected(SingleOrderUploaderService.this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                                sendBrodCast("Internet Connection not available", true);
                            }
                            uploadTableStatusOnline(table, order);

                        } else {
                            Table finalTable = table;
                            int final_order_id = _order_id;
                            createUpdateOrderOnline(_order_id, order, onlineOrderObject -> new DeleteOldAndSaveNewAsync(final_order_id, onlineOrderObject, order, () -> {
                                uploadTableStatusOnline(finalTable, order);
                                return null;
                            }).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR), sendAtLevel == 0);
                        }
                    } else {
                        if (!myApp.isConnected(SingleOrderUploaderService.this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                            sendBrodCast("Internet Connection not available", true);
                        }
                        uploadTableStatusOnline(table,order);

                    }
                } else {
                    nextMethod = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true,"");
            }
        }


    }

    private void uploadTableStatusOnline(Table table, Order order) {
        if (table == null || (order.table_id == null || !order.order_type_id.equalsIgnoreCase("1"))) {
            LogUtils.e(TAG, "SERVICE_TABLE not dinein order");
            publishResult(true,order.id);
            return;
        }
        new Thread(() -> {
            table.locked = false;
            appDatabase.tableDao().insert(table);
            if (false && !Validators.isNullOrEmpty(oldStatus) && oldStatus.equalsIgnoreCase(table.status) && !table.locked) {
                LogUtils.e(TAG, "SERVICE_TABLE same status so we are returning", oldStatus);
                publishResult(true,order.id);
                return;
            }
            LogUtils.e(TAG, "Uploading SERVICE_TABLE Status online::" + new Gson().toJson(table));

            LogUtils.e(TAG, "SERVICE_TABLE STATUS:" + table.id + " & status_id: " + table.table_status_id + " as " + table.status + " Loked? " + table.locked);
            if ((forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(SingleOrderUploaderService.this))) {
                AndroidNetworking.post(ApiEndPoints.tables + table.id)
                        .addApplicationJsonBody(table)
                        .build()
                        .getAsObject(Table.class, new ParsedRequestListener() {
                            @Override
                            public void onResponse(Object response) {
                                LogUtils.e(TAG, "SERVICE SERVICE_TABLE STATUS CHANGED RESPONSE:" + new Gson().toJson(response));
                                publishResult(true,order.id);
                            }

                            @Override
                            public void onError(ANError anError) {
                                publishResult(true,"");
                            }
                        });
            }
        }).start();

    }

    private void createUpdateOrderOnline(int _order_id, Order order, OnCreateOrderSuccessListeners onCreateOrderSuccessListeners, boolean shouldSendPush) {
        new Thread(() -> {
            // un comment above code if need to test failed scenario in auto mode
            //String url = !isFromError ? ApiEndPoints.orders : ApiEndPoints.orders1;
            String url = ApiEndPoints.orders1;
            if (!Validators.isNullOrEmpty(order.id)) {
                url = url + order.id + "/";
                // url = url + order.id+"/";
            }
            LogUtils.e(TAG, "shouldSendPush?" + shouldSendPush);
            String isPrintTheOrder = myApp.myPreferences.getRemoteDeviceEnableStatus() && myApp.myPreferences.getIsPrintBill() ? "1" : "";
            myApp.myPreferences.saveIsPrintBill(false);
            order.socket_type = "order";
            order.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
            Log.e("AndroidNetworking", "ordercreateequest " + order);
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(order)
                    .addQueryParameter("send_push", shouldSendPush ? "1" : "0")
                    .addQueryParameter("print", isPrintTheOrder)
                    .build()
                    .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                        @Override
                        public void onResponse(Order response) {
                            new Thread(() -> {
                                Log.e("Order created updated", " " + response.id);
                                order.id = response.id;
                                response.customer._id = order._customer_id;
                                order.customer = response.customer;
                                order.customer_id = response.customer.id;
                                order.customer_name = response.customer.name;
                                Order onlineOrderObject;
                                onlineOrderObject = response;
                                // changes is uploaded on server true
                                order.is_uploaded_on_server = true;
                                //onlineOrderObject.unique_id = order.unique_id;
                                onlineOrderObject.is_uploaded_on_server = true;
                                onlineOrderObject.customer_name = response.customer.name;
                                // send success msg brodcast
                                new UpdateSplitAndPaymentOrderIdsWithOnlineOrderIds(_order_id, order, response, () -> {
                                    //nextMethod.call();
                                    onCreateOrderSuccessListeners.onDialogDismiss(onlineOrderObject);
                                    return null;
                                }).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
                                if (order.order_items != null && response.order_items != null && response.order_items.size() != order.order_items.size()) {
                                    String text = "File created from SingleOrderUploaderService \n\n" + "Local response is \n" + order + "\n\n\nResponse from api \n" + response;
                                    CommonFunctions.writeToDownloadFile(text, "item_mismatch_order_id_" + order.id + ".txt");
                                }
                            }).start();
                        }

                        @Override
                        public void onError(ANError anError) {
                            //  LogUtils.e(TAG, "Order error createUpdateOrderOnline()" + Log.getStackTraceString(anError.fillInStackTrace()));
                            anError.printStackTrace();
                            sendBrodCast("\n[ID=> " + order._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage(), true);
                            if (anError.getErrorCode() == 400) {
                                // send success msg brodcast
                                publishResult( "\n[ID=> " + order._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage());
                            }

                        }
                    });
        }).start();
    }

    private void createBulkSplits(Order order, Callable<Void> nextMethod) {
        new Thread(() -> {
            AndroidNetworking.post(ApiEndPoints.order_splits + "split-bulk")
                    .addBodyParameter("splits", new Gson().toJson(order.order_splits))
                    .build()
                    .getAsObjectList(OrderSplit.class, new ParsedRequestListener<List<OrderSplit>>() {
                        @Override
                        public void onResponse(List<OrderSplit> response) {
                            /*new LinkSplitItemWithNameAndLocalId(order,() -> {
                                new FetchOrderOfflineAsyncTask(() -> {
                                    if (nextMethod != null) {
                                        nextMethod.call();
                                    }
                                    return null;
                                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                return null;
                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);*/

                        }

                        @Override
                        public void onError(ANError anError) {
                            if (anError.getErrorCode() == 400) {
                                publishResult( "\n[ID=> " + order._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        }).start();
    }

    private void sendBrodCast(String msg, Boolean isFromError) {
        // display order taken success message start
        Intent intent = new Intent(Constants.BOOK_TABLE_SUCCESS);
        intent.putExtra(Constants.SUCCESS_MESSAGE, msg);
        intent.putExtra(Constants.IS_FROM_ERROR, isFromError);
        //intent.putExtra(Constants._ORDER_ID, _order_id);
        LocalBroadcastManager.getInstance(SingleOrderUploaderService.this).sendBroadcast(intent);
        // display order taken success message end
    }

    private void createBulkPayment(Order order, Callable<Void> nextMethod) {
        new Thread(() -> {
            AndroidNetworking.post(ApiEndPoints.order_payments + "payment-bulk")
                    .addBodyParameter("payments", new Gson().toJson(order.order_payments))
                    .build()
                    .getAsObjectList(OrderPayment.class, new ParsedRequestListener<List<OrderPayment>>() {
                        @Override
                        public void onResponse(List<OrderPayment> response) {
                           /* new FetchOrderOfflineAsyncTask(() -> {
                                if (nextMethod != null) {
                                    nextMethod.call();
                                }
                                return null;
                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);*/

                        }

                        @Override
                        public void onError(ANError anError) {
                            if (anError.getErrorCode() == 400) {
                                publishResult("\n[ID=> " + order._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        }).start();
    }

    private class LinkSplitItemWithNameAndLocalId extends AsyncTask<List<OrderSplit>, String, String> {
        Callable<Void> nextMethod;
        Order order;
        int _order_id;

        public LinkSplitItemWithNameAndLocalId(int _order_id, Order order, Callable<Void> nextMethod) {
            this._order_id = _order_id;
            this.order = order;
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(List<OrderSplit>... arrayLists) {
            List<OrderSplit> splits = arrayLists[0];
            for (OrderSplit split : splits) {
                for (OrderSplit dbSplit : order.order_splits) {
                    if (dbSplit.group_name.equalsIgnoreCase(split.group_name)) {
                        split._id = dbSplit._id;
                        split._order_id = _order_id;
                        break;
                    }
                }
            }
            Log.e("LinkSplitItemWithNam", " " + splits.size());
            if (splits.size() > 0) {
                for (int i = 0; i < splits.size(); i++) {
                    Log.e("LinkSplitItemWithNam", "ID " + splits.get(i)._id);
                }
            }
            appDatabase.orderSplitDao().insertMultiple(splits);
            for (OrderSplit s : splits) {
                appDatabase.orderItemDao().updateSplitIds(s._id, s.id);
                appDatabase.orderPaymentDao().updateSplitIds(_order_id, s._id, s.id);
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class DeleteOldAndSaveNewAsync extends AsyncTask<String, String, String> {
        Callable<Void> nextMethod;
        Order order;
        int _order_id;
        private Order onlineOrderObject;

        public DeleteOldAndSaveNewAsync(int _order_id, Order onlineOrderObject, Order order, Callable<Void> nextMethod) {
            this._order_id = _order_id;
            this.onlineOrderObject = onlineOrderObject;
            this.order = order;
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
//            appDatabase.orderDao().delete(order);
            onlineOrderObject._id = order._id;
            // get object from the database
            Order dbOrder = appDatabase.orderDao().view(order._id);
            if (dbOrder == null) {
                dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
            }
            Customer dbCustomer = appDatabase.customerDao().view(onlineOrderObject.customer_id);
            int _customer_id;
            if (dbCustomer == null) {
                _customer_id = (int) appDatabase.customerDao().insert(onlineOrderObject.customer);
            } else {
                appDatabase.customerDao().update(dbCustomer);
                _customer_id = dbCustomer._id;
            }
            onlineOrderObject._customer_id = _customer_id;
            // check record from the database if null insert else update
            if (dbOrder == null) {
                _order_id = (int) appDatabase.orderDao().insert(onlineOrderObject);
                onlineOrderObject._id = _order_id;
            } else {
                _order_id = dbOrder._id;
                // if local order status is not paid then update the order
                if (!dbOrder.order_status_id.equalsIgnoreCase("5") || onlineOrderObject.order_status_id.equalsIgnoreCase("10")) {
                    appDatabase.orderDao().update(onlineOrderObject);
                }
            }
            Log.e("_order_id", "_order_id " + _order_id + "Offline order id " + order._id + "dbOrder " + dbOrder);

            appDatabase.orderPaymentDao().deleteAll(_order_id);
            appDatabase.orderSplitDao().deleteAll(_order_id);
            appDatabase.orderItemAddonDao().deleteAll(_order_id);
            appDatabase.orderItemIngredientDao().deleteAll(_order_id);
            appDatabase.orderItemIngredientDao().deleteAll(_order_id);

            if (onlineOrderObject.order_splits != null) {
                for (OrderSplit split : onlineOrderObject.order_splits) {
                    split._order_id = _order_id;
                }
                Log.e("DeleteOldAndSaveNew", " " + onlineOrderObject.order_splits.size());
                if (onlineOrderObject.order_splits.size() > 0) {
                    for (int i = 0; i < onlineOrderObject.order_splits.size(); i++) {
                        Log.e("DeleteOldAndSaveNew", "ID " + onlineOrderObject.order_splits.get(i)._id);
                    }
                }
                appDatabase.orderSplitDao().insertMultiple(onlineOrderObject.order_splits);
            }

            if (onlineOrderObject.order_payments != null) {
                for (OrderPayment payment : onlineOrderObject.order_payments) {
                    payment._order_id = _order_id;
                    if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                        OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                        if (dbOrderSplit != null)
                            payment._order_split_id = dbOrderSplit._id;
                    }
                }
                appDatabase.orderPaymentDao().insertMultiple(onlineOrderObject.order_payments);
            }

            appDatabase.orderItemDao().deleteAll(_order_id);
            for (OrderItem orderItem : onlineOrderObject.order_items) {
                orderItem._order_id = _order_id;

                if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                    OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                    if (orderSplit != null) orderItem._order_split_id = orderSplit._id;
                }
                /*OrderItem dbOrderItem = appDatabase.orderItemDao().viewByOrderId(_order_id);
                int _order_item_id = 0;
                if (dbOrderItem == null) {
                    _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                } else {
                    Log.e("orderItemorderItem", "orderItem " + orderItem);
                    _order_item_id = dbOrderItem._id;
                    appDatabase.orderItemDao().update(orderItem);
                }*/
                Log.e("orderItemorderItem", "orderItem " + orderItem);
                int _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                if (orderItem.order_item_addons != null) {
                    for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                        itemAddon._order_item_id = _order_item_id;
                    }
                    appDatabase.orderItemAddonDao().insertAll(orderItem.order_item_addons);
                }

                if (orderItem.order_item_ingredients != null) {
                    appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                    for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                        itemIngredient._order_item_id = _order_item_id;
                    }
                    appDatabase.orderItemIngredientDao().insertAll(orderItem.order_item_ingredients);
                }

            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            sendBrodCast("Order Taken Successfully", false);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class UpdateSplitAndPaymentOrderIdsWithOnlineOrderIds extends AsyncTask<String, String, String> {
        Order response, order;
        Callable<Void> nextMethod;
        int _order_id;

        public UpdateSplitAndPaymentOrderIdsWithOnlineOrderIds(int _order_id, Order order, Order response, Callable<Void> nextMethod) {
            this._order_id = _order_id;
            this.order = order;
            this.response = response;
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
            appDatabase.customerDao().insert(order.customer);
            appDatabase.orderDao().update(order);
            appDatabase.orderPaymentDao().updateOrderId(_order_id, response.id);
            appDatabase.orderSplitDao().updateOrderId(_order_id, response.id);
            for (OrderPayment orderPayment : order.order_payments) {
                orderPayment.order_id = response.id;
            }
            for (OrderSplit orderSplit : order.order_splits) {
                orderSplit.order_id = response.id;
            }
//            order.order_payments = (ArrayList<OrderPayment>) appDatabase.orderPaymentDao().list(response.id);
//            order.order_splits = (ArrayList<OrderSplit>) appDatabase.orderSplitDao().list(response.id);
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
