package com.ubsidi.epos_2021.services;

import android.app.IntentService;
import android.content.Intent;
import android.os.AsyncTask;

import androidx.annotation.Nullable;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.util.concurrent.Callable;

/**
 * Created by Amrish on 01-06-2021.
 */
public class SingleReservationUploadService extends IntentService {

    int _reservation_id = 0;

    private MyApp myApp;
    private int position = -1;
    private AppDatabase appDatabase;
    private Order onlineOrderObject;
    private boolean forceFully;
    private Reservation reservation;


    public SingleReservationUploadService() {
        super("reservation_upload_service");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            myApp = MyApp.getInstance();
            appDatabase = myApp.appDatabase;

            if (intent != null) {
                _reservation_id = intent.getIntExtra("_reservation_id", 0);
                position = intent.getIntExtra("position", -1);
                forceFully = intent.getBooleanExtra("forcefully", false);
            }
            LogUtils.e("Uploading start for reservation id: " + _reservation_id + " position: " + position);
            FetchReservationAsync();
        } catch (Exception e) {
            e.printStackTrace();
        }
        /*new FetchReservationAsync(() -> {
            if (myApp.isConnected(this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                uploadReservation(() -> {
                    new UpdateReservationAsync(() -> {
                        publishResult(true);
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    return null;
                });
            }
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);*/
    }

    private void FetchReservationAsync() {
        try {
            new FetchReservationAsync(() -> {
                if (myApp.isConnected(this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                    uploadReservation(() -> {
                        new UpdateReservationAsync(() -> {
                            publishResult(true);
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        return null;
                    });
                }
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishResult(boolean b) {
        try {
            Intent intent = new Intent(Constants.RESERVATION_UPLOAD_UPDATE);
            intent.putExtra("_reservation_id", _reservation_id);
            intent.putExtra("result", b);
            intent.putExtra("position", position);
            myApp.notifyCart(this, intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishResult(boolean b, String message) {
        try {
            Intent intent = new Intent(Constants.RESERVATION_UPLOAD_UPDATE);
            intent.putExtra("_reservation_id", _reservation_id);
            intent.putExtra("result", b);
            intent.putExtra("message", message);
            intent.putExtra("position", position);
            myApp.notifyCart(this, intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uploadReservation(Callable<Void> nextMethod) {
        try {
            String url = ApiEndPoints.customers;
            if (!Validators.isNullOrEmpty(reservation.id)) {
                url = url + reservation.id;
            }
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(reservation)
                    .build()
                    .getAsObject(Reservation.class, new ParsedRequestListener<Reservation>() {
                        @Override
                        public void onResponse(Reservation response) {
                            try {
                                response._id = reservation._id;
                                response._customer_id = reservation._customer_id;
                                response.customer._id = reservation.customer._id;
                                response.uploadable = false;
                                reservation = response;

                                if (nextMethod != null) {
                                    try {
                                        nextMethod.call();
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            publishResult(false, "\n[Reservation ID=> " + reservation._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchReservationAsync extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchReservationAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            reservation = appDatabase.reservationDao().view(_reservation_id);
            if (reservation != null)
                reservation.customer = appDatabase.customerDao().view(reservation._customer_id);
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true);
            }
        }
    }

    private class UpdateReservationAsync extends AsyncTask<String, String, String> {
        Callable<Void> nextMethod;

        public UpdateReservationAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                myApp.appDatabase.customerDao().insert(reservation.customer);
                myApp.appDatabase.reservationDao().insert(reservation);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true);
            }
        }
    }

}
