package com.ubsidi.epos_2021.services;

import android.app.IntentService;
import android.content.Intent;
import android.os.AsyncTask;

import androidx.annotation.Nullable;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.util.concurrent.Callable;

/**
 * Created by Amrish on 01-06-2021.
 */
public class SingleVoucherUploadService extends IntentService {

    int _voucher_id = 0;

    private MyApp myApp;
    private int position = -1;
    private AppDatabase appDatabase;
    private Order onlineOrderObject;
    private boolean forceFully;
    private Voucher voucher;


    public SingleVoucherUploadService() {
        super("voucher_upload_service");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            myApp = MyApp.getInstance();
            appDatabase = myApp.appDatabase;

            if (intent != null) {
                _voucher_id = intent.getIntExtra("_voucher_id", 0);
                position = intent.getIntExtra("position", -1);
                forceFully = intent.getBooleanExtra("forcefully", false);
            }
            LogUtils.e("Uploading start for voucher id: " + _voucher_id + " position: " + position);

            //FetchVoucherAsync();
            new FetchVoucherAsync(() -> {
                if (myApp.isConnected(this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                    uploadVoucher(() -> {
                        new UpdateVoucherAsync(() -> {
                            publishResult(true);
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        return null;
                    });
                }
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void FetchVoucherAsync(){
        new FetchVoucherAsync(() -> {
            if (myApp.isConnected(this) && (forceFully || "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                uploadVoucher(() -> {
                    new UpdateVoucherAsync(() -> {
                        publishResult(true);
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    return null;
                });
            }
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }
    private void publishResult(boolean b) {
        try {
            Intent intent = new Intent(Constants.VOUCHER_UPLOAD_UPDATE);
            intent.putExtra("_voucher_id", _voucher_id);
            intent.putExtra("result", b);
            intent.putExtra("position", position);
            myApp.notifyCart(this, intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishResult(boolean b, String message) {
        try {
            Intent intent = new Intent(Constants.VOUCHER_UPLOAD_UPDATE);
            intent.putExtra("_voucher_id", _voucher_id);
            intent.putExtra("result", b);
            intent.putExtra("message", message);
            intent.putExtra("position", position);
            myApp.notifyCart(this, intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchVoucherAsync extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchVoucherAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                voucher = appDatabase.voucherDao().view(_voucher_id);
                voucher.customer = appDatabase.customerDao().view(voucher._customer_id);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true);
            }
        }
    }

    private void uploadVoucher(Callable<Void> nextMethod) {
        try {
            String url = ApiEndPoints.voucher_add;
            if (!Validators.isNullOrEmpty(voucher.id)) {
                url = url + voucher.id;
            }
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(voucher)
                    .build()
                    .getAsObject(Voucher.class, new ParsedRequestListener<Voucher>() {
                        @Override
                        public void onResponse(Voucher response) {
                            response._id = voucher._id;
                            response._customer_id = voucher._customer_id;
                            response.customer._id = voucher.customer._id;
                            response.uploadable = false;
                            voucher = response;

                            if (nextMethod != null) {
                                try {
                                    nextMethod.call();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            publishResult(true, "\n[Voucher ID=> " + voucher._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UpdateVoucherAsync extends AsyncTask<String, String, String> {
        Callable<Void> nextMethod;

        public UpdateVoucherAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                myApp.appDatabase.customerDao().insert(voucher.customer);
                myApp.appDatabase.voucherDao().insert(voucher);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                publishResult(true);
            }
        }
    }

}
