package com.ubsidi.epos_2021.services

import android.app.IntentService
import android.content.Context
import android.content.Intent
import android.os.AsyncTask
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.google.gson.Gson
import com.ubsidi.epos_2021.MyApp
import com.ubsidi.epos_2021.comman.Validators
import com.ubsidi.epos_2021.daos.AppDatabase
import com.ubsidi.epos_2021.models.Order
import com.ubsidi.epos_2021.models.Table
import com.ubsidi.epos_2021.utils.Constants
import com.ubsidi.epos_2021.utils.LogUtils

/**
 * Created by Amrish on 01-06-2021.
 */
class UpdateOrderAsyncTaskServices : IntentService {
    var order = Order()
    var _order_id = 0
    private var myApp: MyApp? = null
    private var appDatabase: AppDatabase? = null

    constructor(context: Context?) : super("Upload Service") {
        LogUtils.e("Intent Service")
    }

    constructor() : super("Upload Service") {}

    override fun onHandleIntent(intent: Intent?) {
        try {
            myApp = MyApp.getInstance()
            appDatabase = myApp!!.appDatabase
            if (intent != null) {
                order = Gson().fromJson<Order>(
                    intent.getStringExtra("order"),
                    Order::class.java
                )
                _order_id = intent.getIntExtra("_order_id", 0)
                DeleteOrderAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    inner class DeleteOrderAsyncTask() :
        AsyncTask<Any?, Any?, Any?>() {
        override fun onPostExecute(s: Any?) {
            super.onPostExecute(s)
        }

        override fun doInBackground(vararg params: Any?): Any? {
            if (order.order_type_id.equals("1", ignoreCase = true) &&
                !Validators.isNullOrEmpty(order.table_id) &&
                (order.order_status_id.equals("5", ignoreCase = true) ||
                        order. order_status_id.equals("10", ignoreCase = true))
            ) {
                val vacantStatus = myApp!!.findStatus("Vacant")
                val table: Table = appDatabase!!.tableDao().view(order.table_id)
                table.status = vacantStatus.status
                table.locked = false
                table.last_order_total = 0f
                table.last_order_id = null
                table._last_order_id = 0
                table.last_order_created_at = null
                table.table_status_id = vacantStatus.id
                appDatabase!!.tableDao().insert(table)
            }
            if (order.order_status.equals("Order Deleted", ignoreCase = true)) {
                appDatabase!!.orderDao().delete(order)
                sendBrodCast(true)
            }
            return null
        }
    }


    private fun sendBrodCast(isFromError: Boolean) {
        // display order taken success message start
        val intent = Intent(Constants.BOOK_TABLE_SUCCESS)
        intent.putExtra(Constants.IS_FROM_ERROR, isFromError)
        LocalBroadcastManager.getInstance(this@UpdateOrderAsyncTaskServices).sendBroadcast(intent)
        // display order taken success message end
    }
}