package com.ubsidi.epos_2021.storageutils;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.merchant.models.RestaurantUser;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.models.Category;
import com.ubsidi.epos_2021.models.DepositType;
import com.ubsidi.epos_2021.models.Device;
import com.ubsidi.epos_2021.models.EposUserPermission;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.User;

import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Amrish on 08-08-2020.
 */
public class MyPreferences {
    private Context context;
    private String PREF_EPOS_MAIN = "EPOS_MAIN";
    private String PREF_USER = "EPOS_USER";
    private String PREF_CATEGORY = "EPOS_CATEGORY";
    private SharedPreferences prefMain, prefUser, prefCategory;

    public MyPreferences(Context context) {
        this.context = context;
        prefMain = context.getSharedPreferences(PREF_EPOS_MAIN, Context.MODE_PRIVATE);
        prefUser = context.getSharedPreferences(PREF_USER, Context.MODE_PRIVATE);
        prefCategory = context.getSharedPreferences(PREF_CATEGORY, Context.MODE_PRIVATE);
    }

    public void saveLoggedInAdmin(Admin admin) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("admin", new Gson().toJson(admin));
        editor.apply();
    }

    public Admin getLoggedInAdmin() {
        String adminString = prefMain.getString("admin", null);
        if (Validators.isNullOrEmpty(adminString)) return null;
        return new Gson().fromJson(adminString, Admin.class);
    }

    public void saveEposAdminPassword(String password) {
        prefMain.edit().putString("epos_admin_pass", password).apply();
    }

    public String getEposAdminPassword() {
        return prefMain.getString("epos_admin_pass", null);
    }

    public void saveCallerIdEnableStatus(boolean enable) {
        prefMain.edit().putBoolean("caller_id_enable", enable).apply();
    }

    public boolean getCallerIdEnableStatus() {
        return prefMain.getBoolean("caller_id_enable", false);
    }

    public void saveRemoteDeviceEnableStatus(boolean enable) {
        prefMain.edit().putBoolean("remote_device_enable", enable).apply();
    }

    public boolean getRemoteDeviceEnableStatus() {
        return prefMain.getBoolean("remote_device_enable", false);
    }

    public void saveDefaultCardReader(BusinessCardReader businessCardReader) {
        prefMain.edit().putString("default_card_reader", new Gson().toJson(businessCardReader)).apply();
    }

    public BusinessCardReader getDefaultCardReader() {
        if (prefMain != null) {
            String savedValue = prefMain.getString("default_card_reader", null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, BusinessCardReader.class);
        }
        return null;
    }

//    public void savePrintSetting(PrintSetting setting) {
//        SharedPreferences.Editor editor = prefMain.edit();
//        editor.putString("print_setting", new Gson().toJson(setting));
//        editor.apply();
//    }
//
//    public PrintSetting getPrintSetting() {
//        String printString = prefMain.getString("print_setting", null);
//        if (Validators.isNullOrEmpty(printString)) return null;
//        return new Gson().fromJson(printString, PrintSetting.class);
//    }

    public void savePrintSetting(List<PrintSetting> printSettings) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("print_setting", new Gson().toJson(printSettings));
        editor.apply();
    }

    public List<PrintSetting> getPrintSetting() {
        String printString = prefMain.getString("print_setting", null);
        Type type = new TypeToken<ArrayList<PrintSetting>>() {
        }.getType();
        return new Gson().fromJson(printString, type);
    }

    public void saveRegisteredDevice(Device device) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("device", new Gson().toJson(device));
        editor.apply();
    }

    public Device getRegisteredDevice() {
        String prefString = prefMain.getString("device", null);
        if (Validators.isNullOrEmpty(prefString)) return null;
        return new Gson().fromJson(prefString, Device.class);
    }

    public void saveOrderSyncMode(String mode) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("order_sync_mode", mode);
        editor.apply();
    }

    public String getOrderSyncMode() {
        return prefMain.getString("order_sync_mode", "manual");
    }

    public void saveBluetoothPrinter(String mode) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("bluetooth_printer_name", mode);
        editor.apply();
    }

    public String getBluetoothPrinter() {
        return prefMain.getString("bluetooth_printer_name", "");
    }


    public void saveLoggedInUser(User user) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("user", new Gson().toJson(user));
        editor.apply();
    }

    public User getLoggedInUser() {
        String adminString = prefMain.getString("user", null);
        if (Validators.isNullOrEmpty(adminString)) return null;
        return new Gson().fromJson(adminString, User.class);
    }

    public void saveEposUserPermission(String permission) {
        SharedPreferences.Editor editor = prefUser.edit();
        editor.putString("permissions", (permission));
        editor.apply();
    }

    public EposUserPermission getEposUserPermission() {
        String permissions = prefUser.getString("permissions", null);
        if (Validators.isNullOrEmpty(permissions)) return null;
        return new Gson().fromJson(permissions, EposUserPermission.class);
    }

    public void saveBusinessId(String business_id) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("business_id", business_id);
        editor.apply();
    }

    public String getBusinessId() {
        return prefMain.getString("business_id", null);
    }

    public void saveForOfflineLoginBusinessId(String business_id) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("business_id_for_login", business_id);
        editor.apply();
    }

    public String getForOfflineLoginBusinessId() {
        return prefMain.getString("business_id_for_login", null);
    }

    public void saveForOfflineLoginLoggedInAdmin(Admin admin) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("admin_offline", new Gson().toJson(admin));
        editor.apply();
    }

    public Admin getForOfflineLoginLoggedInAdmin() {
        String adminString = prefMain.getString("admin_offline", null);
        if (Validators.isNullOrEmpty(adminString)) return null;
        return new Gson().fromJson(adminString, Admin.class);
    }

    public void saveSelectedReservationFileName(String reservation) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("selected_reservation_file_name", reservation);
        editor.apply();
    }

    public String getSelectedReservationFileName() {
        return prefMain.getString("selected_reservation_file_name", null);
    }

    public void saveSelectedReservationFileUri(String reservationUri) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("selected_reservation_file_uri", reservationUri);
        editor.apply();
    }

    public String getSelectedReservationFileUri() {
        return prefMain.getString("selected_reservation_file_uri", null);
    }

    public void saveIsPrintBill(boolean isPrint) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putBoolean("print_bill", isPrint);
        editor.apply();
    }

    public boolean getIsPrintBill() {
        return prefMain.getBoolean("print_bill", false);
    }

    public void savePullStatus(boolean saved) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putBoolean("pulled", saved);
        editor.apply();
    }

    public void saveWifiConnectionId(String wifi_connection_id) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("wifi_connection_id", wifi_connection_id);
        editor.apply();
    }

    public String getWifiConnectionId() {
        return prefMain.getString("wifi_connection_id", "192.168.1.86");
    }

    public void setSunmiEnabled(boolean sunmi_enabled) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putBoolean("sunmi_printer_enable", sunmi_enabled);
        editor.apply();
    }

    public boolean isSunmiEnabled() {
        return prefMain.getBoolean("sunmi_printer_enable", false);
    }

    public boolean getPullStatus() {
        return prefMain.getBoolean("pulled", false);
    }

    public void saveAdminTokens(String xToken, String rToken) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("x-token", xToken);
        editor.putString("x-refresh-token", rToken);
        editor.apply();
    }

    public void saveUserTokens(String xToken, String rToken) {
        SharedPreferences.Editor editor = prefUser.edit();
        editor.putString("x-token", xToken);
        editor.putString("x-refresh-token", rToken);
        editor.apply();
    }

    public void saveMerchantRole(int role) {
        //0=waiter, 1= supervisor,2=admin
        SharedPreferences.Editor editor = prefUser.edit();
        editor.putInt("merchant_role", role);
        editor.apply();
    }

    /*
    @@ Params 0=waiter, 1= supervisor,2=admin
     */
    public int getMerchantRole() {
        return prefUser.getInt("merchant_role", 0);
    }

    // is used to save username for admin login
    // will use this username when internet is not and user try to login
    public void saveUserNameAdmin(String usernameAdmin) {
        //0=waiter, 1= supervisor,2=admin
        SharedPreferences.Editor editor = prefUser.edit();
        editor.putString("user_name_admin", usernameAdmin);
        editor.apply();
    }

    public String getUserNameAdmin() {
        return prefUser.getString("user_name_admin", "");
    }

    public void userLoggedInWithoutInternet(boolean saved) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putBoolean("login_without_internet", saved);
        editor.apply();
    }

    public boolean isUserLoginWithoutInternet() {
        return prefMain.getBoolean("login_without_internet", false);
    }

    public void adminLoggedInWithoutInternet(boolean saved) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putBoolean("admin_login_without_internet", saved);
        editor.apply();
    }

    public boolean isAdminLoginWithoutInternet() {
        return prefMain.getBoolean("admin_login_without_internet", false);
    }

    public String getAdminToken(String token) {
        return prefMain.getString(token, null);
    }

    public String getUserToken(String token) {
        return prefUser.getString(token, null);
    }

    public List<Category> getCategories() {
        String value = prefCategory.getString("categories", null);
        if (Validators.isNullOrEmpty(value)) return null;
        else {
            Type token = new TypeToken<List<Category>>() {
            }.getType();
            return new Gson().fromJson(value, token);
        }
    }

    public void saveCategories(List<Category> categories) {
        SharedPreferences.Editor editor = prefCategory.edit();
        editor.putString("categories", new Gson().toJson(categories));
        editor.apply();
    }

    public List<SiteSetting> getSiteSettings() {
        String siteSettingValue = prefMain.getString("site-settings", null);
        if (Validators.isNullOrEmpty(siteSettingValue)) return null;
        else {
            Type token = new TypeToken<List<SiteSetting>>() {
            }.getType();
            return new Gson().fromJson(siteSettingValue, token);
        }
    }

    public void saveSiteSettings(List<SiteSetting> siteSettings) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString("site-settings", new Gson().toJson(siteSettings));
        editor.apply();
    }

    public void saveSingleSetting(SiteSetting siteSetting) {
        SharedPreferences.Editor editor = prefMain.edit();
        editor.putString(siteSetting.key, new Gson().toJson(siteSetting));
        editor.apply();
    }

    public SiteSetting getSingleSetting(String key) {
        return new Gson().fromJson(prefMain.getString(key, null), SiteSetting.class);
    }

    public Map<String, String> getUserAuthToken() {

        String xToken = getUserToken("x-token");
        String xRefreshToken = getUserToken("x-refresh-token");
        String businessId = getBusinessId();

        Map<String, String> map = new HashMap<>();
        if (businessId != null)
            map.put("business-id", getBusinessId());
        if (xToken != null)
            map.put("x-token", xToken);
        if (xRefreshToken != null)
            map.put("x-refresh-token", xRefreshToken);
        return map;
    }

    public Map<String, String> getAdminAuthToken() {

        String xToken = getAdminToken("x-token");
        String xRefreshToken = getAdminToken("x-refresh-token");
        String businessId = getBusinessId();

        Map<String, String> map = new HashMap<>();
        if (businessId != null)
            map.put("business-id", getBusinessId());
        if (xToken != null)
            map.put("x-token", xToken);
        if (xRefreshToken != null)
            map.put("x-refresh-token", xRefreshToken);

        return map;
    }

    public Printer getDefaultPrinter() {
        Printer defaultPrinter = null;
        if (MyApp.printerStatus == 0) return null;
        for (Printer p : getLoggedInAdmin().selected_business.printers) {
            if (p.is_default) {
                defaultPrinter = p;
                break;
            }
        }
        return defaultPrinter;
    }

    public Printer getDefaultPrinter(boolean forceFully) {
        Printer defaultPrinter = null;
        if (!forceFully && MyApp.printerStatus == 0) return null;
        if (getLoggedInAdmin() == null) return null;
        if (getLoggedInAdmin().selected_business == null) return null;
        for (Printer p : getLoggedInAdmin().selected_business.printers) {
            if (p.is_default) {
                defaultPrinter = p;
                break;
            }
        }
        return defaultPrinter;
    }

    public void setUserFCMToken(String s) {
        prefMain.edit().putString("fcm_token", s).apply();

    }

    public String getUserFCMToken() {
        return prefMain.getString("fcm_token", null);
    }

    public void saveRestaurant(Restaurant user) {
        if (prefMain != null && user != null) {
            SharedPreferences.Editor editor = prefMain.edit();
            editor.putString("business_restaurant", new Gson().toJson(user));
            editor.apply();
        }
    }

    public void saveRestaurant(JSONObject user) {
        if (prefMain != null && user != null) {
            SharedPreferences.Editor editor = prefMain.edit();
            editor.putString("business_restaurant", user.toString());
            editor.apply();
        }
    }

    public Restaurant getRestaurant() {
        if (prefMain != null) {
            String savedValue = prefMain.getString("business_restaurant", null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, Restaurant.class);
        } else return null;
    }

    public void saveRestaurantDetails(RestaurantUser user) {
        if (prefMain != null && user != null) {
            SharedPreferences.Editor editor = prefMain.edit();
            editor.putString("logged_in_restaurant", new Gson().toJson(user));
            editor.apply();
        }
    }

    public RestaurantUser getLoggedInRestaurant() {
        if (prefMain != null) {
            String savedValue = prefMain.getString("logged_in_restaurant", null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, RestaurantUser.class);
        } else return null;
    }

    public void saveDepositTypes(List<DepositType> types) {
        if (prefMain != null && types != null) {
            SharedPreferences.Editor editor = prefMain.edit();
            editor.putString("deposit_types", new Gson().toJson(types));
            editor.apply();
        }
    }

    public List<DepositType> getDepositTypes() {
        if (prefMain != null) {
            String savedValue = prefMain.getString("deposit_types", null);
            if (Validators.isNullOrEmpty(savedValue)) return new ArrayList<>();
            Type type = new TypeToken<List<DepositType>>() {
            }.getType();
            return new Gson().fromJson(savedValue, type);
        } else return null;
    }

    public void saveIsUsb(boolean isUsb) {
        prefMain.edit().putBoolean("is_usb_enable", isUsb).apply();
    }

    public boolean getIsUbEnableStatus() {
        return prefMain.getBoolean("is_usb_enable", false);
    }
}
