package com.ubsidi.epos_2021.utils;

import android.util.Log;

import androidx.multidex.BuildConfig;

import com.google.gson.Gson;
import com.ubsidi.epos_2021.comman.CommonFunctions;


public class LogUtils {
    private static boolean logEnabled = true;
    private static boolean networkLogEnabled = BuildConfig.DEBUG;
    private static String TAG = "####";
    private static String NETWORK_TAG = "###NETWORK###";

    public static void e(String message) {
        if (logEnabled) Log.e(TAG, message);
    }

    public static void e(Object object) {
        if (logEnabled) Log.e(TAG, new Gson().toJson(object));
    }

    public static void network(String message) {
        if (networkLogEnabled) Log.e(NETWORK_TAG, message);
    }

    public static void network(Object object) {
        if (networkLogEnabled) Log.e(NETWORK_TAG, new Gson().toJson(object));
    }

    public static void e(int message) {
        if (logEnabled) Log.e(TAG, message + "");
    }

    public static void d(String tag, String message) {
        if (logEnabled) Log.d(tag, message);
    }

    public static void d(String message) {
        if (logEnabled) Log.d(TAG, message);
    }

    public static void w(String tag, String message) {
        if (logEnabled) Log.w(tag, message);
    }

    public static void w(String message) {
        if (logEnabled) Log.w(TAG, message);
    }

    public static void e(String... messages) {
        if (logEnabled) Log.e(TAG, CommonFunctions.StringAppender(messages));
    }
}
