package com.ubsidi.epos_2021.utils

import android.util.Log
import com.ubsidi.epos_2021.MyApp
import kotlinx.coroutines.*
import java.io.ByteArrayInputStream
import java.io.InputStream
import java.io.ObjectOutputStream
import java.io.OutputStream
import java.net.InetSocketAddress
import java.net.Socket
import java.nio.charset.StandardCharsets

/**
 * @Author: CZY
 * @Date: 2022/9/27 16:52
 * @Desc:
 */
object Logger {
    private var job: Job? = null
    fun log(any: Any?) {
        Log.e("WifiP2P", any?.toString() ?: "null")
    }

    private var isPrinterRunning = false
    private var listOfRequest = arrayListOf<String>()
    private var listSize = 0
    fun sendText(ipAddress: String, text: String) {
        // delay every request for 1 second to prevent multiple request at the same time
        Log.e(
            "CoroutineScope",
            "CoroutineScope Before ${listOfRequest.size} isPrinterRunning $isPrinterRunning"
        )
        listOfRequest.add(text)
        if (!isPrinterRunning) {
            isPrinterRunning = true
            CoroutineScope(Dispatchers.IO).launch {
                delay(1000L)
                sendTextToSocket(ipAddress, text)
                //Log.e("CoroutineScope", "CoroutineScope In loop after delay")
            }
            //Log.e("CoroutineScope", "CoroutineScope Outside Of CoroutineScope")
        }
    }

    private fun sendTextToSocket(ipAddress: String, text: String) {
        /*if (job != null) {
            job?.cancel()
        }*/
        job = CoroutineScope(Dispatchers.IO).launch {
            Log.e("CoroutineScope", "CoroutineScope ")
            var socket: Socket? = null
            var outputStream: OutputStream? = null
            var objectOutputStream: ObjectOutputStream? = null
            var inputStream: InputStream? = null
            try {
                socket = Socket()
                socket.bind(null)

                socket.connect(InetSocketAddress(ipAddress, Constants.PORT), 30000)

                outputStream = socket.getOutputStream()
                objectOutputStream = ObjectOutputStream(outputStream)
                objectOutputStream.writeObject(text)
                inputStream = ByteArrayInputStream(text.toByteArray(StandardCharsets.UTF_8))
                val buffer = ByteArray(1024 * 100)
                var length: Int
                while (true) {
                    length = inputStream.read(buffer)
                    if (length > 0) {
                        outputStream.write(buffer, 0, length)
                    } else {
                        break
                    }
                }
                isPrinterRunning = false
                Log.e("CoroutineScope", "All Printer is done ${listOfRequest.size}")
                if (listOfRequest.isEmpty()) {
                    Log.e("Logger", "All Printer is done")
                } else {
                    if (listOfRequest.isNotEmpty()) {
                        listOfRequest.removeAt(0)
                    }
                    if (listOfRequest.isNotEmpty()) {
                        inputStream?.close()
                        outputStream?.close()
                        objectOutputStream?.close()
                        delay(1000L)
                        sendTextToSocket(ipAddress, listOfRequest[0])
                    }
                }
                withContext(Dispatchers.Main) {
                    //ToastUtils.makeToast(MyApp.getInstance().applicationContext,"lengthofthemessageis ${length}")
                }
            } catch (e: Throwable) {
                //listOfRequest.removeAt(0)
                Log.e("CoroutineScope", "Throwable ${e.message}")
                withContext(Dispatchers.Main) {
                    //ToastUtils.makeToast(MyApp.getInstance().applicationContext, "${e.message}")
                }
                e.printStackTrace()
                if (listSize == 0) {
                    listSize = listOfRequest.size
                } else {
                    if (listSize == listOfRequest.size) {
                        if (listOfRequest.isNotEmpty()) {
                            listOfRequest.removeAt(0)
                        }
                        listSize = listOfRequest.size
                    }
                }
                if (listOfRequest.isNotEmpty()) {
                    delay(2000L)
                    sendTextToSocket(ipAddress, listOfRequest[0])
                }
            } finally {
                Log.e("CoroutineScope ", "finally")
                /*inputStream?.close()
                outputStream?.close()
                objectOutputStream?.close()*/
                //socket?.close()
            }
        }
        job?.invokeOnCompletion {
            job = null
        }
    }
}