package com.ubsidi.epos_2021.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.core.content.ContextCompat;

import com.google.android.material.snackbar.Snackbar;
import com.ubsidi.R;

public class ToastUtils {
    public static void makeToast(Activity context, String message) {
        try {
            if (context != null && !context.isFinishing())
                context.runOnUiThread(() -> Toast.makeText(context, message, Toast.LENGTH_SHORT).show());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeLongToast(Activity context, String message) {
        try {
            if (context != null && !context.isFinishing())
                context.runOnUiThread(() -> Toast.makeText(context, message, Toast.LENGTH_LONG).show());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeToast(Context context, String message) {
        try {
            if (context != null && !(context instanceof Activity && ((Activity) context).isFinishing()))
                Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeLongToast(Context context, String message) {
        try {
            if (context != null && !(context instanceof Activity && ((Activity) context).isFinishing()))
                Toast.makeText(context, message, Toast.LENGTH_LONG).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeSnackToast(Activity activity, String message) {
        try {
            if (activity != null && !activity.isFinishing())
                activity.runOnUiThread(() -> Toast.makeText(activity, message, Toast.LENGTH_LONG).show());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeSnackToast(Context activity, String message) {
        try {
            if (activity != null && !((Activity) activity).isFinishing())
                Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message, String type) {
        try {
            Snackbar snackbar = Snackbar.make(coordinatorLayout, message, Snackbar.LENGTH_LONG);
            View mView = snackbar.getView();
            if (type.equalsIgnoreCase("success"))
                snackbar.setBackgroundTint(ContextCompat.getColor(context, R.color.chip_green_color));
            else if ((type.equalsIgnoreCase("remove") || type.equalsIgnoreCase("reject") || type.equalsIgnoreCase("failed")))
                snackbar.setBackgroundTint(ContextCompat.getColor(context, R.color.reject_color));
            else snackbar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
            snackbar.setActionTextColor(ContextCompat.getColor(context, R.color.white));
            (mView).getLayoutParams().width = context.getResources().getDimensionPixelSize(R.dimen.width_400);

            TextView sbTextView = (TextView) mView.findViewById(com.google.android.material.R.id.snackbar_text);
            sbTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, context.getResources().getDimension(R.dimen.text_size_16));
            sbTextView.setGravity(Gravity.CENTER_HORIZONTAL);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                sbTextView.setTextAlignment(View.TEXT_ALIGNMENT_CENTER);
            } else {
                sbTextView.setGravity(Gravity.CENTER_HORIZONTAL);
            }
            snackbar.show();
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void showSnackBarFull(Context context, View coordinatorLayout, String message, String type) {
        try {
            if (context == null || (context instanceof Activity && ((Activity) context).isFinishing()) || coordinatorLayout == null)
                return;
            Snackbar snackbar = Snackbar.make(coordinatorLayout.getRootView(), message, Snackbar.LENGTH_LONG);
            View mView = snackbar.getView();
            if (type.equalsIgnoreCase("success"))
                snackbar.setBackgroundTint(ContextCompat.getColor(context, R.color.chip_green_color));
            else if ((type.equalsIgnoreCase("remove") || type.equalsIgnoreCase("reject")))
                snackbar.setBackgroundTint(ContextCompat.getColor(context, R.color.reject_color));
            else snackbar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
            snackbar.setActionTextColor(ContextCompat.getColor(context, R.color.white));
            (mView).getLayoutParams().width = ViewGroup.LayoutParams.MATCH_PARENT;
            TextView sbTextView = (TextView) mView.findViewById(com.google.android.material.R.id.snackbar_text);
            sbTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, context.getResources().getDimension(R.dimen.text_size_16));
            sbTextView.setGravity(Gravity.CENTER_HORIZONTAL);
            snackbar.show();
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message, int length, int color) {
        try {
            if (context == null || (context instanceof Activity && ((Activity) context).isFinishing()))
                return;
            Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, length);
            greySnackBar.setBackgroundTint(ContextCompat.getColor(context, color));
            greySnackBar.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message, int length) {
        if (context == null || (context instanceof Activity && ((Activity) context).isFinishing()))
            return;
        Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, length);
        greySnackBar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
        greySnackBar.show();
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message) {
        try {
            if (context == null || (context instanceof Activity && ((Activity) context).isFinishing()))
                return;
            Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, Snackbar.LENGTH_LONG);
            greySnackBar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
            (greySnackBar.getView()).getLayoutParams().width = ViewGroup.LayoutParams.MATCH_PARENT;
            greySnackBar.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
