/*
 * Decompiled with CFR 0.152.
 */
package a1088sdk;

import a1088sdk.PrnDspA1088Activity;
import a1088sdk.a;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.zqcom.zqcom;
import android.zqgpio.Gpio;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;

public class PrnDspA1088 {
    private PrnDspA1088Activity a = null;
    private final String b = "V1.35";
    public static final int ZQ_SUCCESS = 0;
    public static final int ZQ_USBERROR = -1;
    public static final int ZQ_NOPRNPORT = -2;
    public static final int ZQ_NODSPPORT = -3;
    public static final int ZQ_NOCOMPORT = -4;
    public static final int ZQ_SENDERROR = -5;
    public static final int ZQ_ERRPARAM = -6;
    public static final int ZQ_NOPERMISSION = -7;
    public static final int ZQ_WRONGFILE = -8;
    public static final int ZQ_WRONGDATA = -9;
    public static final int ZQ_READERROR = -10;
    public static final int ZQ_CONTEXTNULL = -11;
    public static final int ZQ_PORTISCLOSE = -12;
    public static final int ZQ_ERROR = -13;
    public static final int ZQ_READWRONG = -14;
    public static final int STATUS_COVEROPEN = 1;
    public static final int STATUS_PAPEREND = 16;
    public static final int STATUS_ERROR = 17;
    public static final int FLOW_NONE = 0;
    public static final int FLOW_XONXOFF = 1;
    public static final int FLOW_HARDWARE = 2;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int FT_DEFAULT = 0;
    public static final int FT_FONTB = 1;
    public static final int FT_BOLD = 2;
    public static final int FT_UNDERLINE = 4;
    public static final int FT_REVERSE = 8;
    public static final int TS_0WIDTH = 0;
    public static final int TS_1WIDTH = 16;
    public static final int TS_2WIDTH = 32;
    public static final int TS_3WIDTH = 48;
    public static final int TS_4WIDTH = 64;
    public static final int TS_5WIDTH = 80;
    public static final int TS_6WIDTH = 96;
    public static final int TS_7WIDTH = 112;
    public static final int TS_0HEIGHT = 0;
    public static final int TS_1HEIGHT = 1;
    public static final int TS_2HEIGHT = 2;
    public static final int TS_3HEIGHT = 3;
    public static final int TS_4HEIGHT = 4;
    public static final int TS_5HEIGHT = 5;
    public static final int TS_6HEIGHT = 6;
    public static final int TS_7HEIGHT = 7;
    public static final int BCS_EAN13 = 103;
    public static final int BCS_JAN13 = 104;
    public static final int BCS_EAN8 = 105;
    public static final int BCS_JAN8 = 106;
    public static final int BCS_Code39 = 107;
    public static final int BCS_Code128 = 111;
    public static final int BCS_Code128_ZQ = 112;
    public static final int BC_TEXT_NONE = 0;
    public static final int BC_TEXT_ABOVE = 1;
    public static final int BC_TEXT_BELOW = 2;
    public static final int IMAGE_2WIDTH = 1;
    public static final int IMAGE_2HEIGHT = 2;
    public static final int IMAGE_2WIDTH2HEIGHT = 3;
    public static final int IMAGE_NORMAL = 4;
    public static final int DISPLAY_LED = 0;
    public static final int DISPLAY_LCD = 1;
    public static final int DISPLAY_VFD = 2;
    public static final int DISPLAY_LED2 = 3;
    public static final int CASHBOX_PIN3 = 0;
    public static final int CASHBOX_PIN5 = 1;
    public static final int STATUS_CASHBOXOPEN = 1;
    public static final int STATUS_CASHBOXCLOSE = 0;
    public static final int STATUS_UNKNOWN = -1;
    public static final int LED_STATUS_PRICE = 49;
    public static final int LED_STATUS_TOTAL = 50;
    public static final int LED_STATUS_PAY = 51;
    public static final int LED_STATUS_CHANGE = 52;
    public static final byte CRT_CODE_MODE_ASCII = 48;
    public static final byte CRT_CODE_MODE_HEX = 49;
    public static final byte CRT_TRACK_NO = 48;
    public static final byte CRT_TRACK_1 = 49;
    public static final byte CRT_TRACK_2 = 50;
    public static final byte CRT_TRACK_3 = 51;
    public static final byte CRT_TRACK_12 = 52;
    public static final byte CRT_TRACK_23 = 53;
    public static final byte CRT_TRACK_13 = 54;
    public static final byte CRT_TRACK_123 = 55;
    public static final byte CRT_SWP_OFF = 48;
    public static final byte CRT_SWP_ON = 49;
    public static final byte CRT_SWP_ON2 = 50;
    public static final byte CRT_BAUD_2400 = 49;
    public static final byte CRT_BAUD_4800 = 50;
    public static final byte CRT_BAUD_9600 = 51;
    public static final byte CRT_BAUD_19200 = 52;
    public static final byte CRT_BAUD_38400 = 53;
    public static final byte CRT_CARDSTATUS_OK = 89;
    public static final byte CRT_CARDSTATUS_ERROR = 78;
    public static final byte CRT_CARDSTATUS_NO = 79;
    public static final byte CRT_ERROR_NOSTX = -31;
    public static final byte CRT_ERROR_NOETX = -30;
    public static final byte CRT_ERROR_VRC = -29;
    public static final byte CRT_ERROR_BLANK = -27;
    public static final byte CRT_TRACK1_START = -128;
    public static final byte CRT_TRACK2_START = -127;
    public static final byte CRT_TRACK3_START = -126;
    private zqcom c = null;
    private OutputStream d = null;
    private InputStream e = null;
    private zqcom f = null;
    private OutputStream g = null;
    private InputStream h = null;
    private zqcom i = null;
    private OutputStream j = null;
    private InputStream k = null;
    private zqcom l = null;
    private OutputStream m = null;
    private InputStream n = null;
    private int o = 1;
    private UsbManager p = null;
    private UsbDevice q = null;
    private UsbInterface r = null;
    private UsbEndpoint s = null;
    private UsbDeviceConnection t = null;
    private UsbEndpoint u = null;
    private PendingIntent v = null;
    private String w = "A1088SDK";
    private Context x = null;
    private boolean y = false;
    private boolean z = true;
    private boolean A = true;
    private boolean B = false;
    private int C = 5000;
    private zqcom D = null;
    private OutputStream E = null;
    private InputStream F = null;
    private boolean G = false;
    private boolean H = false;
    private boolean I = false;
    private boolean J = false;
    private String K = "gb2312";
    private int L = 258;
    private int M = 256;
    private int N = 0;
    private int O = 0;
    private boolean P = true;
    private a Q = new a(this);

    public PrnDspA1088(Context context) {
        Log.v((String)this.w, (String)("Context:" + context.toString()));
        this.v = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("com.google.android.DemoKit.action.USB_PERMISSION"), (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("com.google.android.DemoKit.action.USB_PERMISSION"), (int)0);
        this.x = context;
        this.a();
        IntentFilter intentFilter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        context.registerReceiver((BroadcastReceiver)this.Q, intentFilter);
        Gpio.gpioInt(256, "in");
    }

    public void finalize() {
        if (this.x != null) {
            this.x.unregisterReceiver((BroadcastReceiver)this.Q);
        }
    }

    private int a() {
        if (this.x == null) {
            return -11;
        }
        if (this.q != null) {
            if (!this.A) {
                return 0;
            }
            if (this.t != null && this.r != null) {
                this.t.releaseInterface(this.r);
                this.t.close();
            }
            this.q = null;
        }
        try {
            this.p = (UsbManager)this.x.getSystemService("usb");
        }
        catch (Exception exception) {
            Log.v((String)this.w, (String)exception.getMessage());
        }
        if (this.p == null) {
            Log.v((String)this.w, (String)"mManager null");
            return -1;
        }
        HashMap hashMap = this.p.getDeviceList();
        Iterator iterator = hashMap.values().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            UsbDevice usbDevice = (UsbDevice)iterator.next();
            Log.v((String)this.w, (String)("Device:" + usbDevice.getVendorId() + "," + usbDevice.getProductId() + "," + usbDevice.getDeviceId() + "," + usbDevice.getDeviceName() + "," + usbDevice.getDeviceClass() + "," + usbDevice.getDeviceSubclass() + "," + usbDevice.getDeviceProtocol()));
            if (usbDevice == null) continue;
            if (this.N != 0 && this.O != 0) {
                if (usbDevice.getProductId() != this.N || usbDevice.getVendorId() != this.O) continue;
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 7358 && usbDevice.getProductId() == 3 && usbDevice.getDeviceClass() == 255 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 1317 && usbDevice.getProductId() == 42754 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 1411 && usbDevice.getProductId() == 22336 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 1155 && usbDevice.getProductId() == 22336 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 1411 && usbDevice.getProductId() == 22336 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 4292 && usbDevice.getProductId() == 0 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 4703 && usbDevice.getProductId() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 1137 && usbDevice.getProductId() == 85 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 10473 && usbDevice.getProductId() == 22546 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                break;
            }
            if (usbDevice.getVendorId() == 1305 && usbDevice.getProductId() == 8211 && usbDevice.getDeviceClass() == 2 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                break;
            }
            if (usbDevice.getVendorId() == 4070 && usbDevice.getProductId() == 33054 && usbDevice.getDeviceClass() == 239 && usbDevice.getDeviceSubclass() == 2 && usbDevice.getDeviceProtocol() == 1) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                break;
            }
            if (usbDevice.getVendorId() == 4070 && usbDevice.getProductId() == 33054 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                break;
            }
            if (usbDevice.getVendorId() == 4070 && usbDevice.getProductId() == 33054 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                break;
            }
            if (usbDevice.getVendorId() == 26728 && usbDevice.getProductId() == 768 && usbDevice.getDeviceClass() == 0 && usbDevice.getDeviceSubclass() == 0 && usbDevice.getDeviceProtocol() == 0) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                continue;
            }
            if (usbDevice.getVendorId() == 10473 && usbDevice.getProductId() == 1569) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                continue;
            }
            if (usbDevice.getVendorId() == 1155 && usbDevice.getProductId() == 30016) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                continue;
            }
            if (usbDevice.getVendorId() == 1155 && usbDevice.getProductId() == 1803) {
                this.q = usbDevice;
                this.z = false;
                this.B = false;
                continue;
            }
            if (usbDevice.getVendorId() != 1155 || usbDevice.getProductId() != 22339) continue;
            this.P = false;
            this.q = usbDevice;
            this.z = false;
            this.B = false;
        }
        if (this.q == null) {
            return -2;
        }
        if (!this.p.hasPermission(this.q)) {
            Log.v((String)this.w, (String)"requestPermission");
            this.p.requestPermission(this.q, this.v);
        }
        try {
            this.r = this.q.getInterface(0);
        }
        catch (Exception exception) {
            Log.v((String)this.w, (String)String.format("InterfaceCount:%d", this.q.getInterfaceCount()));
            return -2;
        }
        if (this.r == null) {
            Log.v((String)this.w, (String)"intf is null");
            return -2;
        }
        this.s = this.q.getVendorId() == 1305 && this.q.getProductId() == 8211 && this.q.getDeviceClass() == 2 && this.q.getDeviceSubclass() == 0 && this.q.getDeviceProtocol() == 0 || this.q.getVendorId() == 4070 && this.q.getProductId() == 33054 && this.q.getDeviceClass() == 0 && this.q.getDeviceSubclass() == 0 && this.q.getDeviceProtocol() == 0 ? this.r.getEndpoint(0) : this.r.getEndpoint(1);
        if (this.s == null) {
            Log.v((String)this.w, (String)"endpoint1 is null");
            return -2;
        }
        this.t = this.p.openDevice(this.q);
        if (this.t == null) {
            Log.v((String)this.w, (String)"connection is null");
            return -2;
        }
        boolean bl2 = this.t.claimInterface(this.r, true);
        if (!bl2) {
            Log.v((String)this.w, (String)("claimInterface:" + bl2));
            return -2;
        }
        this.u = this.q.getVendorId() == 1305 && this.q.getProductId() == 8211 && this.q.getDeviceClass() == 2 && this.q.getDeviceSubclass() == 0 && this.q.getDeviceProtocol() == 0 || this.q.getVendorId() == 4070 && this.q.getProductId() == 33054 && this.q.getDeviceClass() == 0 && this.q.getDeviceSubclass() == 0 && this.q.getDeviceProtocol() == 0 ? this.r.getEndpoint(1) : this.r.getEndpoint(0);
        if (this.u == null) {
            Log.v((String)this.w, (String)"endpoint0 is null");
            return -2;
        }
        if (this.u.getDirection() == 0) {
            Log.v((String)this.w, (String)"change direction");
            this.u = this.r.getEndpoint(1);
            this.s = this.r.getEndpoint(0);
        }
        return 0;
    }

    private int a(byte[] byArray, int n) {
        int n2;
        Object object;
        if (this.y && "mounted".equals(Environment.getExternalStorageState())) {
            File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
            File file2 = new File(file.getAbsolutePath(), "a1088usb.dat");
            if (!file2.exists()) {
                try {
                    file2.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                object = new FileWriter(String.valueOf(file.getAbsolutePath()) + File.separator + "a1088usb.dat", true);
                n2 = 0;
                while (n2 < n) {
                    ((Writer)object).append((char)byArray[n2]);
                    ++n2;
                }
                ((OutputStreamWriter)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.q == null) {
            Log.v((String)this.w, (String)"device null");
            return -2;
        }
        if (!this.p.hasPermission(this.q)) {
            return -7;
        }
        if (this.r == null) {
            Log.v((String)this.w, (String)"intf is null");
            return -1;
        }
        if (this.s == null) {
            Log.v((String)this.w, (String)"endpoint is null");
            return -1;
        }
        if (this.t == null) {
            Log.v((String)this.w, (String)"connection is null");
            return -1;
        }
        this.I = true;
        while (this.G) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.G = true;
        int n3 = 0;
        int n4 = 0;
        if (this.z) {
            object = new byte[1];
            object[0] = false;
            this.t.bulkTransfer(this.s, (byte[])object, 1, 10000);
        }
        if (this.B) {
            int n5 = 0;
            while (n5 < byArray.length) {
                byte[] byArray2 = new byte[]{byArray[n5]};
                n4 = this.t.bulkTransfer(this.s, byArray2, 1, this.C);
                if (n4 > 0) {
                    n3 += n4;
                }
                if (n4 >= 0) {
                    ++n5;
                    continue;
                }
                break;
            }
        } else if (byArray.length <= 16384) {
            n4 = this.t.bulkTransfer(this.s, byArray, byArray.length, this.C);
            if (n4 > 0) {
                n3 += n4;
            }
        } else {
            object = new byte[16384];
            int n6 = n2 = byArray.length;
            while (n6 > 0) {
                int n7 = n6 > 16384 ? 16384 : n6;
                System.arraycopy(byArray, n3, object, 0, n7);
                n4 = this.t.bulkTransfer(this.s, (byte[])object, n7, this.C);
                if (n4 > 0) {
                    n3 += n4;
                    n6 -= n4;
                    continue;
                }
                break;
            }
        }
        Log.v((String)this.w, (String)String.format("blukTransfer[%d]:%d", byArray.length, n3));
        this.I = false;
        this.G = false;
        if (this.H) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (n3 == byArray.length) {
            return n3;
        }
        return -5;
    }

    private int a(byte[] byArray, int n, int n2) {
        if (this.q == null) {
            Log.v((String)this.w, (String)"Read,device null");
            return -2;
        }
        if (this.r == null) {
            Log.v((String)this.w, (String)"Read,intf is null");
            return -1;
        }
        if (this.u == null) {
            Log.v((String)this.w, (String)"Read,endpoint is null");
            return -1;
        }
        if (this.t == null) {
            Log.v((String)this.w, (String)"connection is null");
        }
        this.H = true;
        while (this.G) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.G = true;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[n];
        while (n4 > 0 & n5 < 4) {
            n3 = this.t.bulkTransfer(this.u, byArray2, n4, n2 / 4);
            if (n3 > 0) {
                int n7 = 0;
                while (n7 < n3) {
                    byArray[n6 + n7] = byArray2[n7];
                    ++n7;
                }
                n6 += n3;
                n4 -= n3;
                continue;
            }
            ++n5;
        }
        if (n6 > 0) {
            Log.v((String)this.w, (String)("Read:" + n + ",blukTransfer[" + n + "]:" + n6 + ",Try:" + n5));
        }
        this.H = false;
        this.G = false;
        if (this.I) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return n6;
    }

    public int PRN_Open(String string, int n) {
        return this.PRN_Open(string, n, 0);
    }

    public int PRN_Open(String string, int n, int n2) {
        if (n2 == 2) {
            n2 = 1;
        }
        if (this.d != null) {
            try {
                this.d.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.e != null) {
            try {
                this.e.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string.equals("")) {
            string = "/dev/ttyS1";
        }
        if (n == 0) {
            n = 9600;
        }
        try {
            this.c = new zqcom(new File(string), n, n2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return -7;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -2;
        }
        this.d = this.c.getOutputStream();
        this.e = this.c.getInputStream();
        return 0;
    }

    public int PRN_Close() {
        if (this.d != null) {
            try {
                this.d.close();
                this.d = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.e != null) {
            try {
                this.e.close();
                this.e = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.c != null) {
            this.c.Close();
            this.c = null;
        }
        return 0;
    }

    public int PRN_PrintText(String string, int n, int n2, int n3) {
        int n4;
        if (this.d == null && (n4 = this.a()) != 0) {
            return n4;
        }
        byte[] byArray = new byte[12];
        byArray[0] = 27;
        byArray[1] = 97;
        byArray[2] = 48;
        byArray[3] = 27;
        byArray[4] = 33;
        byArray[6] = 29;
        byArray[7] = 66;
        byArray[9] = 29;
        byArray[10] = 33;
        byte[] byArray2 = byArray;
        byArray2[2] = (byte)(byArray2[2] + n);
        if (n2 > 0) {
            if ((n2 & 4) > 0) {
                byArray2[5] = (byte)(byArray2[5] + 128);
                Log.i((String)this.w, (String)("Mode:" + String.valueOf(byArray2[5])));
            }
            if ((n2 & 1) > 0) {
                byArray2[5] = (byte)(byArray2[5] + 1);
                Log.i((String)this.w, (String)("Mode:" + String.valueOf(byArray2[5])));
            }
            if ((n2 & 2) > 0) {
                byArray2[5] = (byte)(byArray2[5] + 8);
                Log.i((String)this.w, (String)("Mode:" + String.valueOf(byArray2[5])));
            }
        }
        if ((n2 & 8) > 0) {
            byArray2[8] = 1;
            Log.i((String)this.w, (String)("Reverse:" + String.valueOf(byArray2[8])));
        }
        byArray2[11] = (byte)n3;
        try {
            byte[] byArray3 = string.getBytes(this.K);
            byte[] byArray4 = PrnDspA1088.a(byArray2, byArray3);
            if (this.d == null) {
                if (this.P) {
                    return this.a(byArray4, byArray4.length);
                }
                return this.a(byArray3, byArray3.length);
            }
            this.d.write(byArray4, 0, byArray4.length);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_LineFeed(int n) {
        int n2;
        if (this.d == null && (n2 = this.a()) != 0) {
            return n2;
        }
        String string = "";
        int n3 = 0;
        while (n3 < n) {
            string = String.valueOf(string) + "\r\n";
            ++n3;
        }
        byte[] byArray = string.getBytes();
        if (this.d == null) {
            if (this.a(byArray, byArray.length) == byArray.length) {
                return 0;
            }
            return -5;
        }
        try {
            this.d.write(byArray, 0, byArray.length);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_CutPaper() {
        int n;
        if (this.d == null && (n = this.a()) != 0) {
            return n;
        }
        byte[] byArray = new byte[]{27, 109};
        if (this.d == null) {
            if (this.a(byArray, byArray.length) == byArray.length) {
                return 0;
            }
            return -5;
        }
        try {
            this.d.write(byArray, 0, byArray.length);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_OpenCashbox(int n) {
        int n2;
        if (n != 1) {
            n = 0;
        }
        if (this.d == null && (n2 = this.a()) != 0) {
            return n2;
        }
        byte[] byArray = new byte[5];
        byArray[0] = 27;
        byArray[1] = 112;
        byArray[3] = 16;
        byArray[4] = 16;
        byte[] byArray2 = byArray;
        byArray2[2] = (byte)n;
        if (this.d == null) {
            if (this.a(byArray2, byArray2.length) == byArray2.length) {
                return 0;
            }
            return -5;
        }
        try {
            this.d.write(byArray2, 0, byArray2.length);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_OpenCashbox() {
        return this.PRN_OpenCashbox(0);
    }

    public int PRN_PrintBarcode(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.d == null && (n7 = this.a()) != 0) {
            return n7;
        }
        if (n2 != 103 && n2 != 104 && n2 != 105 && n2 != 106 && n2 != 107 && n2 != 111 && n2 != 112) {
            return -6;
        }
        byte[] byArray2 = new byte[]{27, 97, 48};
        byte[] byArray3 = new byte[]{27, 97, 48};
        byArray2[2] = (byte)(byArray2[2] + n5);
        if (n2 == 111) {
            byte[] byArray4 = new byte[12];
            byArray4[0] = 29;
            byArray4[1] = 104;
            byArray4[2] = -94;
            byArray4[3] = 29;
            byArray4[4] = 119;
            byArray4[5] = 3;
            byArray4[6] = 29;
            byArray4[7] = 107;
            byArray4[8] = 73;
            byte[] byArray5 = byArray4;
            if (n3 >= 1 && n3 <= 255) {
                byArray5[2] = (byte)n3;
            }
            if (n4 >= 2 && n4 <= 6) {
                byArray5[5] = (byte)n4;
            }
            byArray5[9] = (byte)(n + 2);
            byArray5[10] = 123;
            byArray5[11] = 66;
            byte[] byArray6 = PrnDspA1088.a(PrnDspA1088.a(PrnDspA1088.a(byArray2, byArray5), byArray), byArray3);
            if (this.d == null) {
                return this.a(byArray6, byArray6.length);
            }
            try {
                this.d.write(byArray6, 0, byArray6.length);
                return 0;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -5;
            }
        }
        byte[] byArray7 = new byte[]{29, 104, -94, 29, 119, 3, 29, 107, 1, 1};
        if (n3 >= 1 && n3 <= 255) {
            byArray7[2] = (byte)n3;
        }
        if (n4 >= 2 && n4 <= 6) {
            byArray7[5] = (byte)n4;
        }
        byArray7[9] = (byte)n;
        switch (n2) {
            case 103: 
            case 104: {
                byArray7[8] = 67;
                break;
            }
            case 105: 
            case 106: {
                byArray7[8] = 68;
                break;
            }
            case 107: {
                byArray7[8] = 69;
                break;
            }
            case 112: {
                byArray7[8] = 73;
            }
        }
        byte[] byArray8 = PrnDspA1088.a(PrnDspA1088.a(PrnDspA1088.a(byArray2, byArray7), byArray), byArray3);
        if (this.d == null) {
            return this.a(byArray8, byArray8.length);
        }
        try {
            this.d.write(byArray8, 0, byArray8.length);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_PrintBitmap(Bitmap bitmap, int n) {
        return this.PRN_PrintBitmap(bitmap, n, 0);
    }

    public int PRN_PrintBitmap(Bitmap bitmap, int n, int n2) {
        Bitmap bitmap2;
        int n3;
        if (this.d == null && (n3 = this.a()) != 0) {
            return n3;
        }
        if (n == 4) {
            n = 0;
        }
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        if (n4 > 832) {
            bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)832, (int)(bitmap.getHeight() * 832 / bitmap.getWidth()), (boolean)true);
            n4 = 832;
            n5 = bitmap2.getHeight();
        } else {
            bitmap2 = bitmap;
        }
        Log.i((String)this.w, (String)(String.valueOf(String.valueOf(n4)) + "*" + String.valueOf(n5)));
        int n6 = (n4 + 31) / 8 / 4 * 4 * 8;
        int n7 = n5;
        int n8 = n6 * n7 / 8 + 14;
        byte[] byArray = new byte[n8];
        byArray[0] = 27;
        byArray[1] = 97;
        byArray[2] = (byte)(48 + n2);
        byArray[3] = 29;
        byArray[4] = 118;
        byArray[5] = 48;
        byArray[6] = (byte)n;
        byArray[7] = (byte)(n6 / 8 % 256);
        byArray[8] = (byte)(n6 / 8 / 256);
        byArray[9] = (byte)(n7 % 256);
        byArray[10] = (byte)(n7 / 256);
        int n9 = 0;
        int[] nArray = new int[8];
        int n10 = 0;
        while (n10 < n7) {
            int n11 = 0;
            while (n11 < n6 / 8) {
                int n12 = 0;
                while (n12 < 8) {
                    int n13 = 8 * n11 + n12 < n4 ? bitmap2.getPixel(8 * n11 + n12, n10) : -1;
                    int n14 = Color.alpha((int)n13);
                    int n15 = Color.red((int)n13);
                    int n16 = Color.green((int)n13);
                    int n17 = Color.blue((int)n13);
                    nArray[n12] = n13 == -16777216 || n14 == 255 && n15 < 128 && n16 < 128 && n17 < 128 ? 1 : 0;
                    ++n12;
                }
                n9 = 11 + n6 / 8 * n10;
                byArray[n9 + n11] = (byte)(nArray[0] * 128 + nArray[1] * 64 + nArray[2] * 32 + nArray[3] * 16 + nArray[4] * 8 + nArray[5] * 4 + nArray[6] * 2 + nArray[7]);
                ++n11;
            }
            ++n10;
        }
        byArray[n8 - 3] = 27;
        byArray[n8 - 2] = 97;
        byArray[n8 - 1] = 48;
        if (this.d == null) {
            n3 = this.a(byArray, byArray.length);
            if (n3 == byArray.length) {
                return 0;
            }
            if (n3 > 0) {
                return -5;
            }
            return n3;
        }
        try {
            this.d.write(byArray, 0, byArray.length);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_PrintBMPFile(String string, int n) {
        block30: {
            int n2;
            if (this.d == null && (n2 = this.a()) != 0) {
                return n2;
            }
            switch (n) {
                case 4: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 4;
                }
            }
            if (n == 4) {
                n = 0;
            }
            File file = new File(string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return -8;
            }
            byte[] byArray = new byte[54];
            int n3 = 0;
            int n4 = 0;
            try {
                fileInputStream.read(byArray, 0, 54);
                if (byArray[28] == 1) {
                    int n5;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    n6 = byArray[18] >= 0 ? byArray[18] : 256 + byArray[18];
                    n7 = byArray[19] >= 0 ? byArray[19] : 256 + byArray[19];
                    n8 = byArray[20] >= 0 ? byArray[20] : 256 + byArray[20];
                    n9 = byArray[21] >= 0 ? byArray[21] : 256 + byArray[21];
                    n3 = (n9 << 24) + (n8 << 16) + (n7 << 8) + n6;
                    n6 = byArray[22] >= 0 ? byArray[22] : 256 + byArray[22];
                    n7 = byArray[23] >= 0 ? byArray[23] : 256 + byArray[23];
                    n8 = byArray[24] >= 0 ? byArray[24] : 256 + byArray[24];
                    n9 = byArray[25] >= 0 ? byArray[25] : 256 + byArray[25];
                    n4 = (n9 << 24) + (n8 << 16) + (n7 << 8) + n6;
                    Log.i((String)this.w, (String)(String.valueOf(String.valueOf(n3)) + "*" + String.valueOf(n4)));
                    int n10 = (n3 + 31) / 8 / 4 * 4 * 8;
                    int n11 = (n4 + 7) / 8 * 8;
                    int n12 = n10 * n11 / 8;
                    byte[] byArray2 = new byte[n12];
                    fileInputStream.read(byArray, 0, 8);
                    byte[] byArray3 = new byte[n10 / 8];
                    int n13 = 0;
                    while (n13 < n11) {
                        if (n13 < n4) {
                            fileInputStream.read(byArray3, 0, n10 / 8);
                            if (n3 % 8 == 0) {
                                n5 = 0;
                                while (n5 < n10 / 8 - n3 / 8) {
                                    byArray3[n3 / 8 + n5] = -1;
                                    ++n5;
                                }
                            } else {
                                n5 = 0;
                                while (n5 < n10 / 8 - n3 / 8 - 1) {
                                    byArray3[n3 / 8 + 1 + n5] = -1;
                                    ++n5;
                                }
                                byArray3[n3 / 8] = this.a(byArray3[n3 / 8], n3 % 8);
                            }
                        } else {
                            n5 = 0;
                            while (n5 < n10 / 8) {
                                byArray3[n5] = -1;
                                ++n5;
                            }
                        }
                        n5 = 0;
                        while (n5 < n10 / 8) {
                            byArray2[(n11 - n13 - 1) * (n10 / 8) + n5] = byArray3[n5];
                            ++n5;
                        }
                        ++n13;
                    }
                    fileInputStream.close();
                    n13 = n10 / 256;
                    n5 = n10 % 256;
                    int n14 = n13 * 256 + n5;
                    int n15 = n14 + 5;
                    byte[] byArray4 = new byte[n15];
                    byArray4[0] = 27;
                    byArray4[1] = 42;
                    byArray4[2] = (byte)n;
                    byArray4[3] = (byte)n5;
                    byArray4[4] = (byte)n13;
                    int n16 = 0;
                    while (n16 < n15 - 5) {
                        byArray4[5 + n16] = -1;
                        ++n16;
                    }
                    byte[] byArray5 = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    byte[] byArray6 = new byte[8];
                    int n26 = 0;
                    while (n26 < n11 / 8) {
                        int n27 = 0;
                        while (n27 < n14 / 8) {
                            int n28 = 0;
                            while (n28 < 8) {
                                byArray6[n28] = byArray2[(n26 * 8 + n28) * n10 / 8 + n27];
                                ++n28;
                            }
                            n28 = 0;
                            while (n28 < 8) {
                                int n29 = 0;
                                while (n29 < 8) {
                                    n17 = (byArray6[0] & byArray5[n28]) == 0 ? 1 : 0;
                                    n18 = (byArray6[1] & byArray5[n28]) == 0 ? 1 : 0;
                                    n19 = (byArray6[2] & byArray5[n28]) == 0 ? 1 : 0;
                                    n20 = (byArray6[3] & byArray5[n28]) == 0 ? 1 : 0;
                                    n21 = (byArray6[4] & byArray5[n28]) == 0 ? 1 : 0;
                                    n22 = (byArray6[5] & byArray5[n28]) == 0 ? 1 : 0;
                                    n23 = (byArray6[6] & byArray5[n28]) == 0 ? 1 : 0;
                                    n24 = (byArray6[7] & byArray5[n28]) == 0 ? 1 : 0;
                                    ++n29;
                                }
                                byArray4[5 + n25] = (byte)(n17 * 128 + n18 * 64 + n19 * 32 + n20 * 16 + n21 * 8 + n22 * 4 + n23 * 2 + n24);
                                ++n25;
                                ++n28;
                            }
                            ++n27;
                        }
                        if (this.d == null) {
                            n2 = this.a(byArray4, byArray4.length);
                        } else {
                            this.d.write(byArray4, 0, byArray4.length);
                        }
                        n25 = 0;
                        ++n26;
                    }
                    break block30;
                }
                fileInputStream.close();
                return -9;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -8;
            }
        }
        return 0;
    }

    public int PRN_PrintPNGFile(String string, int n) {
        return this.PRN_PrintPNGFile(string, n, 0);
    }

    public int PRN_PrintPNGFile(String string, int n, int n2) {
        int n3;
        if (this.d == null && (n3 = this.a()) != 0) {
            return n3;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        return this.PRN_PrintBitmap(bitmap, n, n2);
    }

    public String PRN_SetCodePage(String string) {
        this.K = string;
        return this.K;
    }

    public int PRN_SendData(byte[] byArray, int n) {
        if (this.d == null) {
            int n2 = this.a();
            if (n2 != 0) {
                return n2;
            }
            return this.a(byArray, n);
        }
        try {
            this.d.write(byArray, 0, n);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int PRN_ReadData(byte[] byArray, int n, int n2) {
        if (this.e == null) {
            int n3 = this.a();
            if (n3 != 0) {
                return n3;
            }
            return this.a(byArray, n, n2);
        }
        int n4 = 0;
        int n5 = n;
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        int n6 = 0;
        try {
            while (n4 < n5 && l3 - l2 <= (long)n2) {
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                n6 = this.e.available();
                if (n6 > n5 - n4) {
                    n6 = n5 - n4;
                }
                if (n6 > 0) {
                    n4 += this.e.read(byArray, n4, n6);
                }
                l3 = System.currentTimeMillis();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n4;
    }

    public int PRN_Status() {
        int n;
        if (this.d == null) {
            Log.i((String)this.w, (String)"USB Printer");
            n = this.a();
            if (n != 0) {
                return n;
            }
        } else {
            Log.i((String)this.w, (String)"COM Printer");
        }
        byte[] byArray = new byte[]{16, 4, 2, 16, 4, 4};
        if (this.d == null) {
            n = this.a(byArray, 6);
            if (n != 6) {
                return n;
            }
            n = this.a(byArray, 2, 500);
            if (n < 2) {
                return n;
            }
        } else {
            try {
                this.d.write(byArray, 0, 6);
                if (this.PRN_ReadData(byArray, 2, 1000) != 2) {
                    return -10;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -5;
            }
        }
        Log.i((String)this.w, (String)("PRN_Status:" + byArray[0] + "," + byArray[1]));
        n = 0;
        if ((byArray[0] & 4) != 0) {
            ++n;
        }
        if ((byArray[1] & 0x60) != 0) {
            n += 16;
        }
        return n;
    }

    public int PRN_CashboxStatus() {
        int n;
        if (this.d == null && (n = this.a()) != 0) {
            return n;
        }
        byte[] byArray = new byte[]{29, 114, 50};
        if (this.d == null) {
            n = this.a(byArray, 3);
            if (n != 6) {
                return n;
            }
            n = this.a(byArray, 1, 500);
            if (n < 1) {
                return n;
            }
        } else {
            try {
                this.d.write(byArray, 0, 3);
                if (this.PRN_ReadData(byArray, 1, 1000) != 1) {
                    return -10;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -5;
            }
        }
        Log.i((String)this.w, (String)("PRN_CashboxStatus:" + byArray[0]));
        n = 0;
        n = (byArray[0] & 1) != 0 ? 1 : 0;
        return n;
    }

    public int DSP_Open(String string, int n) {
        return this.DSP_Open(string, n, 1);
    }

    public int DSP_Open(String string, int n, int n2) {
        if (this.g != null) {
            try {
                this.g.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.h != null) {
            try {
                this.h.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.f != null) {
            this.f.Close();
        }
        if (string.equals("")) {
            string = "/dev/ttyS2";
        }
        if (n == 0) {
            n = 9600;
        }
        try {
            this.f = new zqcom(new File(string), n, 0);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return -7;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -3;
        }
        this.g = this.f.getOutputStream();
        this.h = this.f.getInputStream();
        this.o = n2;
        Log.v((String)this.w, (String)("Display Mode:" + n2));
        return 0;
    }

    public int DSP_DisplayString(String string) {
        byte[] byArray = string.getBytes();
        if (this.g == null) {
            return -12;
        }
        try {
            if (this.o == 3) {
                byte[] byArray2 = new byte[byArray.length + 4];
                byArray2[0] = 27;
                byArray2[1] = 81;
                byArray2[2] = 65;
                System.arraycopy(byArray, 0, byArray2, 3, byArray.length);
                byArray2[byArray.length + 3] = 13;
                this.g.write(byArray2, 0, byArray2.length);
            } else {
                this.g.write(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
        return 0;
    }

    public int DSP_Clear() {
        byte[] byArray = new byte[]{12};
        if (this.g == null) {
            return -12;
        }
        try {
            this.g.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
        return 0;
    }

    public int DSP_LED_SetStatus(int n) {
        if (this.o != 0 && this.o != 3) {
            return -6;
        }
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 115;
        byte[] byArray2 = byArray;
        byArray2[2] = (byte)n;
        if (this.g == null) {
            return -12;
        }
        try {
            this.g.write(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
        return 0;
    }

    public int DSP_SendData(byte[] byArray, int n) {
        if (this.g == null) {
            return -12;
        }
        try {
            this.g.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
        return 0;
    }

    public int DSP_GetDallasKey(byte[] byArray) {
        if (this.h == null) {
            return -12;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        try {
            while (n < n2 && (l3 - l2 <= 300L || bl)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                n3 = this.h.available();
                if (n3 > n2 - n) {
                    n3 = n2 - n;
                }
                if (n3 > 0) {
                    n += this.h.read(byArray, n, n3);
                    bl = true;
                } else {
                    bl = false;
                }
                l3 = System.currentTimeMillis();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public int DSP_Close() {
        if (this.g != null) {
            try {
                this.g.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.f != null) {
            this.f.Close();
        }
        return 0;
    }

    public int COM_Open(String string, int n) {
        return this.COM_Open(string, n, 0);
    }

    public int COM_Open(String string, int n, int n2) {
        if (this.j != null) {
            try {
                this.j.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.k != null) {
            try {
                this.k.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string.equals("")) {
            string = "/dev/ttyS3";
        }
        if (n == 0) {
            n = 9600;
        }
        try {
            this.i = new zqcom(new File(string), n, n2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return -7;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -2;
        }
        this.j = this.i.getOutputStream();
        this.k = this.i.getInputStream();
        return 0;
    }

    public int COM_SendData(byte[] byArray, int n) {
        if (this.j == null) {
            return -12;
        }
        try {
            this.j.write(byArray, 0, n);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int COM_ReadData(byte[] byArray, int n, int n2) {
        if (this.k == null) {
            return -12;
        }
        int n3 = 0;
        int n4 = n;
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        int n5 = 0;
        boolean bl = false;
        try {
            while (n3 < n4 && (l3 - l2 <= (long)n2 || bl)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                n5 = this.k.available();
                if (n5 > n4 - n3) {
                    n5 = n4 - n3;
                }
                if (n5 > 0) {
                    n3 += this.k.read(byArray, n3, n5);
                    bl = true;
                } else {
                    bl = false;
                }
                l3 = System.currentTimeMillis();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public int COM_Clear() {
        if (this.k == null) {
            return -12;
        }
        try {
            int n = this.k.available();
            byte[] byArray = new byte[n];
            int n2 = this.k.read(byArray, 0, n);
            String string = String.format("COM_Clear(Len=%d):", n2);
            int n3 = 0;
            while (n3 < n2) {
                string = String.valueOf(string) + String.format("%x,", byArray[n3]);
                ++n3;
            }
            Log.v((String)this.w, (String)string);
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public int COM_Close() {
        if (this.j != null) {
            try {
                this.j.close();
                this.j = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.k != null) {
            try {
                this.k.close();
                this.k = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.i != null) {
            this.i.Close();
            this.i = null;
        }
        return 0;
    }

    public int GPIO_OpenCashBox(int n, int n2) {
        try {
            if (!this.J) {
                Gpio.gpioInt(this.L, "out");
                this.J = true;
            }
            Gpio.set(String.format("gpio%d", this.L), 49);
            Thread.sleep(n);
            Gpio.set(String.format("gpio%d", this.L), 48);
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return 0;
    }

    public int GPIO_CashBoxStatus() {
        if (this.M <= 0) {
            return -1;
        }
        if (Gpio.get(String.format("gpio%d", this.M)) == 1) {
            return 1;
        }
        return 0;
    }

    public int GPIO_SetCashBoxPort(int n, int n2) {
        this.L = n;
        this.M = n2;
        return 0;
    }

    public int CRT_Open(String string, int n) {
        return this.CRT_Open(string, n, 0);
    }

    public int CRT_Open(String string, int n, int n2) {
        if (this.E != null) {
            try {
                this.E.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.F != null) {
            try {
                this.F.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string.equals("")) {
            string = "/dev/ttyS1";
        }
        if (n == 0) {
            n = 9600;
        }
        try {
            this.D = new zqcom(new File(string), n, n2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return -7;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -2;
        }
        this.E = this.D.getOutputStream();
        this.F = this.D.getInputStream();
        return 0;
    }

    public int CRT_SendData(byte[] byArray, int n) {
        if (this.E == null) {
            return -12;
        }
        try {
            this.E.write(byArray, 0, n);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int CRT_ReadData(byte[] byArray, int n, int n2) {
        if (this.F == null) {
            return -12;
        }
        int n3 = 0;
        int n4 = n;
        long l2 = System.currentTimeMillis();
        long l3 = -1L;
        long l4 = System.currentTimeMillis();
        int n5 = 0;
        try {
            while (n3 < n4 && l4 - l2 <= (long)n2) {
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                n5 = this.F.available();
                if (n5 > n4 - n3) {
                    n5 = n4 - n3;
                }
                if (n5 > 0) {
                    n3 += this.F.read(byArray, n3, n5);
                    l3 = System.currentTimeMillis();
                }
                l4 = System.currentTimeMillis();
                if (l3 == -1L || l4 - l3 <= 500L) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public int CRT_Close() {
        if (this.E != null) {
            try {
                this.E.close();
                this.E = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.F != null) {
            try {
                this.F.close();
                this.F = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return 0;
    }

    public int[] CRT_Status() {
        int[] nArray = new int[]{-12, -1, -1};
        if (this.E == null) {
            return nArray;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 2;
        byArray[2] = 2;
        byArray[3] = 49;
        byArray[4] = 48;
        byArray[5] = 3;
        byArray[6] = 2;
        byte[] byArray2 = byArray;
        nArray[0] = this.CRT_SendData(byArray2, 7);
        if (nArray[0] != 0) {
            return nArray;
        }
        byte[] byArray3 = new byte[10];
        int n = this.CRT_ReadData(byArray3, 1, 1000);
        if (n > 0 && byArray3[0] == 6) {
            byArray2[0] = 5;
            nArray[0] = this.CRT_SendData(byArray2, 1);
            if (nArray[0] != 0) {
                return nArray;
            }
            n = this.CRT_ReadData(byArray3, 10, 500);
            if (n == 10) {
                nArray[0] = byArray3[5];
                nArray[1] = byArray3[6];
                nArray[2] = byArray3[7];
            } else {
                nArray[0] = -14;
                nArray[1] = n;
            }
        } else {
            nArray[0] = -14;
            nArray[1] = n;
            nArray[2] = byArray3[0];
        }
        return nArray;
    }

    public int CRT_Reset() {
        if (this.E == null) {
            return -12;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 2;
        byArray[2] = 2;
        byArray[3] = 48;
        byArray[4] = 48;
        byArray[5] = 3;
        byArray[6] = 3;
        byte[] byArray2 = byArray;
        int n = this.CRT_SendData(byArray2, 7);
        if (n != 0) {
            return n;
        }
        byte[] byArray3 = new byte[20];
        n = this.CRT_ReadData(byArray3, 1, 500);
        if (n > 0 && byArray3[0] == 6) {
            byArray2[0] = 5;
            n = this.CRT_SendData(byArray2, 1);
            if (n != 0) {
                return n;
            }
            n = this.CRT_ReadData(byArray3, 14, 1000);
            if (n > 0) {
                String string = "CRT SV:";
                int n2 = 5;
                while (n2 < n - 2) {
                    string = String.valueOf(string) + String.format("%c", byArray3[n2]);
                    ++n2;
                }
                Log.v((String)this.w, (String)string);
                return 0;
            }
            return -10;
        }
        return -10;
    }

    public int CRT_Setup(int n, int n2) {
        if (this.E == null) {
            return -12;
        }
        if (n != 48 && n != 49 || n2 < 49 || n2 > 55) {
            return -6;
        }
        byte[] byArray = new byte[9];
        byArray[0] = 2;
        byArray[2] = 4;
        byArray[3] = 50;
        byArray[4] = 48;
        byArray[7] = 3;
        byte[] byArray2 = byArray;
        byArray2[5] = (byte)n;
        byArray2[6] = (byte)n2;
        byArray2[8] = this.b(byArray2, 8);
        int n3 = this.CRT_SendData(byArray2, 9);
        if (n3 != 0) {
            return n3;
        }
        byte[] byArray3 = new byte[20];
        n3 = this.CRT_ReadData(byArray3, 1, 500);
        if (n3 > 0 && byArray3[0] == 6) {
            byArray2[0] = 5;
            n3 = this.CRT_SendData(byArray2, 1);
            if (n3 != 0) {
                return n3;
            }
            n3 = this.CRT_ReadData(byArray3, 8, 500);
            if (n3 == 8) {
                if (byArray3[5] == 89) {
                    return 0;
                }
                return -13;
            }
            return -10;
        }
        return -10;
    }

    public int CRT_SetBaudrate(int n) {
        if (this.E == null) {
            return -12;
        }
        if (n != 2400 && n != 4800 && n != 9600 && n != 19200 && n != 38400 && (n < 49 || n > 53)) {
            return -6;
        }
        byte[] byArray = new byte[8];
        byArray[0] = 2;
        byArray[2] = 3;
        byArray[3] = 70;
        byArray[4] = 48;
        byArray[6] = 3;
        byte[] byArray2 = byArray;
        byArray2[5] = (byte)n;
        if (n == 2400) {
            byArray2[5] = 49;
        } else if (n == 4800) {
            byArray2[5] = 50;
        } else if (n == 9600) {
            byArray2[5] = 51;
        } else if (n == 19200) {
            byArray2[5] = 52;
        } else if (n == 38400) {
            byArray2[5] = 53;
        }
        byArray2[7] = this.b(byArray2, 7);
        int n2 = this.CRT_SendData(byArray2, 8);
        if (n2 != 0) {
            return n2;
        }
        byte[] byArray3 = new byte[20];
        n2 = this.CRT_ReadData(byArray3, 1, 500);
        if (n2 > 0 && byArray3[0] == 6) {
            byArray2[0] = 5;
            n2 = this.CRT_SendData(byArray2, 1);
            if (n2 != 0) {
                return n2;
            }
            n2 = this.CRT_ReadData(byArray3, 8, 500);
            if (n2 == 8) {
                if (byArray3[5] == 89) {
                    return 0;
                }
                return -13;
            }
            return -10;
        }
        return -10;
    }

    public int CRT_SWP(int n) {
        if (this.E == null) {
            return -12;
        }
        if (n != 49 && n != 50 && n != 48) {
            return -6;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 2;
        byArray[2] = 2;
        byArray[3] = 51;
        byArray[4] = 48;
        byArray[5] = 3;
        byte[] byArray2 = byArray;
        if (n == 50) {
            byArray2[4] = 49;
            byArray2[6] = 1;
        } else if (n == 48) {
            byArray2[3] = 52;
            byArray2[4] = 48;
            byArray2[6] = 7;
        }
        int n2 = this.CRT_SendData(byArray2, 7);
        if (n2 != 0) {
            return n2;
        }
        byte[] byArray3 = new byte[2048];
        n2 = this.CRT_ReadData(byArray3, 1, 500);
        if (n2 > 1) {
            String string = "CRT_SWP ReadData:";
            int n3 = 0;
            while (n3 < n2) {
                string = String.valueOf(string) + String.format("%x,", byArray3[n3]);
                ++n3;
            }
            Log.v((String)this.w, (String)string);
        }
        if (n2 > 0 && byArray3[0] == 6) {
            byArray2[0] = 5;
            n2 = this.CRT_SendData(byArray2, 1);
            if (n2 != 0) {
                return n2;
            }
            if (n == 49 || n == 50) {
                return 0;
            }
            n2 = this.CRT_ReadData(byArray3, 8, 500);
            if (n2 == 8) {
                if (byArray3[5] == 89) {
                    return 0;
                }
                return -13;
            }
            return -10;
        }
        return -10;
    }

    public byte[] CRT_GetSWPData(int n) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2048];
        int n2 = this.CRT_ReadData(byArray2, 2048, n);
        if (n2 > 0) {
            int n3 = Integer.parseInt(String.format("%x%x", byArray2[1], byArray2[2]), 16);
            if (n2 != n3 + 5) {
                byArray[0] = -14;
                byArray[1] = (byte)n2;
                return byArray;
            }
            byte[] byArray3 = new byte[n3 - 2];
            int n4 = 0;
            while (n4 < n3 - 2) {
                byArray3[n4] = byArray2[n4 + 5];
                ++n4;
            }
            return byArray3;
        }
        byArray[0] = -10;
        return byArray;
    }

    public byte[] CRT_Resend(int n) {
        byte[] byArray = new byte[1];
        if (this.E == null) {
            byArray[0] = -12;
            return byArray;
        }
        byte[] byArray2 = new byte[8];
        byArray2[0] = 2;
        byArray2[2] = 3;
        byArray2[3] = 69;
        byArray2[4] = 48;
        byArray2[6] = 3;
        byArray2[7] = 119;
        byte[] byArray3 = byArray2;
        int n2 = this.CRT_SendData(byArray3, 8);
        if (n2 != 0) {
            byArray[0] = (byte)n2;
            return byArray;
        }
        byte[] byArray4 = new byte[20];
        n2 = this.CRT_ReadData(byArray4, 1, 500);
        if (n2 > 0 && byArray4[0] == 6) {
            byArray3[0] = 5;
            n2 = this.CRT_SendData(byArray3, 1);
            if (n2 != 0) {
                byArray[0] = (byte)n2;
                return byArray;
            }
            byte[] byArray5 = new byte[2048];
            n2 = this.CRT_ReadData(byArray5, 2048, n);
            if (n2 > 0) {
                int n3 = Integer.parseInt(String.format("%x%x", byArray5[1], byArray5[2]), 16);
                if (n2 != n3 + 5) {
                    byArray[0] = -10;
                    return byArray;
                }
                byte[] byArray6 = new byte[n3 - 2];
                int n4 = 0;
                while (n4 < n3 - 2) {
                    byArray6[n4] = byArray5[n4 + 5];
                    ++n4;
                }
                return byArray6;
            }
            byArray[0] = -10;
            return byArray;
        }
        byArray[0] = -10;
        return byArray;
    }

    public byte[] CRT_GetTrack1(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            if (byArray[n4] == -128) {
                n2 = n4;
            } else if ((byArray[n4] == -127 || byArray[n4] == -126) && n2 != -1) {
                n3 = n4 - 1;
                break;
            }
            ++n4;
        }
        if (n3 == -1) {
            n3 = n - 1;
        }
        if (n2 != -1 && n3 != -1) {
            n4 = n3 - n2 + 1;
            byArray2 = new byte[n4];
            int n5 = 0;
            while (n5 < n4) {
                byArray2[n5] = byArray[n5 + n2];
                ++n5;
            }
        }
        return byArray2;
    }

    public byte[] CRT_GetTrack2(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            if (byArray[n4] == -127) {
                n2 = n4;
            } else if ((byArray[n4] == -128 || byArray[n4] == -126) && n2 != -1) {
                n3 = n4 - 1;
                break;
            }
            ++n4;
        }
        if (n3 == -1) {
            n3 = n - 1;
        }
        if (n2 != -1 && n3 != -1) {
            n4 = n3 - n2 + 1;
            byArray2 = new byte[n4];
            int n5 = 0;
            while (n5 < n4) {
                byArray2[n5] = byArray[n5 + n2];
                ++n5;
            }
        }
        return byArray2;
    }

    public byte[] CRT_GetTrack3(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            if (byArray[n4] == -126) {
                n2 = n4;
            } else if ((byArray[n4] == -128 || byArray[n4] == -127) && n2 != -1) {
                n3 = n4 - 1;
                break;
            }
            ++n4;
        }
        if (n3 == -1) {
            n3 = n - 1;
        }
        if (n2 != -1 && n3 != -1) {
            n4 = n3 - n2 + 1;
            byArray2 = new byte[n4];
            int n5 = 0;
            while (n5 < n4) {
                byArray2[n5] = byArray[n5 + n2];
                ++n5;
            }
        }
        return byArray2;
    }

    private byte b(byte[] byArray, int n) {
        byte by = byArray[0];
        int n2 = 1;
        while (n2 < n) {
            by = (byte)(by ^ byArray[n2]);
            ++n2;
        }
        return by;
    }

    public int RF610_Open(String string, int n) {
        return this.RF610_Open(string, n, 0);
    }

    public int RF610_Open(String string, int n, int n2) {
        if (this.m != null) {
            try {
                this.m.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.n != null) {
            try {
                this.n.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string.equals("")) {
            string = "/dev/ttyS1";
        }
        if (n == 0) {
            n = 9600;
        }
        try {
            this.l = new zqcom(new File(string), n, n2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return -7;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -2;
        }
        this.m = this.l.getOutputStream();
        this.n = this.l.getInputStream();
        return 0;
    }

    public int RF610_SendData(byte[] byArray, int n) {
        if (this.m == null) {
            return -12;
        }
        try {
            this.m.write(byArray, 0, n);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -5;
        }
    }

    public int RF610_ReadData(byte[] byArray, int n, int n2) {
        if (this.n == null) {
            return -12;
        }
        int n3 = 0;
        int n4 = n;
        long l2 = System.currentTimeMillis();
        long l3 = -1L;
        long l4 = System.currentTimeMillis();
        int n5 = 0;
        try {
            while (n3 < n4 && l4 - l2 <= (long)n2) {
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                n5 = this.n.available();
                if (n5 > n4 - n3) {
                    n5 = n4 - n3;
                }
                if (n5 > 0) {
                    n3 += this.n.read(byArray, n3, n5);
                    l3 = System.currentTimeMillis();
                }
                l4 = System.currentTimeMillis();
                if (l3 == -1L || l4 - l3 <= 500L) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public String RF610_GetCardNo() {
        if (this.m == null) {
            return String.format("%d", -12);
        }
        byte[] byArray = new byte[7];
        byArray[0] = 2;
        byArray[2] = 2;
        byArray[3] = 59;
        byArray[4] = 48;
        byArray[5] = 3;
        byArray[6] = 8;
        byte[] byArray2 = byArray;
        int n = this.RF610_SendData(byArray2, 7);
        if (n != 0) {
            return String.format("%d", n);
        }
        byte[] byArray3 = new byte[20];
        n = this.RF610_ReadData(byArray3, 1, 500);
        if (n > 0 && byArray3[0] == 6) {
            byArray2[0] = 5;
            n = this.RF610_SendData(byArray2, 1);
            if (n != 0) {
                return String.format("%d", n);
            }
            n = this.RF610_ReadData(byArray3, 9, 500);
            if (n == 8) {
                if (byArray3[3] == 80) {
                    byArray2[0] = 2;
                    byArray2[1] = 0;
                    byArray2[2] = 2;
                    byArray2[3] = 59;
                    byArray2[4] = 49;
                    byArray2[5] = 3;
                    byArray2[6] = 9;
                    n = this.RF610_SendData(byArray2, 7);
                    if (n != 0) {
                        return String.format("%d", n);
                    }
                    n = this.RF610_ReadData(byArray3, 1, 500);
                    if (n > 0 && byArray3[0] == 6) {
                        byArray2[0] = 5;
                        n = this.RF610_SendData(byArray2, 1);
                        if (n != 0) {
                            return String.format("%d", n);
                        }
                        n = this.RF610_ReadData(byArray3, 12, 500);
                        if (n == 12) {
                            return String.format("%x%x%x%x", byArray3[6], byArray3[7], byArray3[8], byArray3[9]);
                        }
                        return String.format("%d", -13);
                    }
                    return String.format("%d", -13);
                }
                return String.format("%d", -13);
            }
            if (n == 9) {
                return String.format("%d", -13);
            }
            return String.format("%d", -10);
        }
        return String.format("%d", -10);
    }

    public int RF610_Clear() {
        if (this.n == null) {
            return -12;
        }
        try {
            int n = this.n.available();
            byte[] byArray = new byte[n];
            int n2 = this.n.read(byArray, 0, n);
            String string = String.format("RF610_Clear(Len=%d):", n2);
            int n3 = 0;
            while (n3 < n2) {
                string = String.valueOf(string) + String.format("%x,", byArray[n3]);
                ++n3;
            }
            Log.v((String)this.w, (String)string);
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public int RF610_Close() {
        if (this.m != null) {
            try {
                this.m.close();
                this.m = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.n != null) {
            try {
                this.n.close();
                this.n = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return 0;
    }

    public boolean SaveUSBToFile(boolean bl) {
        if (this.y != bl) {
            this.y = bl;
            return true;
        }
        return false;
    }

    public boolean AutoAddZeroToUSB(boolean bl) {
        if (this.z != bl) {
            this.z = bl;
            return true;
        }
        return false;
    }

    public boolean EnableUSBEveryTime(boolean bl) {
        this.q = null;
        if (this.A != bl) {
            this.A = bl;
            return true;
        }
        return false;
    }

    public boolean SetUSBSendOneByOne(boolean bl) {
        this.B = bl;
        return true;
    }

    public boolean SetUSBTimeout(int n) {
        this.C = n;
        return true;
    }

    public boolean SetUSBPIDVID(int n, int n2) {
        this.N = n;
        this.O = n2;
        return true;
    }

    public String SDK_Version() {
        return "V1.35";
    }

    private byte a(byte by, int n) {
        byte[] byArray = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        int[] nArray = new int[8];
        byte by2 = 0;
        while (by2 < 8) {
            nArray[by2] = by2 < n ? ((by & byArray[by2]) == 1 ? 0 : 1) : 1;
            ++by2;
        }
        by2 = 0;
        int n2 = 0;
        while (n2 < 8) {
            by2 = (byte)(by2 + nArray[n2] * byArray[n2]);
            ++n2;
        }
        return by2;
    }

    private static byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static /* synthetic */ int a(PrnDspA1088 prnDspA1088) {
        return prnDspA1088.a();
    }
}

