/*
 * Decompiled with CFR 0.152.
 */
package com.imin.printerlib.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Matrix;
import android.media.ThumbnailUtils;
import android.os.Environment;
import android.util.Log;
import androidx.core.content.ContextCompat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class BmpUtils {
    public static final String TAG = "IminPrintUtils_bit";
    public static String filename = "sdcard/print_img.bmp";
    public Context mContext;

    public BmpUtils(Context context) {
        this.mContext = context;
    }

    public static Bitmap changeBmpBitCount(Bitmap bitmap) {
        FileInputStream fileInputStream;
        BmpUtils.changeBmpBitCountToFile(bitmap);
        bitmap = null;
        FileInputStream fileInputStream2 = fileInputStream;
        try {
            fileInputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            fileInputStream2 = bitmap;
        }
        bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream2);
        if (bitmap == null) {
            return null;
        }
        return bitmap;
    }

    public static Bitmap byteToBitmap(byte[] object) {
        ByteArrayInputStream byteArrayInputStream;
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inSampleSize = 1;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = new SoftReference<Bitmap>(BitmapFactory.decodeStream((InputStream)byteArrayInputStream2, null, (BitmapFactory.Options)options2)).get();
        try {
            ((InputStream)byteArrayInputStream2).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    public static void changeBmpBitCountToFile(Bitmap var0) {
        block15: {
            if (var0 == null) {
                Log.e((String)"IminPrintUtils_bit", (String)"mBitmapSrc is null");
                return;
            }
            var1_4 = BmpUtils.alterSizeBitmap(var0);
            if (var1_4 != null) {
                Log.e((String)"IminPrintUtils_bit", (String)("mBitmapSrcNew.isMutable():" + var1_4.isMutable()));
            } else {
                Log.e((String)"IminPrintUtils_bit", (String)"mBitmapSrcNew is null");
                var1_4 = var0;
            }
            v0 = var1_4;
            var0_1 = v0.getWidth();
            var1_5 = v0.getHeight();
            v1 = var1_5 * var0_1;
            var2_6 = v1 / 8;
            Log.e((String)"IminPrintUtils_bit", (String)("width*height:" + var0_1 + "*" + var1_5));
            Log.e((String)"IminPrintUtils_bit", (String)("bufferSize:" + var2_6));
            Log.e((String)"IminPrintUtils_bit", (String)("filename:" + BmpUtils.filename));
            var3_7 = new int[v1];
            v0.getPixels(var3_7, 0, var0_1, 0, 0, var0_1, var1_5);
            var4_8 = v2;
            if (new File(BmpUtils.filename).exists()) break block15;
            v3 = var4_8.createNewFile();
lbl31:
            // 2 sources

            while (true) {
                continue;
                break;
            }
        }
        v4 = var4_8;
        v5 = v4;
        v4.delete();
        v3 = v5.createNewFile();
        ** continue;
        var4_9 = v3;
        Log.d((String)"IminPrintUtils_bit", (String)("create file:" + var4_9));
        var4_10 = v6;
        v7 = var0_1;
        v8 = var1_5;
        v9 = var3_7;
        v10 = var4_10;
        v11 = v10;
        v12 = v10;
        v13 = var0_1;
        v14 = var1_5;
        v15 = var4_10;
        v16 = v15;
        v15(BmpUtils.filename);
        try {
            v16.write(BmpUtils.getBitmapHeader(62, var2_6 + 62));
            v11.write(BmpUtils.getBitmapInfoHeader(v13, v14));
            v12.write(new byte[]{-1, -1, -1, 0, 0, 0, 0, 0});
            v6.write(BmpUtils.rgbToGrayData(v7, v8, v9));
            v6.flush();
            v6.close();
        }
        catch (IOException var0_2) {
            Log.d((String)"IminPrintUtils_bit", (String)("" + var0_2.toString()));
        }
        catch (FileNotFoundException var0_3) {
            Log.d((String)"IminPrintUtils_bit", (String)("" + var0_3.toString()));
        }
    }

    private int ROUND_UP(int n2, int n3) {
        int n4 = n3 - 1;
        return n2 + n4 & ~n4;
    }

    public static int ROUND_DOWN(int n2, int n3) {
        return n2 & ~(n3 - 1);
    }

    public static Bitmap alterSizeBitmap(Bitmap bitmap) {
        Matrix matrix;
        int n2 = bitmap.getWidth();
        int n3 = n2 % 8;
        if (n3 == 0) {
            n3 = 8;
        }
        if (n3 == 8) {
            Log.e((String)TAG, (String)"don't need change size");
            return null;
        }
        Bitmap bitmap2 = bitmap;
        n2 = BmpUtils.ROUND_DOWN(n2, 8);
        Log.e((String)TAG, (String)("newWidth:" + n2));
        float f2 = (float)n2 / (float)bitmap.getWidth();
        float f3 = (float)bitmap2.getHeight() / (float)bitmap.getHeight();
        Log.e((String)TAG, (String)("scaleWidth:" + f2 + "scaleHeight:" + f3));
        Matrix matrix2 = matrix;
        matrix2();
        matrix.postScale(f2, f3);
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix2, (boolean)true);
    }

    public static byte RGB2Gray(int n2, int n3, int n4) {
        return (int)((double)n2 * 0.299 + (double)n3 * 0.587 + (double)n4 * 0.114) < 200 ? (byte)1 : 0;
    }

    public static byte[] writeInt(int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n2 & 0xFF);
        byArray2[1] = (byte)(n2 >> 8 & 0xFF);
        byArray2[2] = (byte)(n2 >> 16 & 0xFF);
        byArray[3] = (byte)(n2 >> 24 & 0xFF);
        return byArray;
    }

    private byte[] writeShort(int n2) {
        return new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
    }

    public static byte[] getBitmapHeader(int n2, int n3) {
        byte[] byArray;
        byte[] byArray2 = new byte[14];
        byte[] byArray3 = byArray = byArray2;
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[2] = (byte)(n3 & 0xFF);
        byArray[3] = (byte)(n3 >> 8 & 0xFF);
        byArray[4] = (byte)(n3 >> 16 & 0xFF);
        byArray3[5] = (byte)(n3 >> 24 & 0xFF);
        byArray3[6] = 0;
        byArray3[7] = 0;
        byArray3[8] = 0;
        byArray[9] = 0;
        byArray[10] = (byte)(n2 & 0xFF);
        byArray[11] = (byte)(n2 >> 8 & 0xFF);
        byArray[12] = (byte)(n2 >> 16 & 0xFF);
        byArray2[13] = (byte)(n2 >> 24 & 0xFF);
        return byArray2;
    }

    public static byte[] getBitmapInfoHeader(int n2, int n3) {
        byte[] byArray = new byte[40];
        int n4 = n2;
        byte[] byArray2 = BmpUtils.writeInt(40);
        n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        byte[] byArray3 = BmpUtils.writeInt(n4);
        n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray, 4, n2);
        byte[] byArray4 = BmpUtils.writeInt(n3);
        n2 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray, 8, n2);
        byte[] byArray5 = BmpUtils.writeInt(1);
        n2 = byArray5.length;
        System.arraycopy(byArray5, 0, byArray, 12, n2);
        byte[] byArray6 = BmpUtils.writeInt(1);
        n2 = byArray6.length;
        System.arraycopy(byArray6, 0, byArray, 14, n2);
        byte[] byArray7 = BmpUtils.writeInt(0);
        n2 = byArray7.length;
        System.arraycopy(byArray7, 0, byArray, 16, n2);
        byte[] byArray8 = BmpUtils.writeInt(0);
        n2 = byArray8.length;
        System.arraycopy(byArray8, 0, byArray, 20, n2);
        byte[] byArray9 = BmpUtils.writeInt(0);
        n2 = byArray9.length;
        System.arraycopy(byArray9, 0, byArray, 24, n2);
        byte[] byArray10 = BmpUtils.writeInt(0);
        n2 = byArray10.length;
        System.arraycopy(byArray10, 0, byArray, 28, n2);
        byte[] byArray11 = BmpUtils.writeInt(0);
        n2 = byArray11.length;
        System.arraycopy(byArray11, 0, byArray, 32, n2);
        byte[] byArray12 = BmpUtils.writeInt(0);
        n2 = byArray12.length;
        System.arraycopy(byArray12, 0, byArray, 36, n2);
        return byArray;
    }

    public static byte[] rgbToGrayData(int n2, int n3, int[] nArray) {
        int n4 = n2 / 8;
        Log.d((String)TAG, (String)("b:" + n4));
        byte[] byArray = new byte[n4 * n3];
        n4 = n3 - 1;
        int n5 = 0;
        while (n4 >= 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n6;
                int n7 = nArray[n2 * n4 + i2];
                int n8 = n6 = n7;
                n6 = (n8 & 0xFF00) >> 8;
                n6 = BmpUtils.RGB2Gray((n7 & 0xFF0000) >> 16, n6, n8 & 0xFF);
                int n9 = n2 * n5 + i2;
                int n10 = n9 / 8;
                byArray[n10] = (byte)(byArray[n10] | n6 << 7 - n9 % 8);
            }
            --n4;
            ++n5;
        }
        return byArray;
    }

    public static byte[] printDiskAlphaImagefile(int[] nArray, int n2, int n3) {
        byte[] byArray;
        int n4 = n2;
        n2 = n4 / 8;
        int n5 = n4 % 8;
        if (n5 > 0) {
            ++n2;
        }
        byte[] byArray2 = new byte[n2 * n3 + 8];
        byte[] byArray3 = byArray = byArray2;
        byte[] byArray4 = byArray;
        byArray3[0] = 29;
        byArray4[1] = 118;
        byArray3[2] = 48;
        byArray4[3] = 0;
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)n3;
        int n6 = 8;
        byArray2[7] = (byte)(n3 >> 8);
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n2 - 1; ++n9) {
                n8 = 0;
                if (nArray[n7++] < -1) {
                    n8 = 128;
                }
                if (nArray[n7++] < -1) {
                    n8 += 64;
                }
                if (nArray[n7++] < -1) {
                    n8 += 32;
                }
                if (nArray[n7++] < -1) {
                    n8 += 16;
                }
                if (nArray[n7++] < -1) {
                    n8 += 8;
                }
                if (nArray[n7++] < -1) {
                    n8 += 4;
                }
                if (nArray[n7++] < -1) {
                    n8 += 2;
                }
                if (nArray[n7++] < -1) {
                    // empty if block
                }
                int n10 = ++n8;
                n8 = n6 + 1;
                byArray[n6] = (byte)n10;
                n6 = n8;
            }
            n9 = 0;
            if (n5 == 0) {
                for (n8 = 8; n8 > n5; --n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << n8;
                }
            } else {
                for (n8 = 0; n8 < n5; ++n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << 8 - n8;
                }
            }
            int n11 = n9;
            n9 = n6 + 1;
            byArray[n6] = (byte)n11;
            n6 = n9;
        }
        return byArray;
    }

    public static byte[] printDiskImagefile(int[] nArray, int n2, int n3) {
        byte[] byArray;
        int n4 = n2;
        n2 = n4 / 8;
        int n5 = n4 % 8;
        if (n5 > 0) {
            ++n2;
        }
        byte[] byArray2 = new byte[n2 * n3 + 8];
        byte[] byArray3 = byArray = byArray2;
        byte[] byArray4 = byArray;
        byArray3[0] = 29;
        byArray4[1] = 118;
        byArray3[2] = 48;
        byArray4[3] = 0;
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)n3;
        int n6 = 8;
        byArray2[7] = (byte)(n3 >> 8);
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n2 - 1; ++n9) {
                n8 = 0;
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 = 128;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 += 64;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 += 32;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 += 16;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 += 8;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 += 4;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    n8 += 2;
                }
                if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) == 1) {
                    // empty if block
                }
                int n10 = ++n8;
                n8 = n6 + 1;
                byArray[n6] = (byte)n10;
                n6 = n8;
            }
            n9 = 0;
            if (n5 == 0) {
                for (n8 = 8; n8 > n5; --n8) {
                    if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) != 1) continue;
                    n9 += 1 << n8;
                }
            } else {
                for (n8 = 0; n8 < n5; ++n8) {
                    if (BmpUtils.getPixelBlackWhiteValue(nArray[n7++]) != 1) continue;
                    n9 += 1 << 8 - n8;
                }
            }
            int n11 = n9;
            n9 = n6 + 1;
            byArray[n6] = (byte)n11;
            n6 = n9;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPixelBlackWhiteValue(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2;
        n2 = n4 >> 16 & 0xFF;
        int n5 = n4 >> 8 & 0xFF;
        int n6 = n4 & 0xFF;
        if (n3 == 0) {
            return 0;
        }
        if ((int)((double)n2 * 0.3 + (double)n5 * 0.59 + (double)n6 * 0.11) <= 180) return 1;
        return 0;
    }

    public static void checkLegality(int n2) throws IllegalArgumentException {
        if (n2 >= 0 && n2 <= 255) {
            return;
        }
        throw new IllegalArgumentException("Parameter invalid " + n2);
    }

    public static int[] getPixelsByBitmap(Bitmap bitmap) {
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int[] nArray = new int[n2 * n3];
        bitmap.getPixels(nArray, 0, n2, 0, 0, n2, n3);
        return nArray;
    }

    public static ArrayList<Bitmap> cutBitmap(int n2, Bitmap bitmap) {
        ArrayList<Bitmap> arrayList;
        Bitmap bitmap2 = bitmap;
        int n3 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        int n5 = n4 % n2;
        boolean bl = n5 == 0;
        n5 = n5 == 0 ? n4 / n2 : n4 / n2 + 1;
        ArrayList<Bitmap> arrayList2 = arrayList;
        arrayList = new ArrayList<Bitmap>();
        for (int i2 = 0; i2 < n5; ++i2) {
            Bitmap bitmap3;
            if (bl) {
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(i2 * n2), (int)n3, (int)n2);
            } else if (i2 == n5 - 1) {
                int n6 = i2 * n2;
                int n7 = n4 - n6;
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n6, (int)n3, (int)n7);
            } else {
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(i2 * n2), (int)n3, (int)n2);
            }
            arrayList2.add(bitmap3);
        }
        return arrayList2;
    }

    public static byte[] printDiskImagefile1(int[] nArray, int n2, int n3) {
        byte[] byArray;
        int n4 = n2;
        n2 = n4 / 8;
        int n5 = n4 % 8;
        if (n5 > 0) {
            ++n2;
        }
        byte[] byArray2 = new byte[n2 * n3 + 8];
        byte[] byArray3 = byArray = byArray2;
        byte[] byArray4 = byArray;
        byArray3[0] = 29;
        byArray4[1] = 118;
        byArray3[2] = 48;
        byArray4[3] = 0;
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)n3;
        int n6 = 8;
        byArray2[7] = (byte)(n3 >> 8);
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n2 - 1; ++n9) {
                n8 = 0;
                if (nArray[n7++] < -1) {
                    n8 = 128;
                }
                if (nArray[n7++] < -1) {
                    n8 += 64;
                }
                if (nArray[n7++] < -1) {
                    n8 += 32;
                }
                if (nArray[n7++] < -1) {
                    n8 += 16;
                }
                if (nArray[n7++] < -1) {
                    n8 += 8;
                }
                if (nArray[n7++] < -1) {
                    n8 += 4;
                }
                if (nArray[n7++] < -1) {
                    n8 += 2;
                }
                if (nArray[n7++] < -1) {
                    // empty if block
                }
                int n10 = ++n8;
                n8 = n6 + 1;
                byArray[n6] = (byte)n10;
                n6 = n8;
            }
            n9 = 0;
            if (n5 == 0) {
                for (n8 = 8; n8 > n5; --n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << n8;
                }
            } else {
                for (n8 = 0; n8 < n5; ++n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << 8 - n8;
                }
            }
            int n11 = n9;
            n9 = n6 + 1;
            byArray[n6] = (byte)n11;
            n6 = n9;
        }
        return byArray;
    }

    public static Bitmap convertToBlackWhite(Bitmap object) {
        int n2;
        int n3;
        int n4;
        System.out.println(object.getConfig());
        int n5 = object.getWidth();
        int n6 = object.getHeight();
        if (n5 > 640) {
            n5 = 640;
        }
        int n7 = n5 * n6;
        int[] nArray = new int[n7];
        object = nArray;
        object.getPixels(nArray, 0, n5, 0, 0, n5, n6);
        Object object2 = new int[n7];
        block3: for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                Bitmap bitmap;
                n2 = n5 * n4 + n3;
                try {
                    bitmap = object[n2];
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)("PrintBmp:" + exception.getMessage()));
                    break block3;
                }
                object2[n2] = (bitmap & 0xFF0000) >> 16;
                continue;
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n5 * n4 + n3;
                int n8 = object2[n2];
                if (n8 >= 128) {
                    object[n2] = (Bitmap)-1;
                    n8 -= 255;
                } else {
                    object[n2] = (Bitmap)-16777216;
                    n8 -= 0;
                }
                int n9 = n5 - 1;
                if (n3 < n9 && n4 < n6 - 1) {
                    Object object3 = object2;
                    n9 = n8 * 3 / 8;
                    object2[++n2] = object2[n2] + n9;
                    n2 = n5 * (n4 + 1) + n3;
                    object3[n2] = object2[n2] + n9;
                    object3[++n2] = object2[n2] + n8 / 4;
                    continue;
                }
                if (n3 == n9 && n4 < n6 - 1) {
                    n2 = n5 * (n4 + 1) + n3;
                    object2[n2] = object2[n2] + n8 * 3 / 8;
                    continue;
                }
                if (n3 >= n9 || n4 != n6 - 1) continue;
                object2[++n2] = object2[n2] + n8 / 4;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n6, (Bitmap.Config)Bitmap.Config.RGB_565);
        object2 = bitmap;
        object2.setPixels((int[])object, 0, n5, 0, 0, n5, n6);
        return ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)n5, (int)n6);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static String saveBitmap(Bitmap bitmap) {
        void var0_3;
        FileOutputStream fileOutputStream;
        block26: {
            String string;
            block23: {
                FileNotFoundException fileNotFoundException2;
                block25: {
                    IOException iOException3;
                    FileOutputStream fileOutputStream2;
                    block24: {
                        FileOutputStream fileOutputStream3;
                        File file;
                        if (bitmap == null) {
                            return "";
                        }
                        File file2 = file;
                        if (!new File("sdcard/", "anti_white.jpg").exists()) {
                            try {
                                file2.createNewFile();
                            }
                            catch (IOException iOException2) {
                                iOException2.printStackTrace();
                            }
                        }
                        string = file2.getAbsolutePath();
                        fileOutputStream2 = null;
                        fileOutputStream = fileOutputStream3;
                        Bitmap bitmap2 = bitmap;
                        fileOutputStream(file2);
                        bitmap2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                        fileOutputStream3.flush();
                        fileOutputStream3.close();
                        fileOutputStream3.close();
                        break block23;
                        catch (IOException iOException3) {
                            break block24;
                        }
                        catch (FileNotFoundException fileNotFoundException2) {
                            break block25;
                        }
                        catch (Throwable throwable) {
                            fileOutputStream = fileOutputStream2;
                            break block26;
                        }
                        catch (IOException iOException3) {
                            fileOutputStream = fileOutputStream2;
                        }
                    }
                    iOException3.printStackTrace();
                    fileOutputStream.close();
                    catch (FileNotFoundException fileNotFoundException2) {
                        fileOutputStream = fileOutputStream2;
                    }
                }
                fileNotFoundException2.printStackTrace();
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return string;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        throw var0_3;
    }

    public static byte[] printDiskImagefilePath(String string) {
        byte[] byArray;
        FileInputStream fileInputStream;
        Bitmap bitmap = null;
        FileInputStream fileInputStream2 = fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            fileInputStream2 = bitmap;
        }
        bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream2);
        if (bitmap == null) {
            return null;
        }
        String string2 = string;
        if (!string2.substring(string2.toLowerCase().indexOf(".") + 1).equals("bmp")) {
            string = BmpUtils.convertToBlackWhite(bitmap);
            int n2 = string.getWidth();
            int n3 = string.getHeight();
            int[] nArray = new int[n2 * n3];
            string.getPixels(nArray, 0, n2, 0, 0, n2, n3);
            byArray = BmpUtils.printDiskImagefile(nArray, n2, n3);
        } else {
            int n4 = bitmap.getWidth();
            int n5 = bitmap.getHeight();
            int[] nArray = new int[n4 * n5];
            bitmap.getPixels(nArray, 0, n4, 0, 0, n4, n5);
            byArray = BmpUtils.printDiskImagefile(nArray, n4, n5);
        }
        return byArray;
    }

    public static Bitmap getBitmap(String string) {
        Bitmap bitmap;
        if ((string = BitmapFactory.decodeFile((String)string)) != (bitmap = Bitmap.createScaledBitmap((Bitmap)string, (int)360, (int)360, (boolean)false))) {
            string.recycle();
        }
        return bitmap;
    }

    public static byte[] draw2PxPoint360(Bitmap bitmap) {
        byte[] byArray = new byte[16290];
        int n2 = 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            byte[] byArray2 = byArray;
            int n3 = n2 + 1;
            byArray2[n2] = 27;
            n2 = n3 + 1;
            byArray2[n3] = 42;
            n3 = n2 + 1;
            byArray2[n2] = 33;
            n2 = n3 + 1;
            byArray2[n3] = 104;
            n3 = n2 + 1;
            byArray[n2] = 1;
            for (n2 = 0; n2 < 360; ++n2) {
                for (int i3 = 0; i3 < 3; ++i3) {
                    for (int i4 = 0; i4 < 8; ++i4) {
                        byte by = BmpUtils.px2Byte(n2, i2 * 24 + i3 * 8 + i4, bitmap);
                        byArray[n3] = (byte)(byArray[n3] + (byArray[n3] + by));
                    }
                    ++n3;
                }
            }
            n2 = n3 + 1;
            byArray[n3] = 10;
        }
        return byArray;
    }

    public static byte px2Byte(int n2, int n3, Bitmap bitmap) {
        int n4 = bitmap.getPixel(n2, n3);
        int n5 = n2 = n4;
        n2 = (n5 & 0xFF00) >> 8;
        return BmpUtils.RGB2Gray((n4 & 0xFF0000) >> 16, n2, n5 & 0xFF) < 128 ? (byte)1 : 0;
    }

    public static Bitmap getBlackWhiteBitmap(Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        int n2 = bitmap2.getWidth();
        int n3 = bitmap.getHeight();
        Bitmap bitmap3 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.RGB_565);
        int n4 = n2 * n3;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        bitmap2.getPixels(nArray, 0, n2, 0, 0, n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray[i2];
            int n6 = Color.red((int)n5);
            int n7 = Color.green((int)n5);
            int n8 = Color.blue((int)n5);
            int n9 = Color.alpha((int)n5);
            n7 = (n6 = (int)((double)n6 * 0.33 + (double)n7 * 0.59 + (double)n8 * 0.11)) > 255 ? 255 : n6;
            n8 = n6 > 255 ? 255 : n6;
            if (n6 > 255) {
                n6 = 255;
            }
            nArray2[i2] = Color.argb((int)n9, (int)n7, (int)n8, (int)n6);
        }
        Bitmap bitmap4 = bitmap3;
        bitmap4.setPixels(nArray2, 0, n2, 0, 0, n2, n3);
        return bitmap4;
    }

    public static Bitmap compressImage(Bitmap bitmap, int n2) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream2);
        if (byteArrayOutputStream2.toByteArray().length / 1024 > 1024) {
            byteArrayOutputStream2.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)byteArrayOutputStream2);
        }
        int n3 = 100;
        Log.d((String)"IminPrintUtils_Image", (String)("  \u6dfb\u52a0\u5b57\u6bb5 baos.toByteArray().length   " + byteArrayOutputStream2.toByteArray().length + ",  \u5171\u591a\u5c11M==> " + byteArrayOutputStream2.toByteArray().length / 1024 / 1024 + "   bitmap.getHeight()==>" + bitmap.getHeight()));
        while (byteArrayOutputStream2.toByteArray().length / 1024 > n2) {
            byteArrayOutputStream2.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, n3, (OutputStream)byteArrayOutputStream2);
            if (n3 <= 5) break;
            n3 -= 5;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)byteArrayInputStream, null, null);
        try {
            byteArrayOutputStream2.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bitmap;
    }

    public void writeToFileTest(Context context, int n2) {
        Context context2 = context;
        String string = ContextCompat.getExternalFilesDirs((Context)context2, (String)Environment.DIRECTORY_DCIM)[0].getAbsolutePath();
        Log.d((String)TAG, (String)("directory:" + string));
        string.concat("/test.png");
        string.concat("/test3.bmp");
        BmpUtils bmpUtils = null;
        InputStream inputStream = context2.getResources().openRawResource(n2);
        InputStream inputStream2 = inputStream;
        bmpUtils = BitmapFactory.decodeStream((InputStream)inputStream);
        Log.e((String)TAG, (String)("mBitmapSrc.isMutable():" + bmpUtils.isMutable()));
        try {
            inputStream2.close();
        }
        catch (IOException iOException) {
            Log.d((String)TAG, (String)("" + iOException.toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.d((String)TAG, (String)("" + fileNotFoundException.toString()));
        }
        BmpUtils.changeBmpBitCountToFile((Bitmap)bmpUtils);
    }
}

