package com.tiffintom.partner1;

import android.app.Activity;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.multidex.BuildConfig;
import androidx.multidex.MultiDexApplication;
import androidx.room.Room;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.play.core.appupdate.AppUpdateManager;
import com.google.android.play.core.appupdate.AppUpdateManagerFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.gson.Gson;
import com.imin.library.SystemPropManager;
import com.imin.printerlib.IminPrintUtils;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.external.callable.BluetoothReaderListener;
import com.stripe.stripeterminal.external.callable.Callback;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.callable.ReaderCallback;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryMethod;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.log.LogLevel;
import com.sunmi.sunmi_utils.SunmiPrintHelper;
import com.tiffintom.partner1.activities.NoInternetActivity;
import com.tiffintom.partner1.activities.SplashActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.CustomTerminalEventListener;
import com.tiffintom.partner1.common.CustomTokenProvider;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.IMinPrinterUtils;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.models.Counts;
import com.tiffintom.partner1.models.MerchantApp;
import com.tiffintom.partner1.models.MerchantServiceDetails;
import com.tiffintom.partner1.models.MerchantSupervisor;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.RequestResponse;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.models.SiteSetting;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.network.NetworkInterceptor;
import com.tiffintom.partner1.services_receivers.TiffintomPartnerJobService;
import com.tiffintom.partner1.services_receivers.TiffintomPartnerService;
import com.tiffintom.partner1.storageutils.AppDatabase;
import com.tiffintom.partner1.storageutils.MyPreferences;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;

/**
 * Created by Amrish on 07-11-2020.
 */
public class MyApp extends MultiDexApplication {
    public AppUpdateManager appUpdateManager;
    public static MyApp instance;
    private MyPreferences myPreferences;

    public static MyApp getInstance() {
        return instance;
    }

    public String currencySymbol = "£";

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public MyPreferences getMyPreferences() {
        return myPreferences;
    }

    public AppDatabase appDatabase;
    public static String DEL_TIMEFORMAT = "yyyy-MM-dd";
    public static String PHP_TIMEFORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String PHP_DATE_TIME_FORMAT_ZULU = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'";
    private MediaPlayer mp, delayedOrderMP, paymentSuccessMP, paymentFailedMP, newMessageMP, mpBookings;
    private BroadcastReceiver broadcastReceiver;
    public Counts allCounts;
    public boolean orderTiffinTomLogo = false;
    public Bitmap merchantLogo, restaurantLogo;
    public ArrayList<SiteSetting> siteSettings = new ArrayList<>();
    private ZoneRichPrinter zoneRichPrinter;
    public IMinPrinterUtils iMinPrinterUtils;
    public CS20PrintHelper cs20PrintHelper;
    private SunmiPrinter sunmiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private OrderDetail orderDetail;
    public String lastConnectedReader;
    public Cancelable cancelableDiscovery;

    public MerchantApp getMerchantApp() {
        if (getMyPreferences().getLoggedInMerchant() != null) {
            return getMyPreferences().getMerchantApp();
        }
        return null;
    }

    public MerchantServiceDetails getMerchantServiceDetails() {
        MerchantApp merchantApp = getMerchantApp();
        if (merchantApp != null && merchantApp.merchantService != null && merchantApp.merchantService.size() > 0) {
            return merchantApp.merchantService.get(0);
        } else return null;

    }

    public MerchantSupervisor getSupervisorDetails() {
        MerchantApp merchantApp = getMerchantApp();
        if (merchantApp != null && merchantApp.supervisor_info != null && merchantApp.supervisor_info.size() > 0) {
            return merchantApp.supervisor_info.get(0);
        } else return null;

    }

    @Override
    public void onCreate() {
        super.onCreate();
        AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO);
        instance = this;
        myPreferences = new MyPreferences(this);
        appUpdateManager = AppUpdateManagerFactory.create(this);
        initOrderSoundMP();
        initPaymentFailedMP();
        initPaymentSuccessMP();
        initDelayedOrderSoundMP();
        initNewMessageSoundMP();
        initBookingSoundMP();
        getFirebaseToken();
        FirebaseCrashlytics.getInstance().setCrashlyticsCollectionEnabled(true);
        getMyPreferences().setAndroidDeviceId(Settings.Secure.getString(getContentResolver(), Settings.Secure.ANDROID_ID));


        /**
         * Connect print service through interface library
         */
        SunmiPrintHelper.getInstance().initSunmiPrinterService(this);
        appDatabase = Room.databaseBuilder(getApplicationContext(),
                        AppDatabase.class, "tiffintom_partner-database")
                .fallbackToDestructiveMigration()
                .allowMainThreadQueries()
                .build();
        new Thread(this::initializeApi).start();

        broadcastReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getBooleanExtra("refresh", false)) {
                    allCounts = new Gson().fromJson(intent.getStringExtra("counts"), Counts.class);
                    if (allCounts != null && allCounts.pending_orders > 0) {
                        startOrderSound();
                    } else {
                        stopOrderSound();
                    }
                    if (allCounts != null && allCounts.delay_orders > 0) {
                        startDelayedOrderSound();
                    } else {
                        stopDelayedOrderSound();
                    }
                    if (allCounts != null && allCounts.unread_chat > 0) {
                        startNewMessageSound();
                    } else {
                        stopNewMessageSound();
                    }
                    if (allCounts != null && allCounts.pending_bookings > 0) {
                        startBookingSound();
                    } else {
                        stopBookingSound();
                    }
                }
            }
        };

        LocalBroadcastManager.getInstance(this).registerReceiver(broadcastReceiver, new IntentFilter(Constants.NOTIFICATION));
        if (isAddImInPrint()) {
            new Thread(() -> iMinPrinterUtils = new IMinPrinterUtils(this)).start();
        }
    }

    public void changeStatusOnlineReservation(Reservation reservation, Activity currentActivity) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", getMyPreferences().getLoggedInRestaurant().id);

            if (reservation.status.equalsIgnoreCase("Cancel")) {
                params.put("cancel_reason", reservation.cancel_reason);
            }
            params.put("status", reservation.status);
            ANRequest.PostRequestBuilder anRequest;
            anRequest = AndroidNetworking.post(ApiEndPoints.bookings + "/" + reservation.id + "/change-status")
                    .addQueryParameter(params);
            anRequest
                    .build()
                    .getAsObject(Reservation.class, new ParsedRequestListener<Reservation>() {
                        @Override
                        public void onResponse(Reservation response) {
                            try {
                                zoneRichPrinter = new ZoneRichPrinter(currentActivity);
                                sunmiPrinter = new SunmiPrinter(currentActivity);
                                bluetoothPrinter = new BluetoothPrinter(currentActivity);
                                Reservation printReservation = response;
                                if (!getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                                    if (getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                                        iMinPrinterUtils.printReservation(printReservation, restaurantLogo);
                                    } else if (getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                                        if (zoneRichPrinter == null) {
                                            //CommonFunctions.showSnackBar(getActivity(), coordinatorLayout, "Printer is not connected");
                                        } else {
                                            zoneRichPrinter.connectPrinter(getMyPreferences().getPrinterIP());
                                            zoneRichPrinter.printReservation(printReservation, restaurantLogo);
                                        }
                                    } else if (getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                                        try {
                                            if (bluetoothPrinter != null) {
                                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                if (device != null) {
                                                    CommonFunctions.functionThatDelay(200);
                                                    bluetoothPrinter.printReservation(printReservation, restaurantLogo);
                                                } else {
                                                    //ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                                }
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        sunmiPrinter.printReservation(MyApp.this, printReservation);
                                    }
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getFirebaseToken() {
        FirebaseApp.initializeApp(instance);
       /* FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                return;
            }
            String token = task.getResult();
            myPreferences.setUserFCMToken(token);
        });*/
    }

    public void generateMerchantLogoBitmap() {
        new Thread(() -> {
            try {
                URL url = new URL(getMyPreferences().getMerchantBusinesses().image_url);
                merchantLogo = BitmapFactory.decodeStream(url.openConnection().getInputStream());
                LogUtils.e("Merchant logo downloaded");
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();

    }

    public void getOnlineOrderTiffinTomLogo(boolean orderTiffinTomLogo) {
        this.orderTiffinTomLogo = orderTiffinTomLogo;
        /*SiteSetting logoSetting = findSetting("online_order_tiffintom_logo");
        if (logoSetting == null || Validators.isNullOrEmpty(logoSetting.value)) {
            orderTiffinTomLogo = "no";
        } else {
            orderTiffinTomLogo = logoSetting.value;
        }*/
    }

    public SiteSetting findSetting(String key) {
        SiteSetting siteSetting = new SiteSetting();
        siteSetting.key = key;
        int index = siteSettings.indexOf(siteSetting);
        if (index == -1) return null;
        if (siteSettings.size() == 0 || siteSettings.size() - 1 < index) return null;
        return siteSettings.get(index);
    }

    public void generateRestaurantLogoBitmap() {
        new Thread(() -> {
            // change logo as asked by kamal sir at 02-01-2023
            //restaurantLogo = BitmapFactory.decodeResource(this.getResources(), R.drawable.printer_tiffinotom_logo);
            if(getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))){
                restaurantLogo = BitmapFactory.decodeResource(this.getResources(), R.drawable.printer_tiffintom_logo_bmp);
            }else {
                restaurantLogo = BitmapFactory.decodeResource(this.getResources(), R.drawable.printer_tiffinotom_logo_medium);
            }
        }).start();

    }

    public void initService() {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                //schedulerJob(getApplicationContext());
                startService(new Intent(getApplicationContext(), TiffintomPartnerService.class));
            } else {
                startService(new Intent(getApplicationContext(), TiffintomPartnerService.class));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void schedulerJob(Context context) {
        try {
            ComponentName serviceComponent = new ComponentName(context, TiffintomPartnerJobService.class);
            JobInfo.Builder builder = new JobInfo.Builder(0, serviceComponent);
            builder.setMinimumLatency(5000);    // wait at least
            builder.setOverrideDeadline(30000);  //delay time
            builder.setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY);  // require unmetered network
            builder.setRequiresCharging(false);  // we don't care if the device is charging or not
            builder.setRequiresDeviceIdle(false); // device should be idle
            System.out.println("(scheduler Job");
            JobScheduler jobScheduler = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
                jobScheduler = context.getSystemService(JobScheduler.class);
            }
            jobScheduler.schedule(builder.build());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void initializeApi() {
        OkHttpClient okHttpClient = new OkHttpClient().newBuilder()
                .connectTimeout(1, TimeUnit.MINUTES)
                .readTimeout(1, TimeUnit.MINUTES)
                .writeTimeout(1, TimeUnit.MINUTES)
                .addInterceptor(new NetworkInterceptor())
                .build();
        // .addInterceptor(new ChuckerInterceptor(getApplicationContext()))
        AndroidNetworking.initialize(getApplicationContext(), okHttpClient);
    }

    public String checkErrorMessage(JSONObject jsonObject) {
        RequestResponse requestResponse = new Gson().fromJson(jsonObject.toString(), RequestResponse.class);
        if (requestResponse.result != null) {
            if (requestResponse.result.success != 1) {
                if (requestResponse.result.message != null)
                    return requestResponse.result.message;
                else return "No results found";
            } else {
                return null;
            }
        } else {
            return "No results found";
        }
    }


    public String getStripePublishKey() {
        if (!ApiEndPoints.ubsidiBuild) {
            return com.tiffintom.partner1.BuildConfig.stripe_publishkeyTest;
        } else {
            return com.tiffintom.partner1.BuildConfig.stripe_publishkey;
        }
       /* if (getMyPreferences().getSiteSettings().stripe_mode.equalsIgnoreCase("test")) {
            return getMyPreferences().getSiteSettings().stripe_publishkeyTest;
        } else {
            return getMyPreferences().getSiteSettings().stripe_publishkey;
        }*/
    }

    public boolean isLoggedIn() {
        return getMyPreferences().getLoggedInRestaurant() != null;
    }

    public boolean isMerchantLogin() {
        return getMyPreferences().getLoggedInMerchant() != null;
    }

    public void logout(Activity activity) {
       /* if (getMyPreferences().getLoggedInRestaurant() != null) {
            AndroidNetworking.post(ApiEndPoints.BASE_URL()).addBodyParameter("action", "StoreLogout").addBodyParameter("user_id", getMyPreferences().getLoggedInRestaurant().id).build().getAsJSONObject(new JSONObjectRequestListener() {
                @Override
                public void onResponse(JSONObject response) {
                    LogUtils.e("Logout response: ", new Gson().toJson(response));
                }

                @Override
                public void onError(ANError anError) {
                    anError.printStackTrace();
                    LogUtils.e("Logout error: ");
                }
            });
        }*/
        getMyPreferences().logout();
        if (getMyPreferences().getLoggedInMerchant() == null) {
            getMyPreferences().saveDefaultPrinter(null);
            getMyPreferences().saveAppIntroDone(false);
        }
        startActivity(new Intent(activity, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
    }

    public void restaurantLogout(Activity activity, boolean shouldRedirect) {
        /*if (getMyPreferences().getLoggedInRestaurant() != null) {
            AndroidNetworking.post(ApiEndPoints.BASE_URL()).addBodyParameter("action", "StoreLogout").addBodyParameter("user_id", getMyPreferences().getLoggedInRestaurant().id).build().getAsJSONObject(new JSONObjectRequestListener() {
                @Override
                public void onResponse(JSONObject response) {
                    LogUtils.e("Logout response: ", new Gson().toJson(response));
                }

                @Override
                public void onError(ANError anError) {
                    anError.printStackTrace();
                    LogUtils.e("Logout error: ");
                }
            });
        }*/
        getMyPreferences().logout();
        if (getMyPreferences().getLoggedInMerchant() == null) {
            getMyPreferences().saveDefaultPrinter(null);
            getMyPreferences().saveAppIntroDone(false);
        }
        if (shouldRedirect)
            startActivity(new Intent(activity, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
    }

    public void logoutMerchant(Activity activity) {
        getMyPreferences().logoutMerchant();
        if (getMyPreferences().getLoggedInRestaurant() == null) {
            getMyPreferences().saveDefaultPrinter(null);
        }
        startActivity(new Intent(activity, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
    }

    public void logoutMerchant(Activity activity, boolean shouldRedirect) {
        getMyPreferences().logoutMerchant();
        if (getMyPreferences().getLoggedInRestaurant() == null) {
            getMyPreferences().saveDefaultPrinter(null);
        }
        if (shouldRedirect)
            startActivity(new Intent(activity, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
    }

    public void noInternet(Activity activity) {
        if (activity != null)
            startActivity(new Intent(activity, NoInternetActivity.class));
    }

    public static class df {
        public static String format(float value) {
            return String.format("%.2f", value);
        }
    }

    public ArrayList<String> getPrinters() {
        ArrayList<String> printers = new ArrayList<>();
        printers.add("V1");
        printers.add("V1S");
        printers.add("V2");
        printers.add("V2S");
        printers.add(getString(R.string.ubsidi_cs30));
        if (isAddImInPrint()) {
            printers.add("imin");
        }
        printers.add("IP Printer");
        printers.add("Mobile");
        printers.add("KP-80");
        return printers;
    }

    public void autoSelectPrint(){
        try {
            if(Build.BRAND.equalsIgnoreCase("sunmi")){
                myPreferences.saveDefaultPrinter("V1");
            }else if(Build.BRAND.equalsIgnoreCase("ciontek")){
                myPreferences.saveDefaultPrinter(getString(R.string.ubsidi_cs30));
            }else if(isAddImInPrint()){
                myPreferences.saveDefaultPrinter("imin");
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private boolean isAddImInPrint() {
        final String deviceModel = SystemPropManager.getModel();
        return TextUtils.equals("D1p-601", deviceModel) || TextUtils.equals("D1p-602", deviceModel)
                || TextUtils.equals("D1p-603", deviceModel) || TextUtils.equals("D1p-604", deviceModel)
                || TextUtils.equals("D1w-701", deviceModel) || TextUtils.equals("D1w-702", deviceModel)
                || TextUtils.equals("D1w-703", deviceModel) || TextUtils.equals("D1w-704", deviceModel)
                || TextUtils.equals("D4-501", deviceModel) || TextUtils.equals("D4-502", deviceModel)
                || TextUtils.equals("D4-503", deviceModel) || TextUtils.equals("D4-504", deviceModel)
                || deviceModel.startsWith("D4-505") || TextUtils.equals("M2-Max", deviceModel)
                || TextUtils.equals("D1", deviceModel) || TextUtils.equals("D1-Pro", deviceModel)
                || TextUtils.equals("Swift 1", deviceModel) || TextUtils.equals("I22T01", deviceModel)
                || TextUtils.equals("TF1-11", deviceModel) || TextUtils.equals("D3-510", deviceModel) || TextUtils.equals("S1-701", deviceModel) || TextUtils.equals("S1-702", deviceModel)
                || TextUtils.equals("M2-202", deviceModel) || TextUtils.equals("M2-203", deviceModel) || TextUtils.equals("M2-Pro", deviceModel);
    }

    public void setFirebaseCustomKey() {
        if (myPreferences.getDeviceRegistration() != null) {
            FirebaseCrashlytics.getInstance().setCustomKey("crash_device_name", myPreferences.getDeviceRegistration().name);
        }
        if (myPreferences.getLoggedInMerchant() != null) {
            FirebaseCrashlytics.getInstance().setCustomKey("crash_device_email", myPreferences.getLoggedInMerchant().id);
        }
        FirebaseCrashlytics.getInstance().setCustomKey("country", getResources().getConfiguration().locale.getCountry());
        FirebaseCrashlytics.getInstance().setCustomKey("build_type", androidx.multidex.BuildConfig.BUILD_TYPE);
        FirebaseCrashlytics.getInstance().setCustomKey("ui_type", "NEW");
        FirebaseCrashlytics.getInstance().setCustomKey("server", ApiEndPoints.ubsidiBuild ? "ubsidi" : "testrms");
        if (myPreferences.getMerchantBusinesses() != null) {
            FirebaseCrashlytics.getInstance().setCustomKey("business", myPreferences.getMerchantBusinesses().id);
        }
        try {
            FirebaseCrashlytics.getInstance().setCustomKey("first_install_at", CommonFunctions.convertMsToDesiredFormat(getPackageManager().getPackageInfo(getPackageName(), 0).firstInstallTime, Constants.PHP_DATE_TIME_FORMAT));
            FirebaseCrashlytics.getInstance().setCustomKey("last_update_at", CommonFunctions.convertMsToDesiredFormat(getPackageManager().getPackageInfo(getPackageName(), 0).lastUpdateTime, Constants.PHP_DATE_TIME_FORMAT));
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void startOrderSound() {
        if (mp != null) {
            mp.start();
            mp.setLooping(true);
            mp.setVolume(100, 100);
        }
    }

    public void stopOrderSound() {
        if (mp != null && mp.isPlaying()) {
            mp.stop();
            mp.reset();
            mp.release();
            initOrderSoundMP();
        }
    }

    public void startBookingSound() {
        if (mpBookings != null) {
            mpBookings.start();
            mpBookings.setLooping(true);
            mpBookings.setVolume(100, 100);
        }
    }

    public void stopBookingSound() {
        if (mpBookings != null && mpBookings.isPlaying()) {
            mpBookings.stop();
            mpBookings.reset();
            mpBookings.release();
            initBookingSoundMP();
        }
    }


    public void startDelayedOrderSound() {
        if (delayedOrderMP != null) {
            delayedOrderMP.start();
            delayedOrderMP.setLooping(true);
            delayedOrderMP.setVolume(100, 100);
        }
    }

    public void stopDelayedOrderSound() {
        if (delayedOrderMP != null && delayedOrderMP.isPlaying()) {
            delayedOrderMP.stop();
            delayedOrderMP.reset();
            delayedOrderMP.release();
            initDelayedOrderSoundMP();
        }
    }

    private void initOrderSoundMP() {
        mp = MediaPlayer.create(this, R.raw.notification);
    }

    private void initBookingSoundMP() {
        mpBookings = MediaPlayer.create(this, R.raw.notification);
    }

    private void initDelayedOrderSoundMP() {
        delayedOrderMP = MediaPlayer.create(this, R.raw.delayed_order);
    }

    private void initPaymentSuccessMP() {
        paymentSuccessMP = MediaPlayer.create(this, R.raw.payment_approval_sound);
    }

    private void initNewMessageSoundMP() {
        newMessageMP = MediaPlayer.create(this, R.raw.new_message);
    }

    public void startPaymentSuccessSound() {
        if (paymentSuccessMP != null) {
            paymentSuccessMP.start();
            paymentSuccessMP.setVolume(100, 100);
        }
    }

    public void stopPaymentSuccessSound() {
        if (paymentSuccessMP != null && paymentSuccessMP.isPlaying()) {
            paymentSuccessMP.stop();
            paymentSuccessMP.reset();
            paymentSuccessMP.release();
            initPaymentSuccessMP();
        }
    }

    public void startNewMessageSound() {
        if (newMessageMP != null) {
            newMessageMP.start();
            newMessageMP.setVolume(100, 100);
        }
    }

    public void stopNewMessageSound() {
        if (newMessageMP != null && newMessageMP.isPlaying()) {
            newMessageMP.stop();
            newMessageMP.reset();
            newMessageMP.release();
            initNewMessageSoundMP();
        }
    }

    private void initPaymentFailedMP() {
        paymentFailedMP = MediaPlayer.create(this, R.raw.decline_sound);
    }

    public void startPaymentFailedSound() {
        if (paymentFailedMP != null) {
            paymentFailedMP.start();
            paymentFailedMP.setVolume(100, 100);
        }
    }

    public void stopPaymentFailedSound() {
        if (paymentFailedMP != null && paymentFailedMP.isPlaying()) {
            paymentFailedMP.stop();
            paymentFailedMP.reset();
            paymentFailedMP.release();
            initPaymentFailedMP();
        }
    }

    public void acceptOrder(String status, String order_id, String preparation, Activity currentActivity) {
        try {
            zoneRichPrinter = new ZoneRichPrinter(currentActivity);
            sunmiPrinter = new SunmiPrinter(currentActivity);
            bluetoothPrinter = new BluetoothPrinter(currentActivity);
            HashMap<String, String> params = new HashMap<>();
            params.put("status", status);
            params.put("preparation", preparation);
            orderDetail = new OrderDetail();
            // if(orderDetail==null){
            orderDetail.preparation = preparation;
            AndroidNetworking.post(ApiEndPoints.orders + order_id + "/change-status")
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(OrderDetail.class, new ParsedRequestListener<OrderDetail>() {
                        @Override
                        public void onResponse(OrderDetail response) {
                            try {
                                orderDetail.status = status;
                                if (status.equalsIgnoreCase("Accepted")) {
                                    orderDetail = response;
                                    orderDetail.status = "Accepted";
                                    printOrder();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printOrder() {
        try {
            if (!getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                continuePrint();

            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void continuePrint() {
        try {
            if (getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                printIMin(orderDetail, false);
            } else if (getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                printCS20(orderDetail, false);
            } else if (getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                if (zoneRichPrinter == null) {
                    ToastUtils.makeToast(MyApp.this, "Printer is null");
                } else {
                    printZonerich(orderDetail, false);
                }
            } else if (getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                try {
                    if (bluetoothPrinter != null) {
                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                        if (device != null) {
                            CommonFunctions.functionThatDelay(200);
                            printBT(orderDetail, false);
                        } else {
                            ToastUtils.makeToast(MyApp.this, "No bluetooth device found.");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                printSunmi(orderDetail, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIMin(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            iMinPrinterUtils.printOrder(restaurantLogo, merchantLogo, orderDetail, kitchenCopy, orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(300);
                printIMin(orderDetail, true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCS20(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            cs20PrintHelper.printOrder(restaurantLogo, merchantLogo, orderDetail, kitchenCopy, orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(300);
                printCS20(orderDetail, true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonerich(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            zoneRichPrinter.connectPrinter(getMyPreferences().getPrinterIP());
            zoneRichPrinter.printOrder(restaurantLogo, merchantLogo, orderDetail, kitchenCopy, orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(300);
                zoneRichPrinter.connectPrinter(getMyPreferences().getPrinterIP());
                printZonerich(orderDetail, true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSunmi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            sunmiPrinter.printOrder(restaurantLogo, merchantLogo, orderDetail, kitchenCopy, orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(300);
                printSunmi(orderDetail, true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBT(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrder(restaurantLogo, merchantLogo, orderDetail, kitchenCopy, orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(300);
                printBT(orderDetail, true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connectReader(Activity activity,String businessId){
        if(!Validators.isNullOrEmpty(getMyPreferences().getSerialNumber()) && !Validators.isNullOrEmpty(getMyPreferences().getLocationId())){
            try {
                String locationId = getMyPreferences().getLocationId();
                if (!Terminal.isInitialized()) {
                    Terminal.initTerminal(getApplicationContext(), LogLevel.VERBOSE, new CustomTokenProvider(locationId, businessId), new CustomTerminalEventListener(activity));
                } else {
                    LogUtils.e("Terminal already initialized");
                }
                cancelableDiscovery = Terminal.getInstance().discoverReaders(new DiscoveryConfiguration(30, DiscoveryMethod.BLUETOOTH_SCAN, false), list -> {
                    LogUtils.e("TERMINAL:::Discovery result::" + list.size());
                    for (int i=0; i<list.size();i++){
                        if(!Validators.isNullOrEmpty(list.get(i).getSerialNumber())){
                            if(list.get(i).getSerialNumber().equalsIgnoreCase(getMyPreferences().getSerialNumber())){
                                ConnectionConfiguration.BluetoothConnectionConfiguration connectionConfig =
                                        new ConnectionConfiguration.BluetoothConnectionConfiguration(locationId);
                                Terminal.getInstance().connectBluetoothReader(list.get(i), connectionConfig,new BluetoothReaderListener(){}, new ReaderCallback() {
                                    @Override
                                    public void onSuccess(Reader r) {
                                        cancelableDiscovery.cancel(callback);
                                        lastConnectedReader = getMyPreferences().getCardReaderConnect();
                                        Log.e("onSuccessonSuccess","onSuccess "+r.getSerialNumber());
                                    }

                                    @Override
                                    public void onFailure(TerminalException e) {
                                        Log.e("onSuccessonSuccess","onSuccess "+e.getErrorMessage());
                                        e.printStackTrace();
                                    }
                                });
                            }
                        }
                    }
                }, callback);
            } catch (TerminalException e) {
                LogUtils.e("Terminal Error::" + e.getErrorMessage());
            }
        }
    }

    Callback callback = new Callback() {
        @Override
        public void onSuccess() {

        }

        @Override
        public void onFailure(@NonNull TerminalException e) {

        }
    };
}
