package com.tiffintom.partner1.activities;

import static com.tiffintom.partner1.utils.Constants.DELETE_CLICKED;
import static com.tiffintom.partner1.utils.Constants.EDIT_CLICKED;
import static com.tiffintom.partner1.utils.Constants.TRANSFER_CLICKED;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.SearchManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SearchView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Group;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CaxTonBankTransactionAdapter;
import com.tiffintom.partner1.adapters.CaxTonBeneficiariesAdapter;
import com.tiffintom.partner1.adapters.CaxTonRecentTransactionAdapter;
import com.tiffintom.partner1.adapters.TransactionReasonAdapter;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher1;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonBeneficiaresModel;
import com.tiffintom.partner1.models.CaxTonBeneficiariesResponseModel;
import com.tiffintom.partner1.models.CaxTonTransactionListModel;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.TransactionReasonModel;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CaxTonBaneficiariesActivity extends BaseActivity {
    RecyclerView rv_beneficaires_list;
    private String userBankId = "",finance_user_phone_number="";
    TextView txt_no_beneficaires;
    private CaxTonBeneficiariesAdapter caxTonBeneficairesListAdapter;
    private int beneficairesPosition = -1, transferPosition = -1;
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private RelativeLayout llFromDate, llToDate;
    private String fromDate = "2019-06-01", toDate = "2020-12-31", wallet_id = "", searchText = "";
    private TextView tvToDate, tvFromDate,tvResendOtp,txtVerificationMobile;
    private LinearLayout llAfterOtpSend,llAfterOtpSend1;
    private ConstraintLayout constSummary;
    private ProgressBar progressBeneficiary;
    private FloatingActionButton float_add;
    private Dialog dialog, dialogTransfer;
    private float minimum_transfer_charge = 0f;
    private float transfer_charge = 0f;
    private float transfer_charge_back = 0f;
    private String transfer_charge_type = "";
    private EditText etBankName, etAddressLine1, etAddressLine2, etSwift;
    private ImageView ivBack;

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_baneficiaries_list);
    }

    @Override
    protected void initViews() {
        super.initViews();
        minimum_transfer_charge = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.minimum_transfer_charge;
        transfer_charge_back = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge_back;
        transfer_charge = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge;
        transfer_charge_type = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge_type;
        userBankId = myApp.getMyPreferences().getMerchantBusinesses().finance_user_id;
        finance_user_phone_number = myApp.getMyPreferences().getMerchantBusinesses().finance_user_phone_number;
        rv_beneficaires_list = findViewById(R.id.rv_beneficaires_list);
        txt_no_beneficaires = findViewById(R.id.txt_no_beneficaires);
        float_add = findViewById(R.id.float_add);
        llToDate = findViewById(R.id.llToDate);
        llFromDate = findViewById(R.id.llFromDate);
        tvToDate = findViewById(R.id.tvToDate);
        tvFromDate = findViewById(R.id.tvFromDate);
        ivBack = findViewById(R.id.ivBack);
        initAdapter();
        updateViews();
        setListsner();
        fetchBeneficiaryList();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        menuInflater.inflate(R.menu.search_card, menu);

        MenuItem searchItem = menu.findItem(R.id.action_search);

        SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);

        SearchView searchView = null;
        if (searchItem != null) {
            searchView = (SearchView) searchItem.getActionView();
        }
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            // Override onQueryTextSubmit method which is call when submit query is searched
            @Override
            public boolean onQueryTextSubmit(String query) {
                // If the list contains the search query than filter the adapter
                // using the filter method with the query as its argument
                searchText = query;
                fetchBeneficiaryList();
                return false;
            }

            // This method is overridden to filter the adapter according
            // to a search query when the user is typing search
            @Override
            public boolean onQueryTextChange(String newText) {
                if (newText.isEmpty()) {
                    searchText = "";
                    fetchBeneficiaryList();
                }
                return false;
            }
        });
        if (searchView != null) {
            searchView.setSearchableInfo(searchManager.getSearchableInfo(getComponentName()));
        }
        return super.onCreateOptionsMenu(menu);
    }

    private void initAdapter() {
        caxTonBeneficairesListAdapter = new CaxTonBeneficiariesAdapter(new ArrayList<>(),
                // item clicked
                (position, data, clickedViewName) -> {
                    switch (clickedViewName) {
                        case EDIT_CLICKED: {
                            beneficairesPosition = position;
                            addEditBeneficiaryDialog(true, ((CaxTonBeneficiaresModel) data));
                            break;
                        }
                        case DELETE_CLICKED: {
                            deleteConfirmationDialog(((CaxTonBeneficiaresModel) data));
                            break;
                        }
                        case TRANSFER_CLICKED: {
                            transferPosition = position;
                            getBankBalance(((CaxTonBeneficiaresModel) data));
                            break;
                        }
                    }
                });

        rv_beneficaires_list.setAdapter(caxTonBeneficairesListAdapter);
    }

    private void getBankBalance(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/balance";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                String transferBalance = "0.00";
                                if (Validators.isNullOrEmpty(response.balance)) {
                                } else {
                                    transferBalance = "" + CommonFunctions.formatTo2Digit(Float.parseFloat(response.balance));
                                }
                                showTransferDialog(caxTonBeneficiaresModel, transferBalance);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void deleteConfirmationDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        AlertDialog alertDialog = new AlertDialog.Builder(CaxTonBaneficiariesActivity.this).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to delete?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            deleteBeneficiaryApiCall(caxTonBeneficiaresModel);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void deleteBeneficiaryApiCall(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/beneficiary/" + caxTonBeneficiaresModel.id;
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.delete(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                fetchBeneficiaryList();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void setListsner() {
        float_add.setOnClickListener(view -> {
            addEditBeneficiaryDialog(false,new CaxTonBeneficiaresModel());
        });
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalendar.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchBeneficiaryList();
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalendar.set(y, m, d);
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchBeneficiaryList();
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
        ivBack.setOnClickListener(view -> {
            finish();
        });
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DAY_OF_MONTH, -60);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchBeneficiaryList() {
        try {
            String url = ApiEndPoints.BENEFICIARIES_LIST + userBankId + "/beneficiary";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", myApp.getMyPreferences().getMerchantBusinesses().id);
            params.put("nopaginate", String.valueOf(1));
            params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("from_date",CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("query",searchText);
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(CaxTonBeneficiaresModel.class, new ParsedRequestListener<ArrayList<CaxTonBeneficiaresModel>>() {
                        @Override
                        public void onResponse(ArrayList<CaxTonBeneficiaresModel> response) {
                            try {
                                progressDialog.dismiss();
                                if (response.isEmpty()) {
                                    txt_no_beneficaires.setVisibility(View.VISIBLE);
                                    rv_beneficaires_list.setVisibility(View.GONE);
                                } else {
                                    txt_no_beneficaires.setVisibility(View.GONE);
                                    rv_beneficaires_list.setVisibility(View.VISIBLE);
                                    caxTonBeneficairesListAdapter.notifyList(response);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_beneficaires.setVisibility(View.VISIBLE);
                                rv_beneficaires_list.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showTransferDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel, String availableBalance) {
        Dialog dialogTransfer = new Dialog(this);
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_trasfer);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        progressBeneficiary = dialogTransfer.findViewById(R.id.progress_image);
        MaterialButton btnSubmit = dialogTransfer.findViewById(R.id.btnSubmit);
        //progress_image.setVisibility(View.VISIBLE);
        ConstraintLayout llFromDate = dialogTransfer.findViewById(R.id.llFromDate);
        TextView tvFromDate = dialogTransfer.findViewById(R.id.tvFromDate);
        Group groupPaymentDate = dialogTransfer.findViewById(R.id.groupPaymentDate);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        EditText etAmount = dialogTransfer.findViewById(R.id.etAmount);
        EditText etFees = dialogTransfer.findViewById(R.id.etFees);
        EditText etNotes = dialogTransfer.findViewById(R.id.etNotes);
        TextView txtFees = dialogTransfer.findViewById(R.id.txtFees);
        TextView txt_available_balance = dialogTransfer.findViewById(R.id.txt_available_balance);
        TextView txtRemainningAmount = dialogTransfer.findViewById(R.id.txtRemainningAmount);
        groupPaymentDate.setVisibility(View.VISIBLE);
        txt_available_balance.setVisibility(View.VISIBLE);
        txt_available_balance.setText(myApp.currencySymbol + availableBalance + " Available funds");
        etAmount.addTextChangedListener(new MoneyTextWatcher1(etAmount));
        BigDecimal availableBalanceBig = BigDecimal.valueOf(Float.parseFloat(availableBalance));
        AtomicInteger fromYear = new AtomicInteger();
        AtomicInteger fromMonth = new AtomicInteger();
        AtomicInteger fromDay = new AtomicInteger();
        Calendar fromCalendar = Calendar.getInstance();
        Calendar selectedCalendar = Calendar.getInstance();
        tvFromDate.setText("" + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        Spinner spinnerReason = dialogTransfer.findViewById(R.id.spinnerReason);

        ArrayList<TransactionReasonModel> transactionReasonModels = CommonFunctions.getTransactionReason();
        TransactionReasonAdapter transactionReasonAdapter = new TransactionReasonAdapter(CaxTonBaneficiariesActivity.this, transactionReasonModels);
        transactionReasonAdapter.setDropDownViewResource(R.layout.spinner_item);
        spinnerReason.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                caxTonBeneficiaresModel.transaction_reason = transactionReasonModels.get(i).id;
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
        spinnerReason.setAdapter(transactionReasonAdapter);

        caxTonBeneficiaresModel.payment_date = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                fromDay.set(d);
                fromMonth.set(m);
                fromYear.set(y);
                selectedCalendar.set(y, (m), d);
                if (selectedCalendar.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY || selectedCalendar.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                    new AlertDialog.Builder(this)
                            .setMessage("Sorry!! Weekend date's can not be selected for the Transfer")
                            .setPositiveButton(android.R.string.ok, (dialog, which) -> {
                                dialog.dismiss();
                            })
                            .setIcon(android.R.drawable.ic_dialog_alert)
                            .show();
                }
                tvFromDate.setText("" + CommonFunctions.formatMiliToDesireFormat(selectedCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                //offer.offer_from = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
                caxTonBeneficiaresModel.payment_date = CommonFunctions.formatMiliToDesireFormat(selectedCalendar.getTimeInMillis(), "yyyy-MM-dd");
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
        });
        etAmount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 0) {
                    txtFees.setVisibility(View.GONE);
                    etFees.setVisibility(View.GONE);
                    etFees.setText(myApp.currencySymbol + "0.00");
                } else {
                    txtFees.setVisibility(View.VISIBLE);
                    etFees.setVisibility(View.VISIBLE);
                    float amount = 0;
                    if (transfer_charge_type.equalsIgnoreCase("flat")) {
                        amount = amount + transfer_charge;
                        etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(amount));
                        BigDecimal trasferChargeBig = BigDecimal.valueOf(transfer_charge);
                        BigDecimal etAmountEnteredByUser = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", "")));
                        caxTonBeneficiaresModel.trasferChargeBig = trasferChargeBig;
                        caxTonBeneficiaresModel.etAmountEnteredByUser = etAmountEnteredByUser;
                        txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(trasferChargeBig))));
                    } else if (transfer_charge_type.equalsIgnoreCase("percentage")) {
                        BigDecimal trasferChargeBig = BigDecimal.valueOf(transfer_charge);
                        BigDecimal minimumTransferCharge = BigDecimal.valueOf(minimum_transfer_charge);
                        BigDecimal etAmountEnteredByUser = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", "")));
                        BigDecimal etAmountBigDecimal = BigDecimal.valueOf(Float.parseFloat(editable.toString().replace(",", ""))).multiply(trasferChargeBig).divide(BigDecimal.valueOf(100));
                        caxTonBeneficiaresModel.trasferChargeBig = trasferChargeBig;
                        caxTonBeneficiaresModel.etAmountEnteredByUser = etAmountEnteredByUser;
                        caxTonBeneficiaresModel.minimumTransferCharge = minimumTransferCharge;
                        if (etAmountBigDecimal.compareTo(minimumTransferCharge) > 0) {
                            etAmountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etAmountBigDecimal = etAmountBigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etFees.setText(myApp.currencySymbol + etAmountBigDecimal);
                            caxTonBeneficiaresModel.etFeesAmountBigDecimal = etAmountBigDecimal;
                            txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(etAmountBigDecimal))));
                        } else {
                            minimumTransferCharge.setScale(2, BigDecimal.ROUND_HALF_UP);
                            minimumTransferCharge = minimumTransferCharge.setScale(2, BigDecimal.ROUND_HALF_UP);
                            etFees.setText(myApp.currencySymbol + minimumTransferCharge);
                            caxTonBeneficiaresModel.etFeesAmountBigDecimal = minimumTransferCharge;
                            txtRemainningAmount.setText("Deposite to Currency Balance " + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(etAmountEnteredByUser.add(minimumTransferCharge))));
                        }
                       /* if (amount < minimum_transfer_charge) {
                            etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(minimum_transfer_charge));
                        }else {
                            etFees.setText(myApp.currencySymbol + CommonFunctions.formatTo2Digit(amount));
                        }*/
                    }
                }
            }
        });
        etNotes.setText(caxTonBeneficiaresModel.notes);
        img_close.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        btnSubmit.setOnClickListener(view -> {
            if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                etAmount.setError("Amount must be greater than 0");
                etAmount.requestFocus();
            }else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) < 5) {
                etAmount.setError("Entered amount must be greater than "+myApp.currencySymbol+"5.00");
                etAmount.requestFocus();
            } else {
                if (availableBalanceBig.compareTo(caxTonBeneficiaresModel.etFeesAmountBigDecimal.add(caxTonBeneficiaresModel.etAmountEnteredByUser)) > 0) {
                    caxTonBeneficiaresModel.amount = etAmount.getText().toString();
                    caxTonBeneficiaresModel.transferCharger = etFees.getText().toString();
                    caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                    caxTonBeneficiaresModel.user_id = userBankId;
                    dialogTransfer.dismiss();
                    showTransferSummaryDialog(caxTonBeneficiaresModel,availableBalanceBig);
                } else {
                    etAmount.setError("Insufficient funds");
                    etAmount.requestFocus();
                }
                //showTransferApiCall(caxTonBeneficiaresModel);
            }
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    CountDownTimer countDownTimer =  new CountDownTimer(30000, 1000) {

        @Override
        public void onTick(long millisUntilFinished) {
            int seconds = (int) (millisUntilFinished / 1000);
            int minutes = seconds / 60;
            seconds %= 60;
            if(tvResendOtp!=null){
                tvResendOtp.setEnabled(false);
                tvResendOtp.setText("Resend otp in "+String.format("%02d", minutes) + ":" + String.format(
                        "%02d",
                        seconds
                ));
            }
        }

        @Override
        public void onFinish() {
            if(tvResendOtp!=null){
            tvResendOtp.setEnabled(true);
            tvResendOtp.setText("Resend Otp");
            }
        }
    };

    private void showTransferSummaryDialog(CaxTonBeneficiaresModel caxTonBeneficiaresModel, BigDecimal availableBalanceBig) {
        dialogTransfer = new Dialog(this);
        dialogTransfer.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialogTransfer.setContentView(R.layout.dialog_trasfer_summary);
        dialogTransfer.setCanceledOnTouchOutside(false);
        Window window = dialogTransfer.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        progressBeneficiary = dialogTransfer.findViewById(R.id.progress_image);
        ConstraintLayout constAmountToPay = dialogTransfer.findViewById(R.id.constAmountToPay);
        //progress_image.setVisibility(View.VISIBLE);
        Button btnVerify = dialogTransfer.findViewById(R.id.btnVerify);
        Button btnCancel = dialogTransfer.findViewById(R.id.btnCancel);
        EditText etOtp = dialogTransfer.findViewById(R.id.etOtp);
        tvResendOtp = dialogTransfer.findViewById(R.id.tvResendOtp);
        txtVerificationMobile = dialogTransfer.findViewById(R.id.txtVerificationMobile);
        if(finance_user_phone_number.length()>=10){
            String first = "OTP is sent to the ";
            String second = " <font color='#3F51B5'>"+finance_user_phone_number.substring(0,3)+"****"+finance_user_phone_number.substring((finance_user_phone_number.length()-3),finance_user_phone_number.length())+"</font>";
            txtVerificationMobile.setText(Html.fromHtml(first + second));
        }
        llAfterOtpSend = dialogTransfer.findViewById(R.id.llAfterOtpSend);
        llAfterOtpSend1 = dialogTransfer.findViewById(R.id.llAfterOtpSend1);
        constSummary = dialogTransfer.findViewById(R.id.constSummary);
        ImageView img_close = dialogTransfer.findViewById(R.id.img_close);
        TextView txt_fees_value = dialogTransfer.findViewById(R.id.txt_fees_value);
        TextView txtNamevalue = dialogTransfer.findViewById(R.id.txtNamevalue);
        TextView txtBankValue = dialogTransfer.findViewById(R.id.txtBankValue);
        TextView txtNotesValue = dialogTransfer.findViewById(R.id.txtNotesValue);
        CheckBox cxPaymentInst = dialogTransfer.findViewById(R.id.cxPaymentInst);
        TextView txtAvaialbleBalanceValue = dialogTransfer.findViewById(R.id.txtAvaialbleBalanceValue);
        TextView txtDepositeCurrenyBalanceValue = dialogTransfer.findViewById(R.id.txtDepositeCurrenyBalanceValue);
        TextView txtAmountToPay = dialogTransfer.findViewById(R.id.txtAmount);
        TextView txtAmountToPayListValue = dialogTransfer.findViewById(R.id.txtAmountToPayListValue);
        txtAmountToPay.setText(myApp.currencySymbol+CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser.add(caxTonBeneficiaresModel.etFeesAmountBigDecimal)));
        txt_fees_value.setText(myApp.currencySymbol +CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etFeesAmountBigDecimal) );
        txtAmountToPayListValue.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser));
        cxPaymentInst.setText(getString(R.string.payment_inst1)+" "+myApp.currencySymbol+CommonFunctions.formatTo2Digit(transfer_charge_back)+" "+getString(R.string.payment_inst3));
        txtNamevalue.setText(caxTonBeneficiaresModel.name);
        txtBankValue.setText(caxTonBeneficiaresModel.bank_name);
        txtNotesValue.setText(caxTonBeneficiaresModel.notes);
        txtDepositeCurrenyBalanceValue.setText("" + myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig.subtract(caxTonBeneficiaresModel.etAmountEnteredByUser.add(caxTonBeneficiaresModel.etFeesAmountBigDecimal))));
        txtAvaialbleBalanceValue.setText(myApp.currencySymbol + CommonFunctions.formatTo2DigitBigDecimal(availableBalanceBig));
        btnCancel.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        img_close.setOnClickListener(view -> {
            dialogTransfer.dismiss();
        });
        constAmountToPay.setOnClickListener(view -> {
            if(!cxPaymentInst.isChecked()){
                ToastUtils.makeLongToast(this,"Please agree terms and condition");
            }else {
               sendOtpApi();
            }
            /*if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            } else {
                caxTonBeneficiaresModel.amount = etAmount.getText().toString();
                caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                caxTonBeneficiaresModel.user_id = userBankId;
                //showTransferApiCall(caxTonBeneficiaresModel);
            }*/
        });
        btnVerify.setOnClickListener(view -> {
            if(etOtp.getText().toString().isEmpty()){
                etOtp.setError("Please enter otp");
                etOtp.requestFocus();
            }else{
                CommonFunctions.hideKeyboard(this,btnVerify);
                caxTonBeneficiaresModel.otp = etOtp.getText().toString();
                caxTonBeneficiaresModel.amount =""+ CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etAmountEnteredByUser);
                caxTonBeneficiaresModel.fee =""+ CommonFunctions.formatTo2DigitBigDecimal(caxTonBeneficiaresModel.etFeesAmountBigDecimal);
                showTransferApiCall(caxTonBeneficiaresModel);
            }
        });
        dialogTransfer.setOnDismissListener(dialogInterface -> {
            if (countDownTimer != null) {
                countDownTimer.cancel();
            }
        });
        tvResendOtp.setOnClickListener(view -> {
            sendOtpApi();
        });

        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialogTransfer.show();
    }

    private void sendOtpApi() {
        try {
            /*if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = ApiEndPoints.send_otp + userBankId +"/send-otp";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, response.message);
                                if (countDownTimer != null) {
                                    countDownTimer.start();
                                }
                                if (llAfterOtpSend != null) {
                                llAfterOtpSend.setVisibility(View.VISIBLE);
                                    llAfterOtpSend1.setVisibility(View.VISIBLE);
                                constSummary.setVisibility(View.GONE);}
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showTransferApiCall(CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            /*if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }*/
            progressDialog.show();
            String url = ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/transfer";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.post(url)
                    .addBodyParameter(caxTonBeneficiaresModel)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialogTransfer != null) {
                                    dialogTransfer.dismiss();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addEditBeneficiaryDialog(boolean isFromEdit, CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        dialog = new Dialog(this);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_add_edit_beneficiary);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_close = dialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        TextView txt_title = dialog.findViewById(R.id.txt_title);
        RadioButton rd_company = dialog.findViewById(R.id.rd_company);
        RadioButton rd_individual = dialog.findViewById(R.id.rd_individual);
        EditText etAccountNumner = dialog.findViewById(R.id.etAccountNumner);
        EditText etsortCode = dialog.findViewById(R.id.etsortCode);
        EditText etName = dialog.findViewById(R.id.etName);
        EditText etEmail = dialog.findViewById(R.id.etEmail);
        EditText etPhone = dialog.findViewById(R.id.etPhone);
        EditText etIbanNumber = dialog.findViewById(R.id.etIbanNumber);
        EditText etNotes = dialog.findViewById(R.id.etNotes);
        etSwift = dialog.findViewById(R.id.etSwift);
        etBankName = dialog.findViewById(R.id.etBankName);
        etAddressLine1 = dialog.findViewById(R.id.etAddressLine1);
        etAddressLine2 = dialog.findViewById(R.id.etAddressLine2);
        progressBeneficiary = dialog.findViewById(R.id.progressBeneficiary);
        TextView txtLookUp = dialog.findViewById(R.id.txtLookUp);
        rd_company.setChecked(true);
        if (isFromEdit) {
            txt_title.setText(getString(R.string.edit_beneficiary));
            btnSubmit.setText(getString(R.string.edit_beneficiary));
            etAddressLine1.setText(caxTonBeneficiaresModel.address1);
            etAddressLine2.setText(caxTonBeneficiaresModel.address2);
            etAccountNumner.setText(caxTonBeneficiaresModel.account_number);
            etsortCode.setText(caxTonBeneficiaresModel.sortCode);
            etName.setText(caxTonBeneficiaresModel.name);
            etBankName.setText(caxTonBeneficiaresModel.bank_name);
            etEmail.setText(caxTonBeneficiaresModel.email);
            etPhone.setText(caxTonBeneficiaresModel.phone);
            etSwift.setText(caxTonBeneficiaresModel.swift);
            etIbanNumber.setText(caxTonBeneficiaresModel.iban);
            etNotes.setText(caxTonBeneficiaresModel.notes);
            if (caxTonBeneficiaresModel.beneficiary_type != null) {
                if (caxTonBeneficiaresModel.beneficiary_type.equalsIgnoreCase("Entity")) {
                    rd_company.setChecked(true);
                } else {
                    rd_individual.setChecked(true);
                }
            }
        }
        etsortCode.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 0) {
                    txtLookUp.setVisibility(View.GONE);
                } else {
                    txtLookUp.setVisibility(View.VISIBLE);
                }
            }
        });
        txtLookUp.setOnClickListener(view -> {
            CommonFunctions.hideKeyboard(CaxTonBaneficiariesActivity.this,etsortCode);
            lookUpAccountApiCall(etsortCode.getText().toString(), etAccountNumner.getText().toString(), rd_company.isChecked() ? "Entity" : "Individual");
        });
        btnSubmit.setOnClickListener(view -> {
            if (etAccountNumner.getText().toString().isEmpty()) {
                etAccountNumner.setError("Please enter account number");
                etAccountNumner.requestFocus();
            } else if (etsortCode.getText().toString().isEmpty()) {
                etsortCode.setError("Please enter sort code");
                etsortCode.requestFocus();
            } else if (etName.getText().toString().isEmpty()) {
                etName.setError("Please enter name");
                etName.requestFocus();
            } else if (etBankName.getText().toString().isEmpty()) {
                etBankName.setError("Please enter bank name");
                etBankName.requestFocus();
            } else if (etAddressLine1.getText().toString().isEmpty()) {
                etAddressLine1.setError("Please enter address line 1");
                etAddressLine1.requestFocus();
            } else if (etAddressLine2.getText().toString().isEmpty()) {
                etAddressLine2.setError("Please enter address line 2");
                etAddressLine2.requestFocus();
            } else {
                if (rd_company.isChecked()) {
                    caxTonBeneficiaresModel.beneficiary_type = "Entity";
                } else {
                    caxTonBeneficiaresModel.beneficiary_type = "Individual";
                }
                caxTonBeneficiaresModel.bank_name = etBankName.getText().toString();
                caxTonBeneficiaresModel.address1 = etAddressLine1.getText().toString();
                caxTonBeneficiaresModel.address2 = etAddressLine2.getText().toString();
                caxTonBeneficiaresModel.name = etName.getText().toString();
                caxTonBeneficiaresModel.sortCode = etsortCode.getText().toString();
                caxTonBeneficiaresModel.account_number = etAccountNumner.getText().toString();
                caxTonBeneficiaresModel.email = etEmail.getText().toString();
                caxTonBeneficiaresModel.phone = etPhone.getText().toString();
                caxTonBeneficiaresModel.iban = etIbanNumber.getText().toString();
                caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                addEditBeneficiaryApiCall(isFromEdit, caxTonBeneficiaresModel);
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }

    private void lookUpAccountApiCall(String sortCode, String accountNumber, String type) {
        try {
            if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }
            //progressDialog.show();
            String url = ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/beneficiary/lookup";
            HashMap<String, String> params = new HashMap<>();
            params.put("country", "GB");
            params.put("currency", "GBP");
            params.put("sortCode", sortCode);
            params.put("account_number", accountNumber);
            params.put("beneficiary_type", type);
            Log.e("wallet_id", "wallet_id " + url+" params "+params);
            AndroidNetworking.post(url)
                    .addBodyParameter(params)
                    .build()
                    .getAsObject(CaxTonBeneficiaresModel.class, new ParsedRequestListener<CaxTonBeneficiaresModel>() {
                        @Override
                        public void onResponse(CaxTonBeneficiaresModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (etSwift != null) {
                                    etSwift.setText(response.swift);
                                }
                                if (etAddressLine1 != null) {
                                    etAddressLine1.setText(response.address1);
                                }
                                if (etAddressLine2 != null) {
                                    etAddressLine2.setText(response.address2);
                                }
                                if (etBankName != null) {
                                    etBankName.setText(response.bank_name);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addEditBeneficiaryApiCall(boolean isFromEdit, CaxTonBeneficiaresModel caxTonBeneficiaresModel) {
        try {
            if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }
            //progressDialog.show();
            String url = isFromEdit ? ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/beneficiary/" + caxTonBeneficiaresModel.id : ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/beneficiary";
            Log.e("wallet_id", "wallet_id " + url);
            caxTonBeneficiaresModel.country = "GB";
            caxTonBeneficiaresModel.currency = "GBP";
            AndroidNetworking.post(url)
                    .addBodyParameter(caxTonBeneficiaresModel)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialog != null) {
                                    dialog.dismiss();
                                }
                                if(isFromEdit){
                                    caxTonBeneficairesListAdapter.notifyItemChanged(beneficairesPosition);
                                }else{
                                    fetchBeneficiaryList();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBaneficiariesActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBaneficiariesActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}