package com.tiffintom.partner1.activities;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.SearchManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.util.Log;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.appcompat.widget.SearchView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CaxTonBankTransactionAdapter;
import com.tiffintom.partner1.adapters.CaxTonRecentTransactionAdapter;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonBankTransactionModel;
import com.tiffintom.partner1.models.CaxTonBankTransactionResponseModel;
import com.tiffintom.partner1.models.CaxTonTransactionListModel;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public class CaxTonBankTransctionListActivity extends BaseActivity {
    RecyclerView rv_transaction_list;
    private String userBankId = "";
    TextView txt_no_transaction;
    Dialog dialog;
    private CaxTonBankTransactionAdapter caxTonRecentTransactionAdapter;
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private RelativeLayout llFromDate, llToDate;
    private String fromDate = "2019-06-01", toDate = "2020-12-31",searchText="";
    private TextView tvToDate, tvFromDate,txtExport;
    private ImageView ivBack,imgExport;
    MerchantBusinesses merchantBusiness;
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_cax_ton_bank_transaction_list);
    }

    @Override
    protected void initViews() {
        super.initViews();
        merchantBusiness = myApp.getMyPreferences().getMerchantBusinesses();
        userBankId = myApp.getMyPreferences().getMerchantBusinesses().finance_user_id;
        rv_transaction_list = findViewById(R.id.rv_transaction_list);
        txt_no_transaction = findViewById(R.id.txt_no_card);
        llToDate = findViewById(R.id.llToDate);
        llFromDate = findViewById(R.id.llFromDate);
        tvToDate = findViewById(R.id.tvToDate);
        ivBack = findViewById(R.id.ivBack);
        imgExport = findViewById(R.id.imgExport);
        txtExport = findViewById(R.id.txtExport);
        tvFromDate = findViewById(R.id.tvFromDate);
        initAdapter();
        updateViews();
        setListsner();
        fetchTransactionList();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        menuInflater.inflate(R.menu.search_card, menu);

        MenuItem searchItem = menu.findItem(R.id.action_search);

        SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);

        SearchView searchView = null;
        if (searchItem != null) {
            searchView = (SearchView) searchItem.getActionView();
        }
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            // Override onQueryTextSubmit method which is call when submit query is searched
            @Override
            public boolean onQueryTextSubmit(String query) {
                // If the list contains the search query than filter the adapter
                // using the filter method with the query as its argument
                searchText = query;
                fetchTransactionList();
                return false;
            }

            // This method is overridden to filter the adapter according
            // to a search query when the user is typing search
            @Override
            public boolean onQueryTextChange(String newText) {
                if(newText.isEmpty()){
                    searchText ="";
                    fetchTransactionList();
                }
                return false;
            }
        });
        if (searchView != null) {
            searchView.setSearchableInfo(searchManager.getSearchableInfo(getComponentName()));
        }
        return super.onCreateOptionsMenu(menu);
    }

    private void initAdapter() {
        caxTonRecentTransactionAdapter = new CaxTonBankTransactionAdapter(new ArrayList<>(), (position, data) -> {

        });
        rv_transaction_list.setAdapter(caxTonRecentTransactionAdapter);
    }

    private void setListsner(){
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalendar.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchTransactionList();
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalendar.set(y, m, d);
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchTransactionList();
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
        ivBack.setOnClickListener(view -> {
            finish();
        });
        txtExport.setOnClickListener(view -> {
            showExportFilterSelection();
        });
        imgExport.setOnClickListener(view -> {
            txtExport.performClick();
        });
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DAY_OF_MONTH, -60);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchTransactionList() {
        try {
            String url = ApiEndPoints.BANK_TRANSACTION_LIST + userBankId + "/transactions";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", myApp.getMyPreferences().getMerchantBusinesses().id);
            params.put("nopaginate", String.valueOf(1));
            params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("from_date",CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("query",searchText);
            params.put("not_status", "1");
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(CaxTonBankTransactionModel.class, new ParsedRequestListener<ArrayList<CaxTonBankTransactionModel>>() {
                        @Override
                        public void onResponse(ArrayList<CaxTonBankTransactionModel> response) {
                            try {
                                progressDialog.dismiss();
                                if (response.isEmpty()) {
                                    txt_no_transaction.setVisibility(View.VISIBLE);
                                    rv_transaction_list.setVisibility(View.GONE);
                                } else {
                                    txt_no_transaction.setVisibility(View.GONE);
                                    rv_transaction_list.setVisibility(View.VISIBLE);
                                    caxTonRecentTransactionAdapter.notifyList(response);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_transaction.setVisibility(View.VISIBLE);
                                rv_transaction_list.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonBankTransctionListActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonBankTransctionListActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonBankTransctionListActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void downloadReport(String fromDate,String toDate,String format){
        progressDialog.show();
        HashMap<String,String> hashMap = new HashMap<>();
        hashMap.put("from_date",fromDate);
        hashMap.put("business_id", merchantBusiness.id);
        hashMap.put("to_date",toDate);
        //hashMap.put("format","excel");
        String getUrl =ApiEndPoints.BANK_TRANSACTION_LIST + userBankId + "/transactions-export"+"?from_date="+fromDate+"&to_date="+toDate+"&business_id="+merchantBusiness.id+"&format="+format;

        String url = ApiEndPoints.BANK_TRANSACTION_LIST + userBankId + "/transactions-count";
        AndroidNetworking.get(url)
                .addQueryParameter(hashMap)
                .build()
                .getAsObject(CaxTonTransactionListModel.class, new ParsedRequestListener<CaxTonTransactionListModel>() {
                    @Override
                    public void onResponse(CaxTonTransactionListModel response) {
                        try {
                            progressDialog.dismiss();
                            Log.e("getUrlgetUrl","getUrlgetUrl "+getUrl);
                            if(response.no_of_transactions>0){
                                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(getUrl));
                                startActivity(browserIntent);
                                Log.e("onResponse", "Walletlist response is " + response);
                                if(dialog!=null){
                                    dialog.dismiss();
                                }
                            }else{
                                ToastUtils.makeLongToast(CaxTonBankTransctionListActivity.this, "Transactions not found");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            progressDialog.dismiss();
                            if(dialog!=null){
                                dialog.dismiss();
                            }
                            if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                myApp.getMyPreferences().logoutMerchant();
                                myApp.getMyPreferences().logout();
                                ToastUtils.makeLongToast(CaxTonBankTransctionListActivity.this, "Session expired");
                            } else if (anError.getErrorCode() > 200) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                Log.e("onError", "onError " + anError.getMessage());
                                ToastUtils.makeSnackToast(CaxTonBankTransctionListActivity.this, apiError.getMessage());
                                // Navigate to dashboard if any API error occurs
                            } else {
                                ToastUtils.makeSnackToast(CaxTonBankTransctionListActivity.this, "Something went wrong!!");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });
    }

    private void showExportFilterSelection() {
        dialog = new Dialog(CaxTonBankTransctionListActivity.this);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_export_filter);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_close = dialog.findViewById(R.id.img_close);
        MaterialButton btnExportAsExcel = dialog.findViewById(R.id.btnExportAsExcel);
        MaterialButton btnExportAsPdf = dialog.findViewById(R.id.btnExportAsPdf);
        RadioGroup rdTimePeriods = dialog.findViewById(R.id.rdTimePeriods);
        RadioButton rdLast6Months = dialog.findViewById(R.id.rdLast6Months);
        RadioButton rdLast3Months = dialog.findViewById(R.id.rdLast3Months);
        RadioButton rdLastMonth = dialog.findViewById(R.id.rdLastMonth);
        RadioButton rdThisWeek = dialog.findViewById(R.id.rdThisWeek);
        AtomicReference<String> fromDate = new AtomicReference<>("2019-06-01");
        AtomicReference<String> toDate = new AtomicReference<>("2020-12-31");
        String wallet_id="";
        String searchText="";
        RadioButton rdCurrentMonth = dialog.findViewById(R.id.rdCurrentMonth);
        rdThisWeek.setChecked(true);
        CardView cvCalender = dialog.findViewById(R.id.cvCalender);
        RelativeLayout llFromDate11, llToDate11;
        TextView tvToDate, tvFromDate;
        tvToDate = dialog.findViewById(R.id.tvToDate);
        tvFromDate = dialog.findViewById(R.id.tvFromDate);
        llToDate11 = dialog.findViewById(R.id.llToDate11);
        llFromDate11 = dialog.findViewById(R.id.llFromDate11);

        fromCalendar.setTime(Calendar.getInstance().getTime());
        fromCalendar.set(Calendar.DAY_OF_WEEK, 1);
        toCalendar.setTime(Calendar.getInstance().getTime());
        toCalendar.set(Calendar.DAY_OF_WEEK, 7);

        fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
        toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
        rdTimePeriods.setOnCheckedChangeListener((compoundButton, b) -> {
            switch (compoundButton.getCheckedRadioButtonId()){
                case R.id.rdThisWeek:{
                    cvCalender.setVisibility(View.GONE);
                    fromCalendar.setTime(Calendar.getInstance().getTime());
                    fromCalendar.set(Calendar.DAY_OF_WEEK, 1);
                    toCalendar.setTime(Calendar.getInstance().getTime());
                    toCalendar.set(Calendar.DAY_OF_WEEK, 7);
                    fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    break;
                }
                case R.id.rdCurrentMonth:{
                    cvCalender.setVisibility(View.GONE);
                    fromCalendar.setTime(Calendar.getInstance().getTime());
                    fromCalendar.set(Calendar.DATE, fromCalendar.getActualMinimum(Calendar.DAY_OF_MONTH));
                    toCalendar.setTime(Calendar.getInstance().getTime());
                    fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    break;
                }
                case R.id.rdLast3Months:{
                    cvCalender.setVisibility(View.GONE);
                    fromCalendar.setTime(Calendar.getInstance().getTime());
                    fromCalendar.add(Calendar.DAY_OF_MONTH, -90);
                    toCalendar.setTime(Calendar.getInstance().getTime());

                    fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    break;
                }
                case R.id.rdLastMonth:{
                    cvCalender.setVisibility(View.GONE);
                    fromCalendar.setTime(Calendar.getInstance().getTime());
                    fromCalendar.add(Calendar.MONTH, -1);
                    fromCalendar.set(Calendar.DATE, 1);

                    toCalendar.setTime(Calendar.getInstance().getTime());
                    toCalendar.add(Calendar.MONTH, -1);
                    toCalendar.set(Calendar.DATE, fromCalendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                    fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    break;
                }
                case R.id.rdCustom:{
                    cvCalender.setVisibility(View.VISIBLE);
                    break;
                }
                case R.id.rdLast6Months:{
                    fromCalendar.setTime(Calendar.getInstance().getTime());
                    cvCalender.setVisibility(View.GONE);
                    fromCalendar.add(Calendar.DAY_OF_MONTH, -180);

                    toCalendar.add(Calendar.DATE, fromCalendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                    toCalendar.setTime(Calendar.getInstance().getTime());

                    fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                    break;
                }
                default:{
                    break;
                }
            }
        });
        llFromDate11.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                fromDate.set(y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d));
                fromCalendar.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));

                fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate.get())) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate11.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                toDate.set(y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d));
                toCalendar.set(y, m, d);
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));

                fromDate.set(CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                toDate.set(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate.get())) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
        btnExportAsExcel.setOnClickListener(view -> {
            downloadReport(fromDate.get(),toDate.get(),"excel");
        });
        btnExportAsPdf.setOnClickListener(view -> {
            downloadReport(fromDate.get(),toDate.get(),"pdf");
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }
}