package com.tiffintom.partner1.activities;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.SearchManager;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.card.MaterialCardView;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CaxTonCardListAdapter;
import com.tiffintom.partner1.adapters.CaxTonRecentTransactionAdapter;
import com.tiffintom.partner1.adapters.CaxTonWalletListAdapter;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonBeneficiaresModel;
import com.tiffintom.partner1.models.CaxTonCardListModel;
import com.tiffintom.partner1.models.CaxTonCardResponseModel;
import com.tiffintom.partner1.models.CaxTonGetPinModel;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class CaxTonCardListActivity extends BaseActivity {
    RecyclerView rv_card_list;
    TextView txt_no_card;
    private CaxTonCardListAdapter caxTonCardListAdapter;
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private int blockUnBlockPosition = -1;
    private CaxTonCardListModel caxTonCardListModel;
    private RelativeLayout llFromDate, llToDate;
    private String fromDate = "2019-06-01", toDate = "2020-12-31",wallet_id="",searchText="";
    private TextView tvToDate, tvFromDate;
    private ImageView ivBack;
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_cax_ton_card_list);
    }

    @Override
    protected void initViews() {
        super.initViews();
        rv_card_list = findViewById(R.id.rv_card_list);
        txt_no_card = findViewById(R.id.txt_no_card);
        llToDate = findViewById(R.id.llToDate);
        llFromDate = findViewById(R.id.llFromDate);
        tvToDate = findViewById(R.id.tvToDate);
        tvFromDate = findViewById(R.id.tvFromDate);
        ivBack = findViewById(R.id.ivBack);
        initAdapter();
        updateViews();
        setListsner();
        wallet_id  = getIntent().getStringExtra("wallet_id");
        fetchCardsList();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        menuInflater.inflate(R.menu.search_card, menu);

        MenuItem searchItem = menu.findItem(R.id.action_search);

        SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);

        SearchView searchView = null;
        if (searchItem != null) {
            searchView = (SearchView) searchItem.getActionView();
        }
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            // Override onQueryTextSubmit method which is call when submit query is searched
            @Override
            public boolean onQueryTextSubmit(String query) {
                // If the list contains the search query than filter the adapter
                // using the filter method with the query as its argument
                searchText = query;
                fetchCardsList();
                return false;
            }

            // This method is overridden to filter the adapter according
            // to a search query when the user is typing search
            @Override
            public boolean onQueryTextChange(String newText) {
                if(newText.isEmpty()){
                    searchText ="";
                    fetchCardsList();
                }
                return false;
            }
        });
        if (searchView != null) {
            searchView.setSearchableInfo(searchManager.getSearchableInfo(getComponentName()));
        }
        return super.onCreateOptionsMenu(menu);
    }

    private void initAdapter() {
        caxTonCardListAdapter = new CaxTonCardListAdapter(true,new ArrayList<>(),
                // item clicked
                (position, data) -> {

                },
                // get pin clicked
                (position, data) -> {
                    fetchPinImage(((CaxTonCardListModel) data).id);
                },
                // block/unblock clicked
                (position, data) -> {
                    this.blockUnBlockPosition = position;
                    this.caxTonCardListModel = ((CaxTonCardListModel) data);
                    if(caxTonCardListModel.card_state.equalsIgnoreCase("Active")){
                        blockConfirmationDialog(caxTonCardListModel.id, caxTonCardListModel.card_state);
                    }else{
                        blockCard(caxTonCardListModel.id, caxTonCardListModel.card_state);
                    }
                });
        rv_card_list.setAdapter(caxTonCardListAdapter);
    }

    private void blockConfirmationDialog(String cardId, String status) {
        AlertDialog alertDialog = new AlertDialog.Builder(this).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to blocked?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            blockCard(cardId, status);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void setListsner(){
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalendar.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchCardsList();
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalendar.set(y, m, d);
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchCardsList();
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
        ivBack.setOnClickListener(view -> {
            finish();
        });
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DAY_OF_MONTH, -60);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchCardsList() {
        try {
            MerchantBusinesses merchantBusiness = myApp.getMyPreferences().getMerchantBusinesses();
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", merchantBusiness.id);
            params.put("wallet_id", wallet_id);
            params.put("nopaginate", String.valueOf(1));
         /*   params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("from_date",CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));*/
            params.put("not_status", "1");
            params.put("query",searchText);
            Log.e("paramsparamsparams","params "+params);
            AndroidNetworking.get(ApiEndPoints.CARDS_LIST)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(CaxTonCardListModel.class, new ParsedRequestListener<ArrayList<CaxTonCardListModel>>() {
                        @Override
                        public void onResponse(ArrayList<CaxTonCardListModel> response) {
                            try {
                                progressDialog.dismiss();
                                Log.e("onResponse", "Walletlist response is " + response);
                                if (response.isEmpty()) {
                                    txt_no_card.setVisibility(View.VISIBLE);
                                    rv_card_list.setVisibility(View.GONE);
                                } else {
                                    txt_no_card.setVisibility(View.GONE);
                                    rv_card_list.setVisibility(View.VISIBLE);
                                    caxTonCardListAdapter.notifyList(response);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_card.setVisibility(View.VISIBLE);
                                rv_card_list.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonCardListActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonCardListActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonCardListActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void blockCard(String cardId, String status) {
        try {
            progressDialog.show();
            String url = status.equalsIgnoreCase("Blocked") ? ApiEndPoints.CARD_UNBLOCK + cardId : ApiEndPoints.CARD_BLOCK + cardId;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                progressDialog.dismiss();
                                if (caxTonCardListModel.card_state.equalsIgnoreCase("Blocked")) {
                                    caxTonCardListModel.card_state = "Active";
                                } else {
                                    caxTonCardListModel.card_state = "Blocked";
                                }
                                if (blockUnBlockPosition != -1) {
                                    caxTonCardListAdapter.notifyItemChanged(blockUnBlockPosition);
                                    blockUnBlockPosition = -1;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonCardListActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonCardListActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonCardListActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchPinImage(String cardId) {
        try {
            Log.e("cardIdcardIdcardId", "cardIdcardId " + cardId);
            progressDialog.show();
            String url = ApiEndPoints.GET_PIN + cardId;
            AndroidNetworking.get(url)
                    .build()
                    .getAsObject(CaxTonGetPinModel.class, new ParsedRequestListener<CaxTonGetPinModel>() {
                        @Override
                        public void onResponse(CaxTonGetPinModel response) {
                            try {
                                progressDialog.dismiss();
                                showPinDialog(response.pin_image);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonCardListActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonCardListActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonCardListActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void showPinDialog(String pinUrl) {
        Dialog dialog = new Dialog(this);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_show_pin);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_pin = dialog.findViewById(R.id.img_pin);
        ProgressBar progress_image = dialog.findViewById(R.id.progress_image);
        progress_image.setVisibility(View.VISIBLE);
        ImageView img_close = dialog.findViewById(R.id.img_close);
        Glide.with(this)
                .load(pinUrl)
                .listener(new RequestListener<Drawable>() {
                    @Override
                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        progress_image.setVisibility(View.GONE);
                        //on load failed
                        return false;
                    }

                    @Override
                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        progress_image.setVisibility(View.GONE);
                        //on load success
                        return false;
                    }
                })
                .into(img_pin);
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
    }
}