package com.tiffintom.partner1.activities;

import static com.tiffintom.partner1.utils.Constants.DELETE_CLICKED;
import static com.tiffintom.partner1.utils.Constants.EDIT_CLICKED;
import static com.tiffintom.partner1.utils.Constants.TRANSFER_CLICKED;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.SearchManager;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SearchView;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CaxTonStandingInstructionsAdapter;
import com.tiffintom.partner1.adapters.SizeArrayAdapter;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher1;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CaxTonBeneficiaresModel;
import com.tiffintom.partner1.models.CaxTonStandingInstructionModel;
import com.tiffintom.partner1.models.WalletListModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;

public class CaxTonStandingInstructionsActivity extends BaseActivity {
    RecyclerView rv_beneficaires_list;
    private String userBankId = "",finance_user_phone_number="";
    TextView txt_no_beneficaires;
    private CaxTonStandingInstructionsAdapter caxTonStandingListAdapter;
    private int beneficairesPosition = -1, transferPosition = -1;
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private RelativeLayout llFromDate, llToDate;
    private String fromDate = "2019-06-01", toDate = "2020-12-31", wallet_id = "", searchText = "";
    private TextView tvToDate, tvFromDate,tvResendOtp,txtVerificationMobile,tvSelectedCountry;
    private LinearLayout llAfterOtpSend,llAfterOtpSend1;
    private ConstraintLayout constSummary;
    private ProgressBar progressBeneficiary;
    private FloatingActionButton float_add;
    private Dialog dialog, dialogTransfer;
    private float minimum_transfer_charge = 0f;
    private float transfer_charge = 0f;
    private float transfer_charge_back = 0f;
    private String transfer_charge_type = "";
    private EditText etBankName, etAddressLine1, etAddressLine2, etSwift;
    private ImageView ivBack;
    private CardView cvCountry;
    private String selectedBeneficiry = "";
    ArrayList<CaxTonBeneficiaresModel> caxTonBeneficiariesResponseModels;
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_standing_instructions_list);
    }

    @Override
    protected void initViews() {
        super.initViews();
        minimum_transfer_charge = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.minimum_transfer_charge;
        transfer_charge_back = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge_back;
        transfer_charge = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge;
        transfer_charge_type = myApp.getMyPreferences().getMerchantBusinesses().business_commissions.transfer_charge_type;
        userBankId = myApp.getMyPreferences().getMerchantBusinesses().finance_user_id;
        finance_user_phone_number = myApp.getMyPreferences().getMerchantBusinesses().finance_user_phone_number;
        rv_beneficaires_list = findViewById(R.id.rv_beneficaires_list);
        txt_no_beneficaires = findViewById(R.id.txt_no_beneficaires);
        float_add = findViewById(R.id.float_add);
        llToDate = findViewById(R.id.llToDate);
        llFromDate = findViewById(R.id.llFromDate);
        tvToDate = findViewById(R.id.tvToDate);
        tvFromDate = findViewById(R.id.tvFromDate);
        ivBack = findViewById(R.id.ivBack);
        initAdapter();
        updateViews();
        setListsner();
        fetchStandingInstructionsList();
        fetchBeneficiaryList();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        menuInflater.inflate(R.menu.search_card, menu);

        MenuItem searchItem = menu.findItem(R.id.action_search);

        SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);

        SearchView searchView = null;
        if (searchItem != null) {
            searchView = (SearchView) searchItem.getActionView();
        }
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            // Override onQueryTextSubmit method which is call when submit query is searched
            @Override
            public boolean onQueryTextSubmit(String query) {
                // If the list contains the search query than filter the adapter
                // using the filter method with the query as its argument
                searchText = query;
                fetchStandingInstructionsList();
                return false;
            }

            // This method is overridden to filter the adapter according
            // to a search query when the user is typing search
            @Override
            public boolean onQueryTextChange(String newText) {
                if (newText.isEmpty()) {
                    searchText = "";
                    fetchStandingInstructionsList();
                }
                return false;
            }
        });
        if (searchView != null) {
            searchView.setSearchableInfo(searchManager.getSearchableInfo(getComponentName()));
        }
        return super.onCreateOptionsMenu(menu);
    }

    private void initAdapter() {
        caxTonStandingListAdapter = new CaxTonStandingInstructionsAdapter(new ArrayList<>(),
                true,
                // item clicked
                (position, data, clickedViewName) -> {
                    switch (clickedViewName) {
                        case EDIT_CLICKED: {
                            beneficairesPosition = position;
                            addEditStandingInstDialog(true, ((CaxTonStandingInstructionModel) data));
                            break;
                        }
                        case DELETE_CLICKED: {
                            deleteConfirmationDialog(((CaxTonStandingInstructionModel) data));
                            break;
                        }
                        case TRANSFER_CLICKED: {
                            transferPosition = position;

                            break;
                        }
                    }
                });

        rv_beneficaires_list.setAdapter(caxTonStandingListAdapter);
    }

    private void deleteConfirmationDialog(CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        AlertDialog alertDialog = new AlertDialog.Builder(CaxTonStandingInstructionsActivity.this).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
        animation_view.setVisibility(View.GONE);
        TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
        TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
        tvInfo1.setVisibility(View.INVISIBLE);
        tvInfo.setText("Are you sure you want to delete?");
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            deleteBeneficiaryApiCall(caxTonBeneficiaresModel);
            alertDialog.dismiss();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void deleteBeneficiaryApiCall(CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        try {
            progressDialog.show();
            String url = ApiEndPoints.GET_BANK_BALANCE + userBankId + "/standing-instructions/" + caxTonBeneficiaresModel.id;
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.delete(url)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                fetchStandingInstructionsList();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonStandingInstructionsActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void setListsner() {
        float_add.setOnClickListener(view -> {
            addEditStandingInstDialog(false,new CaxTonStandingInstructionModel());
        });
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalendar.set(y, m, d);
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchStandingInstructionsList();
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalendar.set(y, m, d);
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                fetchStandingInstructionsList();
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
        ivBack.setOnClickListener(view -> {
            finish();
        });
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DAY_OF_MONTH, -60);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchStandingInstructionsList() {
        try {
            String url = ApiEndPoints.BENEFICIARIES_LIST + userBankId + "/standing-instructions";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", myApp.getMyPreferences().getMerchantBusinesses().id);
            params.put("nopaginate", String.valueOf(1));
            params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("from_date",CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("query",searchText);
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(CaxTonStandingInstructionModel.class, new ParsedRequestListener<ArrayList<CaxTonStandingInstructionModel>>() {
                        @Override
                        public void onResponse(ArrayList<CaxTonStandingInstructionModel> response) {
                            try {
                                progressDialog.dismiss();
                                if (response.isEmpty()) {
                                    txt_no_beneficaires.setVisibility(View.VISIBLE);
                                    rv_beneficaires_list.setVisibility(View.GONE);
                                } else {
                                    txt_no_beneficaires.setVisibility(View.GONE);
                                    rv_beneficaires_list.setVisibility(View.VISIBLE);
                                    caxTonStandingListAdapter.notifyList(response);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                txt_no_beneficaires.setVisibility(View.VISIBLE);
                                rv_beneficaires_list.setVisibility(View.GONE);
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonStandingInstructionsActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addEditStandingInstDialog(boolean isFromEdit, CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        if(caxTonBeneficiariesResponseModels!=null && !caxTonBeneficiariesResponseModels.isEmpty()){
        dialog = new Dialog(this);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_add_edit_standing_inst);
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        ImageView img_close = dialog.findViewById(R.id.img_close);
        MaterialButton btnSubmit = dialog.findViewById(R.id.btnSubmit);
        TextView txt_title = dialog.findViewById(R.id.txt_title);
        EditText etNotes = dialog.findViewById(R.id.etNotes);
        Spinner spinnerBene = dialog.findViewById(R.id.spinnerBene);
        Spinner spinnerStandingType = dialog.findViewById(R.id.spinnerStandingType);
        Spinner spinnerOrderDate = dialog.findViewById(R.id.spinnerOrderDate);
        ConstraintLayout constStandingType = dialog.findViewById(R.id.constOrderDate);
        etSwift = dialog.findViewById(R.id.etSwift);
        etBankName = dialog.findViewById(R.id.etBankName);
        etAddressLine1 = dialog.findViewById(R.id.etAddressLine1);
        etAddressLine2 = dialog.findViewById(R.id.etAddressLine2);
        progressBeneficiary = dialog.findViewById(R.id.progressBeneficiary);
        TextView tvFromDate = dialog.findViewById(R.id.tvFromDate);
        TextView tvFromDateOrder = dialog.findViewById(R.id.tvFromDateOrder);
        String selectedeneficiares ="";
        RelativeLayout llExpiryDateDate = dialog.findViewById(R.id.llExpiryDateDate);
        RelativeLayout llOrderDate = dialog.findViewById(R.id.llOrderDate);
        EditText etAmount = dialog.findViewById(R.id.etAmount);
        etAmount.addTextChangedListener(new MoneyTextWatcher1(etAmount));
            weeklyTypeAdapter(caxTonBeneficiaresModel,spinnerOrderDate,isFromEdit);
        SizeArrayAdapter sizeArrayAdapter = new SizeArrayAdapter(CaxTonStandingInstructionsActivity.this, caxTonBeneficiariesResponseModels);
        sizeArrayAdapter.setDropDownViewResource(R.layout.spinner_item);

            ArrayList<CaxTonBeneficiaresModel> caxTonTypesModels = new ArrayList<>();
            CaxTonBeneficiaresModel caxTonModel = new CaxTonBeneficiaresModel();
            caxTonModel.name="Monthly";
            caxTonModel.id="monthly";
            caxTonTypesModels.add(caxTonModel);

            CaxTonBeneficiaresModel caxTonModel2 = new CaxTonBeneficiaresModel();
            caxTonModel2.name="Weekly";
            caxTonModel2.id="weekly";
            caxTonTypesModels.add(caxTonModel2);
            SizeArrayAdapter sizeStandingType = new SizeArrayAdapter(CaxTonStandingInstructionsActivity.this, caxTonTypesModels);
            sizeStandingType.setDropDownViewResource(R.layout.spinner_item);
            spinnerStandingType.setAdapter(sizeStandingType);
            spinnerStandingType.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                    if(caxTonTypesModels.get(i).id.equalsIgnoreCase("weekly")){
                        constStandingType.setVisibility(View.VISIBLE);
                        llOrderDate.setVisibility(View.GONE);
                    }else {
                        constStandingType.setVisibility(View.GONE);
                        llOrderDate.setVisibility(View.VISIBLE);
                    }
                    caxTonBeneficiaresModel.standing_type = caxTonTypesModels.get(i).id;
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView) {

                }
            });
        spinnerBene.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                caxTonBeneficiaresModel.beneficiary_name = caxTonBeneficiariesResponseModels.get(i).name;
                caxTonBeneficiaresModel.beneficiary_id = caxTonBeneficiariesResponseModels.get(i).id;
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
        spinnerBene.setAdapter(sizeArrayAdapter);
        if (isFromEdit) {
            etAmount.setText(caxTonBeneficiaresModel.amount);
            tvFromDate.setText(caxTonBeneficiaresModel.expiry_date);
            tvFromDateOrder.setText(caxTonBeneficiaresModel.order_date);
            etNotes.setText(caxTonBeneficiaresModel.notes);
            int positionBene=0;
            for (int i=0; i<caxTonBeneficiariesResponseModels.size();i++){
                if(Objects.equals(caxTonBeneficiariesResponseModels.get(i).id, caxTonBeneficiaresModel.beneficiary_id)){
                    positionBene = i;
                }
            }

            int positionType=0;
            for (int i=0; i<caxTonTypesModels.size();i++){
                if(Objects.equals(caxTonTypesModels.get(i).id, caxTonBeneficiaresModel.standing_type)){
                    positionType = i;
                }
            }
            spinnerStandingType.setSelection(positionType);
            spinnerBene.setSelection(positionBene);
            txt_title.setText(getString(R.string.edit_stading_order));
            btnSubmit.setText(getString(R.string.edit_stading_order));
        }
        btnSubmit.setOnClickListener(view -> {
            if (etAmount.getText().toString().isEmpty()) {
                etAmount.setError("Please enter amount");
                etAmount.requestFocus();
            }else {
                if( caxTonBeneficiaresModel.standing_type.equalsIgnoreCase("monthly") && tvFromDateOrder.getText().toString().isEmpty()){
                    ToastUtils.makeToast(CaxTonStandingInstructionsActivity.this,"Please select order date");
                }else if (tvFromDate.getText().toString().isEmpty()) {
                    ToastUtils.makeToast(CaxTonStandingInstructionsActivity.this,"Please select expiry Date");
                }else {
                    if(caxTonBeneficiaresModel.standing_type.equalsIgnoreCase("monthly")){
                        caxTonBeneficiaresModel.days ="";
                    }else {
                        caxTonBeneficiaresModel.order_date ="";
                    }
                    caxTonBeneficiaresModel.amount = etAmount.getText().toString();
                    caxTonBeneficiaresModel.notes = etNotes.getText().toString();
                    caxTonBeneficiaresModel.user_id = userBankId;
                    addEditStandingApiCall(isFromEdit, caxTonBeneficiaresModel);
                }
            }
        });
        img_close.setOnClickListener(view -> {
            dialog.dismiss();
        });
        llExpiryDateDate.setOnClickListener(view -> {
            Calendar nowCalender = Calendar.getInstance();
            DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                nowCalender.set(y, m, d);
                caxTonBeneficiaresModel.expiry_date= CommonFunctions.formatMiliToDesireFormat(nowCalender.getTimeInMillis(), "yyyy/MM/dd");
                tvFromDate.setText("" + CommonFunctions.formatMiliToDesireFormat(nowCalender.getTimeInMillis(), "dd/MM/yyyy"));
            }, nowCalender.get(Calendar.YEAR), nowCalender.get(Calendar.MONTH), nowCalender.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            datePickerDialog.getDatePicker().setMinDate(nowCalender.getTimeInMillis());
        });
            llOrderDate.setOnClickListener(view -> {
                Calendar nowCalender = Calendar.getInstance();
                DatePickerDialog datePickerDialog = new DatePickerDialog(this, (datePicker, y, m, d) -> {
                    nowCalender.set(y, m, d);
                    caxTonBeneficiaresModel.order_date= CommonFunctions.formatMiliToDesireFormat(nowCalender.getTimeInMillis(), "yyyy/MM/dd");
                    tvFromDateOrder.setText("" + CommonFunctions.formatMiliToDesireFormat(nowCalender.getTimeInMillis(), "dd/MM/yyyy"));
                }, nowCalender.get(Calendar.YEAR), nowCalender.get(Calendar.MONTH), nowCalender.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                datePickerDialog.getDatePicker().setMinDate(nowCalender.getTimeInMillis());
            });
        window.setGravity(Gravity.CENTER);
        layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        layoutParams.gravity = Gravity.CENTER;
        layoutParams.windowAnimations = R.style.DialogAnimation;
        window.setAttributes(layoutParams);
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.show();
        }else {
            ToastUtils.makeToast(CaxTonStandingInstructionsActivity.this,"Please wait while beneficiary is loading");
        }
    }

    private void weeklyTypeAdapter( CaxTonStandingInstructionModel caxTonStandingInstructionModel,Spinner spinner,boolean isFromEdit){
        ArrayList<CaxTonBeneficiaresModel> caxTonBeneficiariesResponseModels = new ArrayList<>();
        CaxTonBeneficiaresModel caxTonModel = new CaxTonBeneficiaresModel();
        caxTonModel.name="Sunday";
        caxTonModel.id="sunday";
        caxTonBeneficiariesResponseModels.add(caxTonModel);

        CaxTonBeneficiaresModel caxTonModel2 = new CaxTonBeneficiaresModel();
        caxTonModel2.name="Monday";
        caxTonModel2.id="monday";
        caxTonBeneficiariesResponseModels.add(caxTonModel2);


        CaxTonBeneficiaresModel caxTonModel3 = new CaxTonBeneficiaresModel();
        caxTonModel3.name="Tuesday";
        caxTonModel3.id="tuesday";
        caxTonBeneficiariesResponseModels.add(caxTonModel3);

        CaxTonBeneficiaresModel caxTonModel4 = new CaxTonBeneficiaresModel();
        caxTonModel4.name="Wednesday";
        caxTonModel4.id="wednesday";
        caxTonBeneficiariesResponseModels.add(caxTonModel4);

        CaxTonBeneficiaresModel caxTonModel5 = new CaxTonBeneficiaresModel();
        caxTonModel5.name="Thursday";
        caxTonModel5.id="thursday";
        caxTonBeneficiariesResponseModels.add(caxTonModel5);

        CaxTonBeneficiaresModel caxTonModel6 = new CaxTonBeneficiaresModel();
        caxTonModel6.name="Friday";
        caxTonModel6.id="friday";
        caxTonBeneficiariesResponseModels.add(caxTonModel6);

        CaxTonBeneficiaresModel caxTonModel7 = new CaxTonBeneficiaresModel();
        caxTonModel7.name="Saturday";
        caxTonModel7.id="saturday";
        caxTonBeneficiariesResponseModels.add(caxTonModel7);

        SizeArrayAdapter sizeStandingType = new SizeArrayAdapter(CaxTonStandingInstructionsActivity.this, caxTonBeneficiariesResponseModels);
        sizeStandingType.setDropDownViewResource(R.layout.spinner_item);
        spinner.setAdapter(sizeStandingType);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                caxTonStandingInstructionModel.days = caxTonBeneficiariesResponseModels.get(i).id;
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
        if (isFromEdit) {
            int positionType=0;
            for (int i=0; i<caxTonBeneficiariesResponseModels.size();i++){
                if(Objects.equals(caxTonBeneficiariesResponseModels.get(i).id, caxTonStandingInstructionModel.days)){
                    positionType = i;
                }
            }
            spinner.setSelection(positionType);
        }
    }

    private void addEditStandingApiCall(boolean isFromEdit, CaxTonStandingInstructionModel caxTonBeneficiaresModel) {
        try {
            if (progressBeneficiary != null) {
                progressBeneficiary.setVisibility(View.VISIBLE);
            }
            //progressDialog.show();
            String url = isFromEdit ? ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/standing-instructions/" + caxTonBeneficiaresModel.id : ApiEndPoints.ADD_EDIT_BENEFICIARY + userBankId + "/standing-instructions";
            Log.e("wallet_id", "wallet_id " + url);
            AndroidNetworking.post(url)
                    .addBodyParameter(caxTonBeneficiaresModel)
                    .build()
                    .getAsObject(WalletListModel.class, new ParsedRequestListener<WalletListModel>() {
                        @Override
                        public void onResponse(WalletListModel response) {
                            try {
                                progressDialog.dismiss();
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                if (dialog != null) {
                                    dialog.dismiss();
                                }
                                if(isFromEdit){
                                    caxTonStandingListAdapter.notifyItemChanged(beneficairesPosition);
                                }else{
                                    fetchStandingInstructionsList();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (progressBeneficiary != null) {
                                    progressBeneficiary.setVisibility(View.GONE);
                                }
                                progressDialog.dismiss();
                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonStandingInstructionsActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchBeneficiaryList() {
        try {
            String url = ApiEndPoints.BENEFICIARIES_LIST + userBankId + "/beneficiary";
            progressDialog.show();
            HashMap<String, String> params = new HashMap<>();
            params.put("business_id", myApp.getMyPreferences().getMerchantBusinesses().id);
            params.put("nopaginate", String.valueOf(1));
            AndroidNetworking.get(url)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(CaxTonBeneficiaresModel.class, new ParsedRequestListener<ArrayList<CaxTonBeneficiaresModel>>() {
                        @Override
                        public void onResponse(ArrayList<CaxTonBeneficiaresModel> response) {
                            try {
                                caxTonBeneficiariesResponseModels = response;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {

                                if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                    myApp.getMyPreferences().logoutMerchant();
                                    myApp.getMyPreferences().logout();
                                    ToastUtils.makeLongToast(CaxTonStandingInstructionsActivity.this, "Session expired");
                                } else if (anError.getErrorCode() > 200) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onError", "onError " + anError.getMessage());
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, apiError.getMessage());
                                    // Navigate to dashboard if any API error occurs
                                } else {
                                    ToastUtils.makeSnackToast(CaxTonStandingInstructionsActivity.this, "Something went wrong!!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}