package com.tiffintom.partner1.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.services_receivers.NetworkWatcher;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Amrish on 09-11-2020.
 */
public class ForgotPasswordActivity extends BaseActivity {
    private MaterialButton btnConfirm, btnLogin;
    private AppCompatEditText etEmail;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setListeners();

        try {
            new NetworkWatcher(this).observe(this, aBoolean -> {
                if (aBoolean){
                    Intent pushNotification = new Intent("NetworkChange");
                    // Toast.makeText(HomeActivity.this, "Internet Connected", Toast.LENGTH_LONG).show();
                    pushNotification.putExtra("isConnected", true);
                    LocalBroadcastManager.getInstance(ForgotPasswordActivity.this).sendBroadcast(pushNotification);
                } else {
                    Intent pushNotification = new Intent("NetworkChange");
                    //  Toast.makeText(HomeActivity.this, "Internet NOT Connected", Toast.LENGTH_LONG).show();
                    pushNotification.putExtra("isConnected", false);
                    LocalBroadcastManager.getInstance(ForgotPasswordActivity.this).sendBroadcast(pushNotification);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_forgot_password);
    }

    @Override
    protected void initViews() {
        super.initViews();
        btnConfirm = findViewById(R.id.btnConfirm);
        etEmail = findViewById(R.id.etEmail);
        btnLogin = findViewById(R.id.btnLogin);
    }

    private void setListeners() {
        btnConfirm.setOnClickListener(view -> {
            if (isValid()) new Thread(this::forgotPassword).start();
        });
        btnLogin.setOnClickListener(v -> {
            startActivity(new Intent(ForgotPasswordActivity.this, LoginActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
        });
    }

    private void forgotPassword() {
        try {
            runOnUiThread(() -> progressDialog.show());
            AndroidNetworking.post(ApiEndPoints.forgot_password)
                  //  .addBodyParameter("action", "forgetPassword")
                    .addPathParameter("username", etEmail.getText().toString())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                String errorMessage = myApp.checkErrorMessage(response);
                                runOnUiThread(() -> progressDialog.dismiss());
                                if (errorMessage == null) {
                                    try {
                                        String message = response.getJSONObject("result").getString("message");
                                        ToastUtils.makeToast(ForgotPasswordActivity.this, message);
                                        startActivity(new Intent(ForgotPasswordActivity.this, ForgetPasswordSuccessActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));

                                    } catch (JSONException e) {
                                        e.printStackTrace();
                                        ToastUtils.makeToast(ForgotPasswordActivity.this, e.getLocalizedMessage());

                                    }
                                } else {
                                    ToastUtils.makeToast(ForgotPasswordActivity.this, errorMessage);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                runOnUiThread(() -> progressDialog.dismiss());
                                anError.printStackTrace();
                                if (!CommonFunctions.isConnected(ForgotPasswordActivity.this)) {
                                    myApp.noInternet(ForgotPasswordActivity.this);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        etEmail.setError(null);

        if (Validators.isNullOrEmpty(etEmail.getText().toString())) {
            etEmail.setError("Please enter your email");
            etEmail.requestFocus();
            return false;
        }
        if (!Validators.isEmail(etEmail.getText().toString())) {
            etEmail.setError("Please enter valid email");
            etEmail.requestFocus();
            return false;
        }

        return true;
    }

    @Override
    protected void onStop() {
        CommonFunctions.hideKeyboard(this, etEmail);
        super.onStop();
    }

    BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (!intent.getBooleanExtra("isConnected", false)) {
                    try {
                        Intent i = new Intent(ForgotPasswordActivity.this, NoInternetActivity.class);
                        startActivityForResult(i, 67);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(ForgotPasswordActivity.this).registerReceiver(networkChangeReceiver, new IntentFilter("NetworkChange"));
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (networkChangeReceiver != null) {
            LocalBroadcastManager.getInstance(ForgotPasswordActivity.this).unregisterReceiver(networkChangeReceiver);
        }
    }
}
