package com.tiffintom.partner1.activities;

import static com.tiffintom.partner1.utils.Constants.AUTO_ACCEPT;
import static com.tiffintom.partner1.utils.Constants.BOOKING_ID;
import static com.tiffintom.partner1.utils.Constants.ORDER_ID;
import static com.tiffintom.partner1.utils.Constants.PREPARATION_TIME;

import android.Manifest;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.SwitchCompat;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.navigation.NavigationView;
import com.google.android.play.core.install.InstallStateUpdatedListener;
import com.google.android.play.core.install.model.ActivityResult;
import com.google.android.play.core.install.model.AppUpdateType;
import com.google.android.play.core.install.model.InstallStatus;
import com.google.android.play.core.install.model.UpdateAvailability;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.external.callable.Callback;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.tiffintom.partner1.BuildConfig;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.AidlUtil;
import com.tiffintom.partner1.common.printer.CS20PrintHelper;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.fragments.AnimatedConfirmationDialogFragment;
import com.tiffintom.partner1.fragments.CardReaderPaymentFragment;
import com.tiffintom.partner1.fragments.CaxTonCardAndBank;
import com.tiffintom.partner1.fragments.ChatHistoryFragment;
import com.tiffintom.partner1.fragments.ConfirmationExitDialogFragment;
import com.tiffintom.partner1.fragments.EnterIPDialogFragment;
import com.tiffintom.partner1.fragments.EnterPasswordDialogFragment;
import com.tiffintom.partner1.fragments.HomeFragment;
import com.tiffintom.partner1.fragments.MenuFragment;
import com.tiffintom.partner1.fragments.MerchantDashboardFragment;
import com.tiffintom.partner1.fragments.MerchantPrintersFragment;
import com.tiffintom.partner1.fragments.MerchantSettingsFragment;
import com.tiffintom.partner1.fragments.MotoAndPaymentLinkTabFragment;
import com.tiffintom.partner1.fragments.MotoPaymentFragment;
import com.tiffintom.partner1.fragments.OReportFragment;
import com.tiffintom.partner1.fragments.OrdersAllFragment;
import com.tiffintom.partner1.fragments.OrdersFragment;
import com.tiffintom.partner1.fragments.PaymentFragment;
import com.tiffintom.partner1.fragments.PaymentLinkFragment;
import com.tiffintom.partner1.fragments.PaymentTypeSelection;
import com.tiffintom.partner1.fragments.QRCodeFragment;
import com.tiffintom.partner1.fragments.ReservationsFragment;
import com.tiffintom.partner1.fragments.RestaurantChatWindowFragment;
import com.tiffintom.partner1.fragments.ReviewFragment;
import com.tiffintom.partner1.fragments.SettingsFragment;
import com.tiffintom.partner1.fragments.Theme2PaymentSelection;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.Counts;
import com.tiffintom.partner1.models.DeviceRegistration;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.MerchantCardReader;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.services_receivers.NetworkWatcher;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Objects;
import java.util.concurrent.Callable;

public class HomeActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_home);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getIntent() != null) destination = getIntent().getStringExtra("destination");

        if (getIntent().getExtras() != null) {
            Bundle bundle = getIntent().getExtras();
            if (bundle != null) {
                for (String key : bundle.keySet()) {
                    LogUtils.w("HOMEEXTRAS", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
                    try {
                        if (key.equalsIgnoreCase("data")) {
                            JSONObject data = new JSONObject(getIntent().getStringExtra("data"));
                            Log.e("Amount ", " " + data.getString("amount"));
                            if (data.has("amount")) {
                                destination = null;
                                managePaymentLinkResponse(data.getString("amount"), data.getString("status"),
                                        data.getString("transaction_id"), data.getString("phone"), data.getString("email"));
                            }
                            break;
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (getIntent() != null && getIntent().hasExtra("amount")) {
                    try {
                        Log.e("Amount ", " " + getIntent().getStringExtra("amount"));
                        destination = null;
                        managePaymentLinkResponse(getIntent().getStringExtra("amount"), getIntent().getStringExtra("status"),
                                getIntent().getStringExtra("transaction_id"), getIntent().getStringExtra("phone"), getIntent().getStringExtra("email"));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        /*if (getIntent() != null&&getIntent().hasExtra("data"))
        {
            try {
                JSONObject data = new JSONObject(getIntent().getStringExtra("data"));
                Log.e("Amount "," "+data.getString("amount"));
                if (data.has("amount")) {
                    destination=null;
                    managePaymentLinkResponse(data.getString("amount"),data.getString("status"),
                            data.getString("transaction_id"));
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }*/
    }

    @Override
    protected void initViews() {
        super.initViews();
        // set firebase custom keys
        myApp.setFirebaseCustomKey();
        color = ContextCompat.getColor(this, R.color.persian_green);
        /*if (merchantBusinesses != null && merchantBusinesses.settings != null) {
            myApp.siteSettings = merchantBusinesses.settings;
        }*/
        if (merchantBusinesses != null && merchantBusinesses.image_url != null)
            myApp.generateMerchantLogoBitmap();
        if (merchantBusinesses != null) {
            myApp.getOnlineOrderTiffinTomLogo(merchantBusinesses.print_logo);
        }
        myApp.generateRestaurantLogoBitmap();
        appBarLayout = findViewById(R.id.appbar);
        cvToolbar = findViewById(R.id.cvToolbar);
        toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        rlHeader = findViewById(R.id.rlHeader);
        drawer = findViewById(R.id.drawer_layout);
        navigationView = findViewById(R.id.nav_view);
        tvMenu = findViewById(R.id.tvMenu);
        ivNext = findViewById(R.id.ivNext);
        llLogout = findViewById(R.id.llLogout);
        rbGroup = findViewById(R.id.rbGroup);
        rbThemePayment = findViewById(R.id.rbThemePayment);
        tvVersion = findViewById(R.id.tvVersion);
        tvDeviceName = findViewById(R.id.tvDeviceName);
        tvAddress = findViewById(R.id.tvAddress);
        ivProfile = findViewById(R.id.ivProfile);

        rbOverview = findViewById(R.id.rbOverView);
        rbRestaurantLogin = findViewById(R.id.rbRestaurantLogin);
        rbTheme1 = findViewById(R.id.rbTheme1);
        rbTheme2 = findViewById(R.id.rbTheme2);
        rbMerchantLogin = findViewById(R.id.rbMerchantLogin);
        rbChat = findViewById(R.id.rbChats);
        rbMenu = findViewById(R.id.rbMenu);
        rbOrders = findViewById(R.id.rbOrders);
        rbOrdersHistory = findViewById(R.id.rbOrdersHistory);
        rbReservations = findViewById(R.id.rbReservations);
        rbReviews = findViewById(R.id.rbRatingReviews);
        rbSettings = findViewById(R.id.rbSettings);
        rbChangeIP = findViewById(R.id.rbChangeIP);
        toastLayout = findViewById(R.id.toast_layout_root);
        llPaymentTheme = findViewById(R.id.llPaymentTheme);

        flOverview = findViewById(R.id.flOverview);
        flMerchantOverview = findViewById(R.id.flMerchantOverview);
        flRestaurantLogin = findViewById(R.id.flRestaurantLogin);
        flBusinessChange = findViewById(R.id.flBusinessChange);
        flCardReadrUsb = findViewById(R.id.flCardReadrUsb);
        flBankingService = findViewById(R.id.flBankingService);
        flDisconnectReader = findViewById(R.id.flDisconnectReader);
        flReport = findViewById(R.id.flReport);
        switchIsUsb = findViewById(R.id.switchIsUsb);
        flMerchantLogin = findViewById(R.id.flMerchantLogin);
        flOrders = findViewById(R.id.flOrders);
        flOrdersHistory = findViewById(R.id.flOrdersHistory);
        flReservations = findViewById(R.id.flReservations);
        flReviews = findViewById(R.id.flReviewsRating);
        flChat = findViewById(R.id.flChats);
        flPayments = findViewById(R.id.flPayments);
        flMenu = findViewById(R.id.flMenu);
        flSettings = findViewById(R.id.flSettings);
        flDeviceType = findViewById(R.id.flSelectdevice);
        flSettingScreen = findViewById(R.id.flSettingScreen);
        flChangePrinter = findViewById(R.id.flChangePrinter);
        flChangeIP = findViewById(R.id.flChangePrinterIP);
        flSupervisorLogin = findViewById(R.id.flSupervisorLogin);
        flMerchantSettings = findViewById(R.id.flMerchantSettings);

        vOverview = findViewById(R.id.vOverview);
        vMerchantOverview = findViewById(R.id.vMerchantOverview);
        vRestaurantLogin = findViewById(R.id.vRestaurantLogin);
        vBusinessChange = findViewById(R.id.vBusinessChange);
        vReport = findViewById(R.id.vReport);
        vMerchantLogin = findViewById(R.id.vMerchantLogin);
        vOrders = findViewById(R.id.vOrders);
        vOrdersHistory = findViewById(R.id.vOrdersHistory);
        vReservations = findViewById(R.id.vReservations);
        vReviews = findViewById(R.id.vReviewsRating);
        vChat = findViewById(R.id.vChats);
        vPayments = findViewById(R.id.vPayments);
        vDeviceType = findViewById(R.id.vDeviceType);
        vMenu = findViewById(R.id.vMenu);
        vReviewsRating = findViewById(R.id.vReviewsRating);
        vSettings = findViewById(R.id.vSettings);
        vMerchantSettings = findViewById(R.id.vMerchantSettings);
        vChangeIP = findViewById(R.id.vChangePrinterIP);

        tvChatCounts = findViewById(R.id.tvChatsCount);
        tvOrdersCounts = findViewById(R.id.tvOrdersCount);
        tvReservationsCounts = findViewById(R.id.tvReservationsCount);
        tvReviewsCounts = findViewById(R.id.tvReviewRatingsCount);
        tvSupervisorLogin = findViewById(R.id.tvSupervisorLogin);

        tvVersion.setText("Version " + BuildConfig.VERSION_NAME);
        if (myApp.getMyPreferences().getDeviceRegistration() != null) {
            tvDeviceName.setText("Device Id " + myApp.getMyPreferences().getDeviceRegistration().device_id);
        }
        actionBarDrawerToggle = new ActionBarDrawerToggle(
                this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        drawer.addDrawerListener(actionBarDrawerToggle);
        actionBarDrawerToggle.syncState();
        if (merchantBusinesses.online_service) {
            flReport.setVisibility(View.VISIBLE);
        } else {
            flReport.setVisibility(View.GONE);
        }
        if (Terminal.isInitialized() && Terminal.getInstance().getConnectedReader() != null) {
            flDisconnectReader.setVisibility(View.VISIBLE);
        }
        flDisconnectReader.setOnClickListener(view -> {
            flDisconnectReader.setVisibility(View.GONE);
            myApp.getMyPreferences().saveCardReaderConnect("");
            myApp.getMyPreferences().saveLocationId("");
            myApp.getMyPreferences().saveSerialNumber("");
            runOnUiThread(() -> ToastUtils.makeToast(this, "Disconnect successfully"));
            Terminal.getInstance().disconnectReader(new Callback() {
                @Override
                public void onSuccess() {

                }

                @Override
                public void onFailure(@NonNull TerminalException e) {

                }
            });
        });
        flReport.setOnClickListener(view -> validateDevice(() -> {
            checkNavigationItem(vReport);
            changeFragment(new OReportFragment());
            return null;
        }));
        if (myApp.getMyPreferences().getPaymentTheme().equalsIgnoreCase("theme2")) {
            rbThemePayment.check(rbTheme2.getId());
        } else {
            rbThemePayment.check(rbTheme1.getId());
        }
        rbThemePayment.setOnCheckedChangeListener((radioGroup, i) -> {
            if (radioGroup.getCheckedRadioButtonId() == R.id.rbTheme1) {
                myApp.getMyPreferences().savePaymentTheme("theme1");
                startActivity(new Intent(this, HomeActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
            } else {
                myApp.getMyPreferences().savePaymentTheme("theme2");
                startActivity(new Intent(this, HomeActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
            }
        });
    }

    private void checkUpdate() {
        if (myApp.appUpdateManager != null) {
            myApp.appUpdateManager.getAppUpdateInfo();
            myApp.appUpdateManager.getAppUpdateInfo().addOnSuccessListener(appUpdateInfo -> {
                if (appUpdateInfo.updateAvailability() == UpdateAvailability.UPDATE_AVAILABLE
                        && appUpdateInfo.isUpdateTypeAllowed(AppUpdateType.IMMEDIATE)) {
                    // Request the update.
                    Log.d("TAG", "Update available");
                    myApp.appUpdateManager.registerListener(listener);
                    try {
                        myApp.appUpdateManager.startUpdateFlowForResult(
                                // Pass the intent that is returned by 'getAppUpdateInfo()'.
                                appUpdateInfo,
                                // Or 'AppUpdateType.FLEXIBLE' for flexible updates.
                                AppUpdateType.IMMEDIATE,
                                // The current activity making the update request.
                                this,
                                // Include a request code to later monitor this update request.
                                MY_REQUEST_CODE);
                    } catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    Log.d("", "No Update available");
                }
            });
        }
    }

    private boolean isDownloadedConfirmDialogAdded = false;
    // Create a listener to track request state updates.
    InstallStateUpdatedListener listener = state -> {
        // (Optional) Provide a download progress bar.
        if (state.installStatus() == InstallStatus.DOWNLOADING) {
            /*long bytesDownloaded = state.bytesDownloaded();
            long totalBytesToDownload = state.totalBytesToDownload();*/
            // Implement progress bar.
        } else if (state.installStatus() == InstallStatus.DOWNLOADED) {
            unRegisterList();
            popupSnackbarForCompleteUpdate();
        }
        // Log state or install the update.
    };

    // Displays the snackbar notification and call to action.
    private void popupSnackbarForCompleteUpdate() {
        if (myApp.appUpdateManager != null && !isDownloadedConfirmDialogAdded) {
            isDownloadedConfirmDialogAdded = true;
            AlertDialog alertDialog = new AlertDialog.Builder(HomeActivity.this).create();
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View dialogView = inflater.inflate(R.layout.dialog_logout, null);
            LottieAnimationView animation_view = dialogView.findViewById(R.id.animation_view);
            animation_view.setVisibility(View.GONE);
            View viewDivider = dialogView.findViewById(R.id.viewDivider);
            TextView tvInfo1 = dialogView.findViewById(R.id.tvInfo1);
            TextView tvInfo = dialogView.findViewById(R.id.tvInfo);
            tvInfo1.setVisibility(View.INVISIBLE);
            tvInfo.setText("An update has just been downloaded.");
            TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
            TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);
            tvCancle.setVisibility(View.GONE);
            viewDivider.setVisibility(View.GONE);
            tvConfirm.setText("RESTART");
            tvConfirm.setOnClickListener(view -> {
                try {
                    myApp.appUpdateManager.completeUpdate();
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
                alertDialog.dismiss();
            });
            tvCancle.setOnClickListener(view -> alertDialog.dismiss());

            alertDialog.setView(dialogView);
            alertDialog.setCancelable(false);
            alertDialog.setOnDismissListener(dialogInterface -> isDownloadedConfirmDialogAdded = false);
            alertDialog.show();
        }
    }

    private void unRegisterList() {
        if (myApp.appUpdateManager != null) {
            myApp.appUpdateManager.unregisterListener(listener);
        }
    }

    private AppBarLayout appBarLayout;
    private MaterialCardView cvToolbar;
    private Toolbar toolbar;
    private ActionBarDrawerToggle actionBarDrawerToggle;
    private int MY_REQUEST_CODE = 123;
    private Counts allCounts;
    private DrawerLayout drawer;
    private NavigationView navigationView;
    private LinearLayout llLogout;
    private RelativeLayout rlHeader;
    private RadioGroup rbGroup, rbThemePayment;
    private TextView tvVersion, tvAddress, tvMenu, tvDeviceName;
    private ImageView ivProfile, ivNext;
    private LinearLayout toastLayout, llPaymentTheme;
    private RadioButton rbTheme1, rbTheme2, rbRestaurantLogin, rbMerchantLogin, rbOrders, rbChat, rbReservations, rbReviews, rbMenu, rbSettings, rbOverview, rbChangeIP, rbOrdersHistory;
    private FrameLayout flReport, flDisconnectReader, flBankingService, flCardReadrUsb, flBusinessChange, flRestaurantLogin, flMerchantLogin, flOrders, flChat, flReservations, flReviews, flPayments, flDeviceType, flMenu, flSettings, flMerchantOverview, flOverview, flChangeIP, flChangePrinter, flSupervisorLogin, flOrdersHistory, flMerchantSettings, flSettingScreen;
    private View vReport, vBusinessChange, vRestaurantLogin, vMerchantLogin, vOrders, vChat, vReservations, vReviews, vMenu, vReviewsRating, vPayments, vDeviceType, vSettings, vOverview, vChangeIP, vOrdersHistory, vMerchantSettings, vMerchantOverview;
    private TextView tvRestaurantLoginCounts, tvMerchantLoginCounts, tvOrdersCounts, tvChatCounts, tvReservationsCounts, tvReviewsCounts, tvMenuCounts, tvSettingsCounts, tvOverviewCounts, tvChangeIPCounts, tvSupervisorLogin;
    private int lastCheckedId = -1;
    private String destination;
    private int merchantRole = myApp.getMyPreferences().getMerchantRole();
    private boolean isCardReaderReStart = false;
    int color;
    private SwitchCompat switchIsUsb;
    public int height = 0, width = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            getHeightWidth();
            setListner();
            updateViews();
            listenSidebarItemsClick();
            checkUpdate();
            if (!AidlUtil.getInstance().isConnect())
                AidlUtil.getInstance().connectPrinterService(this);

            if (loggedInRestaurant != null && loggedInRestaurant.restaurant_booktable.equalsIgnoreCase("yes")) {
                flReservations.setVisibility(View.VISIBLE);
            } else {
                flReservations.setVisibility(View.GONE);
            }
            wakeupScreen();
            setUpPrinters();
            // this.registerReceiver(new CheckConnectivity(), new IntentFilter(android.net.ConnectivityManager.CONNECTIVITY_ACTION));
            try {
                new NetworkWatcher(this).observe(this, aBoolean -> {
                    if (aBoolean) {
                        Intent pushNotification = new Intent("NetworkChange");
                        // Toast.makeText(HomeActivity.this, "Internet Connected", Toast.LENGTH_LONG).show();
                        pushNotification.putExtra("isConnected", true);
                        LocalBroadcastManager.getInstance(HomeActivity.this).sendBroadcast(pushNotification);
                    } else {
                        Intent pushNotification = new Intent("NetworkChange");
                        //  Toast.makeText(HomeActivity.this, "Internet NOT Connected", Toast.LENGTH_LONG).show();
                        pushNotification.putExtra("isConnected", false);
                        LocalBroadcastManager.getInstance(HomeActivity.this).sendBroadcast(pushNotification);
                    }
                });
                if (myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase(getString(R.string.ubsidi_cs30))) {
                    myApp.cs20PrintHelper = new CS20PrintHelper();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpPrinters() {
        try {
            if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getPrinterIP())) {
                zoneRichPrinter = new ZoneRichPrinter(HomeActivity.this);
            }
            sunmiPrinter = new SunmiPrinter(HomeActivity.this);
            bluetoothPrinter = new BluetoothPrinter(HomeActivity.this);

            // For testing
/*
            if (BuildConfig.DEBUG) {
                if (bluetoothPrinter != null) {
                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                    if (device != null) {
                        ToastUtils.makeToast(HomeActivity.this, device.getName() + " Connected");
                    } else {
                        ToastUtils.makeToast(HomeActivity.this, "Default printer " + MyApp.getInstance().getMyPreferences().getDefaultPrinter());
                    }
                }
            }
*/

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void wakeupScreen() {
        try {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
            PowerManager powerManager = (PowerManager) getSystemService(POWER_SERVICE);
            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK,
                    "MyApp::MyWakelockTag");
            wakeLock.acquire();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            setTitle("");
            handleNavigation();
            boolean isContainsReader = false;
            for (int i = 0; i < myApp.getMyPreferences().getMerchantBusinesses().card_readers.size(); i++) {
                MerchantCardReader businessCardReader = myApp.getMyPreferences().getMerchantBusinesses().card_readers.get(i);
                if (businessCardReader.connectivity.toLowerCase().equalsIgnoreCase("stripebluetooth")
                        || businessCardReader.connectivity.toLowerCase().equalsIgnoreCase("posbluetooth")) {
                    isContainsReader = true;
                }
            }
            if (isContainsReader) {
                flCardReadrUsb.setVisibility(View.VISIBLE);
                switchIsUsb.setChecked(myApp.getMyPreferences().getIsUbEnableStatus());
            }
            switchIsUsb.setOnCheckedChangeListener((compoundButton, b) -> {
                if (compoundButton.isPressed()) {
                    myApp.getMyPreferences().saveIsUsb(b);
                    if (Terminal.isInitialized()) {
                        Terminal.getInstance().disconnectReader(new Callback() {
                            @Override
                            public void onSuccess() {

                            }

                            @Override
                            public void onFailure(@NonNull TerminalException e) {

                            }
                        });
                    }
                }
            });
            if (myApp.getMyPreferences().getMerchantBusinesses() != null && myApp.getMyPreferences().getMerchantBusinesses().issuing_service) {
                if (myApp.getMyPreferences().getDeviceRegistration().caller_id) {
                    flBankingService.setVisibility(View.VISIBLE);
                } else {
                    flBankingService.setVisibility(View.GONE);
                }
            } else {
                flBankingService.setVisibility(View.GONE);
            }
            if (loggedInRestaurant != null) {
                tvAddress.setText(loggedInRestaurant.street_address);
                if (!Validators.isNullOrEmpty(myApp.getMyPreferences().getLoggedInRestaurant().logo_name)) {
                    Glide.with(this)
                            .load(loggedInRestaurant.logo_name)
                            .placeholder(R.drawable.user_profile_image_placeholder)
                            .error(R.drawable.user_profile_image_placeholder)
                            .into(ivProfile);
                }
                if (loggedInRestaurant.restaurant_booktable.equalsIgnoreCase("yes")) {
                    flReservations.setVisibility(View.VISIBLE);
                } else {
                    flReservations.setVisibility(View.GONE);
                }
                if (loggedInRestaurant.app_setting.equalsIgnoreCase("yes")) {
                    flSettings.setVisibility(View.VISIBLE);
                } else {
                    flSettings.setVisibility(View.GONE);
                }

                rbRestaurantLogin.setVisibility(View.GONE);
                flRestaurantLogin.setVisibility(View.GONE);
                flMerchantLogin.setVisibility(View.GONE);
                llLogout.setVisibility(View.GONE);
                if (loggedInMerchant == null) {
                    rbMerchantLogin.setVisibility(View.VISIBLE);
                    flMerchantSettings.setVisibility(View.GONE);
                    flMerchantOverview.setVisibility(View.GONE);
                    merchantRole = -1;
                    if (myApp.getMyPreferences().getMerchantBusinesses() != null && myApp.getMyPreferences().getMerchantBusinesses().merchant_service) {
                        flMerchantLogin.setVisibility(View.VISIBLE);
                    }
                }
            } else if (loggedInMerchant != null) {
                tvAddress.setText(merchantBusinesses.name);
                if (!Validators.isNullOrEmpty(merchantBusinesses.image_url)) {
                    Glide.with(this)
                            .load(merchantBusinesses.image_url)
                            .placeholder(R.drawable.user_profile_image_placeholder)
                            .error(R.drawable.user_profile_image_placeholder)
                            .into(ivProfile);
                }

                tvMenu.setVisibility(View.GONE);
                ivNext.setVisibility(View.GONE);

                flOverview.setVisibility(View.GONE);
                flOrders.setVisibility(View.GONE);
                flOrdersHistory.setVisibility(View.GONE);
                flChat.setVisibility(View.GONE);
                flReservations.setVisibility(View.GONE);
                flReviews.setVisibility(View.GONE);
                flMenu.setVisibility(View.GONE);
                flSettings.setVisibility(View.GONE);
                flPayments.setVisibility(View.GONE);
                flMerchantLogin.setVisibility(View.GONE);
                flRestaurantLogin.setVisibility(View.GONE);

                rbOrders.setVisibility(View.GONE);
                rbOrdersHistory.setVisibility(View.GONE);
                rbChat.setVisibility(View.GONE);
                rbReservations.setVisibility(View.GONE);
                rbReviews.setVisibility(View.GONE);
                rbMenu.setVisibility(View.GONE);
                rbSettings.setVisibility(View.GONE);
                rbMerchantLogin.setVisibility(View.GONE);
                rbRestaurantLogin.setVisibility(View.VISIBLE);
                rbOverview.setVisibility(View.GONE);
                llLogout.setVisibility(View.VISIBLE);
            }
            updateMerchantView();
            if (myApp.getMyPreferences().getDefaultPrinter() != null && myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                rbChangeIP.setVisibility(View.VISIBLE);
                flChangeIP.setVisibility(View.VISIBLE);
            } else {
                rbChangeIP.setVisibility(View.GONE);
                flChangeIP.setVisibility(View.GONE);
            }
            flChangePrinter.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleNavigation() {
        try {
            if (myApp.getMyPreferences().isReStartFromCardReader()) {
                isCardReaderReStart = true;
                myApp.getMyPreferences().saveReStartFromCardReader(false);
                if (myApp.getMyPreferences().getPaymentTheme().equalsIgnoreCase("theme2")) {
                    changeFragment(new Theme2PaymentSelection());
                } else {
                    changeFragment(CardReaderPaymentFragment.getInstance());
                }
            } else {
                if (loggedInRestaurant != null) {
                    if (destination != null) {
                        if (destination.equalsIgnoreCase("orders")) {
                            checkNavigationItem(vOrders);
                            changeFragment(OrdersFragment.getInstance());
                        }
                        if (destination.equalsIgnoreCase("orders history")) {
                            checkNavigationItem(vOrdersHistory);
                            changeFragment(OrdersAllFragment.getInstance());
                        }
                        if (destination.equalsIgnoreCase("reservations")) {
                            checkNavigationItem(vReservations);
                            changeFragment(ReservationsFragment.getInstance());
                        }
                    } else {
                        rbOverview.setChecked(true);
                        checkNavigationItem(vOverview);
                        changeFragment(HomeFragment.getInstance());
                    }
                } else {
                    rbOverview.setChecked(true);
                    checkNavigationItem(vMerchantOverview);
                    if (loggedInMerchant != null) {
                        changeFragment(MerchantDashboardFragment.getInstance());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listenSidebarItemsClick() {
        rbGroup.setOnCheckedChangeListener((group, checkedId) -> {
            if (progressDialog != null) progressDialog.dismiss();
            drawer.closeDrawer(GravityCompat.START);
            if (checkedId == R.id.rbOverView) {
                if (loggedInRestaurant != null) {
                    changeFragment(HomeFragment.getInstance());
                } else {
                    if (loggedInMerchant != null) {
                        changeFragment(MerchantDashboardFragment.getInstance());
                    }
                }

                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbOrders) {
                changeFragment(OrdersFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbReservations) {
                changeFragment(ReservationsFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbChats) {
                changeFragment(ChatHistoryFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbRatingReviews) {
                changeFragment(ReviewFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbPayments) {
                changeFragment(PaymentFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbSelcetDevice) {
                changeFragment(MerchantDashboardFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbSettings) {
                changeFragment(SettingsFragment.getInstance());
                lastCheckedId = checkedId;
            } else if (checkedId == R.id.rbRestaurantLogin) {
                startActivity(new Intent(this, LoginActivity.class));
                finish();
            } else if (checkedId == R.id.rbMerchantLogin) {
                startActivity(new Intent(this, LoginActivity.class).putExtra("select_restaurant", false));
                finish();
            } else if (checkedId == R.id.rbChangeIP) {
                if (lastCheckedId != -1) {
                    rbGroup.setOnCheckedChangeListener(null);
                    rbGroup.check(lastCheckedId);
                    listenSidebarItemsClick();
                } else {
                    rbChangeIP.setChecked(false);
                }
                EnterIPDialogFragment enterIPDialogFragment = EnterIPDialogFragment.getInstance();
                enterIPDialogFragment.show(getSupportFragmentManager(), "enter_ip");

            }
        });
    }

    private void setListner() {
//        llLogout.setOnClickListener(v -> askForLogout());
        ivNext.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vMenu);
                changeFragment(MenuFragment.getInstance());
                return null;
            });
        });
        tvMenu.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vMenu);
                changeFragment(MenuFragment.getInstance());
                return null;
            });
        });
        toastLayout.setOnClickListener(view -> {
            validateDevice(() -> {
                flOrders.performClick();
                return null;
            });
        });
        flMerchantLogin.setOnClickListener(view -> {
            validateDevice(() -> {
                startActivity(new Intent(this, LoginActivity.class).putExtra("select_restaurant", false));
                finish();
                return null;
            });
        });
        flBankingService.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vReviewsRating);
                changeFragment(CaxTonCardAndBank.newInstance());
                return null;
            });
        });
        flRestaurantLogin.setOnClickListener(view -> {
            validateDevice(() -> {
                if (merchantRole != 2) {
                    askForMerchantPasswordAndLetThemDoRestaurantLogin(true);
                } else {
                    startActivity(new Intent(this, LoginActivity.class));
                    finish();
                }
                return null;
            });
        });
        llLogout.setOnClickListener(view -> {
            askForPasswordAndLetThemGoToLoginScreen(false);
        });
        flOverview.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vOverview);
                if (loggedInRestaurant != null) {
                    changeFragment(HomeFragment.getInstance());
                }
                return null;
            });
        });
        flBusinessChange.setOnClickListener(view -> {
            checkNavigationItem(vBusinessChange);
            Intent intent = new Intent(this, TransportActivity.class).putExtra("destination", "restaurant_selection").putExtra("finish", true)
                    .putExtra("is_from_business_change", true);
            startActivity(intent);
        });
        flMerchantOverview.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vMerchantOverview);
                if (loggedInMerchant != null) {
                    changeFragment(MerchantDashboardFragment.getInstance());
                }
                return null;
            });
        });
        flOrders.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vOrders);
                changeFragment(OrdersFragment.getInstance());
                return null;
            });
        });
        flOrdersHistory.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vOrdersHistory);
                changeFragment(OrdersAllFragment.getInstance());
                return null;
            });
        });

        flReservations.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vReservations);
                changeFragment(ReservationsFragment.getInstance());
                return null;
            });
        });
        flChat.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vChat);
                changeFragment(ChatHistoryFragment.getInstance());
                return null;
            });
        });
        flReviews.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vReviews);
                changeFragment(ReviewFragment.getInstance());
                return null;
            });
        });
        flPayments.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vPayments);
                changeFragment(PaymentFragment.getInstance());
                return null;
            });
        });
        flDeviceType.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vDeviceType);
                changeFragment(MerchantPrintersFragment.getInstance());
                return null;
            });
        });

        flMenu.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vMenu);
                changeFragment(MenuFragment.getInstance());
                return null;
            });
        });
        flChangeIP.setOnClickListener(view -> {
            validateDevice(() -> {
                EnterIPDialogFragment enterIPDialogFragment = EnterIPDialogFragment.getInstance();
                enterIPDialogFragment.show(getSupportFragmentManager(), "enter_ip");
                return null;
            });
        });
        flChangePrinter.setOnClickListener(view -> {
            validateDevice(() -> {
                Intent intent = new Intent(this, TransportActivity.class).putExtra("destination", "printer_selection").putExtra("finish", true);
                startActivity(intent);
                return null;
            });
        });
        flMerchantSettings.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vMerchantSettings);
                changeFragment(MerchantSettingsFragment.getInstance());
                return null;
            });
        });
        flSettings.setOnClickListener(view -> {
            validateDevice(() -> {
                checkNavigationItem(vSettings);
                changeFragment(SettingsFragment.getInstance());
                return null;
            });
        });
        flSupervisorLogin.setOnClickListener(view -> {
            try {
                validateDevice(() -> {
                    drawer.closeDrawer(GravityCompat.START);
                    if (merchantRole == 0) {
                        EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("", "Please enter password", "Please enter to login as Supervisor");
                        enterPasswordDialogFragment.show(getSupportFragmentManager(), "password");
                        enterPasswordDialogFragment.setDialogDismissListener(o -> {
                            if (o instanceof String) {
                                String password = (String) o;
                                if (password.equalsIgnoreCase(merchantBusinesses.supervisor_password)) {
                                    merchantRole = 1;
                                    myApp.getMyPreferences().saveMerchantRole(1);
                                    updateMerchantView();
                                    CommonFunctions.showSnackBar(this, drawer, "Logged in successfully");
                                    tvSupervisorLogin.setText("Exit Supervisor");
                                    notifyMerchantLoginEvent();
                                    openHome();
                                } else if (password.equalsIgnoreCase(merchantBusinesses.admin_password)) {
                                    merchantRole = 2;
                                    myApp.getMyPreferences().saveMerchantRole(2);
                                    updateMerchantView();
                                    CommonFunctions.showSnackBar(this, drawer, "Logged in successfully");
                                    tvSupervisorLogin.setText("Exit Admin");
                                    notifyMerchantLoginEvent();
                                    openHome();
                                } else {
                                    tvSupervisorLogin.setText("Supervisor");
                                    CommonFunctions.showSnackBar(this, drawer, "Wrong password");
                                }
                            }
                        });
                    } else {
                        CommonFunctions.showSnackBar(this, drawer, "Logout successfully");
                        myApp.getMyPreferences().saveMerchantRole(0);
                        merchantRole = 0;
                        updateMerchantView();
                        tvSupervisorLogin.setText("Supervisor");
                        Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
                        openHome();
                        notifyMerchantLoginEvent();
                    }
                    return null;
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        LocalBroadcastManager.getInstance(this).registerReceiver(new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    if (intent.getBooleanExtra("refresh", false)) {
                        allCounts = new Gson().fromJson(intent.getStringExtra("counts"), Counts.class);
                        toastLayout.setVisibility(View.GONE);
                        fetchBusinesses();
                        invalidateOptionsMenu();
                        if (allCounts != null) {
                            if (allCounts.pending_orders > 0) {
                                Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
                                if (openedFragment instanceof OrdersFragment || openedFragment instanceof RestaurantChatWindowFragment
                                        || openedFragment instanceof CardReaderPaymentFragment || openedFragment instanceof MotoAndPaymentLinkTabFragment
                                        || openedFragment instanceof QRCodeFragment || openedFragment instanceof PaymentTypeSelection || openedFragment instanceof MotoPaymentFragment
                                        || openedFragment instanceof PaymentLinkFragment || openedFragment instanceof Theme2PaymentSelection) {
                                    toastLayout.setVisibility(View.GONE);
                                } else
                                    toastLayout.setVisibility(View.VISIBLE);
                                tvOrdersCounts.setVisibility(View.VISIBLE);
                                tvOrdersCounts.setText(String.valueOf(allCounts.pending_orders));
                            } else {
                                tvOrdersCounts.setVisibility(View.GONE);
                            }
                            if (allCounts.pending_bookings > 0) {
                                tvReservationsCounts.setVisibility(View.VISIBLE);
                                tvReservationsCounts.setText(String.valueOf(allCounts.pending_bookings));
                            } else {
                                tvReservationsCounts.setVisibility(View.GONE);
                            }
                            if (allCounts.new_reviews > 0) {
                                tvReviewsCounts.setVisibility(View.VISIBLE);
                                tvReviewsCounts.setText(String.valueOf(allCounts.new_reviews));
                            } else {
                                tvReviewsCounts.setVisibility(View.GONE);
                            }
                            if (allCounts.unread_chat > 0) {
                                tvChatCounts.setVisibility(View.VISIBLE);
                                tvChatCounts.setText(String.valueOf(allCounts.unread_chat));
                            } else {
                                tvChatCounts.setVisibility(View.GONE);
                            }

                        }
                        // accept booking request
                        String order_id = intent.getStringExtra(ORDER_ID);
                        String preparation_time = intent.getStringExtra(PREPARATION_TIME);
                        int booking_id = intent.getIntExtra(BOOKING_ID, 0);
                        boolean auto_accept = intent.getBooleanExtra(AUTO_ACCEPT, false);
                        if (auto_accept && booking_id != 0) {
                            Reservation onlineReservation = new Reservation();
                            onlineReservation.status = "Approved";
                            onlineReservation.id = booking_id;
                            myApp.changeStatusOnlineReservation(onlineReservation, HomeActivity.this);
                        }
                        if (!Validators.isNullOrEmpty(order_id) || !auto_accept) {
                            if (!Validators.isNullOrEmpty(preparation_time)) {
                                myApp.acceptOrder("Accepted", order_id, preparation_time, HomeActivity.this);
                            }
                        }
                    }
                    if (intent.getBooleanExtra("paymentDone", false) && intent.hasExtra("amount")) {
                        managePaymentLinkResponse(intent.getStringExtra("amount"), intent.getStringExtra("status"),
                                intent.getStringExtra("transaction_id"), intent.getStringExtra("phone"), intent.getStringExtra("email"));
                    }
                    if (intent.getBooleanExtra("hide_toast_layout", false)) {
                        toastLayout.setVisibility(View.GONE);
                    }
                } catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }, new IntentFilter(Constants.NOTIFICATION));

    }

    private void validateDevice(Callable<Void> nextMethod) {
        try {
            progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.MERCHANT_DEVICE_REGISTRATION)
                    .addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addBodyParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addBodyParameter("device_id", myApp.getMyPreferences().getAndroidDeviceId())
                    .addBodyParameter("device_type", "Android")
                    .addBodyParameter("service_type", "Merchant")
                    .addBodyParameter("device_token", myApp.getMyPreferences().getUserFCMToken())
                    .build()
                    .getAsObject(DeviceRegistration.class, new ParsedRequestListener<DeviceRegistration>() {
                        @Override
                        public void onResponse(DeviceRegistration response) {
                            try {
                                progressDialog.dismiss();
                                myApp.getMyPreferences().saveDeviceRegistration(response);
                                if (myApp.getMyPreferences().getMerchantBusinesses() != null && myApp.getMyPreferences().getMerchantBusinesses().issuing_service) {
                                    if (response.caller_id) {
                                        flBankingService.setVisibility(View.VISIBLE);
                                    } else {
                                        flBankingService.setVisibility(View.GONE);
                                    }
                                } else {
                                    flBankingService.setVisibility(View.GONE);
                                }
                                if (Validators.isNullOrEmpty(response.status)) {
                                    Intent intent = new Intent(HomeActivity.this, RegisterDeviceActivity.class);
                                    startActivity(intent);
                                } else {
                                    if (!Validators.isNullOrEmpty(response.status) && !response.status.equalsIgnoreCase("approved")) {
                                        Intent intent = new Intent(HomeActivity.this, RegisterDeviceActivity.class);
                                        startActivity(intent);
                                    } else {
                                        nextMethod.call();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorDetail() != null && anError.getErrorDetail().toLowerCase().equalsIgnoreCase("connectionError")) {
                                    //myApp.noInternet(SplashActivity.this);
                                    //myApp.noInternet(HomeActivity.this);
                                    Intent i = new Intent(HomeActivity.this, NoInternetActivity.class);
                                    startActivityForResult(i, 67);
                                }
                                if (anError.getErrorCode() == 400 && anError.getErrorAsObject(ApiError.class) != null) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeToast(HomeActivity.this, apiError.getMessage());
                                } else {
                                    ToastUtils.makeToast(HomeActivity.this, "Unknown Error");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchBusinesses() {
        try {
            AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES + myApp.getMyPreferences().getBusinessId())
                    .build()
                    .getAsObject(MerchantBusinesses.class, new ParsedRequestListener<MerchantBusinesses>() {
                        @Override
                        public void onResponse(MerchantBusinesses response) {
                            try {
                                myApp.getMyPreferences().saveMerchantBusinesses(response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForPasswordAndLetThemGoToLoginScreen(boolean select_restaurant) {
        try {
            EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("", "Please enter password", "Please enter to continue");
            enterPasswordDialogFragment.show(getSupportFragmentManager(), "password");
            enterPasswordDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    String password = (String) o;
                    boolean success;
                    if (password.equalsIgnoreCase(myApp.getMyPreferences().getUserP())) {
                        success = true;
                    } else if (merchantBusinesses != null && password.equalsIgnoreCase(merchantBusinesses.supervisor_password)) {
                        success = true;
                    } else if (merchantBusinesses != null && password.equalsIgnoreCase(merchantBusinesses.admin_password)) {
                        success = true;
                    } else {
                        success = false;
                        CommonFunctions.showSnackBar(this, drawer, "Wrong password");
                    }
                    if (success) {
                        startActivity(new Intent(this, LoginActivity.class).putExtra("select_restaurant", select_restaurant));
                        finish();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForMerchantPasswordAndLetThemDoRestaurantLogin(boolean select_restaurant) {
        try {
            EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("", "Please enter password", "Please enter to continue");
            enterPasswordDialogFragment.show(getSupportFragmentManager(), "password");
            enterPasswordDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    String password = (String) o;
                    boolean success;
                    if (password.equalsIgnoreCase(merchantBusinesses.supervisor_password)) {
                        success = true;
                    } else if (password.equalsIgnoreCase(merchantBusinesses.admin_password)) {
                        success = true;
                    } else {
                        success = false;
                        CommonFunctions.showSnackBar(this, drawer, "Wrong password");
                    }
                    if (success) {
                        startActivity(new Intent(this, LoginActivity.class).putExtra("select_restaurant", select_restaurant));
                        finish();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void notifyMerchantLoginEvent() {
        Intent pushNotification = new Intent(Constants.LOGIN_UPDATE);
        pushNotification.putExtra("refresh", true);
        LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
    }

    private void updateMerchantView() {
        try {
            flSupervisorLogin.setVisibility(View.VISIBLE);
            flMerchantSettings.setVisibility(View.GONE);
            color = getResources().getColor(R.color.persian_green);
            rlHeader.setBackground(ContextCompat.getDrawable(this, R.drawable.nav_header_bg_persian));
            if (merchantRole == 0) {
                flMerchantOverview.setVisibility(View.VISIBLE);
                tvSupervisorLogin.setText("Supervisor");
                toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                cvToolbar.setCardBackgroundColor(ContextCompat.getColor(this, R.color.white));
                appBarLayout.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                actionBarDrawerToggle.getDrawerArrowDrawable().setColor(getResources().getColor(R.color.black));
            } else if (merchantRole == 1) {
                flMerchantOverview.setVisibility(View.VISIBLE);
                tvSupervisorLogin.setText("Exit Supervisor");
                toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                cvToolbar.setCardBackgroundColor(ContextCompat.getColor(this, R.color.white));
                appBarLayout.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                actionBarDrawerToggle.getDrawerArrowDrawable().setColor(getResources().getColor(R.color.black));
            } else if (merchantRole == 2) {
                flMerchantOverview.setVisibility(View.VISIBLE);
                flMerchantSettings.setVisibility(View.VISIBLE);
                tvSupervisorLogin.setText("Exit Admin");
                color = getResources().getColor(R.color.toolbar_red);
                toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.toolbar_red));
                cvToolbar.setCardBackgroundColor(ContextCompat.getColor(this, R.color.toolbar_red));
                appBarLayout.setBackgroundColor(ContextCompat.getColor(this, R.color.toolbar_red));
                actionBarDrawerToggle.getDrawerArrowDrawable().setColor(getResources().getColor(R.color.white));
                rlHeader.setBackground(ContextCompat.getDrawable(this, R.drawable.nav_header_bg_red));
            } else {
                flMerchantOverview.setVisibility(View.GONE);
                flSupervisorLogin.setVisibility(View.GONE);
                toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                cvToolbar.setCardBackgroundColor(ContextCompat.getColor(this, R.color.white));
                appBarLayout.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                actionBarDrawerToggle.getDrawerArrowDrawable().setColor(getResources().getColor(R.color.black));
            }
            llLogout.setBackgroundColor((color));
            tvAddress.setTextColor((color));

            vOverview.setBackgroundColor((color));
            vMerchantOverview.setBackgroundColor((color));
            vRestaurantLogin.setBackgroundColor((color));
            vMerchantLogin.setBackgroundColor((color));
            vChat.setBackgroundColor((color));
            vMenu.setBackgroundColor((color));
            vPayments.setBackgroundColor((color));
            vOrders.setBackgroundColor((color));
            vOrdersHistory.setBackgroundColor((color));
            vReservations.setBackgroundColor((color));
            vReviews.setBackgroundColor((color));
            vSettings.setBackgroundColor((color));
            vDeviceType.setBackgroundColor((color));
            vMerchantSettings.setBackgroundColor((color));
            vChangeIP.setBackgroundColor((color));

            invalidateOptionsMenu();
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void checkNavigationItem(View view) {
        try {
            vOverview.setVisibility(View.GONE);
            vMerchantOverview.setVisibility(View.GONE);
            vRestaurantLogin.setVisibility(View.GONE);
            vMerchantLogin.setVisibility(View.GONE);
            vChat.setVisibility(View.GONE);
            vMenu.setVisibility(View.GONE);
            vPayments.setVisibility(View.GONE);
            vOrders.setVisibility(View.GONE);
            vOrdersHistory.setVisibility(View.GONE);
            vReservations.setVisibility(View.GONE);
            vReviews.setVisibility(View.GONE);
            vSettings.setVisibility(View.GONE);
            vDeviceType.setVisibility(View.GONE);
            vMerchantSettings.setVisibility(View.GONE);
            vChangeIP.setVisibility(View.GONE);
            if (view == vOverview) vOverview.setVisibility(View.VISIBLE);
            if (view == vMerchantOverview) vMerchantOverview.setVisibility(View.VISIBLE);
            if (view == vRestaurantLogin) vRestaurantLogin.setVisibility(View.VISIBLE);
            if (view == vMerchantLogin) vMerchantLogin.setVisibility(View.VISIBLE);
            if (view == vChat) vChat.setVisibility(View.VISIBLE);
            if (view == vMenu) vMenu.setVisibility(View.VISIBLE);
            if (view == vPayments) vPayments.setVisibility(View.VISIBLE);
            if (view == vOrders) vOrders.setVisibility(View.VISIBLE);
            if (view == vOrdersHistory) vOrdersHistory.setVisibility(View.VISIBLE);
            if (view == vReservations) vReservations.setVisibility(View.VISIBLE);
            if (view == vReviews) vReviews.setVisibility(View.VISIBLE);
            if (view == vSettings) vSettings.setVisibility(View.VISIBLE);
            if (view == vDeviceType) vDeviceType.setVisibility(View.VISIBLE);
            if (view == vMerchantSettings) vMerchantSettings.setVisibility(View.VISIBLE);
            if (view == vChangeIP) vChangeIP.setVisibility(View.VISIBLE);
            drawer.closeDrawer(GravityCompat.START);

            vOverview.setBackgroundColor((color));
            vMerchantOverview.setBackgroundColor((color));
            vRestaurantLogin.setBackgroundColor((color));
            vMerchantLogin.setBackgroundColor((color));
            vChat.setBackgroundColor((color));
            vMenu.setBackgroundColor((color));
            vPayments.setBackgroundColor((color));
            vOrders.setBackgroundColor((color));
            vOrdersHistory.setBackgroundColor((color));
            vReservations.setBackgroundColor((color));
            vReviews.setBackgroundColor((color));
            vSettings.setBackgroundColor((color));
            vDeviceType.setBackgroundColor((color));
            vMerchantSettings.setBackgroundColor((color));
            vChangeIP.setBackgroundColor((color));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForLogout(boolean merchant) {
        try {
            AlertDialog alertDialog = new AlertDialog.Builder(this).create();
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            LayoutInflater inflater = (LayoutInflater) this.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View dialogView = inflater.inflate(R.layout.dialog_logout, null);
            TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
            TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);
            TextView tvInfo = dialogView.findViewById(R.id.tvInfo);

            tvConfirm.setOnClickListener(view -> {
                alertDialog.dismiss();
                merchantLogout();
            });
            tvCancle.setOnClickListener(view -> {
                alertDialog.dismiss();
            });

            alertDialog.setView(dialogView);
            alertDialog.setCancelable(false);
            alertDialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void merchantLogout() {
        try {
            myApp.stopOrderSound();
            myApp.stopDelayedOrderSound();
            myApp.stopNewMessageSound();
            myApp.logoutMerchant(this, false);
            ToastUtils.makeToast(this, "Merchant Logout successfully");
            loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
            startActivity(new Intent(this, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragmentTheme2(Fragment fragment) {
        FragmentManager manager = getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.replace(R.id.nav_host_fragment, fragment, "theme2_payment_selection");
        transaction.addToBackStack("theme2_payment_selection");
        transaction.commit();
        toastLayout.setVisibility(View.GONE);
    }

    private void changeFragment(Fragment fragment) {
        FragmentManager manager = getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.replace(R.id.nav_host_fragment, fragment);
        transaction.addToBackStack("can_go_back");
        transaction.commit();
        if (fragment instanceof OrdersFragment || fragment instanceof RestaurantChatWindowFragment || fragment instanceof CardReaderPaymentFragment || fragment instanceof MotoAndPaymentLinkTabFragment) {
            toastLayout.setVisibility(View.GONE);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_toolbar, menu);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem userNameMenu = menu.findItem(R.id.menu_name);
        MenuItem orderMenu = menu.findItem(R.id.menu_orders);
        MenuItem motoMenu = menu.findItem(R.id.menu_moto);
        MenuItem cardReaderMenu = menu.findItem(R.id.menu_cardreader);
        MenuItem payment_option = menu.findItem(R.id.payment_option);
        MenuItem reservationMenu = menu.findItem(R.id.menu_reservation);
        MenuItem chatMenu = menu.findItem(R.id.menu_chat);
        MenuItem logoutMenu = menu.findItem(R.id.menu_logout);

        AppCompatTextView textView = userNameMenu.getActionView().findViewById(R.id.tvUserName);
        orderMenu.setVisible(false);
        chatMenu.setVisible(false);
        reservationMenu.setVisible(false);

        RelativeLayout orderRootMenu = (RelativeLayout) orderMenu.getActionView();
        LinearLayout motoRootMenu = (LinearLayout) motoMenu.getActionView();
        LinearLayout cardreaderRootMenu = (LinearLayout) cardReaderMenu.getActionView();
        LinearLayout paymentRootMenu = (LinearLayout) payment_option.getActionView();
        RelativeLayout reservationRootMenu = (RelativeLayout) reservationMenu.getActionView();
        RelativeLayout chatRootMenu = (RelativeLayout) chatMenu.getActionView();
        LinearLayout logoutRootMenu = (LinearLayout) logoutMenu.getActionView();

        TextView tvOrders, tvReservations, tvChat, tvMoto, tvCardReader, tvLogout, tvPayment;
        ImageView ivOrders, ivReservations, ivChat, ivMoto, ivCardReader, ivLogout, ivPayment;

        tvOrders = orderRootMenu.findViewById(R.id.tvOrders);
        tvReservations = reservationRootMenu.findViewById(R.id.tvReservations);
        tvChat = chatRootMenu.findViewById(R.id.tvChat);
        tvMoto = motoRootMenu.findViewById(R.id.tvMoto);
        tvLogout = logoutRootMenu.findViewById(R.id.tvLogout);
        tvCardReader = cardreaderRootMenu.findViewById(R.id.tvCardReader);
        tvPayment = paymentRootMenu.findViewById(R.id.tvCardReader);
        tvPayment.setText("Payments");
        ivOrders = orderRootMenu.findViewById(R.id.ivOrders);
        ivReservations = reservationRootMenu.findViewById(R.id.ivReservations);
        ivChat = chatRootMenu.findViewById(R.id.ivChat);
        ivMoto = motoRootMenu.findViewById(R.id.ivMoto);
        ivLogout = logoutRootMenu.findViewById(R.id.ivLogout);
        ivCardReader = cardreaderRootMenu.findViewById(R.id.ivCardReader);
        ivPayment = paymentRootMenu.findViewById(R.id.ivCardReader);

        TextView tvOrderCount = orderRootMenu.findViewById(R.id.tvOrderCount);
        TextView tvReservationCount = reservationRootMenu.findViewById(R.id.tvReservationCount);
        TextView tvUnreadCount = chatRootMenu.findViewById(R.id.tvUnreadCount);

        LogUtils.e("onPrepareOptionsMenu CALLED--------------------------------------------------");
        if (allCounts != null) {
            if (allCounts.pending_orders > 0) {
                tvOrderCount.setVisibility(View.VISIBLE);
                tvOrderCount.setText(String.valueOf(allCounts.pending_orders));
            } else {
                tvOrderCount.setVisibility(View.GONE);
            }
            if (allCounts.pending_bookings > 0) {
                tvReservationCount.setVisibility(View.VISIBLE);
                tvReservationCount.setText(String.valueOf(allCounts.pending_bookings));
            } else {
                tvReservationCount.setVisibility(View.GONE);
            }
            if (allCounts.unread_chat > 0) {
                tvUnreadCount.setVisibility(View.VISIBLE);
                tvUnreadCount.setText(String.valueOf(allCounts.unread_chat));
            } else {
                tvUnreadCount.setVisibility(View.GONE);
            }

        } else {
            tvOrderCount.setVisibility(View.GONE);
            tvReservationCount.setVisibility(View.GONE);
            tvUnreadCount.setVisibility(View.GONE);
        }
        if (loggedInRestaurant != null) {
            textView.setText(loggedInRestaurant.restaurant_name);
            orderMenu.setVisible(true);
            chatMenu.setVisible(true);
            reservationMenu.setVisible(true);
        } else if (loggedInMerchant != null) {
            textView.setText(merchantBusinesses.name);
        } else {
            userNameMenu.setVisible(false);
        }
        if (loggedInMerchant == null) {
            motoMenu.setVisible(false);
            cardReaderMenu.setVisible(false);
            logoutMenu.setVisible(false);
        } else {
            logoutMenu.setVisible(false);
            if ((merchantRole == 2 && merchantBusinesses.admin_permissions.payworks)) {
                cardReaderMenu.setVisible(true);
            } else if (merchantRole == 1 && merchantBusinesses.supervisor_permissions.payworks) {
                cardReaderMenu.setVisible(true);
            } else cardReaderMenu.setVisible(merchantRole == 0);
            motoMenu.setVisible(false);
        }
        if (merchantRole == 2) {
            tvOrders.setTextColor(ContextCompat.getColor(this, R.color.white));
            tvReservations.setTextColor(ContextCompat.getColor(this, R.color.white));
            tvChat.setTextColor(ContextCompat.getColor(this, R.color.white));
            tvMoto.setTextColor(ContextCompat.getColor(this, R.color.white));
            tvCardReader.setTextColor(ContextCompat.getColor(this, R.color.white));
            tvPayment.setTextColor(ContextCompat.getColor(this, R.color.white));
            tvLogout.setTextColor(ContextCompat.getColor(this, R.color.white));

            ivOrders.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            ivReservations.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            ivChat.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            ivMoto.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            ivCardReader.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            ivPayment.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            ivLogout.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));


        } else {
            tvOrders.setTextColor(ContextCompat.getColor(this, R.color.menu_color));
            tvReservations.setTextColor(ContextCompat.getColor(this, R.color.menu_color));
            tvChat.setTextColor(ContextCompat.getColor(this, R.color.menu_color));
            tvMoto.setTextColor(ContextCompat.getColor(this, R.color.menu_color));
            tvPayment.setTextColor(ContextCompat.getColor(this, R.color.menu_color));
            tvCardReader.setTextColor(ContextCompat.getColor(this, R.color.menu_color));
            tvLogout.setTextColor(ContextCompat.getColor(this, R.color.menu_color));

            ivOrders.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
            ivReservations.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
            ivChat.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
            ivMoto.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
            ivCardReader.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
            ivPayment.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
            ivLogout.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.menu_color)));
        }
        updateAdminLayout();
        if (myApp.getMyPreferences().getMerchantBusinesses().online_service && myApp.getMyPreferences().isOnlineOrderEnable()) {
            orderMenu.setVisible(true);
            chatMenu.setVisible(true);
            reservationMenu.setVisible(true);
        } else {
            orderMenu.setVisible(false);
            chatMenu.setVisible(false);
            reservationMenu.setVisible(false);
        }
        if (cardReaderMenu.isVisible() || motoMenu.isVisible()) {
            llPaymentTheme.setVisibility(View.VISIBLE);
        }
        if (myApp.getMyPreferences().getPaymentTheme().equalsIgnoreCase("theme2")) {
            if (cardReaderMenu.isVisible() || motoMenu.isVisible()) {
                cardReaderMenu.setVisible(false);
                motoMenu.setVisible(false);
                payment_option.setVisible(true);
            } else {
                payment_option.setVisible(false);
            }
        } else {
            payment_option.setVisible(false);
        }
        paymentRootMenu.setOnClickListener(view -> onOptionsItemSelected(payment_option));
        motoRootMenu.setOnClickListener(view -> {
            onOptionsItemSelected(motoMenu);
        });
        cardreaderRootMenu.setOnClickListener(view -> {
            onOptionsItemSelected(cardReaderMenu);
        });
        orderRootMenu.setOnClickListener(view -> {
            onOptionsItemSelected(orderMenu);
        });
        reservationRootMenu.setOnClickListener(view -> {
            onOptionsItemSelected(reservationMenu);
        });
        chatRootMenu.setOnClickListener(view -> {
            onOptionsItemSelected(chatMenu);
        });
        logoutRootMenu.setOnClickListener(view -> {
            onOptionsItemSelected(logoutMenu);
        });
        return true;
    }

    private void updateAdminLayout() {
        if (myApp.getMyPreferences().getMerchantBusinesses() != null && myApp.getMyPreferences().getMerchantBusinesses().merchant_service) {
            flPayments.setVisibility(View.VISIBLE);
            //flSettings.setVisibility(View.VISIBLE);
            flSupervisorLogin.setVisibility(View.VISIBLE);
            if (loggedInMerchant == null) {
                flMerchantLogin.setVisibility(View.VISIBLE);
            }
        } else {
            //flSettings.setVisibility(View.GONE);
            flSupervisorLogin.setVisibility(View.GONE);
            flPayments.setVisibility(View.GONE);
            flMerchantLogin.setVisibility(View.GONE);
        }
        if (myApp.getMyPreferences().getMerchantBusinesses().merchant_service) {
            flMerchantOverview.setVisibility(View.VISIBLE);
        } else {
            flMerchantOverview.setVisibility(View.GONE);
        }
        if (myApp.getMyPreferences().getMerchantBusinesses().online_service && myApp.getMyPreferences().isOnlineOrderEnable()) {
            flOrders.setVisibility(View.VISIBLE);
            flOrdersHistory.setVisibility(View.VISIBLE);
            flChat.setVisibility(View.VISIBLE);
            flReservations.setVisibility(View.VISIBLE);
            flReviews.setVisibility(View.VISIBLE);
            flRestaurantLogin.setVisibility(View.GONE);
            flMenu.setVisibility(View.VISIBLE);
        } else {
            flOrdersHistory.setVisibility(View.GONE);
            flChat.setVisibility(View.GONE);
            flReservations.setVisibility(View.GONE);
            flReviews.setVisibility(View.GONE);
            flOrders.setVisibility(View.GONE);
            flRestaurantLogin.setVisibility(View.GONE);
            flMenu.setVisibility(View.GONE);
        }
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        super.onOptionsItemSelected(item);
        if (item.getItemId() == R.id.menu_orders) {
            validateDevice(() -> {
                checkNavigationItem(vOrders);
                changeFragment(OrdersFragment.getInstance());
                return null;
            });
        }
        if (item.getItemId() == R.id.menu_moto) {
            checkNavigationItem(vPayments);
            changeFragment(MotoAndPaymentLinkTabFragment.getInstance());
        }
        if (item.getItemId() == R.id.menu_cardreader) {
            checkNavigationItem(vPayments);
            //turnOnOffDeviceBluetooth();

            changeFragment(CardReaderPaymentFragment.getInstance());
        }
        if (item.getItemId() == R.id.menu_reservation) {
            validateDevice(() -> {
                checkNavigationItem(vReservations);
                changeFragment(ReservationsFragment.getInstance());
                return null;
            });
        }
        if (item.getItemId() == R.id.menu_chat) {
            validateDevice(() -> {
                checkNavigationItem(vChat);
                changeFragment(ChatHistoryFragment.getInstance());
                return null;
            });
        }
        if (item.getItemId() == R.id.menu_logout) {
            if (merchantRole > 0) {
                flSupervisorLogin.performClick();
            } else {
                askForLogout(true);
            }
        }
        if (item.getItemId() == R.id.payment_option) {
            changeFragmentTheme2(new Theme2PaymentSelection());
        }
        return true;
    }

    private void turnOnOffDeviceBluetooth() {
        try {
            if (ContextCompat.checkSelfPermission(HomeActivity.this, Manifest.permission.BLUETOOTH_CONNECT) == PackageManager.PERMISSION_DENIED) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                    ActivityCompat.requestPermissions(HomeActivity.this, new String[]{Manifest.permission.BLUETOOTH_CONNECT}, 2);
                    return;
                }
            }

            BluetoothAdapter bluetoothAdapter;
            BluetoothManager bluetoothManager = (BluetoothManager) this.getSystemService(Context.BLUETOOTH_SERVICE);

            if (Build.VERSION.SDK_INT >= 31) {
                bluetoothAdapter = bluetoothManager.getAdapter();
            } else {
                bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            }

            //  BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter.isEnabled()) {
                bluetoothAdapter.disable();
                //  ToastUtils.makeToast(HomeActivity.this, "BLUETOOTH TURNED OFF.");
                // LogUtils.e("BLUETOOTH TURNED OFF.");
            }
            new Handler(Objects.requireNonNull(Looper.myLooper()))
                    .postDelayed(() -> {
                        try {
                            if (!bluetoothAdapter.isEnabled()) {
                                bluetoothAdapter.enable();
                                //   ToastUtils.makeToast(HomeActivity.this, "BLUETOOTH TURNED ON.");
                                //    LogUtils.e("BLUETOOTH TURNED On.");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }, 1000);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openHome() {
        try {
            if (loggedInRestaurant != null) {
                checkNavigationItem(vOverview);
                updateAdminLayout();
                changeFragment(HomeFragment.getInstance());
            } else {
                if (loggedInMerchant != null) {
                    checkNavigationItem(vMerchantOverview);
                    changeFragment(MerchantDashboardFragment.getInstance());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        try {
            Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
            FragmentManager manager = getSupportFragmentManager();
            if (isCardReaderReStart) {
                isCardReaderReStart = false;
                openHome();
            } else {
                if (openedFragment == null) {
                    super.onBackPressed();
                } else if (openedFragment instanceof CaxTonCardAndBank) {
                    CaxTonCardAndBank caxTonCardAndBank = ((CaxTonCardAndBank) openedFragment);
                    if (caxTonCardAndBank != null && caxTonCardAndBank.viewPager != null && caxTonCardAndBank.viewPager.getCurrentItem() == 1) {
                        if (caxTonCardAndBank.caxTonWallet.caxTonWalletListAdapter.getItemCount() > 1 && caxTonCardAndBank.caxTonWallet.rv_wallet_list.getVisibility() == View.GONE) {
                            caxTonCardAndBank.caxTonWallet.rv_wallet_list.setVisibility(View.VISIBLE);
                            caxTonCardAndBank.caxTonWallet.txt_life_time_balance.setVisibility(View.VISIBLE);
                            caxTonCardAndBank.caxTonWallet.txt_wallet.setVisibility(View.VISIBLE);
                            caxTonCardAndBank.caxTonWallet.const_wallet_detail.setVisibility(View.GONE);
                        } else {
                            if (manager.getBackStackEntryCount() > 0) {
                                manager.popBackStack();
                            } else {
                                openHome();
                            }
                        }
                    } else {
                        if (manager.getBackStackEntryCount() > 0) {
                            manager.popBackStack();
                        } else {
                            openHome();
                        }
                    }
                } else if (openedFragment instanceof HomeFragment) {
                    askExitConfirmation();
                } else if (openedFragment instanceof MerchantDashboardFragment) {
                    askExitConfirmation();
                } else if (openedFragment instanceof OrdersFragment || openedFragment instanceof ReservationsFragment || openedFragment instanceof ChatHistoryFragment || openedFragment instanceof SettingsFragment || openedFragment instanceof PaymentFragment || openedFragment instanceof ReviewFragment || openedFragment instanceof MerchantPrintersFragment) {
                    openHome();
                } else if (openedFragment instanceof MotoAndPaymentLinkTabFragment) {
                    openHome();
                } else {
                    if (manager.getBackStackEntryCount() > 0) {
                        manager.popBackStack();
                    } else {
                        openHome();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askExitConfirmation() {
        try {
            ConfirmationExitDialogFragment confirmationExitDialogFragment = ConfirmationExitDialogFragment.getInstance();
            confirmationExitDialogFragment.show(getSupportFragmentManager(), "exit");
            confirmationExitDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm")) {
                        finishAffinity();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onRestart() {
        myApp.initService();
        super.onRestart();
    }

    // Print copies from payment link notification

    private SunmiPrinter sunmiPrinter;
    private ZoneRichPrinter zoneRichPrinter;
    private BluetoothPrinter bluetoothPrinter;
    private float totalAmount;

    String title;
    String headerA = "", headerB = "", resAddress = "";
    String amount;
    // String card_____;
    String account__;
    String stripe_id;
    String entry_mod;
    String status___;
    String mobile___;
    String email___;
    String please;
    String date_final;
    String footerA;
    String footerB;
    String main_content;
    String print_amount, print_stripe_id, print_payment_mode, print_status;
    // Need to set from notification data

    private void managePaymentLinkResponse(String amountResponse, String status, String transId, String phone, String email) {
        try {

            String transactionId = transId;

            print_stripe_id = transactionId;
            totalAmount = Float.parseFloat(amountResponse);
            print_amount = MyApp.df.format(totalAmount);
            print_payment_mode = "Pay By Link";
            if (status.equalsIgnoreCase("Success")) {
                // Payment completed successfully
                myApp.startPaymentSuccessSound();
                print_status = "Approved";

            } else if (status.equalsIgnoreCase("Failed")) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
            }

            title = "" + "Customer Copy" + "\n";

            if (merchantBusinesses != null) {
                headerA = merchantBusinesses.header_a;
                headerB = merchantBusinesses.header_b;
            }

            amount = "£" + print_amount + "\n";

            mobile___ = "Mobile No. :" + phone;
            email___ = "Email      :" + email;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";

            if (merchantBusinesses != null) {
                footerA = merchantBusinesses.footer_a;
                footerB = merchantBusinesses.footer_b;
            }

            main_content = mobile___ + "\n" + email___ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            String positiveButton = "";
            if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                positiveButton = "Print";
            } else {
                positiveButton = "NoConfirm";
            }

            String desc;
            if (Validators.isNullOrEmpty(phone)) {
                desc = "£" + print_amount;
            } else {
                desc = phone + " - £" + print_amount;
            }
            AnimatedConfirmationDialogFragment animatedConfirmationDialogFragment = AnimatedConfirmationDialogFragment.getInstance(print_status, desc, print_status.equalsIgnoreCase("approved") ? 1 : 2, positiveButton, "Okay");
            animatedConfirmationDialogFragment.show(getSupportFragmentManager(), "show_confirm");
            animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof String && !o.toString().equalsIgnoreCase("cancel")) {
                        if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                            if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                                if (zoneRichPrinter == null) {
                                    CommonFunctions.showSnackBar(HomeActivity.this, drawer, "Printer is null");
                                } else {
                                    printZonrich("Customer Copy");
                                }
                            } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                                try {
                                    if (bluetoothPrinter != null) {
                                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                        if (device != null) {
                                            CommonFunctions.functionThatDelay(200);
                                            printBT("Customer Copy");
                                        } else {
                                            CommonFunctions.showSnackBar(HomeActivity.this, drawer, "No bluetooth device found.");
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else {
                                printReceipt();
                            }
                        } else {
                            try {
                                Thread.sleep(200);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReceipt() {
        print_v1("Customer Copy");
    }

    public void print_v1(String title_copy) {
        try {
            String title = "" + title_copy + "\n";
            runOnUiThread(() -> {
                try {
                    sunmiPrinter.printMotoReceiptAidlUtil(myApp.merchantLogo, title, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
                    if (!title_copy.equalsIgnoreCase("merchant copy")) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(HomeActivity.this, R.style.AppDialog);
                        builder.setTitle("Is Merchant Copy Required ?");
                        builder.setPositiveButton("OK", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                            print_v1("Merchant Copy");
                        });
                        builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                            dialogInterface.dismiss();
                        });
                        builder.setCancelable(false);
                        builder.show();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
            progressDialog.dismiss();
        }
    }

    public void printZonrich(String title) {
        try {
            title = title + "\n";
            String finalTitle = title;
            zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
            zoneRichPrinter.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
            if (!finalTitle.toLowerCase().contains("merchant copy")) {
                AlertDialog.Builder builder = new AlertDialog.Builder(HomeActivity.this, R.style.AppDialog);
                builder.setTitle("Is Merchant Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printZonrich("Merchant Copy");
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                });
                builder.setCancelable(false);
                builder.show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printBT(String title) {
        try {
            title = title + "\n";
            String finalTitle = title;
            bluetoothPrinter.printMotoReceipt(myApp.merchantLogo, finalTitle, headerA, headerB, resAddress, amount, main_content, date_final, please, footerA, footerB);
            if (!finalTitle.toLowerCase().contains("merchant copy")) {
                AlertDialog.Builder builder = new AlertDialog.Builder(HomeActivity.this, R.style.AppDialog);
                builder.setTitle("Is Merchant Copy Required ?");
                builder.setPositiveButton("OK", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    printBT("Merchant Copy");
                });
                builder.setNegativeButton("SKIP", (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                });
                builder.setCancelable(false);
                builder.show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
            if (requestCode == 67 && resultCode == RESULT_OK && openedFragment != null) {
                FragmentTransaction fragTransaction = getSupportFragmentManager().beginTransaction();
                fragTransaction.detach(openedFragment);
                fragTransaction.attach(openedFragment);
                fragTransaction.commit();
            }

            if (requestCode == MY_REQUEST_CODE) {
                if (resultCode == Activity.RESULT_OK) {
                    Log.d("TAG", "" + "Result Ok");
                } else if (resultCode == Activity.RESULT_CANCELED) {
                    Log.d("TAG", "" + "Result Cancelled");
                } else if (resultCode == ActivityResult.RESULT_IN_APP_UPDATE_FAILED) {
                    Log.d("TAG", "" + "Update Failure");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (!intent.getBooleanExtra("isConnected", false)) {
                    Intent i = new Intent(HomeActivity.this, NoInternetActivity.class);
                    startActivityForResult(i, 67);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(HomeActivity.this).registerReceiver(networkChangeReceiver, new IntentFilter("NetworkChange"));
        if (myApp.appUpdateManager != null) {
            myApp.appUpdateManager
                    .getAppUpdateInfo()
                    .addOnSuccessListener(appUpdateInfo -> {
                        // If the update is downloaded but not installed,
                        // notify the user to complete the update.
                        if (appUpdateInfo.installStatus() == InstallStatus.DOWNLOADED) {
                            popupSnackbarForCompleteUpdate();
                        }
                        if (appUpdateInfo.updateAvailability()
                                == UpdateAvailability.DEVELOPER_TRIGGERED_UPDATE_IN_PROGRESS) {
                            // If an in-app update is already running, resume the update.
                            try {
                                myApp.appUpdateManager.startUpdateFlowForResult(
                                        // Pass the intent that is returned by 'getAppUpdateInfo()'.
                                        appUpdateInfo,
                                        // Or 'AppUpdateType.FLEXIBLE' for flexible updates.
                                        AppUpdateType.IMMEDIATE,
                                        // The current activity making the update request.
                                        this,
                                        // Include a request code to later monitor this update request.
                                        MY_REQUEST_CODE);
                            } catch (IntentSender.SendIntentException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (networkChangeReceiver != null) {
            LocalBroadcastManager.getInstance(HomeActivity.this).unregisterReceiver(networkChangeReceiver);
        }
    }

    private void getHeightWidth() {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            height = displayMetrics.heightPixels;
            width = displayMetrics.widthPixels;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getHeightOfTheScreen() {
        return height;
    }
}